/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail.bank;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.bean.OcrTransDetailBean;
import kd.tmc.bei.common.bean.TransDetailCellBean;
import kd.tmc.bei.common.bean.TransDetailDataBean;
import kd.tmc.bei.common.bean.TransDetailPageBean;
import kd.tmc.bei.common.bean.TransDetailTableBean;
import kd.tmc.bei.formplugin.detail.bank.IBankTransDetailDeal;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OCBCBankTransDetailDeal
implements IBankTransDetailDeal {
    private static final Log logger = LogFactory.getLog(OCBCBankTransDetailDeal.class);

    @Override
    public void ToDeal(OcrTransDetailBean ocrReceiptBean, DealResultBean dealResult) {
        logger.info("\u5339\u914d\u5230\u534e\u4fa8\u94f6\u884c\uff0c\u5f00\u59cb\u89e3\u6790-------------------");
        long startTime = System.nanoTime();
        DynamicObject fileResult = BusinessDataServiceHelper.newDynamicObject((String)"bei_transdetail_file_rec");
        fileResult.set("requestid", (Object)ocrReceiptBean.getRequestId());
        fileResult.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        BigDecimal debitAmountTotal = BigDecimal.ZERO;
        BigDecimal creditAmountTotal = BigDecimal.ZERO;
        DynamicObject transDetail = fileResult.getDynamicObjectCollection("entryentity").addNew();
        DynamicObject currency = null;
        boolean isFoundAccount = false;
        for (Object data : ocrReceiptBean.getData()) {
            TransDetailDataBean transDetailBean = (TransDetailDataBean)((JSONObject)data).toJavaObject(TransDetailDataBean.class);
            List pageDatas = transDetailBean.getPageData();
            for (Object pageData : pageDatas) {
                TransDetailPageBean pageDataBean = (TransDetailPageBean)((JSONObject)pageData).toJavaObject(TransDetailPageBean.class);
                List tableDatas = pageDataBean.getTableData();
                for (Object tableData1 : tableDatas) {
                    TransDetailTableBean tableData = (TransDetailTableBean)((JSONObject)tableData1).toJavaObject(TransDetailTableBean.class);
                    List cells = tableData.getCell();
                    JSONObject[][] res = new JSONObject[cells.size()][];
                    for (int i = 0; i < res.length; ++i) {
                        res[i] = ((List)cells.get(i)).toArray(new JSONObject[((List)cells.get(i)).size()]);
                    }
                    block12: for (JSONObject[] re : res) {
                        block13: for (int j = 0; j < re.length; ++j) {
                            TransDetailCellBean cellBean = (TransDetailCellBean)re[j].toJavaObject(TransDetailCellBean.class);
                            if (pageDataBean.getTableHeader().contains("Daily Statement of Account")) {
                                if (isFoundAccount) continue block12;
                                List<String> split = Arrays.asList(cellBean.getText().split("\n"));
                                int index = split.indexOf(" Account Number  ");
                                if (index == -1) continue;
                                isFoundAccount = true;
                                String[] accountNumber = split.get(index + 1).split(" - ");
                                DynamicObject accountBank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)accountNumber[0])});
                                if (EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
                                    fileResult.set("accountbank", (Object)accountBank);
                                } else {
                                    dealResult.setStatus("F");
                                    dealResult.addFailureReason(this.getNotFoundAccountMessage(accountNumber[0]));
                                }
                                currency = TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accountNumber[1])});
                                if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                                    dealResult.setStatus("F");
                                    dealResult.addFailureReason(this.getNotFoundCurrencyMessage(accountNumber[1]));
                                }
                                fileResult.set("count", (Object)(Long.parseLong(split.get(split.indexOf(" Debits") + 1)) + Long.parseLong(split.get(split.indexOf(" Credits") + 1))));
                                fileResult.set("debitamounttotal", (Object)new BigDecimal(split.get(split.indexOf(" Debits") + 3).replace(",", "")));
                                fileResult.set("creditamounttotal", (Object)new BigDecimal(split.get(split.indexOf(" Credits") + 3).replace(",", "")));
                                continue;
                            }
                            if (!EmptyUtil.isEmpty((String)pageDataBean.getTableEnds()) || !EmptyUtil.isEmpty((String)pageDataBean.getTableHeader())) continue;
                            switch (j) {
                                case 0: {
                                    if (!EmptyUtil.isNoEmpty((DynamicObject)transDetail) || !EmptyUtil.isEmpty((Object)transDetail.getDate("bizdate")) || !EmptyUtil.isNoEmpty((String)cellBean.getText())) continue block13;
                                    transDetail.set("currency", currency);
                                    SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);
                                    Date transDate = null;
                                    try {
                                        transDate = sdf.parse(cellBean.getText());
                                    }
                                    catch (ParseException e) {
                                        dealResult.setStatus("F");
                                        dealResult.addFailureReason(this.getBizDateParseMessage(cellBean.getText()));
                                        logger.error("\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
                                    }
                                    transDetail.set("bizdate", (Object)transDate);
                                    continue block13;
                                }
                                case 3: {
                                    if (!EmptyUtil.isNoEmpty((DynamicObject)transDetail) || !EmptyUtil.isNoEmpty((String)cellBean.getText())) continue block13;
                                    BigDecimal debitAmount = new BigDecimal(cellBean.getText().replace(",", ""));
                                    transDetail.set("debitamount", (Object)debitAmount);
                                    debitAmountTotal = debitAmountTotal.add(debitAmount);
                                    continue block13;
                                }
                                case 4: {
                                    if (!EmptyUtil.isNoEmpty((DynamicObject)transDetail) || !EmptyUtil.isNoEmpty((String)cellBean.getText())) continue block13;
                                    BigDecimal creditAmount = new BigDecimal(cellBean.getText().replace(",", ""));
                                    transDetail.set("creditamount", (Object)creditAmount);
                                    creditAmountTotal = creditAmountTotal.add(creditAmount);
                                    continue block13;
                                }
                                case 5: {
                                    if (!EmptyUtil.isNoEmpty((DynamicObject)transDetail) || !EmptyUtil.isNoEmpty((String)cellBean.getText())) continue block13;
                                    transDetail.set("transbalance", (Object)new BigDecimal(cellBean.getText().replace(",", "")));
                                    transDetail = fileResult.getDynamicObjectCollection("entryentity").addNew();
                                    continue block13;
                                }
                            }
                        }
                    }
                }
            }
        }
        fileResult.set("currencytotal", currency);
        if (EmptyUtil.isEmpty((BigDecimal)transDetail.getBigDecimal("transbalance"))) {
            fileResult.getDynamicObjectCollection("entryentity").remove(fileResult.getDynamicObjectCollection("entryentity").size() - 1);
        }
        this.LeadInCheck(fileResult, dealResult, debitAmountTotal, creditAmountTotal);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileResult});
        long time = (System.nanoTime() - startTime) / 1000L / 1000L;
        logger.info(">>>\u8bc6\u522b\u7ed3\u679c\u89e3\u6790\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + time + "ms");
    }

    private void LeadInCheck(DynamicObject fileResult, DealResultBean dealResult, BigDecimal debitAmountTotal, BigDecimal creditAmountTotal) {
        if ("F".equals(dealResult.getStatus())) {
            dealResult.setPreValidate(ResManager.loadKDString((String)"\u672a\u68c0\u9a8c", (String)"LeadInCheck_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder prevalidate = new StringBuilder();
        int count = fileResult.getInt("count");
        DynamicObjectCollection transDetails = fileResult.getDynamicObjectCollection("entryentity");
        if (count != 0 && count != transDetails.size()) {
            prevalidate.append(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bc6\u522b\u603b\u884c\u6570\u4e0d\u4e00\u81f4\u3002", (String)"LeadInCheck_0", (String)"tmc-bei-formplugin", (Object[])new Object[0])).append("\n");
        }
        if (debitAmountTotal.compareTo(fileResult.getBigDecimal("debitamounttotal")) != 0) {
            prevalidate.append(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u501f\u65b9\u660e\u7ec6\u6c47\u603b\u91d1\u989d\u4e0e\u501f\u65b9\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"LeadInCheck_1", (String)"tmc-bei-formplugin", (Object[])new Object[0])).append("\n");
        }
        if (creditAmountTotal.compareTo(fileResult.getBigDecimal("creditamounttotal")) != 0) {
            prevalidate.append(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8d37\u65b9\u660e\u7ec6\u6c47\u603b\u91d1\u989d\u4e0e\u8d37\u65b9\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"LeadInCheck_2", (String)"tmc-bei-formplugin", (Object[])new Object[0])).append("\n");
        }
        QFilter qFilter = new QFilter("accountbank", "=", fileResult.getDynamicObject("accountbank").getPkValue());
        for (DynamicObject transDetail : transDetails) {
            qFilter.and("bizdate", "=", (Object)transDetail.getDate("bizdate"));
            qFilter.and("currency", "=", transDetail.getDynamicObject("currency").getPkValue());
            qFilter.and("transbalance", "=", (Object)transDetail.getBigDecimal("transbalance"));
            qFilter.and("debitamount", "=", (Object)transDetail.getBigDecimal("debitamount"));
            qFilter.and("creditamount", "=", (Object)transDetail.getBigDecimal("creditamount"));
            qFilter.and("description", "=", (Object)transDetail.getString("description"));
            if (!QueryServiceHelper.exists((String)"bei_transdetail", (QFilter[])qFilter.toArray())) continue;
            prevalidate.append(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"LeadInCheck_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            break;
        }
        if (EmptyUtil.isNoEmpty((String)prevalidate.toString())) {
            dealResult.setPreValidate(prevalidate.toString());
        } else {
            dealResult.setPreValidate(ResManager.loadKDString((String)"\u6821\u9a8c\u901a\u8fc7", (String)"LeadInCheck_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        fileResult.set("accountvalidate", (Object)dealResult.getPreValidate());
    }

    private String getNotFoundAccountMessage(String accountNumber) {
        return ResManager.loadKDString((String)"\u534e\u4fa8\u94f6\u884c\u8d26\u53f7\uff1a%s\u4e0d\u5b58\u5728\u3002", (String)"OCBCBankTransDetailDeal_0", (String)"tmc-bei-formplugin", (Object[])new Object[]{accountNumber});
    }

    private String getNotFoundCurrencyMessage(String currency) {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8d27\u5e01\u4ee3\u7801\u4e3a\u201c%s\u201d\u7684\u5e01\u79cd\u3002", (String)"OCBCBankTransDetailDeal_1", (String)"tmc-bei-formplugin", (Object[])new Object[]{currency});
    }

    private String getBizDateParseMessage(String bizdate) {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f%s\u8f6c\u6362\u5f02\u5e38\u3002", (String)"OCBCBankTransDetailDeal_2", (String)"tmc-bei-formplugin", (Object[])new Object[]{bizdate});
    }
}

