/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class ElecBalanceQueryAcc
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private String opStatus;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("accountbank");
        acctbankF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date lastMonth = DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)1);
        this.getModel().setValue("startmonth", (Object)lastMonth);
        this.getModel().setValue("endmonth", (Object)lastMonth);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Date lastMonth = DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)1);
        DateEdit endControl = (DateEdit)this.getControl("endmonth");
        endControl.setMaxDate(lastMonth);
        DateEdit startControl = (DateEdit)this.getControl("startmonth");
        startControl.setMaxDate(lastMonth);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        if ("startmonth".equals(key)) {
            if (value != null) {
                Date startMonth = DateUtils.stringToDate((String)String.valueOf(value), (String)"yyyy-MM-dd");
                Date endMonth = (Date)this.getModel().getValue("endmonth");
                this.checkMonth(e, startMonth, endMonth, key);
            }
        } else if ("endmonth".equals(key) && value != null) {
            Date startMonth = (Date)this.getModel().getValue("startmonth");
            Date endMonth = DateUtils.stringToDate((String)String.valueOf(value), (String)"yyyy-MM-dd");
            this.checkMonth(e, startMonth, endMonth, key);
        }
    }

    private void checkMonth(BeforeFieldPostBackEvent e, Date startMonth, Date endMonth, String key) {
        if (startMonth != null && endMonth != null) {
            String startMonthStr = DateUtils.formatString((Date)startMonth, (String)"yyyyMM");
            String endMonthStr = DateUtils.formatString((Date)endMonth, (String)"yyyyMM");
            startMonth = DateUtils.stringToDate((String)(startMonthStr + "01"), (String)"yyyyMMdd");
            endMonth = DateUtils.stringToDate((String)(endMonthStr + "01"), (String)"yyyyMMdd");
            if (!startMonthStr.equals(endMonthStr) && startMonth.after(endMonth)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u6708\u6216\u7ed3\u675f\u6708\u8f93\u5165\u4e0d\u89c4\u8303\u3002", (String)"ElecBalanceQueryAcc_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        this.getView().updateView(key);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("queryelecbalance".equals(operateKey)) {
            this.opStatus = "done";
            String tips = args.getOperationResult().getMessage();
            int messageType = args.getOperationResult().getMessageType();
            if (StringUtils.isNotEmpty((String)tips) && MessageTypes.Business.getValue() == messageType) {
                this.getView().showMessage("", tips, MessageTypes.Default);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (StringUtils.isNotEmpty((String)this.opStatus)) {
            IFormView pView = this.getView().getParentView();
            pView.invokeOperation("refresh");
            this.getView().sendFormAction(pView);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bei_elecbalancestate_acc", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("company", "in", (Object)authOrgList);
        qFilter.and(new QFilter("acctstatus", "=", (Object)"normal"));
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }
}

