/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.helper.ElecMatchCheckHelper;
import kd.tmc.bei.common.helper.OrgHelper;
import kd.tmc.bei.formplugin.balance.BalanceCheckViewList;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class ElecMatchCheckPlugin
extends BalanceCheckViewList
implements ItemClickListener {
    private static final Log logger = LogFactory.getLog(ElecMatchCheckPlugin.class);

    public void fillPageData() {
        this.fillPageData(this.getQFilterFromPagCache());
    }

    public void fillPageData(List<QFilter> qFilters) {
        Date startDate;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.checkAddOrg(qFilters);
        List<Long> allMatchAccount = this.getAllMatchAccount(qFilters);
        List<QFilter> accountBankFilter = Collections.singletonList(new QFilter("id", "in", allMatchAccount));
        Map acctMap = TmcDataServiceHelper.loadFromCache((String)"am_accountbank", (String)"id,name,company,bankaccountnumber,currency", (QFilter[])new QFilter("id", "in", allMatchAccount).toArray());
        Map acctBank_predictDate = AccountBankHelper.getAcctBankWithPredictDate(acctMap.values(), (String)BankFuncEnum.RECEIPT.getValue());
        Date endDate = startDate = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
        for (QFilter qFilter : qFilters) {
            logger.info("comm filter: " + qFilter.toString());
            String property = qFilter.getProperty();
            if (!"bizdate".equals(property)) continue;
            Date tmp = (Date)qFilter.getValue();
            if (">=".equals(qFilter.getCP())) {
                startDate = tmp;
                continue;
            }
            if ("<".equals(qFilter.getCP())) {
                endDate = DateUtils.getLastDay((Date)tmp, (int)1);
                continue;
            }
            if (!"<=".equals(qFilter.getCP())) continue;
            endDate = tmp;
        }
        Date today = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
        endDate = endDate.after(today) ? today : endDate;
        ArrayList allBalanceRecord = new ArrayList(16);
        while (startDate.compareTo(endDate) <= 0) {
            ArrayList<QFilter> dateFilter = new ArrayList<QFilter>(10);
            dateFilter.add(new QFilter("accountbank.id", "in", allMatchAccount));
            dateFilter.add(new QFilter("bizdate", "=", (Object)startDate));
            allBalanceRecord.addAll(ElecMatchCheckHelper.getAllElecRecord((Date)startDate, (QFilter)this.andFilter(accountBankFilter), (QFilter)this.andFilter(dateFilter), (Map)acctMap, (Map)acctBank_predictDate));
            startDate = DateUtils.getNextDay((Date)startDate, (int)1);
        }
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("company", new Object[0]);
        vs.addField("accountbank", new Object[0]);
        vs.addField("bank", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("detailcount", new Object[0]);
        vs.addField("detailmatchcount", new Object[0]);
        vs.addField("detaildebittotal", new Object[0]);
        vs.addField("detailcredittotal", new Object[0]);
        vs.addField("eleccount", new Object[0]);
        vs.addField("elecmatchcount", new Object[0]);
        vs.addField("elecdebittotal", new Object[0]);
        vs.addField("eleccredittotal", new Object[0]);
        vs.addField("debitbalance", new Object[0]);
        vs.addField("creditbalance", new Object[0]);
        vs.addField("checkresult", new Object[0]);
        vs.addField("checkresultdesc", new Object[0]);
        for (Map data : allBalanceRecord) {
            vs.addRow(new Object[]{data.get("company"), data.get("accountbank"), data.get("bank"), data.get("currency"), data.get("bizdate"), data.get("detailcount"), data.get("detailmatchcount"), data.get("detaildebittotal"), data.get("detailcredittotal"), data.get("eleccount"), data.get("elecmatchcount"), data.get("elecdebittotal"), data.get("eleccredittotal"), data.get("debitbalance"), data.get("creditbalance"), data.get("checkresult"), data.get("checkresultdesc")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private QFilter andFilter(List<QFilter> filters) {
        QFilter first = filters.get(0).copy();
        for (int i = 1; i < filters.size(); ++i) {
            first.and(filters.get(i).copy());
        }
        return first;
    }

    private void checkAddOrg(List<QFilter> qFilters) {
        QFilter filter;
        boolean hasOrg = qFilters.stream().anyMatch(t -> "company.id".equals(t.getProperty()));
        if (!hasOrg && (filter = OrgHelper.getQFilterAuthorizedOrgId((Long)RequestContext.get().getCurrUserId(), (String)"bei", (String)"bei_elecreceipt", (String)"47150e89000000ac", (String)"company.id")) != null) {
            qFilters.add(filter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("viewelec".equals(operateKey)) {
            IDataModel model = this.getModel();
            DynamicObject row = model.getEntryRowEntity("entryentity", model.getEntryCurrentRowIndex("entryentity"));
            this.showElecViewForm(row);
        } else if ("syncelec".equals(operateKey)) {
            this.showSyncElecForm();
        } else if ("matchelec".equals(operateKey)) {
            this.showMatchElecForm();
        } else if ("refresh".equals(operateKey)) {
            this.fillPageData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"bei_synelecreceipt") && null != args.getReturnData()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ElecReceiptList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private void showElecViewForm(DynamicObject row) {
        int elecCount = row.getInt("eleccount");
        if (elecCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u7535\u5b50\u56de\u5355\u3002", (String)"ElecMatchCheckPlugin_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        Long company = row.getLong("company.id");
        String accountbank = String.valueOf(row.getLong("accountbank.id"));
        Date bizdate = row.getDate("bizdate");
        String bizdateStr = DateUtils.formatString((Date)bizdate, (String)"yyyy-MM-dd");
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bei_elecreceipt");
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("setDefaultFilters", (Object)false);
        showParameter.setCustomParam("company.id", (Object)company.toString());
        showParameter.setCustomParam("accountbank.id", (Object)accountbank);
        showParameter.setCustomParam("bizdate", (Object)bizdateStr);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showSyncElecForm() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (Objects.nonNull(rows) && rows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"ElecMatchCheckPlugin_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("bei_synelecreceipt");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bei_synelecreceipt"));
        if (Objects.nonNull(rows) && 1 == rows.length) {
            IDataModel model = this.getModel();
            DynamicObject row = model.getEntryRowEntity("entryentity", model.getEntryCurrentRowIndex("entryentity"));
            DynamicObject account = row.getDynamicObject("accountbank");
            boolean isBankInterface = account.getBoolean("issetbankinterface");
            Date date = row.getDate("bizdate");
            String dateStr = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
            showForm.setCustomParam("startdate", (Object)dateStr);
            showForm.setCustomParam("enddate", (Object)dateStr);
            if (isBankInterface) {
                long accountId = row.getDynamicObject("accountbank").getLong("id");
                showForm.setCustomParam("accountbank", (Object)String.valueOf(accountId));
            }
        }
        this.getView().showForm(showForm);
    }

    private void showMatchElecForm() {
        Object selectRow;
        HashSet<Long> sendIds = new HashSet<Long>(16);
        HashSet<Long> accountbanks = new HashSet<Long>(16);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        IDataModel model = this.getModel();
        if (rows == null || rows.length == 0) {
            selectRow = model.getEntryEntity("entryentity");
        } else {
            selectRow = new ArrayList(rows.length);
            for (int idx : rows) {
                selectRow.add(model.getEntryRowEntity("entryentity", idx));
            }
        }
        Optional<QFilter> receiptOption = selectRow.stream().filter(t -> t.getLong("eleccount") > t.getLong("elecmatchcount") && Objects.nonNull(t.get("accountbank"))).map(t -> new QFilter("accountbank", "=", t.getDynamicObject("accountbank").getPkValue()).and("bizdate", "=", t.get("bizdate"))).reduce((p, q) -> p.or(q));
        if (!receiptOption.isPresent()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5168\u90e8\u5df2\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ElecReceiptFileList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,accountbank,ismatch", (QFilter[])receiptOption.get().toArray());
        for (DynamicObject obj : objs) {
            if (obj.getBoolean("ismatch")) continue;
            accountbanks.add(obj.getLong("accountbank"));
            sendIds.add(obj.getLong("id"));
        }
        if (sendIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5168\u90e8\u5df2\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ElecReceiptFileList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showForm = new FormShowParameter();
        String idsJson = JSON.toJSONString(sendIds);
        String accountbanksJson = JSON.toJSONString(accountbanks);
        showForm.setCustomParam("ids", (Object)idsJson);
        showForm.setCustomParam("accountbanks", (Object)accountbanksJson);
        showForm.setFormId("bei_receiptmatch");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showForm);
    }
}

