/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.url.UrlService;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.opservice.elec.ViewReceiptService;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class ElecReceiptList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(ElecReceiptList.class);
    private static final String CONFIRM_DOWNLOAD_RECEIPTFILE = "CONFIRM_DOWNLOAD_RECEIPTFILE";
    private static final String CONFIRM_DOWNLOAD_FILENAME = "confirm_download_filename";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("viewreceipt".equals(key)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            ArrayList<Object> pkList = new ArrayList<Object>();
            pkList.add(currentSelectedRowInfo.getPrimaryKeyValue());
            ViewReceiptService service = new ViewReceiptService();
            service.openReceiptById(this.getView(), pkList.toArray());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "synelecreceipt": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.syncTrans();
                break;
            }
            case "downloadreceiptfile": {
                this.downloadReceiptFile();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctToBillQf());
        logger.info("ElecReceiptList: " + e.getQFilters());
    }

    private void syncTrans() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("bei_synelecreceipt");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bei_synelecreceipt"));
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        Map map;
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"bei_synelecreceipt") && (map = (Map)args.getReturnData()) != null && map.get("close") != null && "close".equals(map.get("close"))) {
            List accId = (List)map.get("accId");
            Date startdate = (Date)map.get("startdate");
            Date enddate = (Date)map.get("enddate");
            if (EmptyUtil.isNoEmpty((Object)accId)) {
                DynamicObject[] schedules = BusinessDataServiceHelper.load((Object[])accId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_acctbank_schedule"));
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("startdate", DateUtils.formatString((Date)startdate, (String)"yyyy-MM-dd"));
                operateOption.setVariableValue("enddate", DateUtils.formatString((Date)enddate, (String)"yyyy-MM-dd"));
                OperationServiceHelper.executeOperate((String)"sync", (String)"bei_synelecreceipt", (DynamicObject[])schedules, (OperateOption)operateOption);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ElecReceiptList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        AccountBankHelper.filterContainerInitForAccountManagerTransfer((ListShowParameter)listShowParameter, (List)args.getCommonFilterColumns(), (IPageCache)this.getPageCache());
        boolean lookUp = listShowParameter.isLookUp();
        if (lookUp) {
            return;
        }
        if (this.getPageCache().get("isElecPageOpen") != null) {
            return;
        }
        this.getPageCache().put("isElecPageOpen", "true");
        String accountBankId = (String)listShowParameter.getCustomParam("accountbank.id");
        String companyId = (String)listShowParameter.getCustomParam("company.id");
        String bizDate = (String)listShowParameter.getCustomParam("bizdate");
        block10: for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            String fieldName;
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commonFilter.getFieldName()) {
                case "company.name": {
                    if (companyId == null) break;
                    commonFilter.setDefaultValue(companyId);
                    break;
                }
                case "accountbank.bankaccountnumber": {
                    if (EmptyUtil.isEmpty((String)accountBankId)) break;
                    DynamicObject accountBankDO = TmcDataServiceHelper.loadSingle((Object)accountBankId, (String)"bd_accountbanks");
                    if (accountBankDO == null) continue block10;
                    List<ComboItem> accountBank = this.initAcctItemsList(companyId);
                    commonFilter.setComboItems(accountBank);
                    commonFilter.setDefaultValue(accountBankId);
                    break;
                }
                case "bizdate": {
                    if (bizDate == null) break;
                    commonFilter.setDefaultValues(new Object[]{bizDate, bizDate});
                    break;
                }
            }
        }
    }

    protected List<ComboItem> initAcctItemsList(String companyid) {
        String selectProperties = "id,name,number,defaultcurrency,bankaccountnumber,currency,bank";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(10);
        if (StringUtils.isNotEmpty((CharSequence)companyid)) {
            qfilters.add(new QFilter("company.id", "=", (Object)Long.valueOf(companyid)));
        }
        DynamicObjectCollection accountbankDO = QueryServiceHelper.query((String)"bd_accountbanks", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(10);
        if (accountbankDO != null && !accountbankDO.isEmpty()) {
            for (DynamicObject cashAcct : accountbankDO) {
                if (cashAcct == null) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bankaccountnumber")));
                item.setValue(cashAcct.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    private void downloadReceiptFile() {
        BillList billList = (BillList)this.getControl("billlistap");
        Object[] pkValues = billList.getSelectedRows().getPrimaryKeyValues();
        DynamicObjectCollection fileReceiptColl = QueryServiceHelper.query((String)billList.getBillFormId(), (String)"id,billno,fileflag,uploadfilename,username", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues)});
        int selectSize = pkValues.length;
        List<String> FileBillList = fileReceiptColl.stream().filter(e -> e.getBoolean("fileflag") && StringUtils.isNotBlank((CharSequence)"uploadfilename")).map(e -> e.getString("uploadfilename")).collect(Collectors.toList());
        List noFileBillList = fileReceiptColl.stream().filter(e -> !e.getBoolean("fileflag") || !StringUtils.isNotBlank((CharSequence)"uploadfilename")).map(e -> e.getString("billno")).collect(Collectors.toList());
        int noFileSize = noFileBillList.size();
        if (noFileSize > 0) {
            String title;
            int fileSize = FileBillList.size();
            ArrayList<String> detailList = new ArrayList<String>(noFileBillList.size());
            for (String noFileBill : noFileBillList) {
                String detail = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s \u65e0\u94f6\u884c\u56de\u5355\u6587\u4ef6\u53ef\u4e0b\u8f7d\uff1b", (String)"ElecReceiptList_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]), noFileBill);
                detailList.add(detail);
            }
            String detailMsg = String.join((CharSequence)"\r\n", detailList);
            if (fileSize == 0) {
                title = String.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9%1$s\u7b14\u7535\u5b50\u56de\u5355\u6570\u636e\uff0c\u5176\u4e2d%2$s\u7b14\u53ef\u4e0b\u8f7d\u94f6\u884c\u56de\u5355\u6587\u4ef6\uff0c%3$s\u7b14\u65e0\u94f6\u884c\u56de\u5355\u6587\u4ef6\u3002", (String)"ElecReceiptList_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]), selectSize, fileSize, noFileSize);
                this.getView().showMessage(title, detailMsg, MessageTypes.Default);
            } else {
                title = String.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9%1$s\u7b14\u7535\u5b50\u56de\u5355\u6570\u636e\uff0c\u5176\u4e2d%2$s\u7b14\u53ef\u4e0b\u8f7d\u94f6\u884c\u56de\u5355\u6587\u4ef6\uff0c%3$s\u7b14\u65e0\u94f6\u884c\u56de\u5355\u6587\u4ef6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ElecReceiptList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]), selectSize, fileSize, noFileSize);
                this.getView().showConfirm(title, detailMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DOWNLOAD_RECEIPTFILE, (IFormPlugin)this));
                this.getPageCache().put(CONFIRM_DOWNLOAD_FILENAME, JSON.toJSONString(FileBillList));
            }
        } else {
            this.downloadFile(FileBillList);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String downloadFileNameStr;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (CONFIRM_DOWNLOAD_RECEIPTFILE.equals(callBackId) && MessageBoxResult.Yes == res && EmptyUtil.isNoEmpty((String)(downloadFileNameStr = this.getPageCache().get(CONFIRM_DOWNLOAD_FILENAME)))) {
            List uploadFileNames = (List)JSON.parseObject((String)downloadFileNameStr, List.class);
            this.downloadFile(uploadFileNames);
            this.getPageCache().remove(CONFIRM_DOWNLOAD_FILENAME);
        }
    }

    private void downloadFile(List<String> fileUrlList) {
        if (!EmptyUtil.isEmpty(fileUrlList)) {
            for (String fileUrl : fileUrlList) {
                String realPath = ReceiptPrintHelper.getRealUploadUrl((String)fileUrl);
                String downloadUrl = UrlService.getAttachmentDownloadUrl((String)realPath);
                this.getView().download(downloadUrl);
            }
        }
    }
}

