/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class ElecStatementFileImportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ElecStatementFileImportTask.class);
    private final String pageId;
    private final String appId;
    private final String dataJson;

    public ElecStatementFileImportTask(String pageId, String appId, String dataJson) {
        this.pageId = pageId;
        this.appId = appId;
        this.dataJson = dataJson;
    }

    @Override
    public void run() {
        try {
            logger.info("begin ElecStatementFileImportTask {}", (Object)this.pageId);
            this.doTask();
        }
        catch (Exception e) {
            logger.error("execute ElecStatementFileImportTask " + this.pageId + " error", (Throwable)e);
            new PageCache(this.pageId).put("progress", String.valueOf(100));
        }
    }

    private void doTask() {
        PageCache pageCache = new PageCache(this.pageId);
        List dataList = SerializationUtils.fromJsonStringToList((String)this.dataJson, JSONObject.class);
        int progress = 0;
        int interval = 0;
        int rest = dataList.size();
        if (dataList.size() > 0) {
            interval = this.getInterval(dataList.size());
        }
        for (JSONObject object : dataList) {
            if (Boolean.TRUE.toString().equals(pageCache.get("importCancel"))) {
                logger.info("taskCancel");
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("filename", object.getString("filename"));
            operateOption.setVariableValue("fileurl", object.getString("fileurl"));
            operateOption.setVariableValue("json", object.getString("json"));
            operateOption.setVariableValue("iscover", "true");
            operateOption.setVariableValue("appId", this.appId);
            operateOption.setVariableValue("pageId", this.pageId);
            operateOption.setVariableValue("datasource", DataSourceEnum.FILEIMPORT.getValue());
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"fileimport", (String)"bei_elecstatement", (DynamicObject[])new DynamicObject[]{TmcDataServiceHelper.newDynamicObject((String)"bei_elecstatement")}, (OperateOption)operateOption);
            if (!result.isSuccess()) {
                logger.info("file [{}] import fail {}", (Object)object.getString("filename"), (Object)result.getMessage());
            }
            if ((progress += interval) >= 100) {
                progress = 99;
            }
            pageCache.put("progress", String.valueOf(progress));
            pageCache.put("rest", String.valueOf(5 * --rest));
        }
        progress = 100;
        pageCache.put("progress", String.valueOf(progress));
    }

    private int getInterval(int count) {
        BigDecimal interval = BigDecimal.valueOf(100.0).divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
        return interval.intValue();
    }
}

