/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.helper.OfdFileParseHelper;

public class ElecStatementFileParseTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ElecStatementFileParseTask.class);
    private final String pageId;
    private final String dataJson;

    public ElecStatementFileParseTask(String pageId, String dataJson) {
        this.pageId = pageId;
        this.dataJson = dataJson;
    }

    @Override
    public void run() {
        this.doTask();
    }

    private void doTask() {
        PageCache pageCache = new PageCache(this.pageId);
        List attachmentData = (List)JSON.parseObject((String)this.dataJson, List.class);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        ArrayList<DealResultBean> results = new ArrayList<DealResultBean>(10);
        int progress = 0;
        int interval = 0;
        if (attachmentData.size() > 0) {
            interval = this.getInterval(attachmentData.size());
        }
        for (Object object : attachmentData) {
            DealResultBean result = new DealResultBean();
            Map map = (Map)object;
            String name = (String)map.get("name");
            result.setFileName(name);
            try {
                InputStream ins = tempFileCache.getInputStream((String)map.get("url"));
                Throwable throwable = null;
                try {
                    String isContinue = OfdFileParseHelper.uploadAndGenResult((InputStream)ins, (String)name, results, (DealResultBean)result);
                    if ("continue".equals(isContinue)) {
                        results.add(result);
                        continue;
                    }
                    if ((progress += interval) >= 100) {
                        progress = 99;
                    }
                    pageCache.put("progress", String.valueOf(progress));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ins == null) continue;
                    if (throwable != null) {
                        try {
                            ins.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ins.close();
                    continue;
                }
            }
            catch (Exception e) {
                result.setStatus("F");
                result.setFailureReason(ResManager.loadKDString((String)"%s\u4e0a\u4f20\u5931\u8d25", (String)"TransDetailFileTask_1", (String)"tmc-bei-formplugin", (Object[])new Object[]{name}));
                results.add(result);
                logger.error((Throwable)e);
            }
            results.add(result);
        }
        if (results.size() > 0) {
            String resultJson = JSON.toJSONString(results);
            logger.info("\u8fd4\u56dejson:" + resultJson);
            pageCache.put("resultJson", resultJson);
        }
        progress = 100;
        pageCache.put("progress", String.valueOf(progress));
    }

    private int getInterval(int count) {
        BigDecimal interval = BigDecimal.valueOf(100.0).divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
        return interval.intValue();
    }
}

