/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.business.opservice.elec.ViewStatementService;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class ElecStatementList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(ElecStatementList.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("printpreview".equals(key)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            ArrayList<Object> pkList = new ArrayList<Object>();
            for (ListSelectedRow row : selectedRows) {
                pkList.add(row.getPrimaryKeyValue());
            }
            if (!selectedRows.isEmpty()) {
                args.setCancel(true);
                ViewStatementService service = new ViewStatementService();
                service.openStatementById(this.getView(), pkList.toArray(), key);
            }
        } else if ("viewstatement".equals(key)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            ArrayList<Object> pkList = new ArrayList<Object>();
            pkList.add(currentSelectedRowInfo.getPrimaryKeyValue());
            args.setCancel(true);
            ViewStatementService service = new ViewStatementService();
            service.openStatementById(this.getView(), pkList.toArray(), key);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctToBillQf());
        String billFormId = ((BillList)e.getSource()).getEntityId();
        e.getQFilters().add(new QFilter("billtype", "=", (Object)billFormId));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "viewstatement": {
                    this.getView().invokeOperation("printpreview");
                    break;
                }
                case "discern": {
                    FormShowParameter showForm = new FormShowParameter();
                    showForm.setFormId("bei_elecstatement_upload");
                    showForm.getOpenStyle().setShowType(ShowType.Modal);
                    showForm.setCustomParam("entityName", (Object)"bei_elecstatement");
                    showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "discern"));
                    this.getView().showForm(showForm);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("discern".equals(event.getActionId())) {
            Map returnData = (Map)event.getReturnData();
            if (returnData != null) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bei_transdetail_file_proc");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                String data = (String)returnData.get("data");
                logger.info("ElecStatementList data : {}", (Object)data);
                showParameter.setCustomParam("data", (Object)data);
                showParameter.setCustomParam("entityName", (Object)"bei_elecstatement");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "file_process"));
                this.getView().showForm(showParameter);
            }
        } else if ("file_process".equals(event.getActionId()) && "success".equals(event.getReturnData())) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"TransDetailImportList_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }
}

