/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.Image;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.fbp.common.ofd.OfdConvertUtil;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceiptFileImportResultEdit
extends AbstractBillPlugIn {
    private static final String BTN_RESET = "btnreset";
    private static final String BTN_OK = "btnok";
    private static final String IFRAMEAP = "iframeap";
    private static final String IMAGEAP = "imageap";
    private static final Log logger = LogFactory.getLog(ReceiptFileImportResultEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_RESET});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{IFRAMEAP});
        this.receiptImageInit();
        this.receiptInfoInit();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_RESET.equals(key)) {
            this.receiptInfoInit();
        } else if (BTN_OK.equals(key)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("rowIdx", this.getView().getFormShowParameter().getCustomParam("rowIdx"));
            if (this.getModel().getDataChanged()) {
                paramMap.put("dataChanged", true);
                paramMap.put("creditdebitflag", this.getModel().getValue("creditdebitflag"));
                paramMap.put("bizdate", this.getModel().getValue("bizdate"));
                paramMap.put("amount", this.getModel().getValue("amount"));
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                paramMap.put("currency", currency.getString("name"));
                paramMap.put("accno", this.getModel().getValue("accno"));
                paramMap.put("accname", this.getModel().getValue("accname"));
                paramMap.put("bankname", this.getModel().getValue("bankname"));
                paramMap.put("recno", this.getModel().getValue("recno"));
                paramMap.put("recname", this.getModel().getValue("recname"));
                paramMap.put("recbankname", this.getModel().getValue("recbankname"));
                paramMap.put("detailid", this.getModel().getValue("detailid"));
                paramMap.put("bizrefno", this.getModel().getValue("bizrefno"));
                paramMap.put("use", this.getModel().getValue("use"));
                paramMap.put("description", this.getModel().getValue("description"));
            } else {
                paramMap.put("dataChanged", false);
            }
            this.getView().returnDataToParent(paramMap);
            this.getView().close();
        }
    }

    private void receiptImageInit() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fileUrl = (String)formShowParameter.getCustomParam("fileurl");
        if (fileUrl == null) {
            fileUrl = "";
        }
        fileUrl = ReceiptPrintHelper.getRealUploadUrl((String)fileUrl.trim());
        logger.info("fileUrl: " + fileUrl);
        if (EmptyUtil.isEmpty((String)fileUrl)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5b50\u56de\u5355\u6587\u4ef6\u8def\u5f84\u5f02\u5e38\u3002", (String)"ReceiptFileImportResultEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> jpgs = new HashSet<String>(4);
        jpgs.add("jpg");
        jpgs.add("jpeg");
        jpgs.add("png");
        try {
            if (fileUrl.endsWith(".pdf") || fileUrl.endsWith(".PDF") || fileUrl.endsWith(".ofd") || fileUrl.endsWith(".OFD")) {
                String previewUrl;
                if (fileUrl.endsWith(".ofd") || fileUrl.endsWith(".OFD")) {
                    byte[] bytes = OfdConvertUtil.convertToPdfNew((byte[])BeiHelper.getPdfPutStream((String)fileUrl, (String)"old"));
                    NotePrintService notePrintService = new NotePrintService();
                    LocaleString localeString = new LocaleString("receipt");
                    previewUrl = notePrintService.createPdfUrl(localeString, bytes);
                } else {
                    previewUrl = ReceiptPrintHelper.getFilePreviewUrl((String)fileUrl);
                }
                IFrame iframeap = (IFrame)this.getControl(IFRAMEAP);
                iframeap.setSrc(previewUrl);
                this.getView().setVisible(Boolean.FALSE, new String[]{IMAGEAP});
                this.getView().setVisible(Boolean.TRUE, new String[]{IFRAMEAP});
            } else if (jpgs.contains(fileUrl.substring(fileUrl.lastIndexOf(".") + 1))) {
                String imageFullUrl = UrlService.getImageFullUrl((String)fileUrl);
                Image testimageap = (Image)this.getControl(IMAGEAP);
                testimageap.setUrl(imageFullUrl);
                this.getView().setVisible(Boolean.TRUE, new String[]{IMAGEAP});
                this.getView().setVisible(Boolean.FALSE, new String[]{IFRAMEAP});
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u9884\u89c8\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6587\u4ef6\u9884\u89c8\u5f02\u5e38\u3002", (String)"ReceiptFileImportResultEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private void receiptInfoInit() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = this.getModel().getDataChanged();
        model.beginInit();
        this.getModel().setValue("creditdebitflag", formShowParameter.getCustomParam("creditdebitflag"));
        this.getModel().setValue("bizdate", formShowParameter.getCustomParam("bizdate"));
        String currencyCode = (String)formShowParameter.getCustomParam("currency");
        DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyCode).or(new QFilter("name", "=", (Object)currencyCode).and("issystem", "=", (Object)true))});
        this.getModel().setValue("currency", EmptyUtil.isEmpty((DynamicObject)currency) ? null : Long.valueOf(currency.getLong("id")));
        this.getModel().setValue("amount", formShowParameter.getCustomParam("amount"));
        this.getModel().setValue("accno", formShowParameter.getCustomParam("accno"));
        this.getModel().setValue("accname", formShowParameter.getCustomParam("accname"));
        this.getModel().setValue("bankname", formShowParameter.getCustomParam("bankname"));
        this.getModel().setValue("recno", formShowParameter.getCustomParam("recno"));
        this.getModel().setValue("recname", formShowParameter.getCustomParam("recname"));
        this.getModel().setValue("recbankname", formShowParameter.getCustomParam("recbankname"));
        this.getModel().setValue("detailid", formShowParameter.getCustomParam("detailid"));
        this.getModel().setValue("bizrefno", formShowParameter.getCustomParam("bizrefno"));
        this.getModel().setValue("use", formShowParameter.getCustomParam("use"));
        this.getModel().setValue("description", formShowParameter.getCustomParam("description"));
        model.endInit();
        this.getView().updateView("fieldflexpanelap");
        TextEdit acctField = (TextEdit)this.getControl(LendingDirectionEnum.OUT.getValue().equals(formShowParameter.getCustomParam("creditdebitflag")) ? "accno" : "recno");
        acctField.setMustInput(Boolean.TRUE.booleanValue());
        TextEdit opAcctField = (TextEdit)this.getControl(LendingDirectionEnum.OUT.getValue().equals(formShowParameter.getCustomParam("creditdebitflag")) ? "recno" : "accno");
        opAcctField.setMustInput(Boolean.FALSE.booleanValue());
        this.getModel().setDataChanged(dataChanged);
    }
}

