/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.IFrame;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.opservice.elec.ViewReceiptService;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceiptHandMatchFileEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ReceiptHandMatchFileEdit.class);
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List elecFileIds = (List)formShowParameter.getCustomParam("elecFileIds");
        List transIds = (List)formShowParameter.getCustomParam("transIds");
        if (elecFileIds.isEmpty() || transIds.isEmpty()) {
            this.getView().close();
            return;
        }
        boolean isShowList = (Boolean)formShowParameter.getCustomParam("isShowList");
        if (isShowList) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("bei_transdetail");
            listShowParameter.setFormId("bei_incontainer_list");
            listShowParameter.setMultiSelect(true);
            listShowParameter.setSelectedRows(transIds.toArray(new Object[0]));
            listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            listShowParameter.getOpenStyle().setTargetKey("detailflex");
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("660");
            listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            listShowParameter.setAppId("bei");
            listShowParameter.addCustPlugin("kd.tmc.bei.formplugin.elec.BeiIncontainerListPlugin");
            listShowParameter.getCustomParams().put("flexType", "currentdata");
            listShowParameter.getListFilterParameter().beginInit();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)transIds));
            listShowParameter.getListFilterParameter().endInit();
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("bei_transdetail");
            billShowParameter.setPkId(transIds.get(0));
            billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            billShowParameter.getOpenStyle().setTargetKey("detailflex");
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.getCustomParams().put("handMatchView", "handMatchView");
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
        this.getModel().setValue("selectdataid", (Object)transIds.stream().map(Object::toString).collect(Collectors.joining(",")));
        this.receiptFileInit(elecFileIds);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (BTN_OK.equals(sourceKey)) {
            String selectDataIdStr = (String)this.getModel().getValue("selectdataid");
            if (EmptyUtil.isNoEmpty((String)selectDataIdStr)) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                List selectDataIds = Arrays.stream(selectDataIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
                returnMap.put("elecFileIds", formShowParameter.getCustomParam("elecFileIds"));
                returnMap.put("transIds", selectDataIds);
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceiptMatchEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void receiptFileInit(List<Long> elecFileIds) {
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id, uploadfilename", (QFilter[])new QFilter[]{new QFilter("id", "in", elecFileIds)});
        Set fileUrls = receipts.stream().filter(receipt -> EmptyUtil.isNoEmpty((String)receipt.getString("uploadfilename"))).map(receipt -> ReceiptPrintHelper.getRealUploadUrl((String)receipt.getString("uploadfilename").trim())).collect(Collectors.toSet());
        if (fileUrls.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5b50\u56de\u5355\u6587\u4ef6\u8def\u5f84\u5f02\u5e38\u3002", (String)"ReceiptFileImportResultEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            ViewReceiptService viewReceiptService = new ViewReceiptService();
            String receiptPdfUrl = viewReceiptService.getReceiptPdfUrl(this.getView().getPageId(), elecFileIds.toArray(new Object[0]));
            if (EmptyUtil.isEmpty((String)receiptPdfUrl)) {
                throw new KDBizException("receiptPdfUrl is null.");
            }
            IFrame iframeap = (IFrame)this.getControl("iframeap");
            iframeap.setSrc(receiptPdfUrl);
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u56de\u5355\u6587\u4ef6\u9884\u89c8\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"iframeap"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6587\u4ef6\u9884\u89c8\u5f02\u5e38\u3002", (String)"ReceiptFileImportResultEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }
}

