/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.missing;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class MissingRecordLogPlugin
extends AbstractTmcBillBaseList {
    private static final String[] TITLE_COLUMNS = new String[]{"checktype", "company", "accountbank", "currency", "bizdate", "lcount", "llstbalance", "lcredittotal", "ldebittotal", "lamount", "lbalance", "edetailcount", "edetailmatchcount", "eeleccount", "eelecmatchcount", "edetaildebittotal", "edetailcredittotal", "eelecdebittotal", "eeleccredittotal", "edebitbalance", "ecreditbalance", "lcheckresult", "lcheckresultdesc", "exectime"};

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setBillFormId("bei_missingreord");
        filterContainer.addFilterContainerInitListener(this::filterContainerInit);
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        event.getFastFilterColumns().clear();
        event.getCommonFilterColumns().clear();
        event.getSchemeFilterColumns().clear();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter listShowParameter = this.getView().getFormShowParameter();
        Long missingId = (Long)listShowParameter.getCustomParam("missingId");
        this.fillPageData(missingId);
    }

    private void fillPageData(Long missingId) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", this.getTableValueSetter(missingId));
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private TableValueSetter getTableValueSetter(Long missingId) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String col : TITLE_COLUMNS) {
            vs.addField(col, new Object[0]);
        }
        DynamicObject record = TmcDataServiceHelper.loadSingleFromCache((Object)missingId, (String)"bei_missingreord");
        DynamicObjectCollection logList = record.getDynamicObjectCollection("entryentity");
        for (DynamicObject logObj : logList) {
            Long currency = Objects.nonNull(record.getDynamicObject("currency")) ? record.getDynamicObject("currency").getPkValue() : Long.valueOf(0L);
            vs.addRow(new Object[]{record.get("checktype"), record.getDynamicObject("company").getPkValue(), record.getDynamicObject("accountbank").getPkValue(), currency, record.getDate("bizdate"), logObj.get("lcount"), logObj.get("llstbalance"), logObj.get("lcredittotal"), logObj.get("ldebittotal"), logObj.get("lamount"), logObj.get("lbalance"), logObj.get("edetailcount"), logObj.get("edetailmatchcount"), logObj.get("eeleccount"), logObj.get("eelecmatchcount"), logObj.get("edetaildebittotal"), logObj.get("edetailcredittotal"), logObj.get("eelecdebittotal"), logObj.get("eeleccredittotal"), logObj.get("edebitbalance"), logObj.get("ecreditbalance"), logObj.get("lcheckresult"), logObj.get("lcheckresultdesc"), logObj.get("exectime")});
        }
        return vs;
    }
}

