/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.online;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;

public class OnlineFilterPlugin
extends AbstractTmcDyncListPlugin {
    protected FilterContainerInitArgs initArgs;
    protected FilterContainerInitEvent event;
    protected List<Object> selectedOrgIdList = new ArrayList<Object>();
    protected List<Object> selectedBankIdList = new ArrayList<Object>();
    protected List<Object> selectedAcctIdList = new ArrayList<Object>();
    protected List<Object> selectedCurrencyIdList = new ArrayList<Object>();
    protected DynamicObjectCollection accountBanks;
    protected List<ComboItem> existFinancialTypeList = new ArrayList<ComboItem>(10);
    protected List<Object> selectFinancialTypeIdList = new ArrayList<Object>(10);
    public static final String ENTITY_FINORGINFO = "bd_finorginfo";

    public void filterContainerInit(FilterContainerInitEvent event) {
        FilterContainerInitArgs args = new FilterContainerInitArgs(event);
        this.event = event;
        this.initArgs = args;
        for (FilterColumn filterColumn : event.getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("company.") && !fieldName.startsWith("financialtype.")) continue;
            commonFilterColumn.setMustInput(true);
        }
        this.cacheFirstSelectedOrg(args);
        this.initFinorgType(args);
        this.initAccountBanks(this.selectedOrgIdList);
        IPageCache pageCache = this.getPageCache();
        if (pageCache.get("favorite.name") != null) {
            long favId = Long.parseLong(pageCache.get("favorite.name"));
            DynamicObject fav = TmcDataServiceHelper.loadSingleFromCache((Object)favId, (String)"bei_account_favorite");
            DynamicObject bank = TmcDataServiceHelper.loadSingleFromCache((Object)fav.getLong("accountbank.bank.id"), (String)ENTITY_FINORGINFO);
            this.selectedOrgIdList.add(fav.getLong("accountbank.company.id"));
            this.selectFinancialTypeIdList.clear();
            this.selectFinancialTypeIdList.add(bank.getLong("finorgtype.id"));
            if (FinOrgTypeEnum.BANK.getNumber().equals(bank.getString("finorgtype.number"))) {
                this.selectedBankIdList.add(bank.getLong("bank_cate.id"));
            } else {
                this.selectedBankIdList.add(bank.getPkValue());
            }
            this.selectedAcctIdList.add(fav.getLong("accountbank.id"));
            this.selectedCurrencyIdList.add(fav.getLong("currency.id"));
            pageCache.remove("favorite.name");
            pageCache.remove("init");
        }
        if (pageCache.get("init") == null) {
            pageCache.put("init", "true");
            this.initFilterItem(args);
            for (QFilter qfilter : this.getQFilterFromPagCache()) {
                pageCache.put(qfilter.getProperty(), qfilter.getValue().toString());
            }
        }
    }

    protected void fillPageData() {
    }

    protected String getEntityName() {
        return "bei_bankbalance_view";
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        IPageCache pageCache = this.getPageCache();
        Map filtervalue = event.getFilterValues();
        List customfilterList = (List)filtervalue.get("customfilter");
        String orgId = "";
        String financialTypeId = "";
        String bankId = "";
        String accountBankId = "";
        String currencyId = "";
        for (Map map : customfilterList) {
            String value;
            String FieldName = ((List)map.get("FieldName")).size() > 0 ? ((List)map.get("FieldName")).get(0).toString() : "";
            String string = value = ((List)map.get("Value")).size() > 0 ? ((List)map.get("Value")).get(0).toString() : "";
            if (FieldName.equals("company.id")) {
                orgId = value;
                continue;
            }
            if (FieldName.equals("bank.bank_cate.id")) {
                bankId = value;
                continue;
            }
            if (FieldName.equals("accountbank.id")) {
                accountBankId = value;
                continue;
            }
            if (FieldName.equals("currency.id")) {
                currencyId = value;
                continue;
            }
            if (!FieldName.equals("financialtype.id")) continue;
            financialTypeId = value;
        }
        this.selectedOrgIdList.clear();
        this.selectFinancialTypeIdList.clear();
        this.selectedBankIdList.clear();
        this.selectedAcctIdList.clear();
        this.selectedCurrencyIdList.clear();
        String clickFieldName = ((List)event.getCurrentCommonFilter().get("FieldName")).get(0).toString();
        switch (clickFieldName) {
            case "company.id": {
                filtervalue.put("customfilter", this.filterFieldName(customfilterList, "company.id"));
                this.selectFinancialTypeIdList.clear();
                this.selectFinancialTypeIdList.add(Long.valueOf("615763944224700416"));
                this.getPageCache().put("selectFinancialTypeId", "615763944224700416");
                break;
            }
            case "financialtype.id": {
                filtervalue.put("customfilter", this.filterFieldName(customfilterList, "financialtype.id"));
                if (!StringUtils.isNotEmpty((CharSequence)financialTypeId)) break;
                this.selectFinancialTypeIdList.add(Long.valueOf(financialTypeId));
                pageCache.put("selectFinancialTypeId", financialTypeId);
                break;
            }
            case "bank.bank_cate.id": {
                filtervalue.put("customfilter", this.filterFieldName(customfilterList, "company.id", "financialtype.id", "bank.bank_cate.id"));
                if (StringUtils.isNotEmpty((CharSequence)financialTypeId)) {
                    this.selectFinancialTypeIdList.add(Long.valueOf(financialTypeId));
                }
                if (!StringUtils.isNotEmpty((CharSequence)bankId)) break;
                this.selectedBankIdList.add(Long.valueOf(bankId));
                break;
            }
            case "accountbank.id": {
                filtervalue.put("customfilter", this.filterFieldName(customfilterList, "company.id", "financialtype.id", "bank.bank_cate.id", "accountbank.id"));
                if (StringUtils.isNotEmpty((CharSequence)financialTypeId)) {
                    this.selectFinancialTypeIdList.add(Long.valueOf(financialTypeId));
                }
                if (StringUtils.isNotEmpty((CharSequence)bankId)) {
                    this.selectedBankIdList.add(Long.valueOf(bankId));
                }
                if (!StringUtils.isNotEmpty((CharSequence)accountBankId)) break;
                this.selectedAcctIdList.add(Long.valueOf(accountBankId));
                break;
            }
            case "currency.id": {
                filtervalue.put("customfilter", this.filterFieldName(customfilterList, "company.id", "financialtype.id", "bank.bank_cate.id", "accountbank.id", "currency.id"));
                if (StringUtils.isNotEmpty((CharSequence)financialTypeId)) {
                    this.selectFinancialTypeIdList.add(Long.valueOf(financialTypeId));
                }
                if (StringUtils.isNotEmpty((CharSequence)bankId)) {
                    this.selectedBankIdList.add(Long.valueOf(bankId));
                }
                if (StringUtils.isNotEmpty((CharSequence)accountBankId)) {
                    this.selectedAcctIdList.add(Long.valueOf(accountBankId));
                }
                if (!StringUtils.isNotEmpty((CharSequence)currencyId)) break;
                this.selectedCurrencyIdList.add(Long.valueOf(currencyId));
            }
        }
        if (this.selectedOrgIdList.isEmpty() && EmptyUtil.isNotBlank((CharSequence)orgId)) {
            this.selectedOrgIdList.add(Long.parseLong(orgId));
        }
        this.filterContainerInit(this.event);
        this.initFilterItem(this.initArgs);
        for (QFilter qfilter : this.getQFilterFromPagCache()) {
            pageCache.put(qfilter.getProperty(), qfilter.getValue().toString());
        }
    }

    private List<Map<String, List<Object>>> filterFieldName(List<Map<String, List<Object>>> customfilterList, String ... keys) {
        List<String> list = Arrays.asList(keys);
        return customfilterList.stream().filter(t -> list.contains(((List)t.get("FieldName")).get(0).toString())).collect(Collectors.toList());
    }

    private void initFilterItem(FilterContainerInitArgs args) {
        IPageCache pageCache = this.getPageCache();
        ArrayList<String> qFilterStrList = new ArrayList<String>();
        String bankaccountnumber = null;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List listcomitem;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.equals("company.name") && this.selectedOrgIdList.size() > 0) {
                commonFilterColumn.setDefaultValue(this.selectedOrgIdList.get(0).toString());
                qFilterStrList.add(new QFilter("company.id", "=", this.selectedOrgIdList.get(0)).toSerializedString());
            }
            if (fieldName.equals("financialtype.name")) {
                commonFilterColumn.setComboItems(this.existFinancialTypeList);
                if (this.selectFinancialTypeIdList.size() > 0) {
                    commonFilterColumn.setDefaultValue(String.valueOf(this.selectFinancialTypeIdList.get(0)));
                    qFilterStrList.add(new QFilter("financialtype.id", "=", (Object)String.valueOf(this.selectFinancialTypeIdList.get(0))).toSerializedString());
                }
            }
            if (fieldName.equals("bank.bank_cate.name")) {
                List<ComboItem> bankItems = this.initBankItemsList();
                listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                commonFilterColumn.setComboItems(bankItems);
                if (commonFilterColumn.getComboItems().size() > 0) {
                    if (this.selectedBankIdList.size() == 0) {
                        this.selectedBankIdList.add(Long.valueOf(((ComboItem)commonFilterColumn.getComboItems().get(0)).getValue()));
                    }
                    commonFilterColumn.setDefaultValue(this.selectedBankIdList.get(0).toString());
                    qFilterStrList.add(new QFilter("bank.id", "=", (Object)Long.valueOf(this.selectedBankIdList.get(0).toString())).toSerializedString());
                }
            }
            if (fieldName.equals("accountbank.bankaccountnumber")) {
                List<ComboItem> acctItems = this.initAcctItemsList();
                listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                commonFilterColumn.setComboItems(acctItems);
                if (commonFilterColumn.getComboItems().size() > 0) {
                    bankaccountnumber = this.selectedAcctIdList.size() > 0 ? this.selectedAcctIdList.get(0).toString() : ((ComboItem)commonFilterColumn.getComboItems().get(0)).getValue();
                    commonFilterColumn.setDefaultValue(bankaccountnumber);
                    qFilterStrList.add(new QFilter("accountbank.id", "=", (Object)Long.valueOf(bankaccountnumber)).toSerializedString());
                }
            }
            if (!fieldName.equals("currency.name")) continue;
            List<ComboItem> currencyItems = this.initCurrencyItemsList(bankaccountnumber);
            listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(currencyItems);
            if (commonFilterColumn.getComboItems().size() <= 0) continue;
            commonFilterColumn.setDefaultValue(this.selectedCurrencyIdList.size() > 0 ? this.selectedCurrencyIdList.get(0).toString() : ((ComboItem)commonFilterColumn.getComboItems().get(0)).getValue());
            Object selectedCurrencyId = !this.selectedCurrencyIdList.isEmpty() ? this.selectedCurrencyIdList.get(0) : commonFilterColumn.getDefaultValues().get(0);
            qFilterStrList.add(new QFilter("currency.id", "=", (Object)Long.valueOf(selectedCurrencyId.toString())).toSerializedString());
        }
        qFilterStrList.add(new QFilter("bizdate", ">=", (Object)DateUtils.getCurrentDate()).toSerializedString());
        pageCache.put("qfilters", SerializationUtils.toJsonString(qFilterStrList));
    }

    protected List<ComboItem> initBankItemsList() {
        ArrayList<ComboItem> acctItems;
        block6: {
            List banks;
            String finorgTypeNumber;
            ArrayList<QFilter> qfiltersAccount;
            block7: {
                acctItems = new ArrayList<ComboItem>();
                qfiltersAccount = new ArrayList<QFilter>();
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
                DynamicObjectCollection finorgTypes = null;
                if (this.selectFinancialTypeIdList != null && this.selectFinancialTypeIdList.size() > 0) {
                    qfiltersAccount.add(new QFilter("finorgtype", "in", this.selectFinancialTypeIdList));
                    QFilter typeQfilter = new QFilter("id", "in", this.selectFinancialTypeIdList);
                    typeQfilter.and(new QFilter("enable", "=", (Object)"1"));
                    finorgTypes = QueryServiceHelper.query((String)"bd_finorgtype", (String)"id,name,number", (QFilter[])typeQfilter.toArray());
                }
                if (finorgTypes == null || finorgTypes.size() <= 0) break block6;
                finorgTypeNumber = ((DynamicObject)finorgTypes.get(0)).getString("number");
                if (!finorgTypeNumber.equals(FinOrgTypeEnum.BANK.getNumber())) break block7;
                if (this.selectedOrgIdList != null && this.selectedOrgIdList.size() > 0) {
                    qfilters.add(new QFilter("company.id", "in", this.selectedOrgIdList));
                }
                qfilters.add(new QFilter("bank.finorgtype.number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()));
                qfilters.add(new QFilter("issetbankinterface", "=", (Object)"1"));
                qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"bank", (QFilter[])qfilters.toArray(new QFilter[0]));
                for (int i = 0; i < accountBanks.length; ++i) {
                    DynamicObject cashAcct;
                    DynamicObject bank = accountBanks[i].getDynamicObject("bank");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)bank) || (cashAcct = bank.getDynamicObject("bank_cate")) == null) continue;
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(cashAcct.getString("name")));
                    item.setValue(cashAcct.getString("id"));
                    if (acctItems.contains(item)) continue;
                    acctItems.add(item);
                }
                break block6;
            }
            if (!finorgTypeNumber.equals(FinOrgTypeEnum.TRDPARTPAY.getNumber()) && !finorgTypeNumber.equals(FinOrgTypeEnum.FINCOMP.getNumber())) break block6;
            DynamicObjectCollection finorgInfos = QueryServiceHelper.query((String)ENTITY_FINORGINFO, (String)"name,id", (QFilter[])qfiltersAccount.toArray(new QFilter[0]));
            List finorgInfoIds = finorgInfos.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            ArrayList<QFilter> accBankQfilter = new ArrayList<QFilter>();
            if (this.selectedOrgIdList != null && this.selectedOrgIdList.size() > 0) {
                accBankQfilter.add(new QFilter("company.id", "in", this.selectedOrgIdList));
            }
            accBankQfilter.add(new QFilter("bank", "in", finorgInfoIds));
            accBankQfilter.add(new QFilter("issetbankinterface", "=", (Object)"1"));
            accBankQfilter.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            DynamicObject[] accBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank", (QFilter[])accBankQfilter.toArray(new QFilter[0]));
            if (accBanks != null && accBanks.length > 0 && (banks = Arrays.stream(accBanks).map(e -> e.getDynamicObject("bank")).collect(Collectors.toList())).size() > 0) {
                for (DynamicObject bank : banks) {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(bank.getString("name")));
                    item.setValue(String.valueOf(bank.getLong("id")));
                    if (acctItems.contains(item)) continue;
                    acctItems.add(item);
                }
            }
        }
        return acctItems;
    }

    protected List<ComboItem> initAcctItemsList() {
        String selectProperties = "id,name,number,isbycurrency,defaultcurrency,bankaccountnumber,currency,bank,bebank,union_number";
        List<QFilter> qfilters = this.getAccountBankFilterByOrgId(this.selectedOrgIdList);
        if (this.selectedBankIdList != null && this.selectedBankIdList.size() > 0) {
            DynamicObject acountBankTempDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank.id", "in", this.selectedBankIdList)});
            if (EmptyUtil.isNoEmpty((DynamicObject)acountBankTempDO)) {
                qfilters.add(new QFilter("bank.id", "in", this.selectedBankIdList));
            } else {
                qfilters.add(new QFilter("bank.bank_cate.id", "in", this.selectedBankIdList));
            }
        }
        DynamicObjectCollection accountbankDO = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])qfilters.toArray(new QFilter[0]));
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (accountbankDO != null && accountbankDO.size() > 0) {
            for (int i = 0; i < accountbankDO.size(); ++i) {
                DynamicObject cashAcct = (DynamicObject)accountbankDO.get(i);
                if (cashAcct == null) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bankaccountnumber")));
                item.setValue(String.valueOf(cashAcct.getLong("id")));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    protected List<ComboItem> initCurrencyItemsList(String bankaccountnumber) {
        ArrayList<ComboItem> currencyItems = new ArrayList<ComboItem>();
        for (DynamicObject cashAcct : this.accountBanks) {
            Long currencyId;
            if (bankaccountnumber == null || !bankaccountnumber.equals(cashAcct.get("id").toString())) continue;
            Long defaultCurrencyId = cashAcct.getLong("defaultcurrency.id");
            ComboItem defalutitem = new ComboItem();
            if (EmptyUtil.isNoEmpty((Long)defaultCurrencyId)) {
                defalutitem.setCaption(new LocaleString(cashAcct.getString("defaultcurrency.name")));
                defalutitem.setValue(String.valueOf(defaultCurrencyId));
                if (!currencyItems.contains(defalutitem)) {
                    currencyItems.add(defalutitem);
                }
            }
            if (!EmptyUtil.isNoEmpty((Long)(currencyId = Long.valueOf(cashAcct.getLong("currency.fbasedataid.id"))))) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cashAcct.getString("currency.fbasedataid.name")));
            item.setValue(String.valueOf(currencyId));
            if (currencyItems.contains(item)) continue;
            currencyItems.add(item);
        }
        return currencyItems;
    }

    protected void initAccountBanks(List<Object> selectedOrgIdList) {
        String selectProperties = "id,name,number,isbycurrency,defaultcurrency,bankaccountnumber,currency,bank";
        List<QFilter> qfilters = this.getAccountBankFilterByOrgId(selectedOrgIdList);
        if (this.selectedBankIdList != null && this.selectedBankIdList.size() > 0) {
            DynamicObject acountBankTempDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank.id", "in", this.selectedBankIdList).and(VisibleVirtualAcctHelper.notVirtualAcctQf())});
            if (EmptyUtil.isNoEmpty((DynamicObject)acountBankTempDO)) {
                qfilters.add(new QFilter("bank.id", "in", this.selectedBankIdList));
            } else {
                qfilters.add(new QFilter("bank.bank_cate.id", "in", this.selectedBankIdList));
            }
        }
        this.accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.id,currency.fbasedataid.name", (QFilter[])qfilters.toArray(new QFilter[0]));
    }

    private void initFinorgType(FilterContainerInitArgs args) {
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("financialtype.name")) continue;
            List items = commonFilterColumn.getComboItems();
            Optional<ComboItem> bankItem = items.stream().filter(e -> e.getValue().equals("615763944224700416")).findFirst();
            Optional<ComboItem> threeItem = items.stream().filter(e -> e.getValue().equals("622211932153277440")).findFirst();
            Optional<ComboItem> fiItem = items.stream().filter(e -> e.getValue().equals("630840871381746688")).findFirst();
            List<Object> filterItems = new ArrayList<ComboItem>();
            if (bankItem.isPresent()) {
                filterItems.add(bankItem.get());
            }
            if (threeItem.isPresent()) {
                filterItems.add(threeItem.get());
            }
            if (fiItem.isPresent()) {
                filterItems.add(fiItem.get());
            }
            ArrayList<QFilter> accountBankFilter = new ArrayList<QFilter>(10);
            accountBankFilter.add(new QFilter("bank.finorgtype.number", "=", (Object)FinOrgTypeEnum.TRDPARTPAY.getNumber()));
            if (this.selectedOrgIdList != null && this.selectedOrgIdList.size() > 0) {
                accountBankFilter.add(new QFilter("company.id", "in", this.selectedOrgIdList));
            } else if (this.getPageCache().get("favorite.name") != null) {
                long favId = Long.parseLong(this.getPageCache().get("favorite.name"));
                DynamicObject fav = TmcDataServiceHelper.loadSingleFromCache((Object)favId, (String)"bei_account_favorite");
                accountBankFilter.add(new QFilter("company.id", "in", (Object)fav.getLong("accountbank.company.id")));
            }
            accountBankFilter.add(new QFilter("issetbankinterface", "=", (Object)"1"));
            accountBankFilter.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            DynamicObjectCollection trdpartpayBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])accountBankFilter.toArray(new QFilter[0]));
            if (trdpartpayBanks == null || trdpartpayBanks.size() == 0) {
                filterItems = filterItems.stream().filter(e -> !e.getValue().equals("622211932153277440")).collect(Collectors.toList());
            }
            accountBankFilter.remove(0);
            accountBankFilter.add(new QFilter("bank.finorgtype.number", "=", (Object)FinOrgTypeEnum.FINCOMP.getNumber()));
            DynamicObjectCollection fincompBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])accountBankFilter.toArray(new QFilter[0]));
            if (fincompBanks == null || fincompBanks.size() == 0) {
                filterItems = filterItems.stream().filter(e -> !e.getValue().equals("630840871381746688")).collect(Collectors.toList());
            }
            if (this.selectFinancialTypeIdList.size() == 0) {
                this.selectFinancialTypeIdList.add(Long.valueOf(((ComboItem)filterItems.get(0)).getValue()));
            }
            this.existFinancialTypeList = filterItems;
        }
    }

    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        if (this.getPageCache().get("isPageOpen") == null) {
            this.getPageCache().put("isPageOpen", "true");
            String firstOrgId = null;
            if (this.isDefaultOpen()) {
                for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                    List orgItems;
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    String fieldName = commonFilterColumn.getFieldName();
                    if (!fieldName.startsWith("company.name") || (orgItems = commonFilterColumn.getComboItems()) == null || orgItems.size() <= 0) continue;
                    String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                    for (int i = 0; i < orgItems.size(); ++i) {
                        ComboItem item = (ComboItem)orgItems.get(i);
                        if (!item.getValue().equals(loginOrg)) continue;
                        firstOrgId = loginOrg;
                        break;
                    }
                    if (firstOrgId != null) continue;
                    List defaultVals = commonFilterColumn.getDefaultValues();
                    if (defaultVals != null && defaultVals.size() > 0) {
                        firstOrgId = (String)defaultVals.get(0);
                        continue;
                    }
                    firstOrgId = ((ComboItem)orgItems.get(0)).getValue();
                }
            } else {
                firstOrgId = this.getView().getFormShowParameter().getCustomParam("company.name").toString();
            }
            if (firstOrgId != null) {
                this.selectedOrgIdList.clear();
            }
            if (firstOrgId != null) {
                this.selectedOrgIdList.add(Long.valueOf(firstOrgId));
            }
            this.cacheSelectedOrgIdList(this.selectedOrgIdList);
            this.getPageCache().put("company.name", firstOrgId);
        }
    }

    protected boolean isDefaultOpen() {
        FormShowParameter parameters = this.getView().getFormShowParameter();
        return parameters.getCustomParam("setDefaultFilters") == null;
    }

    private void cacheSelectedOrgIdList(List<Object> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List<ComboItem> currencyItems;
        Long loginOrg = RequestContext.get().getOrgId();
        this.selectedOrgIdList.add(loginOrg);
        this.initAccountBanks(this.selectedOrgIdList);
        List<ComboItem> acctItems = this.initAcctItemsList();
        if (acctItems.size() > 0 && (currencyItems = this.initCurrencyItemsList(acctItems.get(0).getValue())).size() > 0) {
            this.getModel().setValue("currency", (Object)Long.valueOf(currencyItems.get(0).getValue()));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        IPageCache pageCache = this.getPageCache();
        String orgId = pageCache.get("company.id");
        String bankId = pageCache.get("bank.id");
        List qfilters = args.getQfilters();
        if ("accountbank.id".equals(fieldName)) {
            qfilters.addAll(this.getAccountBankFilterByOrgId(Collections.singletonList(Long.valueOf(orgId))));
            if (StringUtils.isNotBlank((CharSequence)bankId)) {
                List<Long> bankIds = Collections.singletonList(Long.parseLong(bankId));
                DynamicObject acountBankTempDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bank.id", "in", bankIds)});
                if (EmptyUtil.isNoEmpty((DynamicObject)acountBankTempDO)) {
                    qfilters.add(new QFilter("bank.id", "in", bankIds));
                } else {
                    qfilters.add(new QFilter("bank.bank_cate.id", "in", bankIds));
                }
            }
        } else if ("bank.bank_cate.id".equals(fieldName)) {
            String selectFinancialTypeId = this.getPageCache().get("selectFinancialTypeId");
            if (selectFinancialTypeId != null) {
                DynamicObjectCollection finorgtype = QueryServiceHelper.query((String)"bd_finorgtype", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(selectFinancialTypeId)).toArray());
                if (finorgtype != null && finorgtype.size() > 0) {
                    String finorgTypeNumber = ((DynamicObject)finorgtype.get(0)).getString("number");
                    if (finorgTypeNumber.equals(FinOrgTypeEnum.BANK.getNumber())) {
                        List<QFilter> bankFilters = this.getAccountBankFilterByOrgId(Collections.singletonList(Long.valueOf(orgId)));
                        bankFilters.add(QFilter.isNotNull((String)"bank"));
                        List cateIds = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"bank", (QFilter[])bankFilters.toArray(new QFilter[0])).values().stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("bank"))).map(t -> t.getDynamicObject("bank.bank_cate")).filter(EmptyUtil::isNoEmpty).map(t -> t.getLong("id")).collect(Collectors.toList());
                        qfilters.add(new QFilter("id", "in", cateIds));
                    } else if (finorgTypeNumber.equals(FinOrgTypeEnum.TRDPARTPAY.getNumber()) || finorgTypeNumber.equals(FinOrgTypeEnum.FINCOMP.getNumber())) {
                        args.setRefEntityId(ENTITY_FINORGINFO);
                        ArrayList<QFilter> qfiltersAccount = new ArrayList<QFilter>(10);
                        qfiltersAccount.add(new QFilter("finorgtype", "=", (Object)Long.valueOf(selectFinancialTypeId)));
                        DynamicObjectCollection finorgInfos = QueryServiceHelper.query((String)ENTITY_FINORGINFO, (String)"name,id", (QFilter[])qfiltersAccount.toArray(new QFilter[0]));
                        List finorgInfoIds = finorgInfos.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                        ArrayList<QFilter> accBankQfilter = new ArrayList<QFilter>();
                        if (this.selectedOrgIdList != null && this.selectedOrgIdList.size() > 0) {
                            accBankQfilter.add(new QFilter("company.id", "in", this.selectedOrgIdList));
                        }
                        accBankQfilter.add(new QFilter("bank", "in", finorgInfoIds));
                        accBankQfilter.add(new QFilter("issetbankinterface", "=", (Object)"1"));
                        accBankQfilter.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                        DynamicObjectCollection accBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank.id", (QFilter[])accBankQfilter.toArray(new QFilter[0]));
                        List cateIds = accBanks.stream().map(e -> e.getLong("bank.id")).collect(Collectors.toList());
                        qfilters.add(new QFilter("id", "in", cateIds));
                    }
                }
            } else {
                List<QFilter> bankFilters = this.getAccountBankFilterByOrgId(Collections.singletonList(Long.valueOf(orgId)));
                bankFilters.add(QFilter.isNotNull((String)"bank"));
                List cateIds = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"bank", (QFilter[])bankFilters.toArray(new QFilter[0])).values().stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("bank"))).map(t -> t.getDynamicObject("bank.bank_cate")).filter(EmptyUtil::isNoEmpty).map(t -> t.getLong("id")).collect(Collectors.toList());
                qfilters.add(new QFilter("id", "in", cateIds));
            }
        }
    }

    private List<QFilter> getAccountBankFilterByOrgId(List<Object> orgIds) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(10);
        if (!EmptyUtil.isEmpty(orgIds)) {
            qfilters.add(new QFilter("company.id", "in", orgIds));
        }
        qfilters.add(new QFilter("bank.finorgtype.number", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getNumber()));
        qfilters.add(new QFilter("issetbankinterface", "=", (Object)"1"));
        qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        return qfilters;
    }
}

