/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.priorityconvert;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RecEleDraftBillHandleConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(RecEleDraftBillHandleConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntityArr;
        for (ExtendedDataEntity billDataEntity : billDataEntityArr = e.getTargetExtDataEntitySet().FindByEntityKey("cdm_receivablebill")) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object srcCurrency = ((DynamicProperty)e.getFldProperties().get("currencytext")).getValue(srcData.get(0));
            Object collAccBankNo = ((DynamicProperty)e.getFldProperties().get("collectionbankno")).getValue(srcData.get(0));
            Object issueAccBankNo = ((DynamicProperty)e.getFldProperties().get("issueticketbankno")).getValue(srcData.get(0));
            DynamicObjectCollection currObjColl = QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", srcCurrency)});
            DynamicObjectCollection bankObjColl = QueryServiceHelper.query((String)"bd_bebank", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", Arrays.asList(collAccBankNo, issueAccBankNo))});
            if (!Objects.isNull(currObjColl) && bankObjColl.size() > 0) {
                DynamicObject currencyObj = (DynamicObject)currObjColl.get(0);
                targetBill.set("currency", currencyObj.get("id"));
            }
            if (Objects.isNull(bankObjColl) || bankObjColl.size() <= 0) continue;
            Map bankObjMap = bankObjColl.stream().collect(Collectors.toMap(item -> item.get("number"), Function.identity(), (k1, k2) -> k1));
            DynamicObject collBankObj = (DynamicObject)bankObjMap.get(bankObjColl);
            DynamicObject issueBankObj = (DynamicObject)bankObjMap.get(bankObjColl);
            if (!Objects.isNull(collBankObj)) {
                targetBill.set("receiverbank", collBankObj.get("id"));
            }
            if (Objects.isNull(issueBankObj)) continue;
            targetBill.set("drawerbank", issueBankObj.get("id"));
        }
    }
}

