/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.proxybank;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.BeBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;

public class ProxyBankEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"proxyacct"});
    }

    public void click(EventObject evt) {
        String keyName;
        super.click(evt);
        Control key = (Control)evt.getSource();
        switch (keyName = key.getKey()) {
            case "proxyacct": {
                this.showBankInfo();
            }
        }
    }

    private void showBankInfo() {
        Object bankname = this.getModel().getValue("bankname");
        if (EmptyUtil.isEmpty((Object)bankname)) {
            throw new BEBizException(new BeBizErrorCode().BANKNAME_ISNULL());
        }
        ListShowParameter lsp = new ListShowParameter();
        String msg = "";
        List acctcompanyIdList = this.getAuthAcctList("company").stream().map(o -> o.getDynamicObject("company").getPkValue()).distinct().collect(Collectors.toList());
        QFilter filter = new QFilter("company", "in", acctcompanyIdList).and(new QFilter("bank", "=", ((DynamicObject)bankname).getPkValue())).and(new QFilter("acctstatus", "in", (Object)BankAcctStatusEnum.NORMAL.getValue()));
        boolean isExists = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
        if (isExists) {
            lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((QFilter)filter);
        } else {
            msg = ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6240\u9009\u4ee3\u7406\u884c\u5f00\u6237\u7684\u8d26\u6237\uff0c\u8bf7\u624b\u5de5\u5f55\u5165\u3002", (String)"ProxyBankEdit_01", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        }
        if (!EmptyUtil.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(2000));
        } else if (lsp != null) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "proxyacct");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData != null && "proxyacct".equals(actionId)) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            Object pkValue = data.getPrimaryKeyValues()[0];
            DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"bd_accountbanks");
            String bankAcct = bankAccount.getString("bankaccountnumber");
            this.getModel().setValue("proxyacct", (Object)bankAcct);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (EmptyUtil.isEmpty((Object)newValue) && "bankname".equals(key)) {
            this.getModel().setValue("name", null);
            this.getModel().setValue("swift_code", null);
            this.getModel().setValue("address", null);
            this.getModel().setValue("country", null);
            this.getModel().setValue("proxyacct", null);
            return;
        }
        if (EmptyUtil.isEmpty((Object)newValue) || newValue.equals(oldValue)) {
            return;
        }
        switch (key) {
            case "bankname": {
                this.getModel().setValue("name", ((DynamicObject)newValue).get("name"));
                this.getModel().setValue("swift_code", ((DynamicObject)newValue).get("swift_code"));
                this.getModel().setValue("address", ((DynamicObject)newValue).get("address"));
                this.getModel().setValue("country", ((DynamicObject)newValue).get("country"));
                this.getModel().setValue("proxyacct", null);
            }
        }
    }

    private List<DynamicObject> getAuthAcctList(String selectProperties) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter companyIdFilter = new QFilter("company", "in", (Object)authOrgList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        List<DynamicObject> authAcctList = Stream.of(TmcDataServiceHelper.load((String)"bd_accountbanks", (String)selectProperties, (QFilter[])new QFilter[]{companyIdFilter, enableFilter})).collect(Collectors.toList());
        return authAcctList;
    }
}

