/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.sign;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.formplugin.sign.RepaySignExecutor;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.sign.CommitBeCrossBillSignBasePlugin;
import kd.tmc.fbp.common.sign.ISignExecutor;
import kd.tmc.fbp.common.sign.ISignInvoker;
import kd.tmc.fbp.common.sign.SignHandler;

public class BankTransRepayCrossBillSignPlugin
extends CommitBeCrossBillSignBasePlugin
implements ISignInvoker {
    public static final String OP_NAME = "repay";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (OP_NAME.equals(op.getOperateKey())) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (OP_NAME.equals(opKey) && result.isSuccess()) {
            List successIdList = result.getSuccessPkIds();
            if (result.isSuccess() && successIdList != null && successIdList.size() > 0) {
                this.sign(successIdList);
            } else {
                throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result));
            }
        }
    }

    protected void onSignSuccess(String errMsg) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u6210\u529f\u3002", (String)"BankTransRepayCrossBillSignPlugin_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public SignHandler createHandler(boolean isInit) {
        String entityName = this.getEntityName();
        String successIdList = this.getPageCache().get("_KEY_SUCCESSIDLIST_");
        List bankTransBillIdList = (List)SerializationUtils.fromJsonString((String)successIdList, List.class);
        List<DynamicObject> bankTransBillList = Arrays.stream(BusinessDataServiceHelper.load((Object[])bankTransBillIdList.stream().map(Object::toString).map(Long::parseLong).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))).collect(Collectors.toList());
        if (bankTransBillList.size() > 0) {
            List<Object> needCommitBeIdList = bankTransBillList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            RepaySignExecutor executor = new RepaySignExecutor(bankTransBillList, this.getEntityName(), needCommitBeIdList, false);
            return new SignHandler(this.getView(), (ISignInvoker)this, isInit, new ISignExecutor[]{executor});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u63d0\u4ea4\u94f6\u4f01\u7684\u8bb0\u5f55", (String)"TransBillCommitBeSignPlugin_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
    }
}

