/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.sign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.formplugin.sign.RepaySignExecutor;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.sign.CommitBeCrossBillSignBasePlugin;
import kd.tmc.fbp.common.sign.ISignExecutor;
import kd.tmc.fbp.common.sign.ISignInvoker;

public class RepayCrossBillSignPlugin
extends CommitBeCrossBillSignBasePlugin
implements ISignInvoker {
    public static final String OP_NAME = "repay";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (OP_NAME.equals(op.getOperateKey())) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (OP_NAME.equals(opKey)) {
            List successIdList = result.getSuccessPkIds();
            if (CollectionUtils.isNotEmpty((Collection)successIdList)) {
                this.sign(successIdList);
            } else {
                throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result));
            }
        }
    }

    protected void onSignSuccess(String errMsg) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u6210\u529f\u3002", (String)"BankTransRepayCrossBillSignPlugin_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    protected String getOpName() {
        return OP_NAME;
    }

    protected String getOrgPropName() {
        return "company";
    }

    protected List<ISignExecutor> getSignExecutors(List<DynamicObject> auditPayBillList, List<DynamicObject> submitPayBillList, List<Object> needCommitBeIdList) {
        ArrayList<ISignExecutor> executors = new ArrayList<ISignExecutor>();
        if (submitPayBillList.size() > 0) {
            executors.add(new RepaySignExecutor(submitPayBillList, this.getEntityName(), needCommitBeIdList, true));
        }
        if (auditPayBillList.size() > 0) {
            executors.add(new RepaySignExecutor(auditPayBillList, this.getEntityName(), needCommitBeIdList, false));
        }
        return executors;
    }
}

