/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.sign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.constants.DBRouteConst;
import kd.tmc.bei.common.helper.BankBillCloneHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.sign.ISignExecutor;

public class RepaySignExecutor
implements ISignExecutor {
    private static Log logger = LogFactory.getLog(RepaySignExecutor.class);
    private String entityName;
    private List<DynamicObject> bankBillList;
    private Set<Object> needCommitBeIdList;
    private boolean isBankBillAudit;
    private String srouceType;
    private List<DynamicObject> targetBillList;
    private StringBuilder errorMessage = new StringBuilder();

    public RepaySignExecutor(List<DynamicObject> bankBillList, String entityName, List<Object> needCommitBeIdList, boolean isBankBillAudit) {
        this.bankBillList = bankBillList;
        this.entityName = entityName;
        this.needCommitBeIdList = new HashSet<Object>(needCommitBeIdList);
        this.isBankBillAudit = isBankBillAudit;
    }

    public List<Object> prepareSignData() {
        DynamicObject[] targetBillArr = BusinessDataServiceHelper.load((String)this.entityName, (String)"tempstatus", (QFilter[])new QFilter[]{new QFilter("lastsourcebillid", "in", (Object)this.bankBillList.stream().map(DataEntityBase::getPkValue).toArray())});
        if (targetBillArr.length > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6709\u5931\u8d25\u91cd\u4ed8\u5355\u636e, \u4e0d\u5141\u8bb8\u518d\u6b21\u5931\u8d25\u91cd\u4ed8\u3002", (String)"RepaySignExecutor_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject bankBill : this.bankBillList) {
            bankBill.set("billstatus", (Object)BillStatusEnum.REPAY.getValue());
            bankBill.set("payunique", bankBill.getPkValue());
        }
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            String tableName = this.bankBillList.get(0).getDynamicObjectType().getAlias();
            String payStatusAlias = "bei_bankpaybill".equals(this.entityName) ? "fbankpaystate" : "fpaystate";
            List idList = this.bankBillList.stream().map(o -> (Long)o.getPkValue()).collect(Collectors.toList());
            String sql = "update " + tableName + " set fbillstatus = ? where fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and fbillstatus = ? and (" + payStatusAlias + " = ? or " + payStatusAlias + " = ?)";
            int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{BillStatusEnum.REPAY.getValue(), BillStatusEnum.AUDIT.getValue(), BeBillStatusEnum.TF.getValue(), BeBillStatusEnum.PS.getValue()}));
            if (result.length < 1 || result[0] != idList.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u6700\u65b0\u72b6\u6001\u518d\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", (String)"GenerateBankPayBillService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            SaveServiceHelper.save((DynamicObject[])this.bankBillList.toArray(new DynamicObject[0]));
            this.targetBillList = new ArrayList<DynamicObject>(this.bankBillList.size());
            for (DynamicObject info : this.bankBillList) {
                DynamicObject billClone;
                boolean isCommitBe = this.needCommitBeIdList.contains(info.getPkValue());
                if ("bei_bankpaybill".equals(this.entityName)) {
                    billClone = BankBillCloneHelper.cloneBankPayBill((DynamicObject)info, (boolean)isCommitBe, (boolean)this.isBankBillAudit);
                    this.srouceType = info.getString("srcbilltype");
                } else if ("bei_bankagentpay".equals(this.entityName)) {
                    billClone = BankBillCloneHelper.cloneBankAgentBill((DynamicObject)info, (boolean)isCommitBe, (boolean)this.isBankBillAudit);
                    this.srouceType = "cas_agentpaybill";
                } else if ("bei_banktransupbill".equals(this.entityName) || "bei_banktransdownbill".equals(this.entityName)) {
                    billClone = BankBillCloneHelper.cloneBankTransBill((DynamicObject)info, (boolean)isCommitBe, (boolean)this.isBankBillAudit);
                    this.srouceType = "bei_banktransupbill".equals(this.entityName) ? "fca_transupbill" : "fca_transdownbill";
                } else {
                    throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"RepaySignExecutor_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                }
                billClone.set("payunique", (Object)-1L);
                this.targetBillList.add(billClone);
            }
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("srcEntityNumber", this.srouceType);
            OperationResult opResult = TmcOperateServiceHelper.execOperate((String)"save", (String)this.entityName, (DynamicObject[])this.targetBillList.toArray(new DynamicObject[0]), (OperateOption)operate);
            List successPkIdList = opResult.getSuccessPkIds();
            if (successPkIdList != null && successPkIdList.size() > 0) {
                this.targetBillList = Arrays.asList((DynamicObject[])TmcDataServiceHelper.load((Object[])successPkIdList.toArray(), (IDataEntityType)this.targetBillList.get(0).getDataEntityType()));
            }
            List list = successPkIdList;
            return list;
        }
        catch (Exception e) {
            try {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getId() {
        return this.isBankBillAudit ? "audit" : "submit";
    }

    public OperationResult doSignOperation(List<Object> dataIdList, OperateOption option) {
        if (this.targetBillList == null) {
            DynamicObject[] bankBillArr = BusinessDataServiceHelper.load((Object[])dataIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityName));
            this.targetBillList = new ArrayList<DynamicObject>();
            this.targetBillList.addAll(Arrays.asList(bankBillArr));
        }
        String signOp = this.isBankBillAudit ? "submit" : "audit";
        option.setVariableValue("srcEntityNumber", this.srouceType);
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)signOp, (String)this.entityName, (Object[])dataIdList.toArray(), (OperateOption)option);
        return result;
    }

    public void doSignOperateSuccess(List<Object> successIdList) {
        DynamicObject[] successSourceBillList = (DynamicObject[])this.targetBillList.stream().filter(o -> successIdList.contains(o.getPkValue())).map(o -> this.bankBillList.stream().filter(t -> t.getPkValue().equals(o.get("lastsourcebillid"))).findFirst().orElse(null)).filter(Objects::nonNull).distinct().toArray(DynamicObject[]::new);
        Object[] needCommitBeBankIdArr = Arrays.stream(successSourceBillList).filter(o -> this.needCommitBeIdList.contains(o.getPkValue())).map(o -> this.targetBillList.stream().filter(t -> t.get("lastsourcebillid").equals(o.getPkValue())).findFirst().orElse(null)).filter(Objects::nonNull).distinct().map(DataEntityBase::getPkValue).toArray();
        if (needCommitBeBankIdArr.length > 0) {
            TmcOperateServiceHelper.execOperate((String)"commitbe", (String)this.entityName, (Object[])needCommitBeBankIdArr, (OperateOption)OperateOption.create());
        }
    }

    public void doSignOperateFailed(Exception e) {
    }

    public String getErrorMessage() {
        return this.errorMessage.length() > 0 ? this.errorMessage.toString() : null;
    }
}

