/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.DetailManualMatchHelper;
import kd.tmc.bei.business.service.factory.WorkBenchServiceFactory;
import kd.tmc.bei.common.constants.BillTypeConstants;
import kd.tmc.bei.common.enums.TabRecordStatusEnum;
import kd.tmc.bei.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PassivePayWorkbenchList
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(PassivePayWorkbenchList.class);
    private static final String DOWN_BILL = "downbill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.tabChange();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String tabKey = this.getPageCache().get("tabKey");
        QFilter receredQf = null;
        if (tabKey == null) {
            receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
        } else {
            switch (tabKey) {
                case "alrecord": {
                    receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
                    break;
                }
                case "norecord": {
                    receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
                    break;
                }
                case "noneedrecord": {
                    receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.NOCONFIRM.getValue());
                }
            }
        }
        e.getQFilters().add(receredQf);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("recedbillnumber".equals(fieldName) || "e_recedbillnumber".equals(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
            if (selectedRow == null || selectedRow.getPrimaryKeyValue() == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PassivePayWorkbenchList_31", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject detailData = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"bei_intelpay");
            DynamicObject recedbill = detailData.getDynamicObjectCollection("recedbillentry").stream().filter(o -> selectedRow.getEntryPrimaryKeyValue().equals(o.getPkValue())).findFirst().orElse(null);
            if (recedbill != null) {
                DynamicObject billtype;
                DynamicObject bizBill;
                if ("cas_paybill".equals(recedbill.getString("e_recedbilltype")) && (bizBill = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billtype", (QFilter[])new QFilter("billno", "=", (Object)recedbill.getString("e_recedbillnumber")).toArray())) != null && (billtype = bizBill.getDynamicObject("billtype")) != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue())) {
                    this.viewBill("cas_paybill_synonym", recedbill.getLong("e_recedbillid"));
                    return;
                }
                this.viewBill(recedbill.getString("e_recedbilltype"), recedbill.getLong("e_recedbillid"));
                return;
            }
            String billNumber = detailData.getString("recedbillnumber");
            if (billNumber != null && billNumber.trim().length() > 0) {
                DynamicObject billtype;
                DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billtype", (QFilter[])new QFilter("billno", "=", (Object)billNumber).toArray());
                if (bizBill != null && (billtype = bizBill.getDynamicObject("billtype")) != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue())) {
                    this.viewBill("cas_paybill_synonym", bizBill.getPkValue());
                    return;
                }
            } else {
                DynamicObject payBill = TmcBotpHelper.getTargetBill((String)"bei_transdetail_cas", (Object)detailData.getPkValue(), (String)"cas_paybill");
                if (payBill != null) {
                    this.viewBill("cas_paybill", payBill.getPkValue());
                    return;
                }
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("botp_track_edit_status", "true");
            this.getView().invokeOperation("trackdown", option);
        }
    }

    private void viewBill(String formId, Object pkValue) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setFormId(formId);
        showParameter.setPkId(pkValue);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void tabChange() {
        Tab tab = (Tab)this.getControl("recordstatustab");
        tab.addTabSelectListener(tabSelectEvent -> {
            String tabKey = tabSelectEvent.getTabKey();
            if ("norecord".equals(tabKey)) {
                this.getModel().setValue("recordbotn", (Object)TabRecordStatusEnum.NORECORD.getValue());
            }
            if ("alrecord".equals(tabKey)) {
                this.getModel().setValue("recordbotn", (Object)TabRecordStatusEnum.ALRECORD.getValue());
            }
            if ("noneedrecord".equals(tabKey)) {
                this.getModel().setValue("recordbotn", (Object)TabRecordStatusEnum.NONEEDRECORD.getValue());
            }
            this.getPageCache().put("tabKey", tabSelectEvent.getTabKey());
            this.getView().invokeOperation("refresh");
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if ("exportlistbyselectfields".equals(operate.getOperateKey()) && selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RecWorkbenchList_14", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("manualmatch".equals(operate.getOperateKey())) {
            DetailManualMatchHelper.verifySameOrg((ListSelectedRowCollection)selectedRows, (String)"bei_intelpay", (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (operationResult != null && operationResult.isSuccess()) {
            String thisOpnumber = DB.genGlobalLongId() + "";
            switch (operateKey) {
                case "dorule": {
                    this.ruleEntry(selectedRows, thisOpnumber);
                    break;
                }
                case "dohand": 
                case "handmerge": {
                    if (selectedRows.isEmpty()) {
                        return;
                    }
                    Object[] selectedPks = selectedRows.getPrimaryKeyValues();
                    QFilter qFilter = new QFilter("id", "in", (Object)selectedPks);
                    DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_intelpay", (String)"id,claimnoticebillno,billno,oppbanknumber,accountbank,kdretflag", (QFilter[])qFilter.toArray());
                    if (transDetails != null && transDetails.size() > 0) {
                        for (DynamicObject transDetail : transDetails) {
                            if (!EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u5355\u5931\u8d25\uff0c\u8be5\u4ea4\u6613\u660e\u7ec6\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u518d\u751f\u5355\u3002", (String)"PassivePayWorkbenchList_34", (String)"tmc-bei-formplugin", (Object[])new Object[0]), transDetail.getString("billno")));
                                return;
                            }
                            if (!EmptyUtil.isNotEmpty((CharSequence)transDetail.getString("kdretflag"))) continue;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u4ea4\u6613\u660e\u7ec6\u6709\u201cKD\u6807\u8bc6\u201d\u4fe1\u606f\uff0c\u4e3a\u94f6\u4f01\u4ed8\u6b3e\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u5e94\u7531\u7cfb\u7edf\u8fdb\u884c\u81ea\u52a8\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6309\u89c4\u5219\u751f\u5355\u3001\u624b\u5de5\u751f\u5355\u3001\u76f4\u63a5\u6807\u8bb0\u5df2\u786e\u8ba4\u3001\u6807\u8bb0\u4e3a\u65e0\u9700\u786e\u8ba4\u3001\u901a\u77e5\u8ba4\u9886\u7b49\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_46", (String)"tmc-bei-formplugin", (Object[])new Object[]{transDetail.getString("billno")}));
                            return;
                        }
                    }
                    Object recordbotn = this.getModel().getDataEntity().get("recordbotn");
                    if (TabRecordStatusEnum.ALRECORD.getValue().equals(recordbotn)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u751f\u5355\u64cd\u4f5c\u3002", (String)"PassivePayWorkbenchList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String oppBankNumber = null;
                    Long accountBankId = null;
                    if (transDetails != null && transDetails.size() > 0) {
                        Set accountBankIdSet;
                        Set oppBankNumberSet = transDetails.stream().filter(t -> EmptyUtil.isNoEmpty((String)t.getString("oppbanknumber"))).map(t -> t.getString("oppbanknumber")).collect(Collectors.toSet());
                        if (EmptyUtil.isNoEmpty(oppBankNumberSet)) {
                            String string = oppBankNumber = oppBankNumberSet.size() == 1 ? (String)oppBankNumberSet.iterator().next() : "";
                        }
                        if (EmptyUtil.isNoEmpty(accountBankIdSet = transDetails.stream().filter(t -> EmptyUtil.isNoEmpty((Long)t.getLong("accountbank"))).map(t -> t.getLong("accountbank")).collect(Collectors.toSet()))) {
                            accountBankId = accountBankIdSet.size() == 1 ? (Long)accountBankIdSet.iterator().next() : Long.valueOf(0L);
                        }
                    }
                    String closeCallBackId = "dohand".equals(operateKey) ? "cas_paybizinfo" : "cas_paybizinfomerge";
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setCustomParam("call", (Object)closeCallBackId);
                    fsp.setCustomParam("multiOppBankNumber", (Object)StringUtils.equals(oppBankNumber, (CharSequence)""));
                    fsp.setCustomParam("oppBankNumber", (Object)oppBankNumber);
                    fsp.setCustomParam("multiAccountBankId", (Object)(accountBankId != null && accountBankId == 0L ? 1 : 0));
                    fsp.setCustomParam("accountBankId", (Object)accountBankId);
                    fsp.setAppId("cas");
                    fsp.setFormId("cas_paybizinfo");
                    CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, closeCallBackId);
                    fsp.setCloseCallBack(callBack);
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(fsp);
                    break;
                }
                case "automatch": {
                    this.matchEntry(selectedRows, thisOpnumber);
                    break;
                }
                case "cancelmatch": {
                    this.cancelMatch();
                    break;
                }
                case "matchrulesetting": {
                    ListShowParameter showPara = new ListShowParameter();
                    showPara.setBillFormId("cas_smartmatch");
                    showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showPara);
                    break;
                }
                case "rulesetting": {
                    ListShowParameter showParaRule = new ListShowParameter();
                    showParaRule.setBillFormId("cas_recpayrule");
                    showParaRule.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParaRule);
                    break;
                }
                case "recered": 
                case "cancelmark": 
                case "marknoconfirm": {
                    this.refresh();
                    break;
                }
                case "cancelgen": {
                    this.refreshList();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u751f\u5355\u6210\u529f\u3002", (String)"PassivePayWorkbenchList_6", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            switch (operateKey) {
                case "cancelmatch": 
                case "dorule": 
                case "handmerge": 
                case "cancelrecered": {
                    this.refresh();
                }
            }
        }
        if ("manualmatch".equals(operateKey)) {
            DetailManualMatchHelper.bizBillMatchDetail((IFormView)this.getView(), (AfterDoOperationEventArgs)args, (ListSelectedRowCollection)selectedRows, (IFormPlugin)this, (String)list.getEntityId(), (String)"company,accountbank,currency");
        }
    }

    private void refreshList() {
        this.getView().invokeOperation("refresh");
    }

    private void confirmEnter(ListSelectedRowCollection selectedRows, String thisOpnumber) {
    }

    private void cancelMatch() {
        BillList list = (BillList)this.getControl("billlistap");
        list.clearSelection();
        this.refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5339\u914d\u6210\u529f\u3002", (String)"PassivePayWorkbenchList_10", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
    }

    private void matchEntry(ListSelectedRowCollection selectedRows, String thisOpnumber) {
        if (selectedRows.isEmpty()) {
            return;
        }
        Object recordbotn = this.getModel().getDataEntity().get("recordbotn");
        if (TabRecordStatusEnum.ALRECORD.getValue().equals(recordbotn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u751f\u5355\u64cd\u4f5c\u3002", (String)"PassivePayWorkbenchList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)selectedPks);
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_intelpay", (String)"id,claimnoticebillno,billno", (QFilter[])qFilter.toArray());
        if (transDetails != null && transDetails.size() > 0) {
            for (DynamicObject transDetail : transDetails) {
                if (EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u540e\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"PassivePayWorkbenchList_36", (String)"tmc-bei-formplugin", (Object[])new Object[0]), transDetail.getString("billno")));
                return;
            }
        }
        ArrayList<MatchBizTypeEnum> bizTypeList = new ArrayList<MatchBizTypeEnum>(4);
        bizTypeList.add(MatchBizTypeEnum.TRANSDOWN);
        bizTypeList.add(MatchBizTypeEnum.PAY);
        bizTypeList.add(MatchBizTypeEnum.TRANSHANDLE);
        bizTypeList.add(MatchBizTypeEnum.AGENTPAY);
        bizTypeList.add(MatchBizTypeEnum.EXCHANGE);
        bizTypeList.add(MatchBizTypeEnum.REC);
        boolean isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, bizTypeList, (String)thisOpnumber, (String)"pay");
        if (!isHasMatch) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u7ed3\u679c\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u672a\u914d\u7f6e\u81ea\u52a8\u5339\u914d\u89c4\u5219\uff0c\u6216\u6839\u636e\u89c4\u5219\u672a\u5339\u914d\u5230\u4e1a\u52a1\u5355\u636e\u3002", (String)"PassivePayWorkbenchList_11", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cas_automatchresult");
        fsp.setCustomParam("thisOpnumber", (Object)thisOpnumber);
        fsp.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
        fsp.setCustomParam("type", (Object)"pay");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "cas_automatchresult");
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ruleEntry(ListSelectedRowCollection selectedRows, String thisOpnumber) {
        if (selectedRows.isEmpty()) {
            return;
        }
        Object recordbotn = this.getModel().getDataEntity().get("recordbotn");
        if (TabRecordStatusEnum.ALRECORD.getValue().equals(recordbotn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u751f\u5355\u64cd\u4f5c\u3002", (String)"PassivePayWorkbenchList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult result = new OperationResult();
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        int selectCount = selectedRows.size();
        result.setBillCount(selectCount);
        QFilter qFilter = new QFilter("id", "in", (Object)selectedPks);
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_intelpay", (String)"id,claimnoticebillno,billno,kdretflag", (QFilter[])qFilter.toArray());
        if (transDetails != null && transDetails.size() > 0) {
            for (DynamicObject transDetail : transDetails) {
                if (!EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) {
                    result.addErrorInfo(this.getOperateErrorInfo(transDetail.getLong("id"), String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u5355\u5931\u8d25\uff0c\u8be5\u4ea4\u6613\u660e\u7ec6\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u518d\u751f\u5355\u3002", (String)"PassivePayWorkbenchList_34", (String)"tmc-bei-formplugin", (Object[])new Object[0]), transDetail.getString("billno"))));
                    selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.getLong("id")));
                }
                if (!EmptyUtil.isNotEmpty((CharSequence)transDetail.getString("kdretflag"))) continue;
                result.addErrorInfo(this.getOperateErrorInfo(transDetail.getPkValue(), ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u4ea4\u6613\u660e\u7ec6\u6709\u201cKD\u6807\u8bc6\u201d\u4fe1\u606f\uff0c\u4e3a\u94f6\u4f01\u4ed8\u6b3e\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u5e94\u7531\u7cfb\u7edf\u8fdb\u884c\u81ea\u52a8\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6309\u89c4\u5219\u751f\u5355\u3001\u624b\u5de5\u751f\u5355\u3001\u76f4\u63a5\u6807\u8bb0\u5df2\u786e\u8ba4\u3001\u6807\u8bb0\u4e3a\u65e0\u9700\u786e\u8ba4\u3001\u901a\u77e5\u8ba4\u9886\u7b49\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_46", (String)"tmc-bei-formplugin", (Object[])new Object[]{transDetail.getString("billno")})));
                selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.getLong("id")));
            }
        }
        if (EmptyUtil.isEmpty((Collection)selectedRows)) {
            if (selectCount == 1) {
                List allErrorInfo = result.getAllErrorInfo();
                this.getView().showTipNotification(((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
            } else {
                this.showOperationResultMulti(result, "", false);
            }
            return;
        }
        selectedPks = selectedRows.getPrimaryKeyValues();
        ArrayList<MatchBizTypeEnum> bizTypeList = new ArrayList<MatchBizTypeEnum>(2);
        bizTypeList.add(MatchBizTypeEnum.PAY);
        bizTypeList.add(MatchBizTypeEnum.AGENTPAY);
        bizTypeList.add(MatchBizTypeEnum.TRANSDOWN);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("opnumber", thisOpnumber);
        boolean isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, bizTypeList, (String)thisOpnumber, (String)"pay");
        if (!isHasMatch) {
            ArrayList errors = new ArrayList();
            List idList = Arrays.stream(selectedPks).map(String::valueOf).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequest(idList, (String)"bei_intelpay", (String)"dorule_mutex");
            List requestIds = MutexServiceHelper.getRequestResultList(idList, errors, (Map)request);
            try {
                if (!errors.isEmpty()) {
                    for (OperateErrorInfo error : errors) {
                        result.addErrorInfo(error);
                    }
                }
                WorkBenchServiceFactory.getWorkBenchService().execute(requestIds.toArray(), "bei_intelpay", result, operateOption, "", "rule");
            }
            finally {
                if (requestIds.size() > 0) {
                    MutexServiceHelper.batchRelease((List)requestIds, (String)"bei_intelpay", (String)"dorule_mutex");
                }
            }
            if (result.getAllErrorOrValidateInfo().size() > 0) {
                this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"PassivePayWorkbenchList_30", (String)"tmc-bei-formplugin", (Object[])new Object[0]), false);
                this.refreshList();
            } else {
                this.refreshList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6309\u89c4\u5219\u751f\u5355\u6210\u529f\u3002", (String)"PassivePayWorkbenchList_12", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        } else {
            QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
            DynamicObjectCollection automatchresultsaves = QueryServiceHelper.query((String)"cas_autocalresult", (String)"id,name,entryentity.billid", (QFilter[])numberFilter.toArray());
            HashSet<Object> remainDetailIds = new HashSet<Object>();
            HashSet<Long> successDetailIds = new HashSet<Long>(automatchresultsaves.size());
            for (DynamicObject automatchresultsave : automatchresultsaves) {
                Long billid = Long.valueOf(automatchresultsave.getString("entryentity.billid"));
                successDetailIds.add(billid);
            }
            for (Object selectedPk : selectedPks) {
                if (successDetailIds.contains(selectedPk)) continue;
                remainDetailIds.add(selectedPk);
            }
            FormShowParameter fsp = new FormShowParameter();
            if (remainDetailIds.size() > 0) {
                WorkBenchServiceFactory.getWorkBenchService().execute(remainDetailIds.toArray(), "bei_intelpay", result, operateOption, "", "rule");
            }
            if (result.getAllErrorOrValidateInfo().size() > 0) {
                this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"PassivePayWorkbenchList_30", (String)"tmc-bei-formplugin", (Object[])new Object[0]), true);
            }
            this.refreshList();
            fsp.setFormId("cas_enterconfirm");
            fsp.setCustomParam("opflag", (Object)"rule");
            fsp.setCustomParam("thisOpnumber", (Object)thisOpnumber);
            fsp.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
            fsp.setCustomParam("successIds", (Object)(result.getSuccessPkIds().size() + ""));
            fsp.setCustomParam("failIds", (Object)(result.getAllErrorInfo().size() + ""));
            fsp.setCustomParam("type", (Object)"pay");
            if (!EmptyUtil.isEmpty(remainDetailIds) && remainDetailIds.size() > 0) {
                fsp.setCustomParam("alreadyEntered", (Object)(remainDetailIds.size() + ""));
            } else {
                fsp.setCustomParam("alreadyEntered", (Object)"0");
            }
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "cas_enterconfirm");
            fsp.setCloseCallBack(callBack);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    private void showOperationResultMulti(OperationResult operationResult, String operateName, boolean isHasMatch) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap(16);
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = this.getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        int totalCount = operationResult.getBillCount();
        int successCount = operationResult.getSuccessPkIds().size();
        int errorCount = operationResult.getAllErrorInfo().size();
        String title = "";
        title = !isHasMatch ? String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"PassivePayWorkbenchList_20", (String)"tmc-bei-formplugin", (Object[])new Object[0]), operationResult.getBillCount(), successCount, operationResult.getBillCount() - successCount) : String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\uff0c\u5f85\u751f\u5355\u786e\u8ba4%4$s\u5f20\u3002", (String)"PassivePayWorkbenchList_21", (String)"tmc-bei-formplugin", (Object[])new Object[0]), totalCount, successCount, errorCount, totalCount - successCount - errorCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int count = 0;
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            String lowerCaseBuf = ((IOperateInfo)errorInfos.get(i)).getMessage().toLowerCase();
            if (count == 0 && lowerCaseBuf.contains("data too long for column 'fbankcheckflag'")) {
                buf.append(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u751f\u5355\u6210\u529f%1$s\u7b14\u660e\u7ec6\uff0c\u5931\u8d25%2$s\u7b14\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\u5408\u5e76\u751f\u6210\u7684\u76ee\u6807\u5355\u636e\u3010\u5bf9\u8d26\u6807\u8bc6\u7801\u3011\u5b57\u6bb5\u8fc7\u957f\uff0c\u6700\u5927\u957f\u5ea6\u4e3a1024\uff0c\u8bf7\u51cf\u5c11\u9700\u5408\u5e76\u751f\u5355\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u3002", (String)"RecWorkbenchList_45", (String)"tmc-bei-formplugin", (Object[])new Object[0]), successCount, operationResult.getBillCount() - successCount)).append("<br/>");
                ++count;
                continue;
            }
            if (lowerCaseBuf.contains("data too long for column 'fbankcheckflag'")) continue;
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        this.getView().showForm(parameters);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        String actionId;
        super.closedCallBack(args);
        switch (actionId = args.getActionId()) {
            case "cas_paybizinfo": {
                this.handMatch(args);
                break;
            }
            case "cas_enterconfirm": {
                Object operateResult;
                Object returnData = args.getReturnData();
                if (EmptyUtil.isEmpty((Object)returnData)) {
                    return;
                }
                Object successPkIds = ((HashMap)returnData).get("successPkIds");
                if (!EmptyUtil.isEmpty(successPkIds)) {
                    this.refreshList();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u5355\u6210\u529f\uff0c\u5df2\u5bf9\u5269\u4f59\u8bb0\u5f55\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PassivePayWorkbenchList_16", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty(operateResult = ((HashMap)returnData).get("operateResultMap"))) break;
                Map operateResultMap = (Map)operateResult;
                List allErrorInfoList = (List)operateResultMap.get("allErrorInfoList");
                int totalCount = (Integer)operateResultMap.get("totalCount");
                int successCount = (Integer)operateResultMap.get("successCount");
                String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u751f\u5355%2$s\u5f20\uff0c\u751f\u5355\u5931\u8d25%3$s\u5f20\u3002", (String)"PassivePayWorkbenchList_19", (String)"tmc-bei-formplugin", (Object[])new Object[0]), totalCount, successCount, totalCount - successCount);
                StringBuilder detailInfo = new StringBuilder();
                for (String allErrorInfo : allErrorInfoList) {
                    detailInfo.append(allErrorInfo);
                }
                this.getView().showMessage(title, detailInfo.toString(), MessageTypes.Default);
                break;
            }
            case "confirm": {
                Object confirmSuccessPkIds;
                Object returnDataConfirm = args.getReturnData();
                if (EmptyUtil.isEmpty((Object)returnDataConfirm) || EmptyUtil.isEmpty(confirmSuccessPkIds = ((HashMap)returnDataConfirm).get("successPkIds"))) break;
                this.refreshList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u5355\u6210\u529f\uff0c\u5df2\u786e\u8ba4\u5269\u4f59\u8bb0\u5f55\u5df2\u751f\u5355\u3002", (String)"PassivePayWorkbenchList_17", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                break;
            }
            case "paycallback": {
                Object confirmSuccessPkIds;
                Object returnDatalink = args.getReturnData();
                if (EmptyUtil.isEmpty((Object)returnDatalink) || EmptyUtil.isEmpty(confirmSuccessPkIds = ((HashMap)returnDatalink).get("flag"))) break;
                this.refreshList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u5173\u8054\u751f\u5355\u6210\u529f\u3002", (String)"PassivePayWorkbenchPlugin_17", (String)"tmc-bei-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                break;
            }
            case "cas_paybizinfomerge": {
                this.handMergeMatch(args);
                break;
            }
            default: {
                this.refreshList();
            }
        }
    }

    private void handMergeMatch(ClosedCallBackEvent args) {
        HashMap returnDataMapmerge = (HashMap)args.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnDataMapmerge)) {
            return;
        }
        BillList listmerge = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRowsmerge = listmerge.getSelectedRows();
        Object[] selectedPksmerge = selectedRowsmerge.getPrimaryKeyValues();
        OperateOption operateOptionmerge = OperateOption.create();
        String returnDataStrmerge = SerializationUtils.toJsonString((Object)returnDataMapmerge);
        operateOptionmerge.setVariableValue("returnDataByOpHandMerge", returnDataStrmerge);
        operateOptionmerge.setVariableValue("opnumber", DB.genGlobalLongId() + "");
        OperationResult result = new OperationResult();
        ConvertRuleElement convertRuleElement = ConvertMetaServiceHelper.loadRule((String)"1057251497840214016");
        HashMap<String, List<Long>> groupMap = new HashMap<String, List<Long>>();
        if (!EmptyUtil.isEmpty((Object)convertRuleElement) && !EmptyUtil.isEmpty((Object)convertRuleElement.getGroupByPolicy())) {
            String groupByField = convertRuleElement.getGroupByPolicy().getGroupByField();
            if (!EmptyUtil.isEmpty((String)groupByField) && !"".equals(groupByField)) {
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bei_intelpay", (String)("id," + groupByField), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedPksmerge)});
                String[] split = groupByField.split(",");
                for (DynamicObject id : ids) {
                    StringBuilder o2 = null;
                    for (String fileName : split) {
                        Object fileData = id.get(fileName);
                        if (o2 == null) {
                            o2 = new StringBuilder(EmptyUtil.isEmpty((Object)fileData) ? "" : fileData.toString());
                            continue;
                        }
                        o2.append(EmptyUtil.isEmpty((Object)fileData) ? "" : fileData.toString());
                    }
                    if (o2 == null) continue;
                    ArrayList<Long> groupList = (ArrayList<Long>)groupMap.get(o2.toString());
                    if (EmptyUtil.isEmpty((Collection)groupList)) {
                        groupList = new ArrayList<Long>();
                    }
                    groupList.add((Long)id.getPkValue());
                    groupMap.put(o2.toString(), groupList);
                }
            } else {
                List collect = Arrays.stream(selectedPksmerge).map(o -> (Long)o).collect(Collectors.toList());
                groupMap.put("only", collect);
            }
        }
        for (Map.Entry objectListEntry : groupMap.entrySet()) {
            try {
                logger.info("\u88ab\u52a8\u4ed8\u6b3e\u5165\u8d26\u4f20\u5165\u53c2\u6570", (Object)returnDataStrmerge);
                OperationResult pushandsavemerge = OperateServiceHelper.execOperate((String)"pushandsavemerge", (String)"bei_intelpay", (Object[])((List)objectListEntry.getValue()).toArray(), (OperateOption)operateOptionmerge);
                result.setSuccess(true);
                List successPkIdss = result.getSuccessPkIds();
                if (result.getSuccessPkIds() != null) {
                    successPkIdss.addAll(pushandsavemerge.getSuccessPkIds());
                }
                result.setSuccessPkIds(successPkIdss);
            }
            catch (Exception ee) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(ee.getMessage());
                result.addErrorInfo(operateErrorInfo);
            }
        }
        if (result.getAllErrorOrValidateInfo().size() > 0) {
            result.setBillCount(selectedPksmerge.length);
            this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"PassivePayWorkbenchList_30", (String)"tmc-bei-formplugin", (Object[])new Object[0]), false);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u5408\u5e76\u751f\u5355\u6210\u529f\u3002", (String)"PassivePayWorkbenchList_33", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        this.refreshList();
    }

    private void handMatch(ClosedCallBackEvent args) {
        HashMap returnDataMap = (HashMap)args.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnDataMap)) {
            return;
        }
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        OperateOption operateOption = OperateOption.create();
        String returnDataStr = SerializationUtils.toJsonString((Object)returnDataMap);
        operateOption.setVariableValue("returnDataByOpHand", returnDataStr);
        String thisOpnumber = DB.genGlobalLongId() + "";
        ArrayList<MatchBizTypeEnum> bizTypeList = new ArrayList<MatchBizTypeEnum>(2);
        String handleBill = (String)returnDataMap.get("handleBill");
        boolean isHasMatch = true;
        if (DOWN_BILL.equals(handleBill)) {
            bizTypeList.add(MatchBizTypeEnum.TRANSDOWN);
            isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, bizTypeList, (String)thisOpnumber, (String)"pay");
        } else {
            bizTypeList.add(MatchBizTypeEnum.PAY);
            bizTypeList.add(MatchBizTypeEnum.AGENTPAY);
            isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, bizTypeList, (String)thisOpnumber, (String)"pay");
        }
        if (!isHasMatch) {
            OperationResult result = new OperationResult();
            operateOption.setVariableValue("opnumber", thisOpnumber);
            WorkBenchServiceFactory.getWorkBenchService().execute(selectedPks, "bei_intelpay", result, operateOption, handleBill, "hand");
            if (result.getAllErrorOrValidateInfo().size() > 0) {
                result.setBillCount(selectedPks.length);
                this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"PassivePayWorkbenchList_30", (String)"tmc-bei-formplugin", (Object[])new Object[0]), false);
                this.refreshList();
            } else {
                this.refreshList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u751f\u5355\u6210\u529f\u3002", (String)"PassivePayWorkbenchList_15", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        } else {
            QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
            DynamicObject[] automatchresultsaves = BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)"id,name,entryentity,entryentity.billid", (QFilter[])new QFilter[]{numberFilter});
            HashSet<Object> remainDetailIds = new HashSet<Object>(selectedPks.length);
            HashSet<Long> successDetailIds = new HashSet<Long>(automatchresultsaves.length);
            for (DynamicObject dynamicObject : automatchresultsaves) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                Long billid = Long.valueOf(((DynamicObject)entryentity.get(0)).getString("billid"));
                successDetailIds.add(billid);
            }
            for (Object object : selectedPks) {
                if (successDetailIds.contains(object)) continue;
                remainDetailIds.add(object);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            OperationResult result = new OperationResult();
            operateOption.setVariableValue("opnumber", thisOpnumber);
            if (remainDetailIds.size() > 0) {
                WorkBenchServiceFactory.getWorkBenchService().execute(remainDetailIds.toArray(), "bei_intelpay", result, operateOption, handleBill, "hand");
            }
            if (result.getAllErrorOrValidateInfo().size() > 0) {
                result.setBillCount(selectedPks.length);
                this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"PassivePayWorkbenchList_30", (String)"tmc-bei-formplugin", (Object[])new Object[0]), true);
                this.refreshList();
            }
            this.refreshList();
            formShowParameter.setFormId("cas_enterconfirm");
            formShowParameter.setCustomParam("opflag", (Object)"hand");
            formShowParameter.setCustomParam("thisOpnumber", (Object)thisOpnumber);
            formShowParameter.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
            formShowParameter.setCustomParam("successIds", (Object)(result.getSuccessPkIds().size() + ""));
            formShowParameter.setCustomParam("failIds", (Object)(result.getAllErrorInfo().size() + ""));
            formShowParameter.setCustomParam("type", (Object)"pay");
            String alreadyentered = EmptyUtil.isEmpty(remainDetailIds) && !(remainDetailIds.size() > 0) ? remainDetailIds.size() + "" : "0";
            formShowParameter.setCustomParam("alreadyEntered", (Object)alreadyentered);
            formShowParameter.setCustomParam("handparam", (Object)returnDataStr);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "cas_enterconfirm");
            formShowParameter.setCloseCallBack(closeCallBack);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void showForm(String formId, String callBackBtn) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("call", (Object)callBackBtn);
        fsp.setAppId("cas");
        fsp.setFormId(formId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackBtn);
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    private void receredOp(String opName, DynamicObject[] transdetails, DynamicObjectType type) {
    }

    private OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    protected void refresh() {
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if ("CONFIRM_MANUALMATCH".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            DetailManualMatchHelper.confirmBizBillMatchDetail((IFormView)this.getView(), (MessageBoxClosedEvent)messageBoxClosedEvent, (String)"company,accountbank,currency");
        }
    }
}

