/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.validate.detail.TransDetailDeleteValidator;
import kd.tmc.bei.common.helper.DataDeleteClearHelper;
import kd.tmc.bei.common.helper.SyncAutoBalanceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailDeleteClearOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TransDetailDeleteClearOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("ismatchereceipt");
        fieldKeys.add("bankcheckflag");
        fieldKeys.add("bizdate");
        fieldKeys.add("company");
        fieldKeys.add("id");
        fieldKeys.add("accountbank");
        fieldKeys.add("currency");
        fieldKeys.add("biztime");
        fieldKeys.add("accountbank.company");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        TransDetailDeleteValidator transDetailDeleteValidator = new TransDetailDeleteValidator();
        e.getValidators().add(transDetailDeleteValidator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        this.dealBalanceLog(dynamicObjects);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        ArrayList<String> autoBalanceList = new ArrayList<String>(16);
        try {
            ArrayList tdaParams = new ArrayList(dynamicObjects.length);
            for (DynamicObject detail : dynamicObjects) {
                HashMap<String, Object> tdaParam = new HashMap<String, Object>(4);
                Long orgId = detail.getDynamicObject("company").getLong("id");
                long accountBankId = detail.getDynamicObject("accountbank").getLong("id");
                long currencyId = detail.getDynamicObject("currency").getLong("id");
                String bizDateStr = DateUtils.formatString((Date)detail.getDate("bizdate"), (String)"yyyy-MM-dd");
                tdaParam.put("orgId", orgId);
                tdaParam.put("bizDate", bizDateStr);
                tdaParams.add(tdaParam);
                autoBalanceList.add(orgId + "_" + accountBankId + "_" + currencyId + "_" + bizDateStr);
            }
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"transDetailSummaryService", (String)"batchSummary", (Object[])new Object[]{tdaParams});
            List billNoList = Arrays.stream(dynamicObjects).map(t -> t.getString("billno")).collect(Collectors.toList());
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"bigAmountSummaryService", (String)"delTransDetailData", (Object[])new Object[]{billNoList});
        }
        catch (Exception ex) {
            logger.error("\u4ea4\u6613\u660e\u7ec6\u5220\u9664\u8c03\u7528tda\u5fae\u670d\u52a1\u62a5\u9519\uff1a" + ex);
        }
        logger.info("\u5220\u9664\u89e6\u53d1\uff1a\u81ea\u52a8\u751f\u6210\u4f59\u989d\u5f00\u59cb");
        SyncAutoBalanceHelper.checkAndAutoBalance((DynamicObject[])dynamicObjects, (boolean)true, autoBalanceList);
        logger.info("\u5220\u9664\u89e6\u53d1\uff1a\u81ea\u52a8\u751f\u6210\u4f59\u989d\u7ed3\u675f");
        this.dealElecReceipt(dynamicObjects);
    }

    private void dealBalanceLog(DynamicObject[] dynamicObjects) throws KDException {
        LinkedHashMap transDetilsSortedGroupByAccCurrency = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(t -> t.getDate("biztime"))).collect(Collectors.groupingBy(e -> e.getString("accountbank.bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number"), LinkedHashMap::new, Collectors.toList()));
        List accountBankIds = Arrays.stream(dynamicObjects).map(t -> t.getDynamicObject("accountbank").getLong("id")).collect(Collectors.toList());
        QFilter logQfilter = new QFilter("accountbank", "in", accountBankIds);
        DynamicObject[] genBalanceLogArray = BusinessDataServiceHelper.load((String)"bei_genbalance_log", (String)"id,accountbank,currency,lastupdatetime,deletetime", (QFilter[])new QFilter[]{logQfilter});
        Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr = Arrays.stream(genBalanceLogArray).collect(Collectors.groupingBy(e -> e.getDynamicObject("accountbank").getString("bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number")));
        for (Map.Entry detailEntry : transDetilsSortedGroupByAccCurrency.entrySet()) {
            String filterKey = (String)detailEntry.getKey();
            Date minDetailBizTime = ((DynamicObject)((List)detailEntry.getValue()).get(0)).getDate("biztime");
            List<DynamicObject> genBalanceLogs = genBalanceLogGroupByAccCurr.get(filterKey);
            if (genBalanceLogs == null || genBalanceLogs.size() <= 0) continue;
            DataDeleteClearHelper.updateGenBalanceLog(genBalanceLogs, (Date)minDetailBizTime, (String)"TransDetailFlag");
        }
    }

    private void dealElecReceipt(DynamicObject[] dynamicObjects) {
        List pkIds = Arrays.stream(dynamicObjects).filter(o -> o.getBoolean("ismatchereceipt") && StringUtils.isNotEmpty((String)o.getString("bankcheckflag"))).map(r -> (Long)r.getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(pkIds)) {
            QFilter tQfilter = new QFilter("matchdetailentry.e_transdetailid", "in", pkIds);
            DynamicObject[] electReceiptDOs = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,ismatch,matchdetailentry,matchdetailentry.id,matchdetailentry.e_transdetailid", (QFilter[])new QFilter[]{tQfilter});
            ArrayList<DynamicObject> updateElecs = new ArrayList<DynamicObject>(pkIds.size());
            for (DynamicObject t : electReceiptDOs) {
                DynamicObjectCollection matchdetailentry = t.getDynamicObjectCollection("matchdetailentry");
                matchdetailentry.removeIf(o -> pkIds.contains((Long)o.get("e_transdetailid")));
                if (matchdetailentry.size() != 0) continue;
                updateElecs.add(t);
            }
            updateElecs.forEach(p -> p.set("ismatch", (Object)0));
            SaveServiceHelper.save((DynamicObject[])electReceiptDOs);
            SaveServiceHelper.save((DynamicObject[])updateElecs.toArray(new DynamicObject[0]));
            logger.info("updateElecs\u7684\u5927\u5c0f\u662f\uff1a{}\uff0cupdateElecs\u4e3a\uff1a{}\uff0celectReceiptDOs\u7684\u5927\u5c0f\u662f\uff1a{}\uff0celectReceiptDOs\u4e3a\uff1a{}", new Object[]{updateElecs.size(), ((Object)updateElecs).toString(), electReceiptDOs.length, electReceiptDOs.toString()});
        }
    }
}

