/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.detail;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.enums.ReceredTypeEnum;
import kd.tmc.bei.opplugin.detail.TransDetailImportNewOp;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailFileRegImpOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TransDetailFileRegImpOp.class);
    private TransDetailImportNewOp importNewOp = new TransDetailImportNewOp();
    private static final String[] IMPORT_KEYS = new String[]{"id", "uniqueseq", "detailid", "billstatus", "ismatchereceipt", "isdataimport", "isdowntobankstate", "isnoreceipt", "iskdretflag", "isrefund", "isreced", "istransup", "istransdown", "isbankwithholding", "description", "sortno", "creator", "creditamount", "debitamount", "transbalance", "recfile"};

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Map variables = this.getOption().getVariables();
        DynamicObject log = TmcDataServiceHelper.newDynamicObject((String)"bei_transdetail_file_log");
        String file = (String)variables.get("requestid");
        log.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        log.set("requestid", (Object)file);
        log.set("filename", variables.get("filename"));
        log.set("fileurl", variables.get("fileurl"));
        log.set("importtime", (Object)new Date());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        String recFileLog = CodeRuleHelper.generateNumber((String)"bei_transdetail_file_log", (DynamicObject)log, null, null);
        log.set("billno", (Object)recFileLog);
        List<JSONObject> dataList = this.getDataList(file, recFileLog);
        dataList = this.importNewOp.customBeforeSave(dataList, (String)variables.get("appId"));
        if (EmptyUtil.isEmpty(dataList)) {
            logger.info("operate is empty");
            return;
        }
        Set<Long> accountSet = dataList.stream().map(t -> (Long)t.get((Object)"f_account_id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> accountMap = this.getAccountMap(accountSet);
        DynamicObject[] arr = (DynamicObject[])dataList.stream().map(t -> this.newImportObject((Map<String, Object>)t, accountMap)).toArray(DynamicObject[]::new);
        Map opVariables = this.getOption().getVariables();
        OperateOption saveOption = OperateOption.create();
        for (Map.Entry entry : opVariables.entrySet()) {
            saveOption.setVariableValue((String)entry.getKey(), (String)entry.getValue());
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"bei_betransdetail_imp", (DynamicObject[])arr, (OperateOption)saveOption);
        logger.info("save size {}", (Object)arr.length);
        DeleteServiceHelper.delete((String)"bei_transdetail_file_rec", (QFilter[])new QFilter("requestid", "=", (Object)file).toArray());
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        String cacheKey = "importCancel" + (String)variables.get("pageId");
        String importCancel = (String)AppCache.get((String)((String)variables.get("appId"))).get(cacheKey, String.class);
        if (Boolean.TRUE.toString().equals(importCancel)) {
            AppCache.get((String)((String)variables.get("appId"))).remove(cacheKey);
            logger.info("data transaction canel");
            throw new KDException(new ErrorCode("", "operation cancel"), new Object[0]);
        }
        logger.info("import cancel value {}", (Object)importCancel);
        List<Long> pkIds = Arrays.stream(arr).map(t -> t.getLong("id")).collect(Collectors.toList());
        this.importNewOp.doAfterSaveImport(pkIds);
    }

    private List<JSONObject> getDataList(String file, String recFileLog) {
        logger.info("import file {}", (Object)file);
        String props = "accountbank,currency,bizdate,description,creditamount,debitamount,transbalance";
        DynamicObject[] objects = TmcDataServiceHelper.load((String)"bei_transdetail_file_rec", (String)props, (QFilter[])new QFilter("requestid", "=", (Object)file).toArray());
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>(objects.length);
        for (DynamicObject obj : objects) {
            DynamicObject account = obj.getDynamicObject("accountbank");
            if (EmptyUtil.isEmpty((DynamicObject)account)) {
                logger.info("no fund accountBank");
                continue;
            }
            HashMap<String, String> accountMap = new HashMap<String, String>(4);
            accountMap.put("importprop", "bankaccountnumber");
            accountMap.put("bankaccountnumber", account.getString("bankaccountnumber"));
            DynamicObjectCollection entityList = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : entityList) {
                DynamicObject currency = detail.getDynamicObject("currency");
                HashMap<String, String> currencyMap = new HashMap<String, String>(4);
                currencyMap.put("number", currency.getString("number"));
                currencyMap.put("name", currency.getString("name"));
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("bizdate", detail.getDate("bizdate"));
                map.put("accountbank", accountMap);
                map.put("currency", currencyMap);
                map.put("description", detail.getString("description"));
                map.put("creditamount", detail.getBigDecimal("creditamount"));
                map.put("debitamount", detail.getBigDecimal("debitamount"));
                map.put("transbalance", detail.getBigDecimal("transbalance"));
                map.put("recfile", recFileLog);
                map.put("f_account_id", account.getPkValue());
                map.put("f_currency", currency);
                map.put("_Type_", "bei_betransdetail_imp");
                dataList.add(new JSONObject(map));
            }
        }
        return dataList;
    }

    private Map<Long, DynamicObject> getAccountMap(Set<Long> bankPropSet) {
        QFilter acctBankFilter = new QFilter("id", "in", bankPropSet);
        DynamicObject[] bankAcctArr = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"id,createorg,company,bank,currency,bankaccountnumber,isvirtual", (QFilter[])new QFilter[]{acctBankFilter});
        return Arrays.stream(bankAcctArr).filter(Objects::nonNull).collect(Collectors.toMap(bankAct -> bankAct.getLong("id"), Function.identity()));
    }

    private DynamicObject newImportObject(Map<String, Object> data, Map<Long, DynamicObject> accountMap) {
        DynamicObject obj = TmcDataServiceHelper.newDynamicObject((String)"bei_betransdetail_imp");
        for (String key : IMPORT_KEYS) {
            obj.set(key, data.get(key));
        }
        this.checkAndSetDate(obj, data.get("bizdate"), "bizdate", "yyyy-MM-dd");
        this.checkAndSetDate(obj, data.get("biztime"), "biztime", "yyyy-MM-dd HH:mm:ss");
        obj.set("modifytime", (Object)DateUtils.getCurrentTime());
        obj.set("lastmodifytime", (Object)DateUtils.getCurrentTime());
        Long accountId = (Long)data.get("f_account_id");
        DynamicObject bankAcct = accountMap.get(accountId);
        obj.set("accountbank", (Object)bankAcct);
        obj.set("currency", data.get("f_currency"));
        obj.set("company", (Object)bankAcct.getDynamicObject("createorg"));
        obj.set("bank", (Object)bankAcct.getDynamicObject("bank"));
        obj.set("datasource", (Object)DataSourceEnum.FROMIMG.getValue());
        obj.set("receredtype", (Object)ReceredTypeEnum.UNRECERED.getValue());
        return obj;
    }

    private void checkAndSetDate(DynamicObject object, Object dateObj, String key, String format) {
        if (null == dateObj) {
            return;
        }
        if (dateObj instanceof Date) {
            object.set(key, dateObj);
        } else if (dateObj instanceof String) {
            object.set(key, (Object)DateUtils.stringToDate((String)dateObj.toString(), (String)format));
        }
    }
}

