/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.sdk.tmc.bei.util.MatchResultBean;
import kd.sdk.tmc.bei.util.RecPayRuleMatchUtil;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class TransDetailImportNewOp
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(TransDetailImportNewOp.class);
    private long count = 0L;
    protected static final String OVERRIDE_NEW = "overridenew";
    private static final String SYSTEM_TYPE = "tmc-bei-opplugin";
    private static List<Map<String, Object>> afterDealData = new ArrayList<Map<String, Object>>(16);
    private static final Pattern pattern = Pattern.compile("\t");

    public String getDefaultImportType() {
        return OVERRIDE_NEW;
    }

    public String getDefaultKeyFields() {
        return "detailid";
    }

    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeSave(rowdatas, logger);
        LOGGER.info(String.format("\u5f53\u524d\u5bfc\u5165\u6279\u6b21\u6570\u636e\u5171 %s \u6761\u3002", rowdatas.size()));
        this.customBeforeSave(rowdatas, this.ctx.getFormShowParameterAppId(), (p, q) -> logger.log(p, q).fail());
    }

    protected boolean isForceBatch() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void customBeforeSave(List<ImportBillData> rowdatas, String appId, BiConsumer<Integer, String> msgLog) {
        HashSet<String> bankPropSet = new HashSet<String>(rowdatas.size());
        HashMap<String, List<String>> orgNumberAndBankAccountNumbersMap = new HashMap<String, List<String>>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            String companyNumber;
            JSONObject data = rowdata.getData();
            Map accountbankMap = (Map)data.get((Object)"accountbank");
            if (accountbankMap == null) continue;
            String acctBankPropVal = (String)accountbankMap.get("bankaccountnumber");
            bankPropSet.add(acctBankPropVal);
            Map detailCompany = (Map)data.get((Object)"company");
            if (detailCompany == null || !EmptyUtil.isNoEmpty((String)(companyNumber = (String)detailCompany.get("number"))) || !EmptyUtil.isNoEmpty((String)acctBankPropVal)) continue;
            List<String> accountNumberList = orgNumberAndBankAccountNumbersMap.containsKey(companyNumber) ? (List)orgNumberAndBankAccountNumbersMap.get(companyNumber) : new ArrayList(10);
            accountNumberList.add(acctBankPropVal);
            orgNumberAndBankAccountNumbersMap.put(companyNumber, accountNumberList);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter numFilter = new QFilter("number", "in", orgNumberAndBankAccountNumbersMap.keySet());
        Map orgList = TmcDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{enableFilter, numFilter});
        Map<String, DynamicObject> numberAndOrgMap = orgList.values().stream().collect(Collectors.toMap(o -> o.getString("number"), Function.identity(), (a, b) -> a));
        QFilter acctBankFilter = new QFilter("bankaccountnumber", "in", bankPropSet);
        DynamicObjectCollection bankAcctArr = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,createorg.number,createorg.name,createorg.id,bank.id,bankaccountnumber", (QFilter[])new QFilter[]{acctBankFilter});
        Map<String, List<DynamicObject>> acctBanks = bankAcctArr.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(bankAct -> bankAct.getString("bankaccountnumber")));
        Map<Long, Set<Long>> orgIdAndAccountIdsMap = this.getOrgIdAndAccountIdsMap(numberAndOrgMap, acctBanks, orgNumberAndBankAccountNumbersMap);
        Map canUseAccountMap = AccountBankHelper.batchCanUseAccountMap(orgIdAndAccountIdsMap);
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"08", (String)appId, (String)"bei_betransdetail_imp", (String)"4730fc9f000003ae");
        if (allPermOrgs.hasAllOrgPerm()) {
            LOGGER.info("\u6709\u6743\u9650\u7684\u7ec4\u7ec7: \u5168\u529f\u80fd\u7528\u6237");
        } else {
            LOGGER.info("\u6709\u6743\u9650\u7684\u7ec4\u7ec7:" + allPermOrgs.getHasPermOrgs());
        }
        List uniqueSeqList = rowdatas.stream().map(ImportBillData::getData).map(b -> b.getString("uniqueseq")).filter(c -> null != c && !c.trim().isEmpty()).collect(Collectors.toList());
        List duplicateUniqueSeqList = this.getDuplicateElements(uniqueSeqList);
        List detailIdList = rowdatas.stream().map(ImportBillData::getData).map(b -> b.getString("detailid")).filter(c -> null != c && !c.trim().isEmpty()).collect(Collectors.toList());
        Map<String, List<ImportBillData>> groupMap = rowdatas.stream().collect(Collectors.groupingBy(v -> (v.getData().get((Object)"accountbank") == null ? "accountbank" : ((Map)v.getData().get((Object)"accountbank")).get("bankaccountnumber")) + "---" + (v.getData().get((Object)"currency") == null ? "currency" : (String)((Map)v.getData().get((Object)"currency")).get("number"))));
        HashMap<String, Pair> needReSortMap = new HashMap<String, Pair>(16);
        for (Map.Entry<String, List<ImportBillData>> entry : groupMap.entrySet()) {
            List<ImportBillData> dataList = entry.getValue();
            List sortNoList = dataList.stream().map(ImportBillData::getData).map(b -> b.getString("sortno")).filter(c -> null != c && !c.trim().isEmpty()).collect(Collectors.toList());
            boolean needReSort = sortNoList.size() < 1;
            boolean checkFlag = sortNoList.size() > 0 && sortNoList.size() < dataList.size();
            Pair pair = Pair.of((Object)needReSort, (Object)checkFlag);
            needReSortMap.put(entry.getKey(), pair);
        }
        List duplicateDetailIdList = this.getDuplicateElements(detailIdList);
        DynamicObjectCollection prefDatas = QueryServiceHelper.query((String)"bei_betransdetail_imp", (String)"id,detailid", (QFilter[])new QFilter[]{new QFilter("detailid", "in", detailIdList)});
        List<String> dbExistsList = prefDatas.stream().map(s -> s.getString("detailid")).collect(Collectors.toList());
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            String message = null;
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            try {
                Map accountbankMap;
                String errMsg;
                if (duplicateUniqueSeqList != null && duplicateUniqueSeqList.size() > 0 && duplicateUniqueSeqList.contains(data.getString("uniqueseq"))) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u94f6\u884c\u4e3b\u952e\uff1a%s\u7684\u8bb0\u5f55\uff0c\u672c\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25\u3002", (String)"TransDetailImportNewOp_17", (String)SYSTEM_TYPE, (Object[])new Object[0]), data.getString("uniqueseq"));
                    this.addErrMessage(errMsg);
                }
                if (duplicateDetailIdList != null && duplicateDetailIdList.size() > 0 && duplicateDetailIdList.contains(data.getString("detailid"))) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u6c34\u53f7\uff1a%s\u7684\u8bb0\u5f55\uff0c\u672c\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25\u3002", (String)"TransDetailImportNewOp_18", (String)SYSTEM_TYPE, (Object[])new Object[0]), data.getString("detailid"));
                    this.addErrMessage(errMsg);
                }
                String acctBankPropVal = (accountbankMap = (Map)data.get((Object)"accountbank")) == null ? "accountbank" : (String)accountbankMap.get("bankaccountnumber");
                Map currencyMap = (Map)data.get((Object)"currency");
                String currencyPropVal = currencyMap == null ? "currency" : (String)currencyMap.get("number");
                String key = acctBankPropVal + "---" + currencyPropVal;
                Pair pair = (Pair)needReSortMap.get(key);
                if (null != pair && ((Boolean)pair.getRight()).booleanValue()) {
                    String errMsg2 = String.format(ResManager.loadKDString((String)"\u8d26\u6237\u201c%1$s\u201d\uff08%2$s\uff09\u672c\u6b21\u5bfc\u5165\u6570\u636e\u4e2d\u53ea\u6709\u90e8\u5206\u586b\u5199\u4e86\u6392\u5e8f\u53f7\uff0c\u8bf7\u5168\u90e8\u586b\u5199\u6392\u5e8f\u53f7\u540e\u518d\u5bfc\u5165\uff1b\u4e5f\u53ef\u4ee5\u5168\u90e8\u6e05\u7a7a\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u6839\u636e\u6570\u636e\u5bfc\u5165\u65f6\u95f4\u8fdb\u884c\u6392\u5e8f\u3002", (String)"TransDetailImportNewOp_21", (String)SYSTEM_TYPE, (Object[])new Object[0]), acctBankPropVal, currencyPropVal);
                    this.addErrMessage(errMsg2);
                }
                boolean needReSort = null == pair || (Boolean)pair.getLeft() != false;
                this.beforeImportOp(data, acctBanks, allPermOrgs, dbExistsList, canUseAccountMap, numberAndOrgMap, needReSort);
            }
            catch (KDBizException exc) {
                message = exc.getMessage();
                LOGGER.error("\u5bfc\u5165\u64cd\u4f5c\u89e3\u6790\u5f02\u5e38 - \u4e1a\u52a1\u5f02\u5e38 >>>> " + message);
            }
            catch (ParseException exc) {
                message = exc.getMessage();
                LOGGER.error("\u5bfc\u5165\u64cd\u4f5c\u89e3\u6790\u5f02\u5e38 - \u89e3\u6790\u5f02\u5e38 >>>> " + message);
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
                if (null != msgLog) {
                    msgLog.accept(rowdata.getStartIndex(), message);
                }
                it.remove();
            }
        }
    }

    public List<JSONObject> customBeforeSave(List<JSONObject> dataList, String appId) {
        List<ImportBillData> importBillData = dataList.stream().map(t -> new ImportBillData(t, 0, 0)).collect(Collectors.toList());
        this.customBeforeSave(importBillData, appId, null);
        return importBillData.stream().map(ImportBillData::getData).collect(Collectors.toList());
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult = super.save(rowdatas, logger);
        ArrayList datas = (ArrayList)apiResult.getData();
        afterDealData.addAll(datas);
        LinkedBlockingQueue dataQueue = this.ctx.getDataQueue(logger.getSrcFile());
        if (dataQueue.size() == 0) {
            ThreadPools.executeOnceIncludeRequestContext((String)"afterImportOp", () -> this.afterImportOp(afterDealData));
        }
        return apiResult;
    }

    private void beforeImportOp(JSONObject data, Map<String, List<DynamicObject>> acctBanks, HasPermOrgResult permOrgResult, List<String> dbExistsList, Map<Long, Map<Long, Boolean>> canUseAccountMap, Map<String, DynamicObject> numberAndOrgMap, boolean needReSort) throws ParseException {
        String propertyAccountBank;
        Map accountbankMap;
        Object bankVal;
        List<DynamicObject> banks;
        String bizDateStr = data.getString("bizdate");
        String bizTimeStr = data.getString("biztime");
        if (EmptyUtil.isNoEmpty((String)bizDateStr) && EmptyUtil.isNoEmpty((String)bizTimeStr)) {
            boolean isEqual = true;
            String formatBizDate = null;
            String formatBizTime = null;
            try {
                Date bizDate = new ObjectConverter.DateConverter().convert((Object)bizDateStr);
                formatBizDate = DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd");
                data.put("bizdate", (Object)formatBizDate);
                Date bizTime = new ObjectConverter.DateConverter().convert((Object)this.resolve(bizTimeStr));
                formatBizTime = DateUtils.formatString((Date)bizTime, (String)"yyyy-MM-dd");
                data.put("biztime", (Object)DateUtils.formatString((Date)bizTime, (String)"yyyy-MM-dd HH:mm:ss"));
                isEqual = formatBizDate.equals(formatBizTime);
            }
            catch (Exception e) {
                this.addErrMessage(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u6216\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\u8bf7\u68c0\u67e5\u3002", (String)"TransDetailImportNewOp_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (!isEqual) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u3010%1$s\u3011\u4e0e\u4ea4\u6613\u65f6\u95f4\u3010%2$s\u3011\u7684\u65e5\u671f\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"TransDetailImportNewOp_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), formatBizDate, formatBizTime));
            }
        }
        if ((banks = acctBanks.get(String.valueOf(bankVal = (accountbankMap = (Map)data.get((Object)"accountbank")).get(propertyAccountBank = (String)accountbankMap.get("importprop"))))) != null && banks.size() > 0) {
            DynamicObject bankAcct = banks.get(0);
            Long companyPkVal = bankAcct.getLong("createorg.id");
            String useAuthOrgNumber = null;
            Map detailCompany = (Map)data.get((Object)"company");
            if (detailCompany != null && detailCompany.size() > 0) {
                String companyNumber = (String)detailCompany.get("number");
                DynamicObject org = numberAndOrgMap.get(companyNumber);
                if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                    boolean orgCanUseAccount;
                    Map<Long, Boolean> accountCheckResultMap = canUseAccountMap.get(org.getLong("id"));
                    boolean bl = orgCanUseAccount = EmptyUtil.isNoEmpty(accountCheckResultMap) && accountCheckResultMap.get(bankAcct.getLong("id")) != false;
                    if (!(permOrgResult.hasAllOrgPerm() || permOrgResult.getHasPermOrgs().contains(companyPkVal) || orgCanUseAccount && !permOrgResult.getHasPermOrgs().contains(org.getLong("id")))) {
                        this.addErrMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%s\u7ec4\u7ec7\u7684\u79bb\u7ebf\u660e\u7ec6\u5bfc\u5165\u6743\u9650\u3002", (String)"TransDetailImportNewOp_11", (String)SYSTEM_TYPE, (Object[])new Object[]{bankAcct.getString("createorg.name")}));
                    }
                    if (!StringUtils.equals((CharSequence)companyNumber, (CharSequence)bankAcct.getString("createorg.number")) && !orgCanUseAccount) {
                        this.addErrMessage(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u7f16\u7801\u4e0e\u8be5\u94f6\u884c\u8d26\u6237\u7cfb\u7edf\u5185\u7684\u8d44\u91d1\u7ec4\u7ec7\u7f16\u7801\u4e0d\u540c\uff0c\u672c\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25\u3002", (String)"TransDetailImportNewOp_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                    useAuthOrgNumber = org.getString("number");
                }
            } else if (!permOrgResult.hasAllOrgPerm() && !permOrgResult.getHasPermOrgs().contains(companyPkVal)) {
                this.addErrMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%s\u7ec4\u7ec7\u7684\u79bb\u7ebf\u660e\u7ec6\u5bfc\u5165\u6743\u9650\u3002", (String)"TransDetailImportNewOp_11", (String)SYSTEM_TYPE, (Object[])new Object[]{bankAcct.getString("createorg.name")}));
            }
            HashMap<String, String> companyMap = new HashMap<String, String>(4);
            companyMap.put("importprop", "number");
            companyMap.put("number", EmptyUtil.isNoEmpty(useAuthOrgNumber) ? useAuthOrgNumber : bankAcct.getString("createorg.number"));
            data.put("company", companyMap);
            HashMap<String, Object> bankMap = new HashMap<String, Object>(4);
            bankMap.put("importprop", "id");
            bankMap.put("id", bankAcct.getLong("bank.id"));
            data.put("bank", bankMap);
        } else {
            this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u7684\u94f6\u884c\u8d26\u6237\u3002", (String)"TransDetailImportNewOp_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), propertyAccountBank, accountbankMap.get(propertyAccountBank) + ""));
        }
        String detailId = data.getString("detailid");
        if (EmptyUtil.isEmpty((String)detailId) || !dbExistsList.contains(detailId)) {
            this.setDefaultData(data);
        } else if (needReSort) {
            data.put("sortno", (Object)(DateUtils.getCurrentTime().getTime() * 100000L + this.count++ % 100000L));
        }
    }

    private void setDefaultData(JSONObject data) {
        Object uniqueSeq;
        long id;
        try {
            Date convert;
            Object date;
            if (EmptyUtil.isNoEmpty((Object)data.get((Object)"bizdate")) && EmptyUtil.isEmpty((Object)data.get((Object)"biztime"))) {
                date = data.get((Object)"bizdate");
                convert = new ObjectConverter.DateConverter().convert(date);
                data.put("biztime", (Object)DateUtils.formatString((Date)convert, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (EmptyUtil.isEmpty((Object)data.get((Object)"bizdate")) && EmptyUtil.isNoEmpty((Object)data.get((Object)"biztime"))) {
                date = data.get((Object)"biztime");
                convert = new ObjectConverter.DateConverter().convert(date);
                data.put("bizdate", (Object)DateUtils.formatString((Date)convert, (String)"yyyy-MM-dd"));
            }
        }
        catch (Exception e) {
            this.addErrMessage(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u6216\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\u8bf7\u68c0\u67e5\u3002", (String)"TransDetailImportNewOp_17", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        Object detailId = data.get((Object)"detailid");
        if (detailId == null || detailId.toString().length() == 0 || " ".equals(detailId.toString())) {
            String tableName = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas").getAlias();
            id = DB.genLongId((String)tableName);
            this.setData((Map<String, Object>)data, "id", id + "");
            this.setData((Map<String, Object>)data, "detailid", id + "");
        }
        if ((uniqueSeq = data.get((Object)"uniqueseq")) == null || uniqueSeq.toString().length() == 0 || " ".equals(uniqueSeq.toString())) {
            if (EmptyUtil.isEmpty((Object)data.get((Object)"id"))) {
                id = DBServiceHelper.genGlobalLongId();
                this.setData((Map<String, Object>)data, "id", id + "");
                this.setData((Map<String, Object>)data, "uniqueseq", id + "");
            } else {
                String id2 = data.getString("id");
                this.setData((Map<String, Object>)data, "uniqueseq", id2);
            }
        }
        this.setData((Map<String, Object>)data, "billstatus", BillStatusEnum.SAVE.getValue());
        this.setData((Map<String, Object>)data, "ismatchereceipt", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "isdataimport", Boolean.TRUE);
        this.setData((Map<String, Object>)data, "isdowntobankstate", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "isnoreceipt", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "iskdretflag", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "isrefund", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "isreced", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "istransup", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "istransdown", Boolean.FALSE);
        this.setData((Map<String, Object>)data, "isbankwithholding", Boolean.FALSE);
        data.put("datasource", (Object)"import");
        data.put("sortno", EmptyUtil.isEmpty((Object)data.get((Object)"sortno")) ? Long.valueOf(DateUtils.getCurrentTime().getTime() * 100000L + this.count++ % 100000L) : data.get((Object)"sortno"));
        HashMap<String, Object> creatorMap = (HashMap<String, Object>)data.get((Object)"creator");
        if (EmptyUtil.isEmpty((Object)creatorMap)) {
            creatorMap = new HashMap<String, Object>(4);
            creatorMap.put("importprop", "id");
            creatorMap.put("id", RequestContext.get().getCurrUserId());
            data.put("creator", creatorMap);
        }
    }

    private void afterImportOp(List<Map<String, Object>> datas) {
        if (datas == null) {
            return;
        }
        List<Long> pkIds = datas.stream().filter(elem -> (Boolean)elem.get("success")).map(elem -> (Long)elem.get("id")).collect(Collectors.toList());
        this.doAfterSaveImport(pkIds);
        afterDealData = new ArrayList<Map<String, Object>>(16);
    }

    public void doAfterSaveImport(List<Long> pkIds) {
        DynamicObject[] transDetails = TmcDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        try {
            List matchResultBeanList = RecPayRuleMatchUtil.match((Object[])Arrays.stream(transDetails).map(DataEntityBase::getPkValue).toArray());
            Map<Object, String> matchResultMap = matchResultBeanList.stream().collect(Collectors.toMap(MatchResultBean::getId, MatchResultBean::getNewRuleName, (k, v) -> v));
            for (DynamicObject detail : transDetails) {
                detail.set("rulename", (Object)matchResultMap.get(detail.getPkValue()));
            }
            SaveServiceHelper.save((DynamicObject[])transDetails);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u8bbe\u7f6e\u5165\u8d26\u89c4\u5219\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%s", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        this.invokeTdaMService(transDetails);
    }

    private void invokeTdaMService(DynamicObject[] transDetails) {
        try {
            ArrayList tdaParams = new ArrayList(transDetails.length);
            for (DynamicObject detail : transDetails) {
                HashMap<String, Object> tdaParam = new HashMap<String, Object>(4);
                tdaParam.put("orgId", detail.getDynamicObject("company").getLong("id"));
                tdaParam.put("bizDate", DateUtils.formatString((Date)detail.getDate("bizdate"), (String)"yyyy-MM-dd"));
                tdaParams.add(tdaParam);
            }
            LOGGER.info("\u4ea4\u6613\u660e\u7ec6\u79bb\u7ebf\u5bfc\u5165\u65f6\u8c03\u7528tda\u5fae\u670d\u52a1\u63a5\u53e3\u53c2\u6570\uff0ctdaParams " + JSONArray.toJSONString(tdaParams));
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"transDetailSummaryService", (String)"batchSummary", (Object[])new Object[]{tdaParams});
            List billnoList = Arrays.stream(transDetails).map(t -> t.getString("billno")).collect(Collectors.toList());
            LOGGER.info("\u4ea4\u6613\u660e\u7ec6\u79bb\u7ebf\u5bfc\u5165\u65f6\u8c03\u7528tda\u5fae\u670d\u52a1\u63a5\u53e3\u53c2\u6570\uff0cbillnoList " + JSONArray.toJSONString(billnoList));
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"bigAmountSummaryService", (String)"batchBigAmount", (Object[])new Object[]{billnoList});
        }
        catch (Exception e) {
            LOGGER.error("\u4ea4\u6613\u660e\u7ec6\u79bb\u7ebf\u5bfc\u5165\u65f6\u8c03\u7528tda\u5fae\u670d\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
    }

    private void setData(Map<String, Object> data, String key, Object value) {
        if (EmptyUtil.isEmpty((Object)data.get(key))) {
            data.put(key, value);
        }
    }

    protected void addErrMessage(String message) {
        throw new KDBizException(message);
    }

    private String resolve(String bizTimeStr) {
        Matcher matcher = pattern.matcher(bizTimeStr);
        return matcher.replaceAll("").trim();
    }

    private <E> List<E> getDuplicateElements(List<E> list) {
        return list.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private Map<Long, Set<Long>> getOrgIdAndAccountIdsMap(Map<String, DynamicObject> numberAndOrgMap, Map<String, List<DynamicObject>> acctBanks, Map<String, List<String>> orgNumberAndBankAccountNumbersMap) {
        HashMap<Long, Set<Long>> orgIdAndAccountIdsMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<String, List<String>> entry : orgNumberAndBankAccountNumbersMap.entrySet()) {
            List<String> accountNumberList;
            DynamicObject org = numberAndOrgMap.get(entry.getKey());
            if (EmptyUtil.isEmpty((DynamicObject)org) || EmptyUtil.isEmpty(accountNumberList = entry.getValue())) continue;
            HashSet accountIdSet = new HashSet(16);
            accountNumberList.forEach(accountNumber -> {
                List accountList = (List)acctBanks.get(accountNumber);
                if (EmptyUtil.isNoEmpty((Object)accountList)) {
                    DynamicObject account = (DynamicObject)accountList.get(0);
                    accountIdSet.add(account.getLong("id"));
                }
            });
            orgIdAndAccountIdsMap.put(org.getLong("id"), accountIdSet);
        }
        return orgIdAndAccountIdsMap;
    }
}

