/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.elec;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.enums.BalanceDirectionEnum;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;

public class ElecStatementImportOp
extends AbstractTmcBatchImportPlugin {
    protected void beforeImportOp(Map<String, Object> rowdata, Map<String, Object> option) throws ParseException {
        JSONObject account = (JSONObject)rowdata.get("accountbank");
        if (EmptyUtil.isEmpty((Object)account)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceBatchImportOp_3", (String)"tmc-bei-opplugin", (Object[])new Object[0]));
            return;
        }
        String accountNum = account.getString("bankaccountnumber");
        DynamicObjectCollection accountDO = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accountNum)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)accountDO)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u4e0d\u5b58\u5728\u3002", (String)"BalanceBatchImportOp_4", (String)"tmc-bei-opplugin", (Object[])new Object[]{accountNum}));
            return;
        }
        JSONObject currency = (JSONObject)rowdata.get("currency");
        if (EmptyUtil.isEmpty((Object)account)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_4", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            return;
        }
        String currencyNum = currency.getString("number");
        DynamicObjectCollection currencyDO = QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNum)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)currencyDO)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5e01\u79cd\uff1a%s\u4e0d\u5b58\u5728\u3002", (String)"ElecStatementImportValidaeOp_0", (String)"tmc-bei-opplugin", (Object[])new Object[]{currencyNum}));
            return;
        }
        Date period = DateUtils.stringToDate((String)rowdata.get("period").toString(), (String)"yyyy-MM-dd");
        QFilter qFilter = new QFilter("accountbank", "=", (Object)((DynamicObject)accountDO.get(0)).getLong("id"));
        qFilter.and("currency", "=", (Object)((DynamicObject)currencyDO.get(0)).getLong("id"));
        qFilter.and("period", "=", (Object)period);
        qFilter.and("datasource", "=", (Object)DataSourceEnum.IMPORT.getValue());
        boolean exists = QueryServiceHelper.exists((String)"bei_elecstatement", (QFilter[])qFilter.toArray());
        if (exists) {
            this.addErrMessage(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"ElecStatementImportValidaeOp_1", (String)"tmc-bei-opplugin", (Object[])new Object[0]));
            return;
        }
        rowdata.put("joindate", DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd"));
        rowdata.put("jointime", DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        rowdata.put("datasource", DataSourceEnum.IMPORT.getValue());
        rowdata.put("billstatus", BillStatusEnum.AUDIT.getValue());
        JSONObject accountBankJsonObject = (JSONObject)rowdata.get("accountbank");
        String accountBank = (String)accountBankJsonObject.get((Object)"bankaccountnumber");
        DynamicObjectCollection acctBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,createorg.id,openorg.number,openorg.name,bank.number,bank.name,acctname", (QFilter[])new QFilter("bankaccountnumber", "=", (Object)accountBank).toArray());
        DynamicObject acctBank = (DynamicObject)acctBanks.get(0);
        JSONObject accountCompanyJsonObject = new JSONObject();
        accountCompanyJsonObject.put("importprop", (Object)"number");
        accountCompanyJsonObject.put("number", (Object)acctBank.getString("openorg.number"));
        accountCompanyJsonObject.put("name", (Object)acctBank.getString("openorg.name"));
        rowdata.put("accountcompany", accountCompanyJsonObject);
        JSONObject bankJsonObject = new JSONObject();
        bankJsonObject.put("importprop", (Object)"number");
        bankJsonObject.put("number", (Object)acctBank.getString("bank.number"));
        bankJsonObject.put("name", (Object)acctBank.getString("bank.name"));
        rowdata.put("bank", bankJsonObject);
        rowdata.put("accountbankname", StringUtils.isNotEmpty((CharSequence)((String)rowdata.get("accountbankname"))) ? rowdata.get("accountbankname") : acctBank.get("acctname"));
        JSONArray jsonArray = (JSONArray)rowdata.get("entryentity");
        for (Object obj : jsonArray) {
            JSONObject rowObj = (JSONObject)obj;
            String name = (String)rowObj.get((Object)"e_balancedirection");
            if (Objects.equals(name, BalanceDirectionEnum.CREDIT.getName())) {
                rowObj.put("e_balancedirection", (Object)BalanceDirectionEnum.CREDIT.getValue());
                continue;
            }
            rowObj.put("e_balancedirection", (Object)BalanceDirectionEnum.DEBIT.getValue());
        }
    }

    protected void afterImportOp(List<Map<String, Object>> datas) {
    }
}

