/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.webapi;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailUploadWebApiPlugin
implements IBillWebApiPlugin {
    private String orgName;
    private String accountNum;
    private String currencyName;
    private static final Log logger = LogFactory.getLog(TransDetailUploadWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            this.doParamsValid(params);
            String errorMessage = this.doAnalysisParams(params);
            if (!StringUtils.isEmpty((Object)errorMessage)) {
                return ApiResult.fail((String)errorMessage);
            }
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"TransDetailUploadWebApiPlugin_1", (String)"tmc-bei-webapi", (Object[])new Object[0]));
    }

    private boolean doParamsValid(Map<String, Object> params) {
        return params != null;
    }

    private String doAnalysisParams(Map<String, Object> params) {
        logger.info("\u5916\u90e8\u7cfb\u7edf\u8c03\u7528TransDetailUploadWebApiPlugin\u7684doAnalysisParams\u65b9\u6cd5");
        this.orgName = params.get("orgName").toString();
        this.accountNum = params.get("accountNum").toString();
        this.currencyName = params.get("currencyName").toString();
        String bizdates = params.get("bizdates").toString();
        String debitamounts = params.get("debitamounts").toString();
        String creditamounts = params.get("creditamounts").toString();
        String transbalances = params.get("transbalances").toString();
        String descriptions = params.get("descriptions").toString();
        String detailids = params.get("detailids").toString();
        String oppbanknumbers = params.get("oppbanknumbers").toString();
        String oppbanks = params.get("oppbanks").toString();
        String[] bankcheckflagArr = null;
        if (params.containsKey("bankcheckflags")) {
            String bankcheckflags = params.get("bankcheckflags").toString();
            bankcheckflagArr = bankcheckflags.split(",");
        }
        String[] bizdateArr = bizdates.split(",");
        String[] debitamountArr = debitamounts.split(",");
        String[] creditamountArr = creditamounts.split(",");
        String[] transbalanceArr = transbalances.split(",");
        String[] descriptionArr = descriptions.split(",");
        String[] detailidArr = detailids.split(",");
        String[] oppbanknumberArr = oppbanknumbers.split(",");
        String[] oppbankArr = oppbanks.split(",");
        int len = bizdateArr.length;
        Object orgId = null;
        Object accountId = null;
        Object curId = null;
        if (len > 0) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)this.orgName)});
            DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.accountNum)});
            DynamicObject currencyObj = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)this.currencyName)});
            if (orgObj != null) {
                orgId = orgObj.getPkValue();
            }
            if (accountObj != null) {
                accountId = accountObj.getPkValue();
            }
            if (currencyObj != null) {
                curId = currencyObj.getPkValue();
            }
        }
        String errorMessage = "";
        try {
            DynamicObject[] objs = new DynamicObject[len];
            MainEntityType props = EntityMetadataCache.getDataEntityType((String)"bei_betransdetail_imp");
            long[] idArr = DB.genLongIds((String)props.getAlias(), (int)len);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            for (int i = 0; i < len; ++i) {
                Object detailId;
                long id = idArr[i];
                objs[i].set("id", (Object)id);
                objs[i] = (DynamicObject)props.createInstance();
                if (orgId != null) {
                    objs[i].set("company", orgId);
                }
                if (accountId != null) {
                    objs[i].set("accountbank", accountId);
                }
                if (curId != null) {
                    objs[i].set("currency", curId);
                }
                if (EmptyUtil.isNoEmpty((String)bizdateArr[i])) {
                    objs[i].set("bizdate", (Object)sdf.parse(bizdateArr[i]));
                }
                if (EmptyUtil.isNoEmpty((String)debitamountArr[i])) {
                    objs[i].set("debitamount", (Object)debitamountArr[i]);
                }
                if (EmptyUtil.isNoEmpty((String)creditamountArr[i])) {
                    objs[i].set("creditamount", (Object)creditamountArr[i]);
                }
                if (EmptyUtil.isNoEmpty((String)transbalanceArr[i])) {
                    objs[i].set("transbalance", (Object)transbalanceArr[i]);
                }
                if (EmptyUtil.isNoEmpty((String)descriptionArr[i])) {
                    objs[i].set("description", (Object)descriptionArr[i]);
                }
                if (EmptyUtil.isNoEmpty((String)detailidArr[i])) {
                    objs[i].set("detailid", (Object)detailidArr[i]);
                }
                if ((detailId = objs[i].getString("detailid")) == null || ((String)detailId).length() == 0 || " ".equals(detailId)) {
                    objs[i].set("detailid", (Object)(id + ""));
                }
                if (bankcheckflagArr == null || bankcheckflagArr.length == 0 || EmptyUtil.isEmpty((String)bankcheckflagArr[i])) {
                    objs[i].set("bankcheckflag", (Object)GenBankcheckCode.genCode());
                } else {
                    objs[i].set("bankcheckflag", (Object)bankcheckflagArr[i]);
                }
                if (EmptyUtil.isNoEmpty((String)oppbanknumberArr[i])) {
                    objs[i].set("oppbanknumber", (Object)oppbanknumberArr[i]);
                }
                if (EmptyUtil.isNoEmpty((String)oppbankArr[i])) {
                    objs[i].set("oppbank", (Object)oppbankArr[i]);
                }
                objs[i].set("billstatus", (Object)"A");
                objs[i].set("createtime", (Object)new Date());
                objs[i].set("modifytime", (Object)new Date());
            }
            List detailIds = Arrays.stream(objs).map(obj -> obj.getString("detailid")).collect(Collectors.toList());
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(detailIds.size());
            for (Object detailId : detailIds) {
                countMap.put((String)detailId, countMap.getOrDefault(detailId, 0) + 1);
            }
            ArrayList inputRepeat = new ArrayList();
            for (Map.Entry entry : countMap.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                inputRepeat.add(entry.getKey());
                detailIds.remove(entry.getKey());
            }
            if (!CollectionUtils.isEmpty(inputRepeat)) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7\uff08%s\uff09\u6570\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u552f\u4e00\uff0c\u76f8\u540c\u6d41\u6c34\u53f7\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\u3002", (String)"TransDetailUploadWebApiPlugin_0", (String)"tmc-bei-webapi", (Object[])new Object[0]), String.join((CharSequence)",", inputRepeat));
            }
            DynamicObjectCollection exist = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"detailid", (QFilter[])new QFilter("detailid", "in", detailIds).toArray());
            Set set = exist.stream().map(e -> e.getString("detailid")).collect(Collectors.toSet());
            logger.info("TransDetailUploadWebApiPlugin\u7c7b\u7684exist\u4e3a\uff1a{}\uff0cexist\u5927\u5c0f\u662f\uff1a{}\uff0cexistDetailIds\u662f\uff1a{}\uff0cexistDetailIds\u5927\u5c0f\u662f:{}", new Object[]{exist, exist.size(), set, set.size()});
            DynamicObject[] notExistObjs = (DynamicObject[])Arrays.stream(objs).filter(o -> !existDetailIds.contains(o.getString("detailid"))).toArray(DynamicObject[]::new);
            if (notExistObjs.length > 0) {
                SaveServiceHelper.save((DynamicObject[])notExistObjs);
            }
            if (!CollectionUtils.isEmpty(set)) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7\uff08%s\uff09\u6570\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u552f\u4e00\uff0c\u76f8\u540c\u6d41\u6c34\u53f7\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\u3002", (String)"TransDetailUploadWebApiPlugin_0", (String)"tmc-bei-webapi", (Object[])new Object[0]), String.join((CharSequence)",", set));
            }
            return errorMessage;
        }
        catch (ParseException parseException) {
            return errorMessage;
        }
    }
}

