/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.webapi.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileNameUtils;
import kd.tmc.bei.business.ocr.impl.OcrServiceImpl;
import kd.tmc.bei.common.constants.OcrReceiptBean;
import kd.tmc.bei.common.constants.ReceiptInfoBean;
import kd.tmc.bei.common.constants.ReceiptRecongnizeDetail;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.bei.common.helper.OfdFileParseHelper;
import kd.tmc.bei.webapi.openapi.bean.ElecReceiptFileInfo;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

@ApiController(value="bei", desc="\u7535\u5b50\u56de\u5355\u6587\u4ef6\u8bc6\u522b\u5bfc\u5165\u63a5\u53e3")
@ApiMapping(value="/openapi/bei/elecreceipt")
public class ElecReceiptFileImportController
implements Serializable {
    private static final Log logger = LogFactory.getLog(ElecReceiptFileImportController.class);
    private static final long serialVersionUID = -1508745016380737287L;

    @ApiPostMapping(value="/importFile")
    public CustomApiResult<String> importFile(@ApiParam(value="\u56de\u5355\u6587\u4ef6\u6d41") @ApiParam(value="\u56de\u5355\u6587\u4ef6\u6d41") List<ElecReceiptFileInfo> datas) {
        CustomApiResult result = new CustomApiResult();
        if (datas == null) {
            result.setStatus(false);
            result.setErrorCode(ApiErrorCode.Data_Invalid.getStatusCode());
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u9001\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ElecReceiptFileImportController_0", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        } else {
            logger.info("ElecReceiptFileInfo fileNames: " + datas.stream().map(ElecReceiptFileInfo::getFileName).collect(Collectors.toList()));
            for (ElecReceiptFileInfo data : datas) {
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                try {
                    OcrReceiptBean ocrReceiptBean;
                    ByteArrayInputStream ins = new ByteArrayInputStream(data.getFileData());
                    String tenantId = RequestContext.get().getTenantId();
                    String accountId = RequestContext.get().getAccountId();
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    long uploadPkId = DBServiceHelper.genGlobalLongId();
                    String fileName = data.getFileName();
                    if (fileName.contains("/")) {
                        String[] split = fileName.split("/");
                        fileName = split[split.length - 1];
                    }
                    String uploadPath = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)uploadPkId, (String)(uuid + "/" + fileName));
                    logger.info("uploadPath " + uploadPath + " uploadPkId: " + uploadPkId);
                    FileItem fileItem = new FileItem(uploadPath, uploadPath, (InputStream)ins);
                    String uploadUrl = fileService.upload(fileItem);
                    logger.info("uploadUrl " + uploadUrl);
                    InputStream insNew = fileService.getInputStream(uploadUrl);
                    if (fileName.endsWith(".ofd") || fileName.endsWith(".OFD")) {
                        ocrReceiptBean = new OcrReceiptBean();
                        ReceiptInfoBean receiptInfoBean = OfdFileParseHelper.genReceiptOfdParseResult((String)uploadPath, (String)fileName);
                        ocrReceiptBean.setData(Collections.singletonList(JSON.parseObject((String)JSON.toJSONString((Object)receiptInfoBean))));
                        ocrReceiptBean.setErrorCode("0");
                    } else {
                        OcrServiceImpl osi = new OcrServiceImpl();
                        ocrReceiptBean = osi.getReceiptDetail(insNew, uploadPath);
                    }
                    this.saveReceipt(ocrReceiptBean, (CustomApiResult<String>)result, uploadUrl, data.getFileName());
                    insNew.close();
                }
                catch (Exception e) {
                    logger.error("fileName: " + data.getFileName() + " \u7535\u5b50\u56de\u5355\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38\uff1a " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            if (result.getData() != null && ((String)result.getData()).trim().split(" ").length > 0) {
                List split = Arrays.stream(((String)result.getData()).trim().split(" ")).filter(Objects::nonNull).collect(Collectors.toList());
                result.setStatus(true);
                result.setMessage(String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5bfc\u5165\u6210\u529f%1$s\u6761\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u6761\uff0c\u82e5\u5bfc\u5165\u5931\u8d25\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ElecReceiptFileImportController_1", (String)"tmc-bei-webapi", (Object[])new Object[0]), split.size(), datas.size() - split.size()));
            } else {
                result.setStatus(false);
                result.setErrorCode(ApiErrorCode.Data_Invalid.getStatusCode());
                result.setMessage(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ElecReceiptFileImportController_2", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private void saveReceipt(OcrReceiptBean ocrReceiptBean, CustomApiResult<String> result, String uploadFileName, String fileName) {
        String errorCode = ocrReceiptBean.getErrorCode();
        logger.info("ocrDescription:" + ocrReceiptBean.getDescription());
        if (EmptyUtil.isEmpty((String)errorCode) || "0".equals(errorCode)) {
            logger.info("ocrData: " + ocrReceiptBean.getData().toString());
            List datas = ocrReceiptBean.getData();
            DynamicObject[] receipts = new DynamicObject[datas.size()];
            int i = 0;
            ArrayList<DynamicObject> resList = new ArrayList<DynamicObject>();
            for (Object data : datas) {
                ReceiptInfoBean receiptInfoBean = (ReceiptInfoBean)((JSONObject)data).toJavaObject(ReceiptInfoBean.class);
                if (EmptyUtil.isNoEmpty((String)receiptInfoBean.getErrorInfo()) && !"".equals(receiptInfoBean.getErrorInfo().trim())) {
                    logger.error("errorInfo: " + receiptInfoBean.getErrorInfo());
                    return;
                }
                ReceiptRecongnizeDetail recongnizeDetail = receiptInfoBean.getRecongnizeDetail();
                receipts[i] = BusinessDataServiceHelper.newDynamicObject((String)"bei_elecreceipt");
                boolean flag = this.setReceiptValue(receipts[i], recongnizeDetail, result, uploadFileName, fileName);
                if (flag) {
                    resList.add(receipts[i]);
                }
                ++i;
            }
            if (receipts.length > 0 && receipts[0] != null) {
                SaveServiceHelper.save((DynamicObject[])resList.toArray(new DynamicObject[0]));
            }
        } else {
            logger.error("ocrErrorCode: " + ocrReceiptBean.getErrorCode() + " Description: " + ocrReceiptBean.getDescription());
        }
    }

    private boolean setReceiptValue(DynamicObject receipt, ReceiptRecongnizeDetail recongnizeDetail, CustomApiResult<String> result, String uploadFileName, String fileName) {
        boolean isPay;
        List authOrgIds;
        BigDecimal amount = new BigDecimal(recongnizeDetail.getFamount().replaceAll(",", ""));
        String currencyCode = recongnizeDetail.getFcurrency();
        String fpayeeAccount = recongnizeDetail.getFpayeeAccount();
        String fpayeeBank = recongnizeDetail.getFpayeeBank();
        String fpayeeName = recongnizeDetail.getFpayeeName();
        String fpaymentAccount = recongnizeDetail.getFpaymentAccount();
        String fpaymentBank = recongnizeDetail.getFpaymentBank();
        String fpaymentName = recongnizeDetail.getFpaymentName();
        String ftradeDate = recongnizeDetail.getFtradeDate();
        String ftradeId = recongnizeDetail.getFtradeId();
        String ftradeType = recongnizeDetail.getFtradeType();
        String fabstract = recongnizeDetail.getFabstract();
        String ftradeNumber = recongnizeDetail.getFtradeNumber();
        String bankAccountNumber = LendingDirectionEnum.OUT.getDirect().equals(ftradeType) ? fpaymentAccount : fpayeeAccount;
        Object[] accountbank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAccountNumber)});
        if (EmptyUtil.isEmpty((Object[])accountbank)) {
            logger.error("fileName: " + fileName + " Description: " + ResManager.loadKDString((String)"\u8d26\u53f7\u3010%s\u3011\u5728\u94f6\u884c\u8d26\u6237\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u94f6\u884c\u8d26\u6237\u3002", (String)"ElecReceiptFileImportController_3", (String)"tmc-bei-webapi", (Object[])new Object[]{bankAccountNumber}));
            return false;
        }
        Object accountBankId = accountbank[0].getPkValue();
        Object[] currency = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyCode).or("name", "=", (Object)currencyCode)});
        boolean exists = false;
        logger.info("ftradeId: " + ftradeId + ",currency: " + Arrays.toString(currency) + ",accountBankId: " + accountBankId + ",amount: " + amount);
        if (ftradeId != null && accountBankId != null && fpayeeAccount != null && fpaymentAccount != null) {
            QFilter filter = new QFilter("detailid", "=", (Object)ftradeId);
            filter.and("currency", "=", EmptyUtil.isNoEmpty((Object[])currency) ? currency[0].get("id") : null);
            filter.and("accountbank", "=", accountBankId);
            filter.and("oppbanknumber", "=", (Object)(LendingDirectionEnum.OUT.getDirect().equals(ftradeType) ? fpayeeAccount : fpaymentAccount));
            filter.and(LendingDirectionEnum.OUT.getDirect().equals(ftradeType) ? "debitamount" : "creditamount", "=", (Object)amount);
            exists = QueryServiceHelper.exists((String)"bei_elecreceipt", (QFilter[])filter.toArray());
        }
        logger.warn("elecReceipt exists " + exists);
        if (exists) {
            logger.warn("fileName: " + fileName + " Description: " + ResManager.loadKDString((String)"\u53ef\u7591\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u7ecf\u5bfc\u5165\u3002", (String)"ElecReceiptFileImportController_4", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((Object[])currency)) {
            receipt.set("currency", currency[0].get("id"));
        }
        DynamicObject company = accountbank[0].getDynamicObject("company");
        logger.info("accountBankId: " + accountBankId + " companyId: " + company.getPkValue());
        receipt.set("accountbank", accountbank[0]);
        Long companyId = (Long)company.getPkValue();
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPermission = TmcOrgDataHelper.hasPermission(null, (long)userId, (long)companyId, (String)"bei_elecreceipt", (String)"47150e89000000ac");
        if (!hasPermission) {
            logger.error("fileName: " + fileName + " Description: " + ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u65e0\u8be5\u56de\u5355\u7684\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u6388\u6743\u540e\u518d\u5bfc\u5165\u3002", (String)"ElecReceiptFileImportController_5", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            return false;
        }
        receipt.set("company", (Object)companyId);
        receipt.set("bank", accountbank[0].getDynamicObject("bank").getPkValue());
        if (accountbank[0].getDynamicObject("company") == null && !(authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)"bei", (String)"bei_elecreceipt", (String)"47150e89000000ac")).isEmpty()) {
            receipt.set("company", authOrgIds.get(0));
        }
        receipt.set("oppbanknumber", (Object)((isPay = LendingDirectionEnum.OUT.getDirect().equals(ftradeType)) ? fpayeeAccount : fpaymentAccount));
        receipt.set("oppbankname", (Object)(isPay ? fpayeeName : fpaymentName));
        receipt.set("oppbank", (Object)(isPay ? fpayeeBank : fpaymentBank));
        receipt.set("oppunit", (Object)(isPay ? fpayeeName : fpaymentName));
        receipt.set("recno", (Object)fpayeeAccount);
        receipt.set("recname", (Object)fpayeeName);
        receipt.set("recbankname", (Object)fpayeeBank);
        receipt.set("accno", (Object)fpaymentAccount);
        receipt.set("accname", (Object)fpaymentName);
        receipt.set("bankname", (Object)fpaymentBank);
        receipt.set(isPay ? "debitamount" : "creditamount", (Object)amount);
        receipt.set("amount", (Object)amount);
        receipt.set("detailid", (Object)ftradeId);
        receipt.set("bizdate", (Object)DateFormatUtil.FormatDate((String)ftradeDate));
        receipt.set("uploadfilename", (Object)uploadFileName);
        receipt.set("filepath", (Object)uploadFileName);
        receipt.set("fileflag", (Object)"1");
        receipt.set("completeflag", (Object)"1");
        receipt.set("biztype", (Object)"1");
        receipt.set("detaildatetime", (Object)DateFormatUtil.FormatDate((String)ftradeDate));
        receipt.set("description", (Object)fabstract);
        receipt.set("creditdebitflag", (Object)(isPay ? LendingDirectionEnum.OUT.getValue() : LendingDirectionEnum.IN.getValue()));
        receipt.set("remarks", (Object)fabstract);
        receipt.set("bizrefno", (Object)ftradeNumber);
        long id = DBServiceHelper.genGlobalLongId();
        receipt.set("id", (Object)id);
        receipt.set("receiptno", (Object)("e-ocr-" + id));
        receipt.set("datasource", (Object)"image");
        receipt.set("billstatus", (Object)"A");
        receipt.set("modifytime", (Object)DateUtils.getCurrentTime());
        String billno = CodeRuleHelper.generateNumber((String)"bei_elecreceipt", (DynamicObject)receipt, null, null);
        logger.info("receiptBillNo: " + billno + " receiptNo: " + id);
        receipt.set("billno", (Object)billno);
        result.setData((Object)(result.getData() == null ? billno : (String)result.getData() + " " + billno));
        return true;
    }
}

