/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.webapi.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.bei.webapi.openapi.bean.ElecReceiptInfo;
import kd.tmc.bei.webapi.openapi.bean.ReceiptDatas;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecReceiptSaveWebApiPlugin
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(ElecReceiptSaveWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info("\u5916\u90e8\u7cfb\u7edf\u8c03\u7528doCustomService\u65b9\u6cd5");
        ApiResult result = new ApiResult();
        HashSet<String> modifyList = new HashSet<String>(16);
        Set<Object> addList = new HashSet(16);
        if (params == null) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u9001\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ElecReceiptSaveWebApiPlugin_0", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            logger.info("doCustomService\u65b9\u6cd5\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u9001\u7684\u56de\u5355\u6570\u636e");
        } else {
            logger.info("doCustomService\u65b9\u6cd5\u7684\u53c2\u6570params\u4e0d\u4e3a\u7a7a");
            JSONObject paramObj = new JSONObject(params);
            JSONObject dataObj = paramObj.getJSONObject("datas");
            ReceiptDatas data = (ReceiptDatas)JSON.parseObject((String)dataObj.toJSONString(), ReceiptDatas.class);
            List<ElecReceiptInfo> infos = data.getInfos();
            ArrayList<DynamicObject> resLists = new ArrayList<DynamicObject>(infos.size());
            logger.info("infos\u7684\u5927\u5c0f\u662f\uff1a{}\uff0cinfos\u662f\uff1a{}", (Object)infos.size(), (Object)infos.toString());
            if (infos.size() > 0) {
                List<ElecReceiptInfo> doReceipt;
                List fileIdList = infos.stream().map(ElecReceiptInfo::getFileId).collect(Collectors.toList());
                logger.info("fileIdList\u662f\uff1a{}", (Object)fileIdList.toString());
                DynamicObject[] hasReceipt = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,fileserverurl,detailid,modifytime,ismatch,receiptno,bizdate,currency,accountbank,company,bank,oppbanknumber,oppbankname,oppbank,oppunit,recno,recname,recbankname,accno,accname,bankname,debitamount,creditamount,amount,detailid,uploadfilename,filepath,fileflag,completeflag,biztype,detaildatetime,description,creditdebitflag,remarks,bizrefno,datasource,billstatus,modifytime,use,validcode,billno", (QFilter[])new QFilter("fileserverurl", "in", fileIdList).toArray());
                logger.info("hasReceipt\u7684\u5927\u5c0f\u662f\uff1a{}\uff0chasReceipt\u662f\uff1a{}", (Object)hasReceipt.length, (Object)hasReceipt);
                if (hasReceipt.length > 0) {
                    logger.info("hasReceipt\u7684\u957f\u5ea6\u5927\u4e8e0");
                    List<DynamicObject> hasReceiptList = Arrays.asList(hasReceipt);
                    Set hasFileIdList = hasReceiptList.stream().map(e -> e.getString("fileserverurl")).collect(Collectors.toSet());
                    doReceipt = infos.stream().filter(e -> !hasFileIdList.contains(e.getFileId())).collect(Collectors.toList());
                    List isMatchReceiptNoList = hasReceiptList.stream().filter(e -> (Boolean)e.get("ismatch")).map(e -> (String)e.get("receiptno")).collect(Collectors.toList());
                    String logStr = String.join((CharSequence)"\u3001", isMatchReceiptNoList);
                    logger.info("\u7535\u5b50\u56de\u5355\u53f7\uff1a{} \u5df2\u5173\u8054\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0", (Object)logStr);
                    Map<DynamicObject, Optional> receiptToInfoMap = hasReceiptList.stream().filter(e -> (Boolean)e.get("ismatch") == false).collect(Collectors.toMap(t -> t, t -> infos.stream().filter(s -> s.getFileId().equals(t.get("fileserverurl"))).findFirst()));
                    logger.info("\u662f\u5426\u5339\u914d\u5b57\u6bb5\u4e3a\u5426\u7684\u7535\u5b50\u56de\u5355 \u548c \u53d1\u7968\u4e91\u4f20\u8fc7\u6765\u7684\u56de\u5355\u6620\u5c04\u662f\uff1a{}", receiptToInfoMap);
                    for (Map.Entry<DynamicObject, Optional> entry : receiptToInfoMap.entrySet()) {
                        DynamicObject localReceipt = entry.getKey();
                        ElecReceiptInfo receiptFromFpy = entry.getValue().isPresent() ? (ElecReceiptInfo)entry.getValue().get() : null;
                        logger.info("\u672c\u7cfb\u7edf\u4e2d\u5b58\u5728\u7684\u5e76\u4e14 \u7535\u5b50\u56de\u5355\u4e0a\u7684\u201c\u662f\u5426\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u201d\u5b57\u6bb5\u4e3a\u5426 \u7684\u56de\u5355\u8fdb\u884c\u5168\u91cf\u66f4\u65b0\uff0c\u66f4\u65b0\u524d\u7684resLists\u662f\uff1a{},\u66f4\u65b0\u524d\u7684 modifyList\u662f\uff1a{}", (Object)((Object)resLists).toString(), (Object)((Object)modifyList).toString());
                        ElecReceiptSaveWebApiPlugin.dealElecreceipt(Collections.singletonList(receiptFromFpy), resLists, localReceipt, modifyList, true);
                        logger.info("\u672c\u7cfb\u7edf\u4e2d\u5b58\u5728\u7684\u5e76\u4e14 \u7535\u5b50\u56de\u5355\u4e0a\u7684\u201c\u662f\u5426\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u201d\u5b57\u6bb5\u4e3a\u5426 \u7684\u56de\u5355\u8fdb\u884c\u5168\u91cf\u66f4\u65b0\uff0c\u66f4\u65b0\u540e\u7684resLists\u662f\uff1a{},\u66f4\u65b0\u540e\u7684modifyList\u662f\uff1a{}", (Object)((Object)resLists).toString(), (Object)((Object)modifyList).toString());
                    }
                } else {
                    doReceipt = infos;
                    logger.info("infos\u7684\u503c\u76f4\u63a5\u8d4b\u7ed9doReceipt");
                }
                addList = doReceipt.stream().map(ElecReceiptInfo::getFileId).collect(Collectors.toSet());
                logger.info("\u76f4\u63a5\u63d2\u5165\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7684\u7535\u5b50\u56de\u5355\uff0c\u63d2\u5165\u524d\u7684resLists\u662f\uff1a{}\uff0c\u63d2\u5165\u524d\u7684resLists\u5927\u5c0f\u662f\uff1a{}\uff0c\u63d2\u5165\u524d\u7684modifyList\u662f\uff1a{}\uff0c\u63d2\u5165\u524d\u7684modifyList\u5927\u5c0f\u662f\uff1a{}", new Object[]{((Object)resLists).toString(), resLists.size(), ((Object)modifyList).toString(), modifyList.size()});
                ElecReceiptSaveWebApiPlugin.dealElecreceipt(doReceipt, resLists, null, modifyList, false);
                logger.info("\u76f4\u63a5\u63d2\u5165\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7684\u7535\u5b50\u56de\u5355\uff0c\u63d2\u5165\u540e\u7684resLists\u662f\uff1a{}\uff0c\u63d2\u5165\u540e\u7684resLists\u5927\u5c0f\u662f\uff1a{}\uff0c\u63d2\u5165\u540e\u7684modifyList\u662f\uff1a{}\uff0c\u63d2\u5165\u540e\u7684modifyList\u5927\u5c0f\u662f\uff1a{}", new Object[]{((Object)resLists).toString(), resLists.size(), ((Object)modifyList).toString(), modifyList.size()});
            } else {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u56de\u5355\u6570\u636e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ElecReceiptSaveWebApiPlugin_1", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            if (resLists.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])resLists.toArray(new DynamicObject[0]));
                result.setSuccess(true);
                StringBuilder sb = new StringBuilder();
                String str = ResManager.loadKDString((String)"\u6210\u529f\u4e0a\u4f20\u56de\u5355", (String)"ElecReceiptSaveWebApiPlugin_2", (String)"tmc-bei-webapi", (Object[])new Object[0]);
                sb.append(str);
                sb.append(resLists.size());
                sb.append(ResManager.loadKDString((String)"\u6761", (String)"ElecReceiptSaveWebApiPlugin_3", (String)"tmc-bei-webapi", (Object[])new Object[0]));
                result.setMessage(sb.toString());
            }
            logger.info("\u4e00\u5171\u9700\u8981\u5bfc\u5165{}\u6761\u6570\u636e,\u5176\u4e2d\u5bfc\u5165\u6210\u529f{}\u6761\u6570\u636e,\u65b0\u589e{}\u6761,\u65b0\u589e\u7684\u670d\u52a1\u5668\u7684\u6587\u4ef6id\u5206\u522b\u4e3a{},\u66f4\u65b0{}\u6761\u6570\u636e,\u66f4\u65b0\u7684\u670d\u52a1\u5668\u7684\u6587\u4ef6id\u5206\u522b\u4e3a{}", new Object[]{infos.size(), modifyList.size() + addList.size(), addList.size(), ((Object)addList).toString(), modifyList.size(), ((Object)modifyList).toString()});
        }
        return result;
    }

    public static void dealElecreceipt(List<ElecReceiptInfo> doReceipt, List<DynamicObject> resLists, DynamicObject localReceipt, Set<String> modifyList, boolean isUpdateOperate) {
        for (ElecReceiptInfo info : doReceipt) {
            boolean isPay;
            DynamicObject obj;
            if (isUpdateOperate) {
                obj = localReceipt;
                modifyList.add(localReceipt.getString("fileserverurl"));
            } else {
                obj = BusinessDataServiceHelper.newDynamicObject((String)"bei_elecreceipt");
                obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
            }
            String fabstract = info.getFabstract();
            double famount = info.getFamount();
            BigDecimal amount = BigDecimal.valueOf(famount);
            amount = amount.setScale(2, RoundingMode.HALF_UP);
            String fcurrency = info.getFcurrency();
            String ffileName = info.getFfileName();
            String fileId = info.getFileId();
            String fpayeeAccount = info.getFpayeeAccount();
            String fpayeeBank = info.getFpayeeBank();
            String fpayeeName = info.getFpayeeName();
            String fpaymentAccount = info.getFpaymentAccount();
            String fpaymentBank = info.getFpaymentBank();
            String fpaymentName = info.getFpaymentName();
            String ftradeDate = info.getFtradeDate();
            String ftradeId = info.getFtradeId();
            String ftradeNumber = info.getFtradeNumber();
            String ftradeType = info.getFtradeType();
            String fuse = info.getFuse();
            String ticketType = info.getTicketType();
            String validCode = info.getFvalidCode();
            obj.set("bizdate", (Object)DateFormatUtil.FormatDate((String)ftradeDate));
            Map accountbank = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"id,company,createorg,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)(LendingDirectionEnum.OUT.getDirect().equals(ftradeType) ? fpaymentAccount : fpayeeAccount))});
            Map currency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)fcurrency).or("name", "=", (Object)fcurrency)});
            if (currency != null && currency.size() > 0) {
                Long currencyId = 0L;
                for (Object t : currency.keySet()) {
                    currencyId = Long.parseLong(t.toString());
                }
                obj.set("currency", (Object)currencyId);
            }
            Object bank = null;
            if (accountbank.size() > 0) {
                Iterator<Object> iterator = accountbank.values().iterator();
                while (iterator.hasNext()) {
                    Object t;
                    bank = t = (DynamicObject)iterator.next();
                }
                obj.set("accountbank", bank);
                if (bank != null) {
                    obj.set("company", (Object)ElecReceiptSaveWebApiPlugin.getCreateOrgIdByAcct((DynamicObject)bank));
                    obj.set("bank", bank.getDynamicObject("bank").getPkValue());
                }
            }
            obj.set("oppbanknumber", (Object)((isPay = LendingDirectionEnum.OUT.getDirect().equals(ftradeType)) ? fpayeeAccount : fpaymentAccount));
            obj.set("oppbankname", (Object)(isPay ? fpayeeName : fpaymentName));
            obj.set("oppbank", (Object)(isPay ? fpayeeBank : fpaymentBank));
            obj.set("oppunit", (Object)(isPay ? fpayeeName : fpaymentName));
            obj.set("recno", (Object)fpayeeAccount);
            obj.set("recname", (Object)fpayeeName);
            obj.set("recbankname", (Object)fpayeeBank);
            obj.set("accno", (Object)fpaymentAccount);
            obj.set("accname", (Object)fpaymentName);
            obj.set("bankname", (Object)fpaymentBank);
            obj.set(isPay ? "debitamount" : "creditamount", (Object)amount);
            obj.set("amount", (Object)amount);
            obj.set("detailid", (Object)ftradeId);
            obj.set("bizdate", (Object)DateFormatUtil.FormatDate((String)ftradeDate));
            obj.set("uploadfilename", (Object)ffileName);
            obj.set("filepath", (Object)ffileName);
            obj.set("fileflag", (Object)"1");
            obj.set("completeflag", (Object)"1");
            obj.set("biztype", (Object)"1");
            obj.set("detaildatetime", (Object)DateFormatUtil.FormatDate((String)ftradeDate));
            obj.set("amount", (Object)amount);
            obj.set("description", (Object)fabstract);
            obj.set("creditdebitflag", (Object)(isPay ? LendingDirectionEnum.OUT.getValue() : LendingDirectionEnum.IN.getValue()));
            obj.set("remarks", (Object)fabstract);
            obj.set("bizrefno", (Object)ftradeNumber);
            obj.set("fileserverurl", (Object)fileId);
            obj.set("receiptno", obj.get("id"));
            obj.set("datasource", (Object)"image");
            obj.set("billstatus", (Object)"A");
            obj.set("modifytime", (Object)DateUtils.getCurrentTime());
            obj.set("use", (Object)fuse);
            obj.set("validcode", (Object)validCode);
            String billno = CodeRuleHelper.generateNumber((String)"bei_elecreceipt", (DynamicObject)obj, (String)(bank != null ? String.valueOf(ElecReceiptSaveWebApiPlugin.getCreateOrgIdByAcct((DynamicObject)bank)) : null), null);
            obj.set("billno", (Object)billno);
            resLists.add(obj);
        }
    }

    private static long getCreateOrgIdByAcct(DynamicObject accountBank) {
        DynamicObject obj = accountBank.getDynamicObject("createorg");
        return !EmptyUtil.isEmpty((DynamicObject)obj) ? obj.getLong("id") : 0L;
    }
}

