/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class CfmLoanBillIntCalcDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(CfmLoanBillIntCalcDataPlugin.class);
    private String statDim;
    private String isFrom;
    private DynamicObject reportCurrency;
    private static final String ORG = "org";
    private static final String TEXTCREDITOR = "textcreditor";
    private static final String IFM_APP = TmcAppEnum.IFM.getValue();
    private static final String SELECT_LOAN_FIELDS = "id, loancontractbill.number contractbillno, loancontractbill.contractno contractno, billno, org.id orgid, org.name org, currency, currency.name, finproduct.name finproduct,  creditor, textcreditor, startintdate, expiredate, drawamount, loantype,banksyndicate_entry.e_bank bankid, banksyndicate_entry.e_shareamount shareamount,banksyndicate_entry.e_bank.name creditorname";
    private static final String SELECT_LOANRATE_FIELDS = "id, rateadjust_entry.ra_effectdate effectdate, rateadjust_entry.ra_yearrate yearrate, rateadjust_entry.ra_effectdate loandate";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.initParams(paramMap);
        DataSet loanBillDS = this.getLoanBillDataSet(queryParam);
        if (loanBillDS == null || loanBillDS.isEmpty()) {
            return CfmLoanBillIntCalcDataPlugin.createEmptyDs();
        }
        Set<Long> bondIds = this.getBondIds(loanBillDS);
        DataSet bondDataSet = this.getBondDataSet(bondIds, paramMap);
        String creditorType = (String)paramMap.get("filter_creditortype");
        if ("other".equals(creditorType) || EmptyUtil.isBlank((CharSequence)creditorType)) {
            bondDataSet = this.dealBondDataSet(bondDataSet);
        }
        Set<Long> ids = this.getDataSetIds(loanBillDS);
        DataSet loanRateDS = this.getLoanRateDataSet(ids, paramMap);
        loanRateDS = this.dealRateDS(loanRateDS, paramMap);
        loanBillDS = loanBillDS.leftJoin(loanRateDS).on("id", "id").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"yearrate"}).finish();
        DataSet intBillSet = this.callInterest(paramMap, loanBillDS);
        DataSet resultSet = loanBillDS.leftJoin(intBillSet).on("id", "id").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"begindate", "enddate", "interestdays", "origccy_intamt", "principle", "intdetail"}).finish().filter("interestdays > 0");
        Date beginDate = (Date)paramMap.get("filter_begindate");
        resultSet = this.dealSlLoand(resultSet, beginDate);
        resultSet = this.dealBond(resultSet, bondDataSet, beginDate);
        return resultSet;
    }

    private void initParams(Map<String, Object> paramMap) {
        this.statDim = (String)paramMap.get("filter_statdim");
        this.isFrom = (String)paramMap.get("isfrom");
        this.reportCurrency = (DynamicObject)paramMap.get("filter_reportcurrency");
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected List<String> orinalAmountField() {
        return Collections.singletonList("origccy_intamt");
    }

    protected String getReportField(String field) {
        return "rptccy_intamt";
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.addFields(new String[]{"currency", this.reportCurrency.getPkValue().toString()}, new String[]{"src_currency", "rpt_currency"});
        return dataSet;
    }

    public String sumNameField() {
        if (IFM_APP.equals(this.isFrom)) {
            return "settlecenter";
        }
        return ORG.equals(this.statDim) ? TEXTCREDITOR : ORG;
    }

    public List<String> groupFields() {
        ArrayList<String> groupFields = new ArrayList<String>(10);
        if (IFM_APP.equals(this.isFrom)) {
            groupFields.add(ORG);
            return groupFields;
        }
        groupFields.add(this.statDim);
        return groupFields;
    }

    public List<String> sumAmountFields() {
        return Collections.singletonList("rptccy_intamt");
    }

    private DataSet dealBondDataSet(DataSet bondDataSet) {
        String otherName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"RepaymentFormListPlugin_29", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String selects = "id, contractbillno, contractno, billno, orgid, org, currency, currency.name, finproduct, creditor, textcreditor, startintdate, expiredate, drawamount, loantype, entryid,case when investorname=null then '" + otherName + "' else investorname end as investorname, investorid, case when investamount=null then drawamount else investamount end as investamount";
        bondDataSet = bondDataSet.select(selects.split(","));
        String groupFields = "id, contractbillno, contractno, billno, orgid, org, currency, currency.name, finproduct, creditor, textcreditor, startintdate, expiredate, drawamount, loantype";
        DataSet otherDS = bondDataSet.copy().filter("investamount!=drawamount").groupBy(groupFields.split(",")).sum("investamount").finish().filter("investamount!=drawamount");
        otherDS = otherDS.updateField("investamount", "drawamount-investamount").addField("'" + otherName + "'", "investorname").addField("0", "entryid").addField("0", "investorid");
        otherDS = otherDS.select(selects.split(","));
        return bondDataSet.union(otherDS);
    }

    private DataSet dealSlLoand(DataSet resultSet, Date date) {
        DataSet slLoandDs = resultSet.copy().filter("loantype='sl'");
        if (slLoandDs.isEmpty()) {
            return resultSet;
        }
        resultSet = resultSet.filter("loantype!='sl'");
        slLoandDs = slLoandDs.updateField("drawamount", "case when shareamount!=null then shareamount else drawamount end").updateField("creditor", "case when loantype='sl' then bankid else creditor end").updateField(TEXTCREDITOR, "case when loantype='sl' then creditorname else textcreditor end");
        if (EmptyUtil.isNoEmpty((Object)date)) {
            DataSet repaymentSlDs = TradeFinanceRptHelper.repaymentSlDs(this.getDataSetIds(slLoandDs).stream().collect(Collectors.toList()), DateUtils.getLastDay((Date)date, (int)1));
            slLoandDs = slLoandDs.leftJoin(repaymentSlDs).on("id", "loanbillid").on("creditor", "bankid").select(resultSet.getRowMeta().getFieldNames(), new String[]{"paidamount"}).finish().updateField("paidamount", "case when paidamount!=null then paidamount else 0 end").updateField("origccy_intamt", "(drawamount-paidamount)*origccy_intamt/principle").updateField("principle", "drawamount-paidamount").removeFields(new String[]{"paidamount"});
        }
        return resultSet.union(slLoandDs);
    }

    private DataSet dealBond(DataSet resultSet, DataSet bondDataSet, Date date) {
        if (bondDataSet == null || bondDataSet.isEmpty()) {
            return resultSet;
        }
        ArrayList bondIds = new ArrayList(16);
        bondDataSet.copy().forEach(o -> bondIds.add(o.getString("id")));
        bondDataSet = bondDataSet.leftJoin(resultSet.copy()).on("id", "id").select(new String[]{"investorname", "investorid", "investamount", "entryid"}, resultSet.getRowMeta().getFieldNames()).finish().filter("drawamount != null").addField("investamount", "investamount1");
        if (EmptyUtil.isNoEmpty((Object)date)) {
            DataSet repaymentBackDs = this.getRepaymentBackDs(bondIds.stream().map(Long::parseLong).collect(Collectors.toSet()), date);
            DataSet notBackDs = repaymentBackDs.filter("!isbuyback");
            DataSet backDs = repaymentBackDs.filter("isbuyback");
            if (!backDs.isEmpty()) {
                bondDataSet = bondDataSet.leftJoin(backDs).on("id", "loanbillid").on("entryid", "vid").select(bondDataSet.getRowMeta().getFieldNames(), new String[]{"vamount"}).finish().updateField("investamount", "case when vamount!=null then investamount-vamount else investamount end");
            }
            if (!notBackDs.isEmpty()) {
                DataSet bondSumDs = bondDataSet.groupBy(new String[]{"id"}).sum("investamount").finish();
                bondDataSet = bondDataSet.leftJoin(bondSumDs).on("id", "id").select(bondDataSet.getRowMeta().getFieldNames(), new String[]{"investamount sumamount"}).finish();
                bondDataSet = bondDataSet.leftJoin(notBackDs).on("id", "loanbillid").select(bondDataSet.getRowMeta().getFieldNames(), new String[]{"repayamount"}).finish().updateField("investamount", "case when repayamount!=null then investamount-investamount*repayamount/sumamount else investamount end");
            }
        }
        bondDataSet = bondDataSet.updateField("origccy_intamt", "(investamount/principle)*origccy_intamt").updateField(TEXTCREDITOR, "investorname").updateField("principle", "investamount").updateField("drawamount", "investamount1");
        resultSet = resultSet.filter("id not in (" + String.join((CharSequence)",", bondIds) + ")").union(bondDataSet.select(resultSet.getRowMeta().getFieldNames()));
        return resultSet;
    }

    private DataSet getRepaymentBackDs(Set<Long> bondIdSet, Date date) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("loans.e_loanbill", "in", bondIdSet).and("bizdate", "<", (Object)DateUtils.getDataFormat((Date)date, (boolean)true)).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        DataSet repaymentDS = QueryServiceHelper.queryDataSet((String)(TradeFinanceRptHelper.class.getName() + "_backrepayment"), (String)"cfm_repaymentbill", (String)"isbuyback,loans.e_loanbill as loanbillid,loans.e_repayamount repayamount,loans.buyback_entry.e_investentryid vid,loans.buyback_entry.e_buybackamt vamount", (QFilter[])qFilter.toArray(), null);
        repaymentDS = repaymentDS.groupBy(new String[]{"loanbillid", "vid", "isbuyback"}).sum("repayamount").sum("vamount").finish();
        return repaymentDS;
    }

    private DataSet callInterest(Map<String, Object> paramMap, DataSet loanBillDS) {
        Date beginDate = (Date)paramMap.get("filter_begindate");
        Date endDate = (Date)paramMap.get("filter_enddate");
        DataSetBuilder datasetBuilder = Algo.create((String)"intBill").createDataSetBuilder(this.getRowMeta());
        HashMap<Long, BigDecimal> loanBillIdMap = new HashMap<Long, BigDecimal>(10);
        for (Object loanBillRow : loanBillDS.copy()) {
            loanBillIdMap.put(loanBillRow.getLong("id"), loanBillRow.getBigDecimal("yearrate"));
        }
        List loanBillIdLists = ListUtils.splitList(new ArrayList(loanBillIdMap.keySet()), (long)100L);
        for (List loanBillIdList : loanBillIdLists) {
            List loanBills = InterestCalcHelper.getLoanBills((List)loanBillIdList);
            for (DynamicObject loanBill : loanBills) {
                IntBillExtInfo intBill;
                long loanBillId = loanBill.getLong("id");
                BigDecimal principle = InterestCalcHelper.getPrinciple((DynamicObject)loanBill, (Date)beginDate);
                if (EmptyUtil.isEmpty((BigDecimal)principle)) continue;
                BigDecimal yearrate = (BigDecimal)loanBillIdMap.get(loanBillId);
                try {
                    intBill = InterestCalcHelper.callInt((DynamicObject)loanBill, (Date)beginDate, (Date)DateUtils.getNextDay((Date)endDate, (int)1), (BigDecimal)principle);
                }
                catch (TmcBizException e) {
                    logger.error("\u8ba1\u7b97\u5229\u606f\u5931\u8d25: loanBillId={}, error: {}", (Object)loanBillId, (Object)e.getMessage());
                    continue;
                }
                if (!EmptyUtil.isNoEmpty((Object)intBill) || !EmptyUtil.isNoEmpty((Object)intBill.getDetails())) continue;
                Date intStartDate = intBill.getBeginDate();
                Date intEndDate = intBill.getEndDate();
                int interestDays = DateUtils.getDiffDays((Date)intStartDate, (Date)intEndDate);
                BigDecimal intAmt = intBill.getAmount();
                Object[] row = new Object[]{loanBillId, intStartDate, intEndDate, interestDays, intAmt, principle, yearrate, JSON.toJSONString((Object)intBill)};
                datasetBuilder.append(row);
            }
        }
        DataSet intBillSet = datasetBuilder.build();
        Boolean isDisplayZore = (Boolean)paramMap.get("filter_isplayzore");
        if (isDisplayZore != null && !isDisplayZore.booleanValue()) {
            intBillSet = intBillSet.filter("origccy_intamt <> 0");
        }
        return intBillSet;
    }

    private RowMeta getRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("begindate", (DataType)DataType.DateType));
        field.add(new Field("enddate", (DataType)DataType.DateType));
        field.add(new Field("interestdays", (DataType)DataType.IntegerType));
        field.add(new Field("origccy_intamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("principle", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearrate", (DataType)DataType.BigDecimalType));
        field.add(new Field("intdetail", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        return rowMeta;
    }

    private DataSet dealRateDS(DataSet loanRateDS, Map<String, Object> paramMap) {
        Date beginDate = (Date)paramMap.get("filter_begindate");
        DataSet dataSet = loanRateDS.copy().groupBy(new String[]{"id"}).min("loandate").finish();
        String s = "loandate";
        if (EmptyUtil.isNoEmpty((Object)beginDate)) {
            DataSet loanDS = loanRateDS.removeFields(new String[]{"loandate"});
            loanRateDS = loanDS.leftJoin(dataSet).on("id", "id").select(loanDS.getRowMeta().getFieldNames(), new String[]{"loandate"}).finish();
            DataSet lessDS = loanRateDS.copy().filter("to_char(loandate, 'yyyyMMdd') >= " + DateUtils.formatString((Date)beginDate, (String)"yyyyMMdd")).groupBy(new String[]{"id"}).min("effectdate").finish();
            DataSet largeDS = loanRateDS.copy().filter("to_char(loandate, 'yyyyMMdd') < " + DateUtils.formatString((Date)beginDate, (String)"yyyyMMdd")).filter("to_char(effectdate, 'yyyyMMdd') <= " + DateUtils.formatString((Date)beginDate, (String)"yyyyMMdd")).groupBy(new String[]{"id"}).max("effectdate").finish();
            dataSet = lessDS.union(largeDS);
            s = "effectdate";
        }
        dataSet = dataSet.leftJoin(loanRateDS).on("id", "id").on(s, "effectdate").select(loanRateDS.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }

    private DataSet getLoanRateDataSet(Set<Long> ids, Map<String, Object> paramMap) {
        QFilter filter = new QFilter("id", "in", ids);
        Date endDate = (Date)paramMap.get("filter_enddate");
        filter.and(new QFilter("rateadjust_entry.ra_effectdate", "<=", (Object)endDate));
        DataSet loanBalDS = QueryServiceHelper.queryDataSet((String)"loanBillRate", (String)"cfm_loanbill", (String)SELECT_LOANRATE_FIELDS, (QFilter[])filter.toArray(), null);
        return loanBalDS;
    }

    private DataSet getLoanBillDataSet(ReportQueryParam queryParam) {
        DataSet loanBillDS;
        QFilter qFilter = this.getQFilter(queryParam);
        Map paramMap = this.transQueryParam(queryParam);
        if ("ifm".equals(paramMap.get("isfrom"))) {
            DynamicObject settleCenter = (DynamicObject)paramMap.get("filter_settlecenter");
            qFilter.and(new QFilter("settlecenter.id", "=", settleCenter.getPkValue()));
            String selectFileds = "id, loancontractbill.number contractbillno, loancontractbill.contractno contractno, billno, org.id orgid, org.name org, currency, currency.name, finproduct.name finproduct,  creditor, textcreditor, startintdate, expiredate, drawamount, loantype,banksyndicate_entry.e_bank bankid, banksyndicate_entry.e_shareamount shareamount,banksyndicate_entry.e_bank.name creditorname, settlecenter.name settlecenter";
            loanBillDS = QueryServiceHelper.queryDataSet((String)"IFM_LoanBill", (String)"ifm_loanbill", (String)selectFileds, (QFilter[])qFilter.toArray(), null);
        } else if ("fl".equals(paramMap.get("isfrom"))) {
            qFilter.and(new QFilter("loantype", "=", (Object)LoanTypeEnum.FINLEASE.getValue()));
            loanBillDS = QueryServiceHelper.queryDataSet((String)"LoanBill", (String)"cfm_loanbill", (String)SELECT_LOAN_FIELDS, (QFilter[])qFilter.toArray(), null);
        } else {
            loanBillDS = QueryServiceHelper.queryDataSet((String)"LoanBill", (String)"cfm_loanbill", (String)SELECT_LOAN_FIELDS, (QFilter[])qFilter.toArray(), null);
        }
        return loanBillDS;
    }

    private DataSet getBondDataSet(Set<Long> bondIds, Map<String, Object> paramMap) {
        QFilter filter = new QFilter("id", "in", bondIds);
        filter.and(TradeFinanceRptHelper.getCreditorFilter(paramMap, "bond"));
        String selectFields = "id, loancontractbill.number contractbillno, loancontractbill.contractno contractno, billno, org.id orgid, org.name org, currency, currency.name, finproduct.name finproduct,  creditor, textcreditor, startintdate, expiredate, drawamount, loantype,banksyndicate_entry.e_bank bankid, banksyndicate_entry.e_shareamount shareamount,banksyndicate_entry.e_bank.name creditorname,investor_entry.id entryid, investor_entry.e_investorname investorname, investor_entry.e_investorid investorid, investor_entry.e_investamount investamount, investor_entry.e_investortype";
        return QueryServiceHelper.queryDataSet((String)"bond", (String)"cfm_loanbill_bond", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    private QFilter getQFilter(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        String loanBillIds = (String)paramMap.get("filter_loanbill");
        if (EmptyUtil.isEmpty((String)loanBillIds)) {
            filter.and(new QFilter("org.id", "in", (Object)this.getQueryOrgIds(queryParam)));
        } else {
            Set idSet = (Set)SerializationUtils.fromJsonString((String)loanBillIds, Set.class);
            filter = new QFilter("id", "in", (Object)idSet);
        }
        String dataSource = (String)paramMap.get("filter_datasource");
        Date endDate = (Date)paramMap.get("filter_enddate");
        filter.and(new QFilter("startintdate", "<=", (Object)endDate));
        filter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, filter);
        if (!EmptyUtil.isEmpty((String)dataSource)) {
            if (dataSource.contains("bond")) {
                String[] split = dataSource.split(",");
                CharSequence[] newSource = (String[])Arrays.stream(split).filter(o -> !o.equals("bond")).toArray(String[]::new);
                String join = String.join((CharSequence)",", newSource);
                QFilter noBondSourceFilter = this.getDataSourceFilter(join);
                QFilter bondSourceFilter = this.getDataSourceFilter("bond");
                filter = noBondSourceFilter != null ? filter.and(noBondSourceFilter.and(TradeFinanceRptHelper.getCreditorFilter(paramMap, "")).or(bondSourceFilter)) : filter.and(bondSourceFilter);
            } else {
                QFilter sourceFilter = this.getDataSourceFilter(dataSource);
                filter.and(TradeFinanceRptHelper.getCreditorFilter(paramMap, "")).and(sourceFilter);
            }
        }
        return filter;
    }

    private QFilter getDataSourceFilter(String dataSource) {
        QFilter qfilter = null;
        if (!EmptyUtil.isEmpty((String)dataSource)) {
            String[] split = dataSource.split(",");
            ArrayList<String> loanTypes = new ArrayList<String>(4);
            for (int i = 0; i < split.length; ++i) {
                String item = split[i];
                if (!EmptyUtil.isNotEmpty((CharSequence)item)) continue;
                if ("bankloan".equals(item)) {
                    loanTypes.add(LoanTypeEnum.BANKLOAN.getValue());
                    loanTypes.add(LoanTypeEnum.BANKSLOAN.getValue());
                    continue;
                }
                if ("entrustloan".equals(item)) {
                    loanTypes.add(LoanTypeEnum.ENTRUSTLOAN.getValue());
                    loanTypes.add(LoanTypeEnum.LINKLEND.getValue());
                    continue;
                }
                if ("bond".equals(item)) {
                    loanTypes.add(LoanTypeEnum.BOND.getValue());
                    continue;
                }
                if (!"fl".equals(item) && !"finlease".equals(item)) continue;
                loanTypes.add(LoanTypeEnum.FINLEASE.getValue());
            }
            if (loanTypes.size() > 0) {
                qfilter = new QFilter("loantype", "in", loanTypes);
            }
        }
        return qfilter;
    }

    private Set<Long> getBondIds(DataSet dataSet) {
        HashSet<Long> ids = new HashSet<Long>(16);
        dataSet.copy().forEach(o -> {
            if (BizTypeEnum.isBond((String)o.getString("loantype"))) {
                ids.add(o.getLong("id"));
            }
        });
        return ids;
    }

    private Set<Long> getDataSetIds(DataSet dataSet) {
        HashSet<Long> ids = new HashSet<Long>(16);
        dataSet.copy().forEach(o -> ids.add(o.getLong("id")));
        return ids;
    }

    public static DataSet createEmptyDs() {
        RowMeta rowMeta = new RowMeta(new String[]{"orgname"}, new DataType[]{DataType.StringType});
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }
}

