/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class LoanDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private TreeMap<String, String> sortDataSetMetaData = new TreeMap();
    private static String BASE_STR = "dynamicColumon_";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        paramMap.putAll(queryParam.getCustomParam());
        QFilter filter = ReportFilterParamHelper.initCfmReportFilterIncludeDrawType(paramMap, this.getQueryOrgIds(queryParam));
        String selectFields = "id,org as company,org.name as companyname,bizdate as oribizdate, TO_CHAR(bizdate,'yyyy-MM-dd') as bizdate,textcreditor,creditortype,creditor,currency,currency.name as currencyname, drawamount as totalamt";
        QFilter creditorFilter = TradeFinanceRptHelper.getCreditorFilter(paramMap, "");
        DataSet oriDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill", (String)selectFields, (QFilter[])new QFilter[]{filter, creditorFilter}, null).filter("totalamt !=null");
        if (oriDs.isEmpty()) {
            return Algo.create((String)"LoanDetailDataListPlugin.emptyDs").createDataSetBuilder(oriDs.getRowMeta()).build();
        }
        DynamicObject currency = (DynamicObject)paramMap.get("filter_statcurrency");
        long currencyID = currency.getLong("id");
        String currencyName = currency.getString("name");
        DataSet exchrateDS = this.getExChangeRateDs(oriDs, paramMap);
        exchrateDS = exchrateDS.select("rate as exchgRate, tarcurrency");
        RowMeta rowMeta = oriDs.getRowMeta();
        DataSet afterExchangeDs = oriDs.join(exchrateDS).on("currency", "tarcurrency").select(rowMeta.getFieldNames(), new String[]{"exchgRate"}).finish();
        afterExchangeDs = afterExchangeDs.select("id,company,companyname,oribizdate, bizdate,textcreditor,creditortype,creditor," + currencyID + " as currency,'" + currencyName + "' as currencyname,totalamt*exchgRate as totalamt");
        DataSet midDs = this.dealTextcreditor(afterExchangeDs);
        DataSet baseDs = midDs.groupBy(this.getGroupStr().split(",", -1)).sum("totalamt").finish().select(this.getGroupStr() + ",totalamt");
        DataSet copy = baseDs.copy();
        DataSet groupNameDs = copy.groupBy(new String[]{"textcreditor"}).finish().select("textcreditor");
        Iterator iterator = groupNameDs.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            this.sortDataSetMetaData.put(row.getString("textcreditor"), BASE_STR + i);
            ++i;
        }
        String divideFactor = (String)paramMap.get("filter_currencyunit");
        String sql = "select company,oribizdate, bizdate,currency," + this.buildSqlStr(this.sortDataSetMetaData, divideFactor, "textcreditor", "totalamt") + " sum(totalamt/" + divideFactor + ") as totalamt group by company,oribizdate,bizdate,currency order by company,bizdate";
        DataSet resultDs = baseDs.executeSql(sql);
        resultDs = resultDs.select("company,year(oribizdate) as entryyear,case when month(oribizdate) in (1,2,3) then 1 when month(oribizdate) in (4,5,6) then 2 when month(oribizdate) in (7,8,9) then 3 when month(oribizdate) in (10,11,12) then 4 else 0 end as entryseason,  month(oribizdate) as entrymonth, bizdate,currency," + String.join((CharSequence)",", this.sortDataSetMetaData.values()) + ",totalamt,'N' as rowflag");
        DataSet monthGroupDs = this.buildMonthSumDataSet(resultDs);
        DataSet seasonGroupDs = this.buildSeasonSumDataSet(monthGroupDs);
        DataSet yearGroupDs = this.buildYearSumDataSet(seasonGroupDs);
        return resultDs.union(monthGroupDs).union(seasonGroupDs).union(yearGroupDs).orderBy(new String[]{"company", "entryyear", "entryseason", "entrymonth"});
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        return bizDs;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        return bizDs;
    }

    private DataSet dealTextcreditor(DataSet dataSet) {
        HashSet<Long> set = new HashSet<Long>();
        String entity = "bd_finorginfo";
        String selectField = "id as creditor,case when finorgtype.type='0' then bank_cate.name else name end as creditorname";
        DataSet finOrgDs = this.generateKindDataSet(dataSet, entity, set, selectField);
        DataSet resultDs = dataSet.filter("creditortype !='bank' and creditortype !='finorg'").union(finOrgDs);
        return resultDs;
    }

    private DataSet generateKindDataSet(DataSet dataSet, String entity, Set<Long> set, String selectFields) {
        set.clear();
        DataSet filterDs = null;
        filterDs = "bd_finorginfo".equals(entity) ? dataSet.copy().filter("creditortype='bank' or creditortype='finorg'") : dataSet.copy().filter(String.format("creditortype='%s'", entity));
        if (filterDs.isEmpty()) {
            return Algo.create((String)"LoanDetailDataListPlugin.generateKindDataSet").createDataSetBuilder(filterDs.getRowMeta()).build();
        }
        DataSet copyDs = filterDs.copy();
        while (copyDs.hasNext()) {
            Row row = copyDs.next();
            set.add(row.getLong("creditor"));
        }
        QFilter qFilter = new QFilter("id", "in", set);
        DataSet entityDs = QueryServiceHelper.queryDataSet((String)"LoanDetailDataListPlugin.generateKindDataSet", (String)entity, (String)selectFields, (QFilter[])qFilter.toArray(), null);
        return filterDs.leftJoin(entityDs).on("creditor", "creditor").select(filterDs.getRowMeta().getFieldNames(), new String[]{"creditorname"}).finish().select("id,company,companyname,oribizdate, bizdate,case when creditorname !=null then creditorname else textcreditor end as textcreditor,creditortype,creditor,currency,currencyname,totalamt");
    }

    private DataSet buildMonthSumDataSet(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(this.buildMonthGroupStr().split(",", -1)).sum("totalamt");
        for (String next : this.sortDataSetMetaData.values()) {
            groupbyDataSet = groupbyDataSet.sum(next);
        }
        return groupbyDataSet.finish().select("company,entryyear,entryseason,entrymonth,CONCAT(CAST(entryyear as String),'" + this.getYear() + "', TO_CHAR(DATE(entryyear,entrymonth,1),'MM'),'" + this.getMonthStr() + "') as bizdate,currency," + String.join((CharSequence)",", this.sortDataSetMetaData.values()) + ",totalamt,'Y' as rowflag");
    }

    private DataSet buildSeasonSumDataSet(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(this.buildSeasonGroupStr().split(",", -1)).sum("totalamt");
        for (String next : this.sortDataSetMetaData.values()) {
            groupbyDataSet = groupbyDataSet.sum(next);
        }
        return groupbyDataSet.finish().select("company,entryyear,entryseason,99 as entrymonth,CONCAT(CAST(entryyear as String),'" + this.getYear() + "',CAST(entryseason as String),'" + this.getSeasonStr() + "') as bizdate,currency," + String.join((CharSequence)",", this.sortDataSetMetaData.values()) + ",totalamt,'Y' as rowflag");
    }

    private DataSet buildYearSumDataSet(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(this.buildYearGroupStr().split(",", -1)).sum("totalamt");
        for (String next : this.sortDataSetMetaData.values()) {
            groupbyDataSet = groupbyDataSet.sum(next);
        }
        return groupbyDataSet.finish().select("company,entryyear,9 as entryseason,99 as entrymonth,CONCAT(CAST(entryyear as String),'" + this.getYearStr() + "') as bizdate,currency," + String.join((CharSequence)",", this.sortDataSetMetaData.values()) + ",totalamt,'Y' as rowflag");
    }

    private String buildMonthGroupStr() {
        return "company,entryyear,entryseason,entrymonth,currency";
    }

    private String buildSeasonGroupStr() {
        return "company,entryyear,entryseason,currency";
    }

    private String buildYearGroupStr() {
        return "company,entryyear,currency";
    }

    private String getGroupStr() {
        return "company,oribizdate,bizdate,currency,textcreditor";
    }

    private String buildSqlStr(Map<String, String> map, String divideFactor, String baseStr, String amtStr) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("sum(case when ");
            sb.append(baseStr);
            sb.append("='");
            sb.append(entry.getKey());
            sb.append("' then ");
            sb.append(amtStr);
            sb.append('/');
            sb.append(divideFactor);
            sb.append(" else 0 end) as ");
            sb.append(entry.getValue());
            sb.append(',');
        }
        return sb.toString();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Set<String> keySet = this.sortDataSetMetaData.keySet();
        Iterator<String> ite = keySet.iterator();
        int i = 1;
        while (ite.hasNext()) {
            String key = ite.next();
            ReportColumn column = new ReportColumn();
            column.setFieldKey(BASE_STR + i);
            column.setFieldType("amount");
            column.setZeroShow(false);
            column.setCurrencyField("currency");
            column.setCaption(new LocaleString(key));
            columns.add((AbstractReportColumn)column);
            ++i;
        }
        return columns;
    }

    private String getMonthStr() {
        return ResManager.loadKDString((String)"\u6708\u5c0f\u8ba1", (String)"LoanDetailDataListPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getSeasonStr() {
        return ResManager.loadKDString((String)"\u5b63\u5ea6\u5c0f\u8ba1", (String)"LoanDetailDataListPlugin_2", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getYearStr() {
        return ResManager.loadKDString((String)"\u5e74\u5408\u8ba1", (String)"LoanDetailDataListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getYear() {
        return ResManager.loadKDString((String)"\u5e74", (String)"LoanDetailDataListPlugin_4", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }
}

