/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.QueryTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceFilterHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class PreIntDataListPlugin
extends AbstractTmcListDataPlugin {
    protected static final String PREINT_FORM_PROPS = "id,0 as sumlevel, id as preintid, '' as summarycol, 0 as findebtslevel,prestartdate, bizdate as preenddate, actpreinstamt as estinterestamt, writeoffamt as paidintamt, nowriteoffamt as unpaidintamt, loanbillno, contractbillno";
    protected static final String CFMLOANBILL_FORM_PROPS = "id as loanbillid, bizdate as drawdate, drawamount, expiredate, renewalexpiredate, repayamount as returnamt, billno as loanno";
    private static final String CFMCONTRACT_FORM_PROPS = "id as contractid,billno as contractnum,debtortype,debtor,textdebtor as fincompanyname,contractno, contractname, term as contractterm, currency as loancurrency, amount as contractamt, notrepayamount as unpaidamt, textcreditor as fincreditorname, latestrate as intrate,startinterestrate,referencerate.number as rrnumber,ratefloatpoint";
    protected static final String[] AMOUNT_SUM_FIELDS = new String[]{"estinterestamt_statccy", "paidintamt_statccy", "unpaidintamt_statccy"};

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        DataSet preIntBillDS = this.queryPreIntBillDS(paramMap);
        if (preIntBillDS.isEmpty()) {
            return TradeFinanceRptHelper.createEmptyDS();
        }
        HashSet<String> contractNumList = new HashSet<String>(10);
        HashSet<String> loanNumList = new HashSet<String>(10);
        preIntBillDS.copy().iterator().forEachRemaining(v -> {
            contractNumList.add(v.getString("contractbillno"));
            loanNumList.add(v.getString("loanbillno"));
        });
        preIntBillDS = this.unionLoanDS(preIntBillDS, paramMap, loanNumList);
        if (preIntBillDS.isEmpty()) {
            return TradeFinanceRptHelper.createEmptyDS();
        }
        preIntBillDS = this.unionContractDS(preIntBillDS, contractNumList);
        preIntBillDS = this.changeCurAndUnit(preIntBillDS, queryParam, paramMap);
        preIntBillDS = this.addSubAndAll(preIntBillDS, paramMap);
        return preIntBillDS;
    }

    private DataSet queryPreIntBillDS(Map<String, Object> paramMap) {
        Date precutoffdate = this.getCutOffDate(paramMap);
        QFilter preintBillQFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        preintBillQFilter.and(new QFilter("bizdate", "<=", (Object)precutoffdate));
        preintBillQFilter.and(new QFilter("operatetype", "=", (Object)"preint"));
        preintBillQFilter.and(ReportFilterParamHelper.initOrgOrViewFilter(paramMap));
        preintBillQFilter.and(TradeFinanceFilterHelper.initCurrencyFilter(paramMap));
        preintBillQFilter.and(TradeFinanceFilterHelper.initCriditorFilter(paramMap));
        preintBillQFilter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, preintBillQFilter);
        QFilter baseQFilter = new QFilter("loantype", "in", Arrays.asList("entrust", "ec"));
        QFilter filter = new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue()).and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        QFilter filter2 = new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue());
        filter.or(filter2);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_preinterestbill", (String)PREINT_FORM_PROPS, (QFilter[])new QFilter[]{preintBillQFilter, baseQFilter, filter}, null);
    }

    private DataSet unionLoanDS(DataSet preIntDS, Map<String, Object> paramMap, Set<String> loanNums) {
        QFilter qFilter = new QFilter("billno", "in", loanNums);
        Boolean includeClose = (Boolean)paramMap.get("filter_includecloseout");
        if (!includeClose.booleanValue()) {
            QFilter noCloseOffDate = new QFilter("closeoffdate", "=", null);
            Date cutOffDate = this.getCutOffDate(paramMap);
            QFilter lessThanCutOffDate = new QFilter("closeoffdate", "<=", (Object)cutOffDate).and(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue())).and(new QFilter("notrepayamount", ">", (Object)BigDecimal.ZERO));
            QFilter largeThanCutOffDate = new QFilter("closeoffdate", ">", (Object)cutOffDate);
            qFilter.and(lessThanCutOffDate.or(largeThanCutOffDate).or(noCloseOffDate));
        }
        DataSet cfmLoanBillDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_invest_loanbill", (String)CFMLOANBILL_FORM_PROPS, (QFilter[])qFilter.toArray(), null);
        return preIntDS.leftJoin(cfmLoanBillDS).on("loanbillno", "loanno").select(preIntDS.getRowMeta().getFieldNames(), cfmLoanBillDS.getRowMeta().getFieldNames()).finish().filter("loanbillid!=null and loanbillid!=0");
    }

    private DataSet unionContractDS(DataSet preIntDS, Set<String> contractNums) {
        QFilter qFilter = new QFilter("billno", "in", contractNums);
        DataSet cfmContractBillDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_invest_contract", (String)CFMCONTRACT_FORM_PROPS, (QFilter[])qFilter.toArray(), null);
        cfmContractBillDS = this.getContractRate(cfmContractBillDS);
        return preIntDS.leftJoin(cfmContractBillDS).on("contractbillno", "contractnum").select(preIntDS.getRowMeta().getFieldNames(), cfmContractBillDS.getRowMeta().getFieldNames()).finish();
    }

    private DataSet getContractRate(DataSet cfmContractBillDS) {
        Date now = new Date();
        HashSet<String> referNum = new HashSet<String>();
        for (Row param : cfmContractBillDS.copy()) {
            referNum.add(param.getString("rrnumber"));
        }
        Map referRateMap = new HashMap();
        if (EmptyUtil.isNoEmpty(referNum)) {
            referRateMap = MarketDataHelper.batchReferRate(referNum, (Date)now, (Date)now);
        }
        StringBuilder updateTemp = new StringBuilder("case when rrnumber is null then startinterestrate+ratefloatpoint/100 ");
        for (Map.Entry referRate : referRateMap.entrySet()) {
            String rrnumber = (String)referRate.getKey();
            Map refermap = (Map)referRate.getValue();
            BigDecimal rrvalue = (BigDecimal)((Map.Entry)refermap.entrySet().stream().findFirst().get()).getValue();
            updateTemp.append("when rrnumber='").append(rrnumber).append("' then ").append(rrvalue).append("+ratefloatpoint/100 ");
        }
        updateTemp.append(" else startinterestrate+ratefloatpoint/100 end");
        return cfmContractBillDS.updateField("intrate", updateTemp.toString()).select(cfmContractBillDS.getRowMeta().getFieldNames());
    }

    private DataSet changeCurAndUnit(DataSet preIntBillDS, ReportQueryParam queryParam, Map<String, Object> paramMap) {
        String currencyUnit = (String)paramMap.get("filter_currencyunit");
        Date precutoffdate = this.getCutOffDate(paramMap);
        DynamicObject statCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        Long statCurrencyID = statCurrency.getLong("id");
        precutoffdate = DateUtils.truncateDate((Date)(precutoffdate == null ? DateUtils.getCurrentDate() : precutoffdate));
        Long orgRootId = Long.parseLong(queryParam.getCustomParam().get("orgid").toString());
        ArrayList currencyIdList = new ArrayList(10);
        preIntBillDS.copy().iterator().forEachRemaining(v -> {
            if (EmptyUtil.isNoEmpty((Long)v.getLong("loancurrency"))) {
                currencyIdList.add(v.getLong("loancurrency"));
            }
        });
        String queryType = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        DataSet exchrateDS = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)statCurrencyID, (long)orgRootId, (Date)precutoffdate, (!QueryTypeEnum.isCompview((String)queryType) ? 1 : 0) != 0);
        RowMeta rowMeta = preIntBillDS.getRowMeta();
        preIntBillDS = preIntBillDS.leftJoin(exchrateDS).on("loancurrency", "tarcurrency").select(rowMeta.getFieldNames(), new String[]{"rate"}).finish();
        return preIntBillDS.addField(String.format("%s*rate/%s", "estinterestamt", currencyUnit), "estinterestamt_statccy").addField(String.format("%s*rate/%s", "paidintamt", currencyUnit), "paidintamt_statccy").addField(String.format("%s*rate/%s", "unpaidintamt", currencyUnit), "unpaidintamt_statccy").updateField("estinterestamt", String.format("%s/%s", "estinterestamt", currencyUnit)).updateField("paidintamt", String.format("%s/%s", "paidintamt", currencyUnit)).updateField("unpaidintamt", String.format("%s/%s", "unpaidintamt", currencyUnit)).updateField("returnamt", String.format("%s/%s", "returnamt", currencyUnit)).updateField("drawamount", String.format("%s/%s", "drawamount", currencyUnit)).updateField("contractamt", String.format("%s/%s", "contractamt", currencyUnit)).updateField("unpaidamt", String.format("%s/%s", "unpaidamt", currencyUnit));
    }

    private DataSet addSubAndAll(DataSet preIntBillDS, Map<String, Object> paramMap) {
        String statdim = (String)paramMap.get("filter_statdim");
        DynamicObject statCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        Long statCurrencyID = statCurrency.getLong("id");
        List<String> groupFields = this.getGroupFieldByDim(statdim);
        ArrayList<String> orderbys = new ArrayList<String>(5);
        orderbys.addAll(groupFields);
        orderbys.add("contractid");
        orderbys.add("loanbillno");
        orderbys.add("prestartdate");
        preIntBillDS = preIntBillDS.orderBy(orderbys.toArray(new String[0]));
        return preIntBillDS.addField(statCurrencyID.toString(), "statcurrency");
    }

    protected List<String> getGroupFieldByDim(String statdim) {
        String[] groupFields = statdim.split(",");
        return Arrays.asList(groupFields);
    }

    private Date getCutOffDate(Map<String, Object> paramMap) {
        String cutOffDateRange = (String)paramMap.get("filter_querycutoffdate");
        Date currentDate = DateUtils.getCurrentDate();
        Date cutOffDate = null;
        switch (cutOffDateRange) {
            case "thisday": {
                cutOffDate = currentDate;
                break;
            }
            case "lastday": {
                cutOffDate = DateUtils.getLastDay((Date)currentDate, (int)1);
                break;
            }
            case "lastweek": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfWeek((Date)currentDate), (int)1);
                break;
            }
            case "lastmonth": {
                cutOffDate = DateUtils.getLastDateOfAnyMonth((Date)currentDate, (int)-1);
                break;
            }
            case "lastyear": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfCurYear(), (int)1);
                break;
            }
            case "custom": {
                cutOffDate = (Date)paramMap.get("filter_precutoffdate");
                break;
            }
        }
        return cutOffDate;
    }
}

