/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class CfmLoanBillIntCalcFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String LOANBILL_KEY = "filter_loanbill";
    private static final String FILTER_REPORTCURRENCY = "filter_reportcurrency";
    private static final String FILTER_LENDERNATURE = "filter_lendernature";
    private static final String FILTER_DATASOURCE = "filter_datasource";
    private static final String FILTER_SETTLECENTER = "filter_settlecenter";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{LOANBILL_KEY});
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit settleCenter = (BasedataEdit)this.getControl(FILTER_SETTLECENTER);
        if (EmptyUtil.isNoEmpty((Object)settleCenter)) {
            settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (FILTER_SETTLECENTER.equals(evt.getProperty().getName())) {
            QFilter filter = new QFilter("id", "in", this.getAuthorizedBankCenterIds());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void beforeBindData(EventObject e) {
        if (this.isBdim()) {
            this.getView().getModel().setValue(FILTER_LENDERNATURE, (Object)"outgroup");
            this.getView().getModel().setValue(FILTER_DATASOURCE, (Object)"bond");
            this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_LENDERNATURE, FILTER_DATASOURCE});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (property) {
            case "filter_loanbill": {
                if (!EmptyUtil.isEmpty((Object)newValue) || !this.getPageCache().getAll().containsKey(LOANBILL_KEY)) break;
                this.getPageCache().remove(LOANBILL_KEY);
                break;
            }
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                if (!EmptyUtil.isNoEmpty((Object)newValue)) break;
                rptFilter.search();
                break;
            }
            case "filter_queryway": 
            case "filter_org": 
            case "filter_orgview": {
                this.getModel().setValue(LOANBILL_KEY, null);
            }
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        long orgId = TmcOrgDataHelper.getCurrentOrgId();
        if (EmptyUtil.isNoEmpty((Long)orgId)) {
            DynamicObject baseCurrency = TmcBusinessBaseHelper.getCasBaseCurrency((long)orgId);
            if (baseCurrency == null) {
                baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)orgId);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) {
                this.getModel().setValue("filter_statcurrency", baseCurrency.getPkValue());
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String lenderNature = (String)this.getModel().getValue(FILTER_LENDERNATURE);
        queryParam.getFilter().addFilterItem(FILTER_LENDERNATURE, (Object)lenderNature);
        String dataSource = (String)this.getModel().getValue(FILTER_DATASOURCE);
        queryParam.getFilter().addFilterItem(FILTER_DATASOURCE, (Object)dataSource);
        String statdim = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        DynamicObject reportCurrency = (DynamicObject)this.getModel().getValue(FILTER_REPORTCURRENCY);
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)reportCurrency);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        queryParam.getFilter().addFilterItem("isfrom", customParams.get("isfrom"));
        this.initQueryColumn(statdim);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("bdim".equals(appId)) {
            queryParam.getFilter().addFilterItem("filter_isshowsubtotal", (Object)Boolean.TRUE);
            queryParam.getFilter().addFilterItem("filter_isshowtotal", (Object)Boolean.TRUE);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (this.getPageCache().getAll().containsKey(LOANBILL_KEY) && EmptyUtil.isNoEmpty((String)this.getPageCache().get(LOANBILL_KEY))) {
            queryParam.getFilter().addFilterItem(LOANBILL_KEY, (Object)this.getPageCache().get(LOANBILL_KEY));
        }
        return this.verifyQuery();
    }

    private boolean verifyQuery() {
        DynamicObject settleCenter;
        DynamicObject currency = (DynamicObject)this.getModel().getValue(FILTER_REPORTCURRENCY);
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfmLoanBillIntCalcFormPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        Date startDate = (Date)this.getModel().getValue("filter_begindate");
        Date endDate = (Date)this.getModel().getValue("filter_enddate");
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u606f\u7ed3\u675f\u65e5\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfmLoanBillIntCalcFormPlugin_2", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        if (startDate != null && endDate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u606f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8ba1\u606f\u5f00\u59cb\u65e5\u671f\u3002", (String)"CfmLoanBillIntCalcFormPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        if (this.isCfm()) {
            String lenderNature = (String)this.getModel().getValue(FILTER_LENDERNATURE);
            if (EmptyUtil.isEmpty((String)lenderNature)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u503a\u6743\u4eba\u6027\u8d28\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfmLoanBillIntCalcFormPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]));
                return false;
            }
            String dataSource = (String)this.getModel().getValue(FILTER_DATASOURCE);
            if (EmptyUtil.isEmpty((String)dataSource)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfmLoanBillIntCalcFormPlugin_6", (String)"tmc-cfm-report", (Object[])new Object[0]));
                return false;
            }
        }
        if (this.isIfm() && EmptyUtil.isEmpty((DynamicObject)(settleCenter = (DynamicObject)this.getModel().getValue(FILTER_SETTLECENTER)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfmLoanBillIntCalcFormPlugin_7", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            DynamicObject settleCenter;
            DynamicObject orgView;
            String queryWay = (String)this.getModel().getValue("filter_queryway");
            if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay) && EmptyUtil.isEmpty((DynamicObject)(orgView = (DynamicObject)this.getModel().getValue("filter_orgview")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CfmLoanBillIntCalcFormPlugin_4", (String)"tmc-cfm-report", (Object[])new Object[0]));
                return;
            }
            if (this.isIfm() && (settleCenter = (DynamicObject)this.getModel().getValue(FILTER_SETTLECENTER)) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfmLoanBillIntCalcFormPlugin_7", (String)"tmc-cfm-report", (Object[])new Object[0]));
                return;
            }
            TextEdit text = (TextEdit)evt.getSource();
            if (LOANBILL_KEY.equals(text.getKey())) {
                this.showLoanBillF7();
            }
        }
    }

    private void showLoanBillF7() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        List<Long> orgIds = this.getOrgIds();
        if (EmptyUtil.isNoEmpty(orgIds)) {
            filter.and(new QFilter("org.id", "in", orgIds));
        } else {
            filter.and(new QFilter("org.id", "=", (Object)-1L));
        }
        String dataSource = (String)this.getModel().getValue(FILTER_DATASOURCE);
        filter = ReportFilterParamHelper.getDataSourceFilter(dataSource, filter);
        String formId = "cfm_loanbill";
        if (this.isBdim()) {
            formId = "cfm_loanbill_bond";
        } else if (this.isIfm()) {
            DynamicObject settleCenter = (DynamicObject)this.getModel().getValue(FILTER_SETTLECENTER);
            filter.and(new QFilter("settlecenter.id", "=", (Object)settleCenter.getLong("id")));
            formId = "ifm_loanbill";
        } else if (this.isFl(dataSource)) {
            formId = "fl_receiptbill";
        }
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)0, (boolean)true);
        parameter.getListFilterParameter().getQFilters().add(filter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LOANBILL_KEY));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)evt.getReturnData();
        if (LOANBILL_KEY.equals(evt.getActionId()) && EmptyUtil.isNoEmpty((Object)evt.getReturnData())) {
            List billIds = selectedRow.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
            this.getPageCache().put(LOANBILL_KEY, SerializationUtils.toJsonString(billIds));
            List billnos = selectedRow.stream().map(row -> row.getBillNo()).collect(Collectors.toList());
            String billno = StringUtils.join(billnos, (String)";");
            this.getModel().setValue(LOANBILL_KEY, (Object)billno);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String intDetail = (String)evt.getRowData().get("intdetail");
        if ("origccy_intamt".equals(evt.getFieldName()) && EmptyUtil.isNoEmpty((String)intDetail)) {
            DynamicObject currency = (DynamicObject)evt.getRowData().get("src_currency");
            String billno = (String)evt.getRowData().get("billno");
            this.showIntDetailForm(intDetail, billno, currency.getPkValue());
        } else if ("contractbillno".equals(evt.getFieldName())) {
            ReportCommonHelper.showContractbill(rowData, this.getView());
        }
    }

    private void initQueryColumn(String statdim) {
        String[] feilds = new String[]{"org", "textcreditor"};
        if ("textcreditor".equals(statdim)) {
            feilds = new String[]{"textcreditor", "org"};
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        this.rebuildColumn(feilds, listTable);
    }

    private void rebuildColumn(String[] feilds, ReportList listTable) {
        List columns = listTable.getColumns();
        ArrayList<Object> newColumns = new ArrayList<Object>(2);
        ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>(columns.size());
        for (int i = 0; i < feilds.length; ++i) {
            String field = feilds[i].trim();
            rebuildColumns.clear();
            for (AbstractReportColumn column : columns) {
                if (column instanceof ReportColumn) {
                    ReportColumn col = (ReportColumn)column;
                    if (col.getFieldKey().equalsIgnoreCase(field)) {
                        newColumns.add(col);
                        continue;
                    }
                    if (col.getFieldKey().equals("org") || col.getFieldKey().equals("textcreditor")) continue;
                    rebuildColumns.add(column);
                    continue;
                }
                rebuildColumns.add(column);
            }
        }
        newColumns.addAll(rebuildColumns);
        columns.clear();
        columns.addAll(newColumns);
    }

    private void showIntDetailForm(String detail, String billno, Object currencyId) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject loanBill = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
            parameter.getCustomParams().put("intdetail", detail);
            parameter.getCustomParams().put("loanbillid", loanBill.getLong("id"));
            parameter.getCustomParams().put("currency", currencyId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId("ifm_intbill_detail");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    private List<Long> getOrgIds() {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        List<Object> orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = parameter.getFormId();
        String appId = parameter.getAppId();
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = this.getOrgPropValues();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = this.getOrgPropValues();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
        }
        return orgIds;
    }

    private List<Long> getOrgPropValues() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgs)) {
            return Collections.EMPTY_LIST;
        }
        return orgs.stream().map(v -> (Long)v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
    }

    private boolean isCfm() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object isfrom = customParams.get("isfrom");
        return EmptyUtil.isNoEmpty(isfrom) && "cfm".equals(isfrom.toString());
    }

    private boolean isBdim() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object isfrom = customParams.get("isfrom");
        return EmptyUtil.isNoEmpty(isfrom) && "bdim".equals(isfrom.toString());
    }

    private boolean isIfm() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object isfrom = customParams.get("isfrom");
        return EmptyUtil.isNoEmpty(isfrom) && "ifm".equals(isfrom.toString());
    }

    private boolean isFl(String dataSource) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object isfrom = customParams.get("isfrom");
        return EmptyUtil.isNoEmpty(isfrom) && "fl".equals(isfrom.toString()) || "fl".equals(dataSource.replaceAll(",", ""));
    }

    private Set<Long> getAuthorizedBankCenterIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isNoEmpty((String)appId)) {
            return SettleCenterHelper.hasPermissionSettleCenter((String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        }
        return Collections.emptySet();
    }
}

