/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.report.form.TradeFinanceFromListPlugin;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class EnterpriseLoanFromListPlugin
extends TradeFinanceFromListPlugin {
    @Override
    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"filter_creditor"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        this.getView().setVisible(Boolean.valueOf("custom".equals(queryCutOffDate)), new String[]{"filter_cutoffdate"});
    }

    @Override
    protected void setCreditorTypeComboItem(boolean inGroup) {
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        queryParam.getFilter().addFilterItem("filter_currencyunit", (Object)currencyUnit);
        this.initQueryColumn(statdim);
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<String> columnKeys = new ArrayList<String>(columns.size());
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn = (ReportColumn)column;
            columnKeys.add(reportColumn.getFieldKey());
        }
        queryParam.getCustomParam().put("columnkeys", String.join((CharSequence)",", columnKeys));
        queryParam.getCustomParam().put("appid", this.getView().getFormShowParameter().getAppId());
        super.beforeQuery(queryParam);
    }

    private void initQueryColumn(String statdim) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(columns.size());
        String[] dimFields = statdim.split(",");
        for (String dim : dimFields) {
            for (AbstractReportColumn column : columns) {
                ReportColumn reportColumn;
                if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().equals(dim)) continue;
                rebuildColumns.add(reportColumn);
            }
        }
        for (AbstractReportColumn column : columns) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("loanbillno".equals(evt.getFieldName())) {
            int rowIdx = evt.getRowIndex();
            ReportList reportList = (ReportList)evt.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIdx);
            BillShowParameter sp = new BillShowParameter();
            Long loanBillId = (Long)rowData.get("loanbillid");
            DynamicObject billData = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)"loantype");
            String loanType = billData.getString("loantype");
            String formId = "cfm_loanbill";
            if (BizTypeEnum.ENTRUST.getValue().equals(loanType) || BizTypeEnum.EC.getValue().equals(loanType)) {
                formId = "cim_invest_loanbill";
            }
            sp.setPkId((Object)loanBillId);
            sp.setStatus(OperationStatus.VIEW);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            sp.setFormId(formId);
            this.getView().showForm((FormShowParameter)sp);
        }
    }

    @Override
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        String filters;
        IReportView view = this.getView();
        ReportShowParameter formShowParameter = (ReportShowParameter)view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String filtersTrackDetail = (String)customParams.get("filtersTrackDetail");
        if (EmptyUtil.isNoEmpty((String)filtersTrackDetail)) {
            Map param = (Map)SerializationUtils.deSerializeFromBase64((String)filtersTrackDetail);
            IDataModel model = this.getModel();
            block14: for (Map.Entry entry : param.entrySet()) {
                String propName = (String)entry.getKey();
                Object value = entry.getValue();
                switch (propName) {
                    case "filter_lendernature": {
                        model.setValue(propName, value);
                        continue block14;
                    }
                    case "filter_creditortype": {
                        model.setValue(propName, value);
                        view.updateView("filter_creditor");
                        continue block14;
                    }
                }
                model.setValue(propName, value);
            }
        }
        if (EmptyUtil.isEmpty((String)(filters = (String)customParams.get("filters")))) {
            super.reSearch();
            return;
        }
        Map param = (Map)SerializationUtils.deSerializeFromBase64((String)filters);
        IDataModel model = this.getModel();
        block15: for (Map.Entry entry : param.entrySet()) {
            String propName = (String)entry.getKey();
            Object value = entry.getValue();
            switch (propName) {
                case "filter_creditortype": {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, value);
                    continue block15;
                }
            }
            model.setValue(propName, value);
        }
        super.reSearch();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object newValue = valSet[0].getNewValue();
        switch (propName) {
            case "filter_statdim": {
                this.reSearch();
                break;
            }
            case "filter_creditortype": {
                if (newValue.equals(CreditorTypeEnum.CUSTOM.getValue()) || newValue.equals(CreditorTypeEnum.OTHER.getValue())) {
                    this.getModel().setValue("filter_lendernature", (Object)"outgroup");
                } else {
                    this.getModel().setValue("filter_lendernature", (Object)"ingroup");
                }
                this.getModel().setValue("filter_creditor", null);
                this.getModel().setValue("filter_creditorid", null);
                break;
            }
            case "filter_creditor": {
                this.getModel().setValue("filter_creditorid", null);
                break;
            }
            case "filter_settlecenter": {
                this.setCreditor();
                break;
            }
            case "filter_querycutoffdate": {
                this.getView().setVisible(Boolean.valueOf("custom".equals(newValue)), new String[]{"filter_cutoffdate"});
                break;
            }
        }
    }
}

