/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.tmc.cfm.common.enums.QueryTypeEnum;
import kd.tmc.cfm.report.form.TradeFinanceBaseFormListPlugin;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreIntFromListPlugin
extends TradeFinanceBaseFormListPlugin
implements HyperLinkClickListener {
    private static final String[] MERGECOLUMCONTRACT = new String[]{"contractid", "fincompanyname", "fincreditorname", "contractno", "contractname", "contractterm", "loancurrency", "contractamt", "unpaidamt", "intrate"};
    private static final String[] MERGECOLUMLOAN = new String[]{"loanbillno", "loanbillid", "drawamount", "drawdate", "expiredate", "renewalexpiredate", "returnamt"};
    private static final Long DEFAULTORGVIEWID = 8L;

    public void setMergeColums(List<String> columns) {
        columns.addAll(Arrays.asList(MERGECOLUMCONTRACT));
        columns.addAll(Arrays.asList(MERGECOLUMLOAN));
        super.setMergeColums(columns);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_org"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"filter_orgview"});
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"filter_orgview"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filter_org"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_orgview"});
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"filter_org"});
        }
        TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"filter_creditortype", "filter_creditor"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_creditortype", "filter_creditor"});
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        if (!"custom".equals(queryCutOffDate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_precutoffdate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_precutoffdate"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (propName) {
            case "filter_querycutoffdate": {
                if (!"custom".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_precutoffdate"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_precutoffdate"});
                break;
            }
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        ReportColumn c = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = c.getFieldKey();
        if (fieldKey.equals("contractid")) {
            this.mergeCol(packageDataEvent, Arrays.asList(MERGECOLUMCONTRACT), "contract_prevalue");
        }
        if (fieldKey.equals("loanbillid")) {
            this.mergeCol(packageDataEvent, Arrays.asList(MERGECOLUMLOAN), "loan_prevalue");
        }
        super.packageData(packageDataEvent);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String orgRootId;
        String statdim = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        queryParam.getFilter().addFilterItem("filter_currencyunit", (Object)currencyUnit);
        this.initQueryColumn(statdim, queryParam);
        queryParam.getFilter().addFilterItem("filter_org_id", this.getQueryOrgIds(queryParam));
        String queryType = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        if (QueryTypeEnum.isCompview((String)queryType)) {
            DynamicObject companyView = (DynamicObject)queryParam.getFilter().getFilterItem("filter_orgview").getValue();
            String companyViewNum = companyView.getString("number");
            orgRootId = TradeFinanceRptHelper.getOrgRootId(companyViewNum);
        } else {
            orgRootId = String.valueOf(RequestContext.get().getOrgId());
        }
        queryParam.getCustomParam().put("orgid", orgRootId);
        super.beforeQuery(queryParam);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        Date cutoffDate = (Date)this.getModel().getValue("filter_precutoffdate");
        if (EmptyUtil.isEmpty((String)queryCutOffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u63d0\u622a\u6b62\u65e5\u671f\u3002", (String)"PreIntFromListPlugin_0", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)cutoffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81ea\u5b9a\u4e49\u9884\u63d0\u622a\u6b62\u65e5\u671f\u3002", (String)"PreIntFromListPlugin_6", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        String lendernature = (String)this.getModel().getValue("filter_lendernature");
        if (EmptyUtil.isEmpty((String)lendernature)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u503a\u6743\u4eba\u6027\u8d28\u3002", (String)"PreIntFromListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        if (!lendernature.contains("outgroup") || !lendernature.contains("ingroup")) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_creditortype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u503a\u6743\u4eba\u7c7b\u578b\u3002", (String)"PreIntFromListPlugin_4", (String)"tmc-cfm-report", (Object[])new Object[0]));
                return false;
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_creditor")) && EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_creditorid"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u503a\u6743\u4eba\u3002", (String)"PreIntFromListPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]));
                return false;
            }
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd\u3002", (String)"PreIntFromListPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void initQueryColumn(String statdim, ReportQueryParam param) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(columns.size());
        String[] dimFields = statdim.split(",");
        for (String dim : dimFields) {
            for (AbstractReportColumn column : columns) {
                ReportColumn reportColumn;
                if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().equals(dim)) continue;
                rebuildColumns.add(reportColumn);
            }
        }
        for (AbstractReportColumn column : columns) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("loanbillno".equals(evt.getFieldName())) {
            int rowIdx = evt.getRowIndex();
            ReportList reportList = (ReportList)evt.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIdx);
            BillShowParameter sp = new BillShowParameter();
            Long loanBillId = (Long)rowData.get("loanbillid");
            String formId = "cim_invest_loanbill";
            sp.setFormId(formId);
            sp.setPkId((Object)loanBillId);
            sp.setStatus(OperationStatus.VIEW);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)sp);
        }
    }

    private void mergeCol(PackageDataEvent packageDataEvent, List mergeCol, String cache) {
        if (EmptyUtil.isEmpty((Object)packageDataEvent.getFormatValue())) {
            packageDataEvent.getNoMergeKey().addAll(mergeCol);
            return;
        }
        String s = packageDataEvent.getFormatValue().toString();
        String condition_prevalue = this.getPageCache().get(cache);
        if (condition_prevalue != null && !condition_prevalue.isEmpty() && !condition_prevalue.equals(s)) {
            packageDataEvent.getNoMergeKey().addAll(mergeCol);
        }
        this.getPageCache().put(cache, s);
    }

    public List<Long> getQueryOrgIds(ReportQueryParam queryParam) {
        return this.getQueryOrgIds(queryParam, "filter_org", "filter_orgview");
    }

    public List<Long> getQueryOrgIds(ReportQueryParam queryParam, String orgField, String orgViewField) {
        List orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)queryParam.getCustomParam().get("formid");
        String appId = (String)queryParam.getCustomParam().get("appid");
        String queryWay = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem(orgViewField).getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
            if (queryParam.getFilter().containProp("filter_isincludelower") && ((Boolean)queryParam.getFilter().getFilterItem("filter_isincludelower").getValue()).booleanValue()) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)DEFAULTORGVIEWID, orgIds, (boolean)true);
            }
        }
        return orgIds;
    }
}

