/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String billno = rowData.getString("billno");
        if (evt.getFieldName().equals("billno")) {
            if (EmptyUtil.isNotEmpty((CharSequence)billno)) {
                DynamicObjectCollection loanBill = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,billno,loantype", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
                if (!loanBill.isEmpty()) {
                    String loanBillID = ((DynamicObject)loanBill.get(0)).getString("id");
                    IReportView view = this.getView();
                    BaseShowParameter parameter = new BaseShowParameter();
                    parameter.setPkId((Object)loanBillID);
                    parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    String showFormId = this.getShowFormId(((DynamicObject)loanBill.get(0)).getString("loantype"));
                    parameter.setFormId(showFormId);
                    view.showForm((FormShowParameter)parameter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RepaymentFormListPlugin_20", (String)"tmc-cfm-report", (Object[])new Object[0]));
            }
        } else if (evt.getFieldName().equals("contractbillno")) {
            ReportCommonHelper.showContractbill(rowData, this.getView());
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if ("homelink".equals(customParams.get("showtype"))) {
            this.getModel().setValue("filter_statcurrency", customParams.get("filter_currency"));
        }
        this.initQueryParam();
        this.initSkipQueryParam();
    }

    private void initQueryParam() {
        String statdim;
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (EmptyUtil.isEmpty(customParams.get("filter"))) {
            return;
        }
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)customParams.get("filter").toString());
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        switch (statdim = (String)paramMap.get("statdim")) {
            case "companycny": {
                this.getModel().setValue("filter_statdim", (Object)"company");
                break;
            }
            case "creditorcny": {
                this.getModel().setValue("filter_statdim", (Object)"finorginfo");
                break;
            }
            case "finprocreditorcny": {
                this.getModel().setValue("filter_statdim", (Object)"finproductfinorginfo");
                break;
            }
            case "finprocreditorcompcny": {
                this.getModel().setValue("filter_statdim", (Object)"finproductfinorgcomp");
                break;
            }
        }
        List filterItems = queryParam.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo filterItem = (FilterItemInfo)filterItems.get(i);
            String propName = filterItem.getPropName();
            Object value = filterItem.getValue();
            if ((propName.equals("repaydateranges") || propName.equals("bizdateranges")) && null != value) {
                String controlName = propName.equals("repaydateranges") ? "definedrepaydate" : "definebizdate";
                this.getView().setVisible(Boolean.valueOf(RptDateRangeEnum.CUSTOM.getValue().equals(value.toString())), new String[]{controlName});
                this.getModel().setValue(propName, value);
            }
            if (propName.startsWith("repaydateranges_") || propName.startsWith("bizdateranges_") || "filter_statcurrency".equals(propName)) {
                this.getModel().setValue(propName, value);
            }
            if (this.getView().getControl(propName) == null) continue;
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection objs = (DynamicObjectCollection)value;
                ArrayList ids = new ArrayList();
                objs.forEach(v -> ids.add(v.getPkValue()));
                this.getModel().setValue(propName, (Object)ids.toArray(new Object[ids.size()]));
                continue;
            }
            if (value instanceof List) {
                this.getModel().setValue(propName, (Object)((List)value).toArray());
                continue;
            }
            this.getModel().setValue(propName, value);
        }
        this.getView().updateView("reportfilterap");
        this.getView().updateView("flexpanelap");
        this.setDefinedDateRangeVisible();
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    public void beforeQuery(ReportQueryParam param) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Map commFilters = null;
        if (!EmptyUtil.isEmpty(customParams.get("commFilters"))) {
            commFilters = (Map)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("commFilters")));
        }
        if (null != commFilters) {
            param.getFilter().setCommFilter(commFilters);
        }
        FilterInfo filter = param.getFilter();
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("statdim", (Object)statdim);
        this.initQueryColumn(statdim);
        if ("bdim_repaymentwarnrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            param.getCustomParam().put("isloanbillbondonly", true);
        }
        if ("fl_repaymentwarnrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            param.getCustomParam().put("isloanbillflonly", true);
        }
        if ("homelink".equals(customParams.get("showtype"))) {
            param.getFilter().addFilterItem("accountbank", customParams.get("accountbank"));
        }
        super.beforeQuery(param);
    }

    private void initQueryColumn(String statdim) {
        String[] fields = null;
        String currency = ResManager.loadKDString((String)"\u501f\u6b3e\u5e01\u79cd", (String)"RepaymentFormListPlugin_7", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String bizDate = ResManager.loadKDString((String)"\u653e\u6b3e\u65e5\u671f", (String)"RepaymentFormListPlugin_10", (String)"tmc-cfm-report", (Object[])new Object[0]);
        if ("bdim_repaymentwarnrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            currency = ResManager.loadKDString((String)"\u53d1\u884c\u5e01\u79cd", (String)"RepaymentFormListPlugin_24", (String)"tmc-cfm-report", (Object[])new Object[0]);
            bizDate = ResManager.loadKDString((String)"\u53d1\u884c\u65e5\u671f", (String)"RepaymentFormListPlugin_25", (String)"tmc-cfm-report", (Object[])new Object[0]);
        }
        String finproduct = ResManager.loadKDString((String)"\u503a\u5238\u7c7b\u578b", (String)"RepaymentFormListPlugin_0", (String)"tmc-cfm-report", (Object[])new Object[0]);
        if (!"bdim_repaymentwarnrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            finproduct = ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"RepaymentFormListPlugin_33", (String)"tmc-cfm-report", (Object[])new Object[0]);
        }
        String finorginfo = ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"RepaymentFormListPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String creditorId = ResManager.loadKDString((String)"\u503a\u6743\u4ebaID", (String)"RepaymentFormListPlugin_46", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String paymenttype = ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b", (String)"RepaymentFormListPlugin_2", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String exrepaydate = ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8\u6b3e\u65e5\u671f", (String)"RepaymentFormListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String cny_original = ResManager.loadKDString((String)"\u4e1a\u52a1\u5e01\u79cd", (String)"RepaymentFormListPlugin_23", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String examount_original = ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8\u6b3e\u91d1\u989d(\u539f\u5e01)", (String)"RepaymentFormListPlugin_4", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String examount = ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8\u6b3e\u91d1\u989d(\u7edf\u8ba1\u5e01)", (String)"RepaymentFormListPlugin_22", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String notrepayamt_original = ResManager.loadKDString((String)"\u672a\u8fd8\u672c\u91d1(\u539f\u5e01)", (String)"RepaymentFormListPlugin_30", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String notrepayamt = ResManager.loadKDString((String)"\u672a\u8fd8\u672c\u91d1(\u7edf\u8ba1\u5e01)", (String)"RepaymentFormListPlugin_31", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String company = ResManager.loadKDString((String)"\u501f\u6b3e\u4eba", (String)"RepaymentFormListPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String project = ResManager.loadKDString((String)"\u9879\u76ee", (String)"RepaymentFormListPlugin_6", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String contractbillno = ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"RepaymentFormListPlugin_42", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String contractno = ResManager.loadKDString((String)"\u5408\u540c\u53f7", (String)"RepaymentFormListPlugin_43", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String billno = String.format(ResManager.loadKDString((String)"%s\u5355", (String)"RepaymentFormListPlugin_8", (String)"tmc-cfm-report", (Object[])new Object[0]), this.getString());
        String drawamount_original = String.format(ResManager.loadKDString((String)"%s\u91d1\u989d(\u539f\u5e01)", (String)"RepaymentFormListPlugin_26", (String)"tmc-cfm-report", (Object[])new Object[0]), this.getString());
        String drawamount = String.format(ResManager.loadKDString((String)"%s\u91d1\u989d(\u7edf\u8ba1\u5e01)", (String)"RepaymentFormListPlugin_9", (String)"tmc-cfm-report", (Object[])new Object[0]), this.getString());
        String expiredate = ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f", (String)"RepaymentFormListPlugin_11", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String sumlevel = ResManager.loadKDString((String)"\u6392\u5e8f", (String)"RepaymentFormListPlugin_12", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String cny = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"RepaymentFormListPlugin_13", (String)"tmc-cfm-report", (Object[])new Object[0]);
        if ("fl_repaymentwarnrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            currency = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"RepaymentFormListPlugin_13", (String)"tmc-cfm-report", (Object[])new Object[0]);
            cny = ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u79cd", (String)"RepaymentFormListPlugin_37", (String)"tmc-cfm-report", (Object[])new Object[0]);
            bizDate = ResManager.loadKDString((String)"\u56de\u6b3e\u65e5\u671f", (String)"RepaymentFormListPlugin_38", (String)"tmc-cfm-report", (Object[])new Object[0]);
            finorginfo = ResManager.loadKDString((String)"\u51fa\u79df\u4eba", (String)"RepaymentFormListPlugin_39", (String)"tmc-cfm-report", (Object[])new Object[0]);
            company = ResManager.loadKDString((String)"\u627f\u79df\u4eba", (String)"RepaymentFormListPlugin_40", (String)"tmc-cfm-report", (Object[])new Object[0]);
            contractbillno = ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41\u5408\u540c\u5355\u53f7", (String)"RepaymentFormListPlugin_44", (String)"tmc-cfm-report", (Object[])new Object[0]);
            contractno = ResManager.loadKDString((String)"\u878d\u8d44\u5408\u540c\u53f7", (String)"RepaymentFormListPlugin_45", (String)"tmc-cfm-report", (Object[])new Object[0]);
            billno = ResManager.loadKDString((String)"\u552e\u540e\u79df\u56de\u56de\u6b3e\u5355", (String)"RepaymentFormListPlugin_34", (String)"tmc-cfm-report", (Object[])new Object[0]);
            drawamount_original = ResManager.loadKDString((String)"\u91d1\u989d(\u539f\u5e01)", (String)"RepaymentFormListPlugin_35", (String)"tmc-cfm-report", (Object[])new Object[0]);
            drawamount = ResManager.loadKDString((String)"\u91d1\u989d(\u7edf\u8ba1\u5e01)", (String)"RepaymentFormListPlugin_36", (String)"tmc-cfm-report", (Object[])new Object[0]);
        }
        switch (statdim) {
            case "finproductfinorginfo": {
                fields = new String[]{finproduct, finorginfo, creditorId, paymenttype, "season", "year", "month", exrepaydate, cny_original, examount_original, examount, notrepayamt_original, notrepayamt, company, project, currency, contractbillno, contractno, billno, drawamount_original, drawamount, bizDate, expiredate, sumlevel, "seasonSort", "monthSort", cny, "finproductid"};
                this.rebuildColumn(fields);
                break;
            }
            case "finproductfinorgcomp": {
                fields = new String[]{finproduct, finorginfo, creditorId, company, paymenttype, "season", "year", "month", exrepaydate, cny_original, examount_original, examount, notrepayamt_original, notrepayamt, project, currency, contractbillno, contractno, billno, drawamount_original, drawamount, bizDate, expiredate, sumlevel, "seasonSort", "monthSort", cny, "finproductid"};
                this.rebuildColumn(fields);
                break;
            }
            case "company": {
                fields = new String[]{company, paymenttype, "season", "year", "month", exrepaydate, cny_original, examount_original, examount, notrepayamt_original, notrepayamt, finorginfo, creditorId, finproduct, project, currency, contractbillno, contractno, billno, drawamount_original, drawamount, bizDate, expiredate, sumlevel, "seasonSort", "monthSort", cny, "finproductid"};
                this.rebuildColumn(fields);
                break;
            }
            case "finorginfo": {
                fields = new String[]{finorginfo, paymenttype, "season", "year", "month", exrepaydate, cny_original, examount_original, examount, notrepayamt_original, notrepayamt, company, finproduct, creditorId, project, currency, contractbillno, contractno, billno, drawamount_original, drawamount, bizDate, expiredate, sumlevel, "seasonSort", "monthSort", cny, "finproductid"};
                this.rebuildColumn(fields);
                break;
            }
        }
    }

    private String getString() {
        String drowAmountColumnName = ResManager.loadKDString((String)"\u63d0\u6b3e", (String)"RepaymentFormListPlugin_27", (String)"tmc-cfm-report", (Object[])new Object[0]);
        if ("bdim_repaymentwarnrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            drowAmountColumnName = ResManager.loadKDString((String)"\u53d1\u884c", (String)"RepaymentFormListPlugin_28", (String)"tmc-cfm-report", (Object[])new Object[0]);
        } else if ("fl_repaymentwarnrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            drowAmountColumnName = ResManager.loadKDString((String)"\u56de\u6b3e", (String)"RepaymentFormListPlugin_41", (String)"tmc-cfm-report", (Object[])new Object[0]);
        }
        return drowAmountColumnName;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd", (String)"RepaymentFormListPlugin_17", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        boolean isVerify = ReportCommonHelper.verifyQueryFilter(queryParam);
        if (!isVerify) {
            return isVerify;
        }
        return true;
    }

    private void rebuildColumn(String[] fields) {
        if (EmptyUtil.isEmpty((Object[])fields)) {
            return;
        }
        String monthSort = ResManager.loadKDString((String)"\u6708\u6392\u5e8f", (String)"RepaymentFormListPlugin_18", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String seasonSort = ResManager.loadKDString((String)"\u5b63\u6392\u5e8f", (String)"RepaymentFormListPlugin_19", (String)"tmc-cfm-report", (Object[])new Object[0]);
        ArrayList<String> fieIdList = new ArrayList<String>(Arrays.asList(fields));
        fieIdList.add(monthSort);
        fieIdList.add(seasonSort);
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        ReportCommonHelper.rebuildColumn(fieIdList.toArray(new String[fieIdList.size()]), listTable);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("filter_statdim") || propName.equals("filter_currencyunit")) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection companys;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey()) && EmptyUtil.isEmpty((DynamicObjectCollection)(companys = (DynamicObjectCollection)this.getModel().getValue("filter_org")))) {
            RequestContext context = RequestContext.get();
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(context.getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (orgIds.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u62a5\u8868\u67e5\u8be2\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"RepaymentFormListPlugin_32", (String)"tmc-cfm-report", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private String getShowFormId(String bizType) {
        String form = "cfm_loanbill";
        if (BizTypeEnum.LOAN.getValue().equals(bizType) || BizTypeEnum.SL.getValue().equals(bizType)) {
            form = "cfm_loanbill_b_l";
        } else if (BizTypeEnum.EC.getValue().equals(bizType) || BizTypeEnum.ENTRUST.getValue().equals(bizType)) {
            form = "cfm_loanbill_e_l";
        } else if (BizTypeEnum.BOND.getValue().equals(bizType)) {
            form = "cfm_loanbill_bond";
        } else if (BizTypeEnum.FINLEASE.getValue().equals(bizType)) {
            form = "fl_receiptbill";
        }
        return form;
    }

    private void setDefinedDateRangeVisible() {
        IDataModel model = this.getModel();
        if (RptDateRangeEnum.CUSTOM.getValue().equals(model.getValue("repaydateranges"))) {
            model.setValue("repaydateranges", (Object)"nextmonth");
            model.setValue("repaydateranges", (Object)RptDateRangeEnum.CUSTOM.getValue());
        }
        if (RptDateRangeEnum.CUSTOM.getValue().equals(model.getValue("bizdateranges"))) {
            model.setValue("bizdateranges", (Object)"nextmonth");
            model.setValue("bizdateranges", (Object)RptDateRangeEnum.CUSTOM.getValue());
        }
    }

    private void initSkipQueryParam() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String filters = (String)customParams.get("filters");
        if (EmptyUtil.isEmpty((String)filters)) {
            return;
        }
        Map param = (Map)SerializationUtils.deSerializeFromBase64((String)filters);
        if (EmptyUtil.isNoEmpty(param.get("skipfromsumrpt"))) {
            DynamicObject currency;
            MulBasedataDynamicObjectCollection currencies;
            String warnings;
            boolean bankTypeLevel;
            String filterCreditor;
            String filterCreditorType;
            String filterLenderNature;
            String repayDateRanges;
            IDataModel model = this.getModel();
            IReportView view = this.getView();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"filter_queryway", (Object)"org");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"filter_statdim", (Object)this.getDetailStadim((String)param.get("filter_statdim")));
            List orgIds = (List)param.get("filter_org");
            this.setMutiPropValue("bos_org", "filter_org", orgIds.toArray());
            List investVarieties = (List)param.get("filter_finproduct");
            if (EmptyUtil.isNoEmpty((Object)investVarieties)) {
                this.setMutiPropValue("cfm_financingvarieties", "filter_finproduct", investVarieties.toArray());
            }
            if (EmptyUtil.isNoEmpty((String)(repayDateRanges = (String)param.get("repaydateranges")))) {
                model.setValue("repaydateranges", (Object)repayDateRanges);
            }
            if ("custom".equals(repayDateRanges)) {
                model.setValue("repaydateranges_startdate", param.get("repaydateranges_startdate"));
                model.setValue("repaydateranges_enddate", param.get("repaydateranges_enddate"));
            }
            if (EmptyUtil.isNoEmpty((String)(filterLenderNature = (String)param.get("filter_lendernature")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_lendernature", (Object)filterLenderNature);
            }
            if (EmptyUtil.isNoEmpty((String)(filterCreditorType = (String)param.get("filter_creditortype")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_creditortype", (Object)filterCreditorType);
            }
            if (EmptyUtil.isNoEmpty((String)(filterCreditor = (String)param.get("filter_creditor")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_creditor", (Object)filterCreditor);
            }
            String statDim = (String)param.get("filter_statdim");
            String level = (String)param.get("filter_banklevel");
            String filterCreditorId = (String)param.get("filter_creditorid");
            if (EmptyUtil.isNoEmpty((String)filterCreditorId)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_creditorid", (Object)filterCreditorId);
            }
            if ((bankTypeLevel = this.isBankTypeLevel(statDim, level, filterCreditorId)) && !"1".equals(filterCreditorId)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_creditorid", (Object)0);
            }
            if (EmptyUtil.isNoEmpty((String)(warnings = (String)param.get("warnings")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"warnings", (Object)warnings);
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencies = (MulBasedataDynamicObjectCollection)param.get("credit_currency")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"credit_currency", (Object)currencies);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)param.get("filter_statcurrency")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_statcurrency", (Object)currency);
            }
            if (bankTypeLevel) {
                model.setValue("filter_banktype", (Object)Long.parseLong(filterCreditorId));
            }
            this.autoSearch();
        }
    }

    private boolean isBankTypeLevel(String statDim, String level, String creditId) {
        boolean isBankType = false;
        if (!"companycny".equals(statDim) && "1".equals(level) && EmptyUtil.isNoEmpty((String)creditId)) {
            isBankType = QueryServiceHelper.exists((String)"bd_bankcgsetting", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(creditId))});
        }
        return isBankType;
    }

    private void setMutiPropValue(String entityName, String propName, Object[] ids) {
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        DynamicObject[] objs = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        DynamicObjectCollection objList = new DynamicObjectCollection();
        Arrays.stream(objs).forEach(v -> objList.add(v));
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)objList)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)objList);
        }
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private String getDetailStadim(String staDim) {
        HashMap<String, String> staDimMap = new HashMap<String, String>(8);
        staDimMap.put("companycny", "company");
        staDimMap.put("creditorcny", "finorginfo");
        staDimMap.put("finprocreditorcny", "finproductfinorginfo");
        staDimMap.put("finprocreditorcompcny", "finproductfinorgcomp");
        return staDimMap.getOrDefault(staDim, "finproductfinorginfo");
    }
}

