/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentSumFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if ("homelink".equals(customParams.get("showtype"))) {
            this.getModel().setValue("filter_statcurrency", customParams.get("filter_currency"));
        }
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        String showType = (String)this.getModel().getValue("filter_showttype");
        if ("step".equals(showType)) {
            event.setTreeReportList(true);
        }
    }

    public void beforeQuery(ReportQueryParam param) {
        String showType;
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Map commFilters = null;
        if (!EmptyUtil.isEmpty(customParams.get("commFilters"))) {
            commFilters = (Map)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("commFilters")));
        }
        if (null != commFilters) {
            param.getFilter().setCommFilter(commFilters);
        }
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("statdim", (Object)statdim);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        param.getFilter().addFilterItem("currency", (Object)currency);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        param.getFilter().addFilterItem("currencyunit", (Object)currencyUnit);
        String bankLevel = (String)this.getModel().getValue("filter_banklevel");
        if (EmptyUtil.isNotEmpty((CharSequence)bankLevel)) {
            param.getFilter().addFilterItem("banklevel", (Object)bankLevel);
        }
        if (EmptyUtil.isNotEmpty((CharSequence)(showType = (String)this.getModel().getValue("filter_showttype")))) {
            param.getFilter().addFilterItem("filter_showttype", (Object)showType);
        }
        if ("bdim_repaymentwarnsumrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            param.getCustomParam().put("isloanbillbondonly", true);
        }
        if ("fl_repaymentwarnsumrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            param.getCustomParam().put("isloanbillflonly", true);
        }
        this.initQueryColumn(statdim);
        super.beforeQuery(param);
    }

    private void initQueryColumn(String statdim) {
        String company = ResManager.loadKDString((String)"\u501f\u6b3e\u4eba", (String)"RepaymentSumFormListPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String currency = ResManager.loadKDString((String)"\u8fd8\u6b3e\u5e01\u79cd", (String)"RepaymentSumFormListPlugin_2", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String creditorname = ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"RepaymentSumFormListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String amount = ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u539f\u5e01", (String)"RepaymentSumFormListPlugin_4", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String examount = ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u6298\u7b97", (String)"RepaymentSumFormListPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String paymenttype = ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b", (String)"RepaymentSumFormListPlugin_6", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String cny = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"RepaymentSumFormListPlugin_7", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String currencyid = ResManager.loadKDString((String)"\u539f\u5e01", (String)"RepaymentSumFormListPlugin_8", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String sumlevel = ResManager.loadKDString((String)"\u6392\u5e8f", (String)"RepaymentSumFormListPlugin_9", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String sort = ResManager.loadKDString((String)"\u5408\u8ba1\u6392\u5e8f", (String)"RepaymentSumFormListPlugin_10", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String finproduct = ResManager.loadKDString((String)"\u503a\u5238\u7c7b\u578b", (String)"RepaymentSumFormListPlugin_11", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u67e5\u770b\u660e\u7ec6", (String)"RepaymentSumFormListPlugin_14", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String companyid = ResManager.loadKDString((String)"\u501f\u6b3e\u4eba(F7\u9690\u85cf)", (String)"RepaymentSumFormListPlugin_15", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String finproductid = ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cdID", (String)"RepaymentSumFormListPlugin_16", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String creditorid = ResManager.loadKDString((String)"\u503a\u6743\u4ebaID", (String)"RepaymentSumFormListPlugin_17", (String)"tmc-cfm-report", (Object[])new Object[0]);
        if (!"bdim_repaymentwarnsumrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            finproduct = ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"RepaymentFormListPlugin_33", (String)"tmc-cfm-report", (Object[])new Object[0]);
        }
        if ("fl_repaymentwarnsumrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            company = ResManager.loadKDString((String)"\u627f\u79df\u4eba", (String)"RepaymentFormListPlugin_40", (String)"tmc-cfm-report", (Object[])new Object[0]);
            companyid = ResManager.loadKDString((String)"\u627f\u79df\u4eba(F7\u9690\u85cf)", (String)"RepaymentSumFormListPlugin_41", (String)"tmc-cfm-report", (Object[])new Object[0]);
            creditorname = ResManager.loadKDString((String)"\u51fa\u79df\u4eba", (String)"RepaymentFormListPlugin_39", (String)"tmc-cfm-report", (Object[])new Object[0]);
            currency = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"RepaymentSumFormListPlugin_7", (String)"tmc-cfm-report", (Object[])new Object[0]);
            cny = ResManager.loadKDString((String)"\u539f\u5e01", (String)"RepaymentSumFormListPlugin_8", (String)"tmc-cfm-report", (Object[])new Object[0]);
        }
        String[] fields = null;
        switch (statdim) {
            case "companycny": {
                fields = new String[]{company, currency, creditorname, amount, examount, paymenttype, cny, currencyid, sumlevel, sort, detail, companyid, finproductid, creditorid};
                this.rebuildColumn(fields);
                break;
            }
            case "creditorcny": {
                fields = new String[]{creditorname, currency, company, amount, examount, paymenttype, cny, currencyid, sumlevel, sort, detail, companyid, finproductid, creditorid};
                this.rebuildColumn(fields);
                break;
            }
            case "finprocreditorcny": {
                fields = new String[]{finproduct, creditorname, currency, amount, examount, paymenttype, cny, currencyid, sumlevel, sort, detail, companyid, finproductid, creditorid};
                this.rebuildColumn(fields);
                break;
            }
            case "finprocreditorcompcny": {
                fields = new String[]{finproduct, creditorname, company, currency, amount, examount, paymenttype, cny, currencyid, sumlevel, sort, detail, companyid, finproductid, creditorid};
                this.rebuildColumn(fields);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd\u3002", (String)"RepaymentSumFormListPlugin_12", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        boolean isVerify = ReportCommonHelper.verifyQueryFilter(queryParam);
        if (!isVerify) {
            return isVerify;
        }
        return true;
    }

    private void rebuildColumn(String[] fields) {
        if (EmptyUtil.isEmpty((Object[])fields)) {
            return;
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i].trim();
            for (AbstractReportColumn column : columns) {
                if (!column.getCaption().toString().equalsIgnoreCase(field)) continue;
                rebuildColumns.add(column);
            }
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("filter_statdim".equals(propName)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_showttype", (Object)"tile");
        }
        if (propName.equals("filter_statdim") || propName.equals("filter_banklevel")) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection companys;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey()) && EmptyUtil.isEmpty((DynamicObjectCollection)(companys = (DynamicObjectCollection)this.getModel().getValue("filter_org")))) {
            RequestContext context = RequestContext.get();
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (orgIds.size() <= 0) {
                throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u62a5\u8868\u67e5\u8be2\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"RepaymentSumFormListPlugin_13", (String)"tmc-cfm-report", (Object[])new Object[0])});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String queryDetailFormId = "cfm_repaymentwarnrpt";
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("bdim_repaymentwarnsumrpt".equals(formId)) {
            queryDetailFormId = "bdim_repaymentwarnrpt";
        }
        if ("fl_repaymentwarnsumrpt".equals(formId)) {
            queryDetailFormId = "fl_repaymentwarnrpt";
        }
        if ("qinganalysis".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cfm_repaymentwarnsqing");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ReportQueryParam queryParam = this.getQueryParam();
            this.removeOrgFilterItem(queryParam);
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)queryParam));
            view.showForm(showParameter);
        } else if ("querydetail".equals(itemKey)) {
            ReportQueryParam queryParam = this.getQueryParam();
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.getCustomParams().put("filter", SerializationUtils.serializeToBase64((Object)queryParam));
            showParameter.setFormId(queryDetailFormId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"detail")) {
            ReportList reportList = (ReportList)event.getSource();
            ReportShowParameter param = new ReportShowParameter();
            String billName = this.getModel().getDataEntity().getDataEntityType().getName();
            String formId = "";
            switch (billName) {
                case "cfm_repaymentwarnsumrpt": {
                    formId = "cfm_repaymentwarnrpt";
                    break;
                }
                case "bdim_repaymentwarnsumrpt": {
                    formId = "bdim_repaymentwarnrpt";
                    break;
                }
                case "fl_repaymentwarnsumrpt": {
                    formId = "fl_repaymentwarnrpt";
                    break;
                }
                default: {
                    formId = "cfm_repaymentwarnrpt";
                }
            }
            param.setFormId(formId);
            List<DynamicObject> selectRows = this.getHyperLinkData(reportList, event.getRowIndex());
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject currRow = reportModel.getRowData(event.getRowIndex());
            param.setCustomParam("filters", (Object)SerializationUtils.serializeToBase64(this.getHyperLinkParam(selectRows, currRow)));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void removeOrgFilterItem(ReportQueryParam queryParam) {
        FilterItemInfo filterItem = queryParam.getFilter().getFilterItem("filter_org");
        if (filterItem != null && filterItem.getValue() != null) {
            List filterItems = queryParam.getFilter().getFilterItems();
            for (int i = filterItems.size() - 1; i >= 0; --i) {
                if (!((FilterItemInfo)filterItems.get(i)).getPropName().equals("filter_org")) continue;
                filterItems.remove(i);
            }
        }
    }

    private List<DynamicObject> getHyperLinkData(ReportList reportList, int rowIndex) {
        ArrayList<DynamicObject> hyperLinkData = new ArrayList<DynamicObject>(16);
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject firstData = reportModel.getRowData(rowIndex);
        String showType = (String)this.getModel().getValue("filter_showttype");
        if ("tile".equals(showType)) {
            hyperLinkData.add(firstData);
            return hyperLinkData;
        }
        ArrayList<Object> rowIds = new ArrayList<Object>(16);
        rowIds.add(firstData.get("rowid"));
        if (!firstData.getBoolean("isgroupnode")) {
            hyperLinkData.add(firstData);
            return hyperLinkData;
        }
        int totalRecords = reportList.getTotalRecords();
        for (int i = rowIndex + 1; i <= totalRecords; ++i) {
            DynamicObject data = reportModel.getRowData(i);
            Object pId = data.get("pid");
            boolean isGroupNode = data.getBoolean("isgroupnode");
            if (!data.getString("sumlevel").equals("0") || !rowIds.contains(pId)) break;
            if (!isGroupNode) {
                hyperLinkData.add(data);
                continue;
            }
            rowIds.add(data.get("rowid"));
        }
        return hyperLinkData;
    }

    private Map<String, Object> getHyperLinkParam(List<DynamicObject> curRowDatas, DynamicObject currRow) {
        HashMap<String, Object> hyperLinkParam = new HashMap<String, Object>(16);
        hyperLinkParam.put("skipfromsumrpt", "true");
        ArrayList<Object> orgIds = new ArrayList<Object>();
        ArrayList<Object> investVarieties = new ArrayList<Object>();
        StringBuilder creditorIds = new StringBuilder();
        StringBuilder creditors = new StringBuilder();
        MulBasedataDynamicObjectCollection loanCurrency = new MulBasedataDynamicObjectCollection();
        String statDim = (String)this.getModel().getValue("filter_statdim");
        String showType = (String)this.getModel().getValue("filter_showttype");
        String level = (String)this.getModel().getValue("filter_banklevel");
        hyperLinkParam.put("filter_statdim", statDim);
        hyperLinkParam.put("filter_banklevel", level);
        boolean isGroupnode = "step".equals(showType) && "companycny".equals(statDim) && currRow.getBoolean("isgroupnode");
        for (DynamicObject curRowData : curRowDatas) {
            this.addOrgIds(orgIds, curRowData);
            this.addInvestIds(investVarieties, curRowData);
            this.addLoanCurrency(loanCurrency, curRowData);
            if (isGroupnode) continue;
            if (this.isBankTypeLevel(statDim, level, curRowData.getLong("creditorid"))) {
                this.addCreditorIds(creditorIds, curRowData);
                continue;
            }
            this.addCreditorIds(creditorIds, curRowData);
            this.addCreditors(creditors, curRowData);
        }
        hyperLinkParam.put("filter_org", orgIds);
        hyperLinkParam.put("filter_finproduct", investVarieties);
        hyperLinkParam.put("filter_statdim", this.getModel().getValue("filter_statdim"));
        hyperLinkParam.put("repaydateranges", this.getModel().getValue("repaydateranges"));
        hyperLinkParam.put("repaydateranges_startdate", this.getModel().getValue("repaydateranges_startdate"));
        hyperLinkParam.put("repaydateranges_enddate", this.getModel().getValue("repaydateranges_enddate"));
        hyperLinkParam.put("filter_lendernature", this.getModel().getValue("filter_lendernature"));
        hyperLinkParam.put("filter_creditortype", this.getModel().getValue("filter_creditortype"));
        hyperLinkParam.put("filter_creditor", EmptyUtil.isNoEmpty((String)creditors.toString()) ? creditors.substring(0, creditors.length() - 1) : "");
        hyperLinkParam.put("filter_creditorid", EmptyUtil.isNoEmpty((String)creditorIds.toString()) ? creditorIds.substring(0, creditorIds.length() - 1) : "");
        if ("1".equals(currRow.getString("creditorid"))) {
            hyperLinkParam.put("filter_creditorid", "1");
            hyperLinkParam.put("filter_creditor", "");
        }
        hyperLinkParam.put("warnings", this.getModel().getValue("warnings"));
        hyperLinkParam.put("bizdateranges", this.getModel().getValue("bizdateranges"));
        hyperLinkParam.put("bizdateranges_startdate", this.getModel().getValue("bizdateranges_startdate"));
        hyperLinkParam.put("bizdateranges_enddate", this.getModel().getValue("bizdateranges_enddate"));
        hyperLinkParam.put("credit_currency", loanCurrency.size() != 0 ? loanCurrency : null);
        hyperLinkParam.put("filter_statcurrency", this.getModel().getValue("filter_statcurrency"));
        return hyperLinkParam;
    }

    private boolean isBankTypeLevel(String statDim, String level, Long creditorId) {
        return !"companycny".equals(statDim) && "1".equals(level) && EmptyUtil.isNoEmpty((Long)creditorId);
    }

    private void addOrgIds(List<Object> orgIds, DynamicObject curRowData) {
        DynamicObject org;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("companyid")) && EmptyUtil.isNoEmpty((DynamicObject)(org = curRowData.getDynamicObject("companyid")))) {
            orgIds.add(org.get("id"));
        }
        if (orgIds.isEmpty()) {
            String orgWay = (String)this.getModel().getValue("filter_queryway");
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (StringUtils.equals((CharSequence)orgWay, (CharSequence)"org")) {
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                    orgIds.addAll(orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
                }
            } else {
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
                if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                    orgIds.addAll(TmcOrgDataHelper.getOrgIds((Long)orgView.getLong("id")));
                }
            }
        }
    }

    private void addInvestIds(List<Object> InvestIds, DynamicObject curRowData) {
        DynamicObjectCollection investCol;
        long investId;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("finproductid")) && EmptyUtil.isNoEmpty((Long)(investId = curRowData.getLong("finproductid")))) {
            InvestIds.add(investId);
        }
        if (InvestIds.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(investCol = (DynamicObjectCollection)this.getModel().getValue("filter_finproduct")))) {
            InvestIds.addAll(investCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
    }

    private void addCreditors(StringBuilder creditors, DynamicObject curRowData) {
        String creditor;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("creditorname")) && EmptyUtil.isNoEmpty((String)(creditor = curRowData.getString("creditorname"))) && !"1".equals(curRowData.getString("creditorid"))) {
            creditors.append(creditor).append(";");
        }
        if (EmptyUtil.isEmpty((String)creditors.toString())) {
            String filterCreditors = (String)this.getModel().getValue("filter_creditor");
            creditors.append(filterCreditors).append(";");
        }
    }

    private void addCreditorIds(StringBuilder creditorIds, DynamicObject curRowData) {
        Long creditorId;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("creditorid")) && EmptyUtil.isNoEmpty((Long)(creditorId = Long.valueOf(curRowData.getLong("creditorid"))))) {
            creditorIds.append(creditorId).append(";");
        }
        if (EmptyUtil.isEmpty((String)creditorIds.toString())) {
            String filterCreditorIds = (String)this.getModel().getValue("filter_creditorid");
            creditorIds.append(filterCreditorIds).append(";");
        }
    }

    private void addLoanCurrency(MulBasedataDynamicObjectCollection loanCurrency, DynamicObject curRowData) {
        DynamicObject currency;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("currencyid")) && !EmptyUtil.isEmpty((DynamicObject)(currency = curRowData.getDynamicObject("currencyid")))) {
            loanCurrency.add(currency);
        }
        if (loanCurrency.isEmpty()) {
            currency = (MulBasedataDynamicObjectCollection)this.getModel().getValue("credit_currency");
            for (DynamicObject c : currency) {
                loanCurrency.add(c);
            }
        }
    }
}

