/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeFinanceBaseFormListPlugin
extends AbstractReportFormPlugin {
    private static final String CLOSECALLBACK_ACTION_ID = "REPORT_BD_F7ACTIONID";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"filter_creditor"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        switch (propName) {
            case "filter_statdim": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_showttype", (Object)"tile");
                this.reSearch();
                break;
            }
            case "filter_lendernature": {
                this.setValuesWhenCreditorNatureChanged(valSet);
                this.getModel().setValue("filter_creditortype", null);
                break;
            }
            case "filter_creditortype": {
                this.getModel().setValue("filter_creditor", null);
                this.getModel().setValue("filter_creditorid", null);
                break;
            }
            case "filter_creditor": {
                this.getModel().setValue("filter_creditorid", null);
                break;
            }
            case "filter_settlecenter": {
                this.setCreditor();
                break;
            }
        }
    }

    protected void setCreditor() {
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("filter_settlecenter");
        ArrayList<String> settId = new ArrayList<String>(value.size());
        ArrayList<String> settName = new ArrayList<String>(value.size());
        for (DynamicObject dynamicObject : value) {
            DynamicObject object = dynamicObject.getDynamicObject("fbasedataid");
            settId.add(String.valueOf(object.getLong("id")));
            settName.add(object.getString("name"));
        }
        if (settId.size() > 0 && settName.size() > 0) {
            this.getModel().setValue("filter_creditor", (Object)String.join((CharSequence)";", settName));
            this.getModel().setValue("filter_creditorid", (Object)String.join((CharSequence)";", settId));
        } else {
            this.getModel().setValue("filter_creditor", (Object)"");
            this.getModel().setValue("filter_creditorid", (Object)"");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String creditorNature = (String)this.getModel().getValue("filter_lendernature");
        this.setCreditorTypeComboItem("ingroup".equals(creditorNature));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String fieldName = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"filter_creditor")) {
            String creditorType = (String)this.getModel().getValue("filter_creditortype");
            if (EmptyUtil.isEmpty((String)creditorType)) {
                String formId = this.getView().getFormShowParameter().getFormId();
                String dataSource = formId.startsWith("fl") ? DataSourceEnum.FL.getValue() : DataSourceEnum.CFM.getValue();
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
                if (formId.equals("cfm_epeloandetail_rpt") || formId.equals("cfm_epeloancollect_rpt")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u501f\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"TradeFinanceFromListPlugin_4", (String)"tmc-cfm-report", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(bizResource.getOrgType());
                }
                return;
            }
            if (!this.getTypeOtherValue().equals(creditorType)) {
                this.showF7(creditorType);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        Date cutoffDate = (Date)this.getModel().getValue("filter_cutoffdate");
        if (EmptyUtil.isEmpty((Object)cutoffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u622a\u6b62\u65e5\u671f\u3002", (String)"TradeFinanceFromListPlugin_0", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_lendernature"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u503a\u6743\u4eba\u6027\u8d28\u3002", (String)"TradeFinanceFromListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd\u3002", (String)"TradeFinanceFromListPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void reSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    protected void setValuesWhenCreditorNatureChanged(ChangeData[] valSet) {
        String newValue = (String)valSet[0].getNewValue();
        this.creditorNatureChanged(newValue);
    }

    protected void creditorNatureChanged(String newValue) {
        if (EmptyUtil.isEmpty((String)newValue)) {
            return;
        }
        String[] values = newValue.split(",");
        boolean notCheckAll = !this.isCheckAll(values);
        this.getView().setVisible(Boolean.valueOf(notCheckAll), new String[]{"filter_creditortype", "filter_creditor"});
        if (notCheckAll) {
            String creditorNature = values[1];
            this.setCreditorTypeComboItem("ingroup".equals(creditorNature));
        }
    }

    protected void setCreditorTypeComboItem(boolean inGroup) {
        ArrayList<String> comboItemValues = new ArrayList<String>(10);
        if (inGroup) {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.SETTLECENTER.getValue(), CreditorTypeEnum.SETTLECENTER.getValue()));
        } else {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue()));
        }
        TmcViewInputHelper.resetComboItems(comboItemValues, (String)"filter_creditortype", (IFormView)this.getView());
    }

    protected void showF7(String creditorType) {
        String f7FormId = this.getF7FormId(creditorType);
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)f7FormId, (boolean)true, (int)3, (boolean)true);
        this.addCustomFilter(creditorType, lsp);
        this.addCustomParam(creditorType, lsp);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ACTION_ID);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    protected String getF7FormId(String type) {
        return CreditorTypeEnum.getFormIdByValue((String)type.toLowerCase());
    }

    protected String getTypeOtherValue() {
        return CreditorTypeEnum.OTHER.getValue();
    }

    protected void addCustomParam(String type, ListShowParameter lsp) {
        if (CreditorTypeEnum.INNERUNIT.getValue().equals(type)) {
            lsp.setCustomParam("orgFuncId", (Object)"08");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (CLOSECALLBACK_ACTION_ID.equals(e.getActionId())) {
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyUtil.isEmpty((Collection)selectedRowCol)) {
                return;
            }
            StringBuilder creditorName = new StringBuilder();
            StringBuilder creditorId = new StringBuilder();
            for (ListSelectedRow row : selectedRowCol) {
                creditorName.append(row.getName()).append(';');
                creditorId.append(row.getPrimaryKeyValue()).append(';');
            }
            this.getModel().setValue("filter_creditor", (Object)creditorName.toString());
            this.getModel().setValue("filter_creditorid", (Object)creditorId.toString());
        }
    }

    protected void addCustomFilter(String type, ListShowParameter lsp) {
        List lspQFilter = lsp.getListFilterParameter().getQFilters();
        String finOrgType = "finorgtype.type";
        if (CreditorTypeEnum.BANK.getValue().equals(type)) {
            lspQFilter.add(new QFilter(finOrgType, "=", (Object)"0"));
        } else if (CreditorTypeEnum.SETTLECENTER.getValue().equals(type)) {
            lspQFilter.add(new QFilter(finOrgType, "=", (Object)"1"));
        } else if (CreditorTypeEnum.FINORG.getValue().equals(type)) {
            lspQFilter.add(new QFilter(finOrgType, "not in", Arrays.asList("0", "1")));
        }
        lspQFilter.add(new QFilter("enable", "=", (Object)"1"));
    }

    private boolean isCheckAll(String[] values) {
        return values.length == 3;
    }
}

