/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.report.form.TradeFinanceBaseFormListPlugin;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeFinanceFromListPlugin
extends TradeFinanceBaseFormListPlugin
implements HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.initF7settlecenter();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        this.getView().setVisible(Boolean.valueOf("custom".equals(queryCutOffDate)), new String[]{"filter_cutoffdate"});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (propName) {
            case "filter_querycutoffdate": {
                this.getView().setVisible(Boolean.valueOf("custom".equals(newValue)), new String[]{"filter_cutoffdate"});
                break;
            }
            case "filter_org": 
            case "filter_orgview": 
            case "filter_creditortype": 
            case "filter_creditor": {
                this.getModel().setValue("filter_banktype", (Object)"");
                break;
            }
        }
    }

    private void initF7settlecenter() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("ifm_internalloan_dtl_rpt".equals(formId)) {
            BasedataEdit company = (BasedataEdit)this.getControl("filter_settlecenter");
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNoEmpty((String)appId) ? appId : "cfm";
                List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
                qFilters.add(new QFilter("finorgtype.type", "=", (Object)"1"));
                qFilters.add(new QFilter("org", "in", (Object)comIdList));
            });
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object datasource = this.getModel().getValue("filter_datasource");
        if (EmptyUtil.isEmpty((Object)datasource)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6765\u6e90\u3002", (String)"TradeFinanceFromListPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        queryParam.getFilter().addFilterItem("filter_currencyunit", (Object)currencyUnit);
        String bankLevel = (String)this.getModel().getValue("filter_banklevel");
        queryParam.getFilter().addFilterItem("filter_banklevel", (Object)bankLevel);
        this.initQueryColumn(statdim, queryParam);
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<String> columnKeys = new ArrayList<String>(columns.size());
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn = (ReportColumn)column;
            columnKeys.add(reportColumn.getFieldKey());
        }
        if ("bdim_loandyndetailrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            queryParam.getCustomParam().put("from", "bondissue");
        }
        queryParam.getCustomParam().put("columnkeys", String.join((CharSequence)",", columnKeys));
        queryParam.getCustomParam().put("appid", this.getView().getFormShowParameter().getAppId());
        super.beforeQuery(queryParam);
    }

    private void initQueryColumn(String statdim, ReportQueryParam param) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(columns.size());
        String[] dimFields = statdim.split(",");
        for (String dim : dimFields) {
            for (AbstractReportColumn column : columns) {
                ReportColumn reportColumn;
                if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().equals(dim)) continue;
                rebuildColumns.add(reportColumn);
            }
        }
        for (AbstractReportColumn column : columns) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIdx = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIdx);
        if ("loanbillno".equals(evt.getFieldName())) {
            BillShowParameter sp = new BillShowParameter();
            Long loanBillId = (Long)rowData.get("loanbillid");
            String viewForm = this.getView().getFormShowParameter().getFormId();
            if ("ifm_internalloan_dtl_rpt".equals(viewForm)) {
                sp.setFormId("ifm_loanbill");
            } else {
                DynamicObject billData = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)"loantype");
                String loanType = billData.getString("loantype");
                String formId = "cfm_loanbill";
                if (BizTypeEnum.LOAN.getValue().equals(loanType) || BizTypeEnum.SL.getValue().equals(loanType)) {
                    formId = "cfm_loanbill_b_l";
                } else if (BizTypeEnum.BOND.getValue().equals(loanType)) {
                    formId = "cfm_loanbill_bond";
                } else if (BizTypeEnum.ENTRUST.getValue().equals(loanType) || BizTypeEnum.EC.getValue().equals(loanType)) {
                    formId = "cfm_loanbill_e_l";
                } else if (BizTypeEnum.FINLEASE.getValue().equals(loanType)) {
                    formId = "fl_receiptbill";
                }
                sp.setFormId(formId);
            }
            sp.setPkId((Object)loanBillId);
            sp.setStatus(OperationStatus.VIEW);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)sp);
        } else if ("contractbillno".equals(evt.getFieldName())) {
            ReportCommonHelper.showContractbill(rowData, this.getView());
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        boolean isBankType;
        super.initDefaultQueryParam(queryParam);
        IReportView view = this.getView();
        ReportShowParameter formShowParameter = (ReportShowParameter)view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String filters = (String)customParams.get("filters");
        if (EmptyUtil.isEmpty((String)filters)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        Map param = (Map)SerializationUtils.deSerializeFromBase64((String)filters);
        String creditorType = (String)param.get("filter_creditortype");
        Object creditorId = param.get("filter_creditorid");
        String creditor = (String)param.get("filter_creditor");
        param.remove("filter_creditortype");
        param.remove("filter_creditorid");
        param.remove("filter_creditor");
        if (EmptyUtil.isEmpty((String)creditorType) && EmptyUtil.isNoEmpty(creditorId) && "0".equals(String.valueOf(creditorId))) {
            creditorType = CreditorTypeEnum.OTHER.getValue();
        }
        model.setValue("filter_creditortype", (Object)creditorType);
        String stadim = (String)param.get("filter_statdim");
        String bankLevel = (String)param.get("filter_banklevel");
        String creditIdStr = String.valueOf(creditorId);
        boolean bl = isBankType = stadim.contains("fincreditorname") && "1".equals(bankLevel) && !creditIdStr.equals("1") && !creditIdStr.equals("0");
        if (isBankType && EmptyUtil.isNoEmpty(creditorId)) {
            isBankType = QueryServiceHelper.exists((String)"bd_bankcgsetting", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(creditorId)))});
        }
        if (isBankType) {
            model.setValue("filter_banktype", creditorId);
            model.setValue("filter_creditortype", (Object)CreditorTypeEnum.BANK.getValue());
        } else {
            if (EmptyUtil.isNoEmpty(creditorId)) {
                model.setValue("filter_creditorid", creditorId);
            }
            if (EmptyUtil.isNoEmpty(creditorId) && !"1".equals(String.valueOf(creditorId))) {
                model.setValue("filter_creditor", (Object)creditor);
            }
        }
        block6: for (Map.Entry entry : param.entrySet()) {
            String propName = (String)entry.getKey();
            Object value = entry.getValue();
            switch (propName) {
                case "filter_lendernature": {
                    model.setValue(propName, value);
                    super.creditorNatureChanged((String)value);
                    continue block6;
                }
            }
            model.setValue(propName, value);
        }
        model.endInit();
        this.getView().updateView();
        super.reSearch();
    }
}

