/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.errorcode.RptQingErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportCommonHelper
extends AbstractReportFormPlugin {
    private static final Log logger = LogFactory.getLog(ReportCommonHelper.class);

    public static Map<String, Object> transQueryParam(ReportQueryParam param) {
        int size = param.getFilter().getFilterItems().size();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(size);
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        paramMap.put("appid", param.getCustomParam().get("appid"));
        return paramMap;
    }

    public static boolean verifyQueryFilter(ReportQueryParam param) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("ranges") || !RptDateRangeEnum.CUSTOM.getValue().equals(entry.getValue()) || !EmptyUtil.isEmpty((Object)paramMap.get(key + "_startdate")) && !EmptyUtil.isEmpty((Object)paramMap.get(key + "_enddate"))) continue;
            throw new TmcBizException(new RptQingErrorCode().DEFINEDATE_NULL());
        }
        return true;
    }

    public static void rebuildColumn(String[] feilds, ReportList listTable) {
        List columns = listTable.getColumns();
        ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>();
        for (int i = 0; i < feilds.length; ++i) {
            String field = feilds[i].trim();
            for (AbstractReportColumn column : columns) {
                logger.info("rebuildColumn field:(" + field + "),rebuildColumn column :" + column.getCaption().toString());
                if (!column.getCaption().toString().equalsIgnoreCase(field)) continue;
                rebuildColumns.add(column);
            }
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public static DataSet createEmptyDataSet() {
        RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    public static DynamicObject getExRateTable(Long orgId) {
        return SystemStatusCtrolHelper.getStandardExRateTable((long)orgId);
    }

    public static BigDecimal getExchangeRate(DynamicObject standardExRateTable, Long sourceCurrencyId, Long targetCurrencyId, Date date) {
        return BaseDataServiceHelper.getExchangeRate((Long)((Long)standardExRateTable.getPkValue()), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
    }

    public static String loadKDString(String description, String resourceID, Object ... args) {
        return ResManager.loadKDString((String)description, (String)resourceID, (String)"tmc-cfm-report", (Object[])args);
    }

    public static void showContractbill(DynamicObject rowData, IReportView view) {
        String contractbillno = rowData.getString("contractbillno");
        BillShowParameter parameter = new BillShowParameter();
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fl_leasecontractbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)contractbillno)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bills)) {
            Long billId = ((DynamicObject)bills.get(0)).getLong("id");
            parameter.setFormId("fl_leasecontractbill");
            parameter.setPkId((Object)billId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)parameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RepaymentFormListPlugin_20", (String)"tmc-cfm-report", (Object[])new Object[0]));
        }
    }

    public static Date getCutOffDate(Map<String, Object> paramMap) {
        String cutOffDateRange = (String)paramMap.get("filter_querycutoffdate");
        Date currentDate = DateUtils.getCurrentDate();
        Date cutOffDate = null;
        switch (cutOffDateRange) {
            case "thisday": {
                cutOffDate = currentDate;
                break;
            }
            case "lastday": {
                cutOffDate = DateUtils.getLastDay((Date)currentDate, (int)1);
                break;
            }
            case "lastweek": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfWeek((Date)currentDate), (int)1);
                break;
            }
            case "lastmonth": {
                cutOffDate = DateUtils.getLastDateOfAnyMonth((Date)currentDate, (int)-1);
                break;
            }
            case "lastyear": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfCurYear(), (int)1);
                break;
            }
            case "custom": {
                cutOffDate = (Date)paramMap.get("filter_cutoffdate");
                break;
            }
        }
        return cutOffDate;
    }
}

