/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.helper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportFilterParamHelper {
    public static QFilter initOrgOrViewFilter(Map<String, Object> paramMap) {
        Object orgParam = paramMap.get("filter_org_id");
        List comIdList = null;
        if (orgParam instanceof DynamicObjectCollection) {
            DynamicObjectCollection orgColls = (DynamicObjectCollection)orgParam;
            comIdList = orgColls.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        } else if (orgParam instanceof List) {
            comIdList = (List)orgParam;
        }
        QFilter ofilter = EmptyUtil.isNoEmpty(comIdList) ? new QFilter("org.id", "in", comIdList) : new QFilter("org.id", "=", (Object)-1L);
        return ofilter;
    }

    public static QFilter getCollFilters(Map<String, Object> paramMap, String prop, String field) {
        ArrayList<Long> finList = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get(prop))) {
            DynamicObjectCollection finproducts = (DynamicObjectCollection)paramMap.get(prop);
            for (DynamicObject finproduct : finproducts) {
                finList.add(finproduct.getLong("id"));
            }
        }
        QFilter qFilter = null;
        if (finList.size() > 0) {
            qFilter = new QFilter(field, "in", finList);
        }
        return qFilter;
    }

    public static QFilter initLenderNatureFilter(Map<String, Object> paramMap, QFilter filter) {
        String lendernature = (String)paramMap.get("filter_lendernature");
        if (!EmptyUtil.isEmpty((String)lendernature)) {
            String[] split = lendernature.split(",");
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
            for (int i = 0; i < split.length; ++i) {
                String item = split[i];
                if (!EmptyUtil.isNotEmpty((CharSequence)item)) continue;
                qfilters.add(new QFilter("lendernature", "=", (Object)item));
            }
            if (qfilters.size() > 0) {
                QFilter qf = (QFilter)qfilters.get(0);
                int len = qfilters.size();
                for (int i = 1; i < len; ++i) {
                    qf.or((QFilter)qfilters.get(i));
                }
                filter.and(qf);
            }
        }
        return filter;
    }

    public static QFilter initDrawTypeFilter(Map<String, Object> paramMap, QFilter filter) {
        String drawStatus = (String)paramMap.get("filter_drawtype");
        if (EmptyUtil.isNoEmpty((String)drawStatus)) {
            String[] split = drawStatus.split(",");
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
            for (int i = 0; i < split.length; ++i) {
                String item = split[i];
                if (!EmptyUtil.isNotEmpty((CharSequence)item)) continue;
                if ("drawed".equals(item)) {
                    qfilters.add(new QFilter("drawtype", "=", (Object)DrawTypeEnum.DRAWED.getValue()));
                }
                if (!"partpayment".equals(item)) continue;
                qfilters.add(new QFilter("drawtype", "=", (Object)DrawTypeEnum.PARTPAYMENT.getValue()));
            }
            if (qfilters.size() > 0) {
                QFilter qf = (QFilter)qfilters.get(0);
                int len = qfilters.size();
                for (int i = 1; i < len; ++i) {
                    qf.or((QFilter)qfilters.get(i));
                }
                filter.and(qf);
            } else {
                filter.and(new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()}));
            }
        } else {
            filter.and(new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()}));
        }
        return filter;
    }

    public static QFilter initCfmReportFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        String expireDateType;
        QFilter expDateFilter;
        QFilter currencyfilter;
        QFilter filter = new QFilter("org.id", "in", orgIds);
        QFilter finProductfilter = ReportFilterParamHelper.getCollFilters(paramMap, "filter_finproduct", "finproduct.id");
        if (finProductfilter != null) {
            filter = filter.and(finProductfilter);
        }
        if ((currencyfilter = ReportFilterParamHelper.getCollFilters(paramMap, "credit_currency", "currency.id")) != null) {
            filter = filter.and(currencyfilter);
        }
        filter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, filter);
        String bizDateType = (String)paramMap.get("bizdateranges");
        QFilter bizDateFilter = ReportFilterParamHelper.getBizDateFilter(bizDateType, paramMap, "bizdate", "bizdateranges_startdate", "bizdateranges_enddate");
        if (bizDateFilter != null) {
            filter.and(bizDateFilter);
        }
        if ((expDateFilter = ReportFilterParamHelper.getBizDateFilter(expireDateType = (String)paramMap.get("expiredateranges"), paramMap, "expiredate", "expiredateranges_startdate", "expiredateranges_enddate")) != null) {
            filter.and(expDateFilter);
        }
        return filter;
    }

    public static QFilter initCfmReportFilterWithOrgView(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter filter = new QFilter("org.id", "in", orgIds);
        return ReportFilterParamHelper.initCfmReportCommonFilter(paramMap, filter);
    }

    public static QFilter initCfmReportCommonFilter(Map<String, Object> paramMap, QFilter filter) {
        String expireDateType;
        QFilter expDateFilter;
        QFilter currencyfilter;
        QFilter finProductfilter = ReportFilterParamHelper.getCollFilters(paramMap, "filter_finproduct", "finproduct.id");
        if (finProductfilter != null) {
            filter = filter.and(finProductfilter);
        }
        if ((currencyfilter = ReportFilterParamHelper.getCollFilters(paramMap, "credit_currency", "currency.id")) != null) {
            filter = filter.and(currencyfilter);
        }
        filter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, filter);
        String bizDateType = (String)paramMap.get("bizdateranges");
        QFilter bizDateFilter = ReportFilterParamHelper.getBizDateFilter(bizDateType, paramMap, "bizdate", "bizdateranges_startdate", "bizdateranges_enddate");
        if (bizDateFilter != null) {
            filter.and(bizDateFilter);
        }
        if ((expDateFilter = ReportFilterParamHelper.getBizDateFilter(expireDateType = (String)paramMap.get("expiredateranges"), paramMap, "expiredate", "expiredateranges_startdate", "expiredateranges_enddate")) != null) {
            filter.and(expDateFilter);
        }
        return filter;
    }

    private static QFilter getBizDateFilter(String bizDateType, Map<String, Object> paramMap, String filterProp, String startDataProp, String endDateProp) {
        Timestamp currentTime = DateUtils.getCurrentTime();
        QFilter filter = null;
        if (bizDateType == null) {
            return filter;
        }
        switch (bizDateType) {
            case "thismonth": {
                filter = new QFilter(filterProp, ">=", (Object)DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate())).and(new QFilter(filterProp, "<=", (Object)DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate())));
                break;
            }
            case "threemonth": {
                filter = new QFilter(filterProp, ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)3)).and(new QFilter(filterProp, "<=", (Object)currentTime));
                break;
            }
            case "sixmonth": {
                filter = new QFilter(filterProp, ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)6)).and(new QFilter(filterProp, "<=", (Object)currentTime));
                break;
            }
            case "oneyear": {
                filter = new QFilter(filterProp, ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)1)).and(new QFilter(filterProp, "<=", (Object)currentTime));
                break;
            }
            case "custom": {
                Date bizDateStartDate = (Date)paramMap.get(startDataProp);
                Date bizDateEndDate = (Date)paramMap.get(endDateProp);
                filter = new QFilter(filterProp, ">=", (Object)bizDateStartDate).and(new QFilter(filterProp, "<=", (Object)bizDateEndDate));
                break;
            }
        }
        return filter;
    }

    public static QFilter initCfmReportFilterIncludeDrawType(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter filter = ReportFilterParamHelper.initCfmReportFilterWithOrgView(paramMap, orgIds);
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("org", ">", (Object)0)).and(new QFilter("loantype", "!=", (Object)BizTypeEnum.BOND.getValue()));
        filter = ReportFilterParamHelper.initDrawTypeFilter(paramMap, filter);
        return filter;
    }

    public static QFilter addExtFilter(Map<String, Object> paramMap, QFilter filter) {
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (!entry.getKey().endsWith("_exflt")) continue;
            String key = entry.getKey();
            String fieldName = key.substring(0, key.lastIndexOf("_exflt"));
            Object value = entry.getValue();
            if (EmptyUtil.isEmpty((Object)value)) continue;
            if (value instanceof DynamicObject) {
                DynamicObject dynamicObject = (DynamicObject)value;
                if (!EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) continue;
                filter.and(fieldName, "=", dynamicObject.getPkValue());
                continue;
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection doc = (DynamicObjectCollection)value;
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)doc)) continue;
                filter.and(fieldName, "in", doc.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                continue;
            }
            if (!(value instanceof String)) continue;
            String string = (String)value;
            if (string.contains(",")) {
                List collect = Arrays.stream(string.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                if (collect.isEmpty()) continue;
                filter.and(fieldName, "in", collect);
                continue;
            }
            if (!EmptyUtil.isNotBlank((CharSequence)string)) continue;
            filter.and(fieldName, "=", (Object)string);
        }
        return filter;
    }

    public static QFilter buildDateRangesFilter(String rangeVal, String datefield, String rangeId, Map<String, Object> paramMap) {
        Date currentDate = DateUtils.getCurrentDate();
        QFilter qfilter = null;
        if (EmptyUtil.isNoEmpty((String)rangeVal)) {
            switch (rangeVal) {
                case "thismonth": {
                    qfilter = new QFilter(datefield, ">=", (Object)DateUtils.getMinMonthDate((Date)currentDate)).and(new QFilter(datefield, "<=", (Object)DateUtils.getMaxMonthDate((Date)currentDate)));
                    break;
                }
                case "thisquarter": {
                    qfilter = new QFilter(datefield, ">=", (Object)DateUtils.getFirstSeasonDate((Date)currentDate)).and(new QFilter(datefield, "<=", (Object)DateUtils.getLastSeasonDate((Date)currentDate)));
                    break;
                }
                case "nextquarter": {
                    Date nQuarterDate = DateUtils.getNextMonth((Date)currentDate, (int)3);
                    qfilter = new QFilter(datefield, ">=", (Object)DateUtils.getFirstSeasonDate((Date)nQuarterDate)).and(new QFilter(datefield, "<=", (Object)DateUtils.getLastSeasonDate((Date)nQuarterDate)));
                    break;
                }
                case "thisyear": {
                    qfilter = new QFilter(datefield, ">=", (Object)DateUtils.getFirstDayOfCurYear()).and(new QFilter(datefield, "<=", (Object)DateUtils.getLastDayOfCurYear()));
                    break;
                }
                case "nextmonth": {
                    qfilter = new QFilter(datefield, ">=", (Object)DateUtils.getFirstDateOfNextMonth((Date)currentDate)).and(new QFilter(datefield, "<=", (Object)DateUtils.getLastDateOfNextMonth((Date)currentDate)));
                    break;
                }
                case "nextweek": {
                    Date nextMonday = DateUtils.getNextWeekMonday((Date)currentDate);
                    qfilter = new QFilter(datefield, ">=", (Object)nextMonday).and(new QFilter(datefield, "<=", (Object)DateUtils.getNextDay((Date)nextMonday, (int)6)));
                    break;
                }
                case "thisweek": {
                    qfilter = new QFilter(datefield, ">=", (Object)DateUtils.getFirstDayOfWeek((Date)currentDate)).and(new QFilter(datefield, "<", (Object)DateUtils.getNextWeekMonday((Date)currentDate)));
                    break;
                }
                case "custom": {
                    Date endDate;
                    Date startDate = (Date)paramMap.get(rangeId + "_startdate");
                    if (startDate != null) {
                        qfilter = new QFilter(datefield, ">=", (Object)startDate);
                    }
                    if ((endDate = (Date)paramMap.get(rangeId + "_enddate")) == null) break;
                    QFilter filter = new QFilter(datefield, "<=", (Object)endDate);
                    qfilter = qfilter == null ? filter : qfilter.and(filter);
                    break;
                }
            }
        }
        return qfilter;
    }

    public static QFilter getLoandTypeFilter(String loandType) {
        if (LoanTypeEnum.BANKSLOAN.getValue().equals(loandType)) {
            return new QFilter("loantype", "=", (Object)loandType).and(new QFilter("banksyndicate_entry.id", "!=", (Object)0));
        }
        if (LoanTypeEnum.BOND.getValue().equals(loandType) || LoanTypeEnum.FINLEASE.getValue().equals(loandType)) {
            return new QFilter("loantype", "=", (Object)loandType);
        }
        return new QFilter("loantype", "in", (Object)new String[]{"loan", "entrust", "ec"});
    }

    public static QFilter getDataSourceFilter(String dataSource, QFilter filter) {
        if (!EmptyUtil.isEmpty((String)dataSource)) {
            String[] split = dataSource.split(",");
            ArrayList<String> loanTypes = new ArrayList<String>(4);
            for (int i = 0; i < split.length; ++i) {
                String item = split[i];
                if (!EmptyUtil.isNotEmpty((CharSequence)item)) continue;
                if ("bankloan".equals(item)) {
                    loanTypes.add(LoanTypeEnum.BANKLOAN.getValue());
                    loanTypes.add(LoanTypeEnum.BANKSLOAN.getValue());
                    continue;
                }
                if ("entrustloan".equals(item)) {
                    loanTypes.add(LoanTypeEnum.ENTRUSTLOAN.getValue());
                    loanTypes.add(LoanTypeEnum.LINKLEND.getValue());
                    continue;
                }
                if ("bond".equals(item)) {
                    loanTypes.add(LoanTypeEnum.BOND.getValue());
                    continue;
                }
                if (!"fl".equals(item) && !"finlease".equals(item)) continue;
                loanTypes.add(LoanTypeEnum.FINLEASE.getValue());
            }
            if (loanTypes.size() > 0) {
                filter.and(new QFilter("loantype", "in", loanTypes));
            }
        }
        return filter;
    }
}

