/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeFinanceFilterHelper {
    public static final String LOANBILLID = "loanbillid";

    public static QFilter loanBillQFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        Boolean includeClose = (Boolean)paramMap.get("filter_includecloseout");
        if (!includeClose.booleanValue()) {
            QFilter noCloseOffDate = new QFilter("closeoffdate", "=", null);
            Date cutOffDate = ReportCommonHelper.getCutOffDate(paramMap);
            QFilter lessThanCutOffDate = new QFilter("closeoffdate", "<=", (Object)cutOffDate).and(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue())).and(new QFilter("notrepayamount", ">", (Object)BigDecimal.ZERO));
            QFilter largeThanCutOffDate = new QFilter("closeoffdate", ">", (Object)cutOffDate);
            qFilter.and(lessThanCutOffDate.or(largeThanCutOffDate).or(noCloseOffDate));
        }
        qFilter.and(new QFilter("org.id", "in", orgIds));
        qFilter.and(TradeFinanceFilterHelper.initBizdateFitler(paramMap));
        qFilter.and(TradeFinanceFilterHelper.initFinProductFilter(paramMap));
        qFilter.and(TradeFinanceFilterHelper.initCurrencyFilter(paramMap));
        return qFilter;
    }

    public static DataSet repaymentDs(DataSet loanBillDs, Date cutoffDate) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("bizdate", "<", (Object)DateUtils.getNextDay((Date)cutoffDate, (int)1));
        List<Long> slloanBillIds = TradeFinanceFilterHelper.getloanBillIds(loanBillDs.copy().filter("loantype='sl'"), LOANBILLID);
        List<Long> notSlLoanBillIds = TradeFinanceFilterHelper.getloanBillIds(loanBillDs.filter("loantype!='sl'"), LOANBILLID);
        DataSet repaymentDs = null;
        if (EmptyUtil.isNoEmpty(notSlLoanBillIds)) {
            QFilter notSlFilter = qFilter.copy().and("loans.e_loanbill", "in", notSlLoanBillIds);
            repaymentDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_notsl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,loans.e_loanbill loanid,loans.e_repayamount repayamt,loans.buyback_entry.e_investentryid entryid,loans.buyback_entry.e_buybackamt buybackamt", (QFilter[])new QFilter[]{notSlFilter}, null).updateField("repayamt", "case when entryid>0 then buybackamt else repayamt end").select("id,repaydate,loantype,isbuyback,loanid,repayamt,entryid");
        }
        if (EmptyUtil.isNoEmpty(slloanBillIds)) {
            QFilter slFilter = qFilter.and("slentryentity.s_loanbillno", "in", slloanBillIds);
            DataSet slLoandDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_sl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,slentryentity.s_loanbillno loanid,slentryentity.s_repayamount repayamt,slentryentity.s_bank entryid", (QFilter[])new QFilter[]{slFilter}, null);
            repaymentDs = repaymentDs != null ? repaymentDs.union(slLoandDs) : slLoandDs;
        }
        return repaymentDs;
    }

    public static DataSet interestDS(List<Long> loanBillIds, Date cutoffDate, Class clazz) {
        QFilter qFilter = new QFilter("sourcebillid", "in", loanBillIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("bizdate", "<", (Object)DateUtils.getNextDay((Date)cutoffDate, (int)1));
        DataSet interestDS = QueryServiceHelper.queryDataSet((String)(clazz.getName() + "_interest"), (String)"cfm_interestbill", (String)"loantype,sourcebillid as loanbillid,convertintamt as paidintamt,slentryentity.s_bank bankid,slentryentity.s_convertintamt slpaidintamt", (QFilter[])qFilter.toArray(), null);
        interestDS = interestDS.groupBy(new String[]{LOANBILLID, "bankid", "loantype"}).sum("paidintamt").sum("slpaidintamt").finish();
        return interestDS;
    }

    public static DataSet interestRateDS(List<Long> loanBillIds, Date cutoffDate, Class clazz) {
        QFilter qFilter = new QFilter("id", "in", loanBillIds);
        qFilter.and(new QFilter("rateadjust_entry.ra_confirmdate", "<", (Object)DateUtils.getNextDay((Date)cutoffDate, (int)1)));
        DataSet intRateDS = QueryServiceHelper.queryDataSet((String)(clazz.getName() + "_interestrate"), (String)"cfm_loanbill", (String)"id as loanbillid, rateadjust_entry.ra_yearrate as intrate , rateadjust_entry.ra_confirmdate as confirmdate", (QFilter[])qFilter.toArray(), null);
        DataSet maxDS = intRateDS.copy().groupBy(new String[]{LOANBILLID}).max("confirmdate", "maxconfirmdate").finish();
        intRateDS = maxDS.leftJoin(intRateDS).on(LOANBILLID, LOANBILLID).on("maxconfirmdate", "confirmdate").select(new String[]{LOANBILLID, "intrate"}).finish();
        intRateDS = intRateDS.groupBy(new String[]{LOANBILLID}).max("intrate").finish();
        return intRateDS;
    }

    public static DataSet createEmptyDS() {
        RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    public static QFilter initCriditorFilter(Map<String, Object> paramMap) {
        String creditorType = (String)paramMap.get("filter_creditortype");
        String creditorId = (String)paramMap.get("filter_creditorid");
        QFilter qfilter = QFilter.of((String)"1==1", (Object[])new Object[0]);
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            qfilter.and(new QFilter("creditortype", "in", Arrays.asList(creditorType.split(";"))));
        }
        String creditorStr = (String)paramMap.get("filter_creditor");
        DynamicObject bankType = (DynamicObject)paramMap.get("filter_banktype");
        List<Object> idList = new ArrayList();
        if ((EmptyUtil.isNoEmpty((String)creditorId) || EmptyUtil.isNoEmpty((DynamicObject)bankType)) && !CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
            String[] ids = StringUtils.split((String)creditorId, (String)";");
            idList = Arrays.stream(ids).map(Long::valueOf).filter(o -> o != 1L && o != 2L && o != 0L).collect(Collectors.toList());
            if (idList.size() == 0 && EmptyUtil.isNoEmpty((DynamicObject)bankType)) {
                DynamicObjectCollection finorgs = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("bank_cate", "=", bankType.getPkValue())});
                idList.addAll(finorgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
            }
            if (idList.size() > 0) {
                qfilter.and("creditor", "in", idList);
            }
        }
        if (EmptyUtil.isNoEmpty((String)creditorStr) && idList.size() == 0) {
            QFilter likeCreditorNameFilter = new QFilter("textcreditor", "=", (Object)creditorStr);
            if (EmptyUtil.isEmpty((String)creditorId)) {
                likeCreditorNameFilter = new QFilter("textcreditor", "like", (Object)("%" + creditorStr + "%"));
            }
            qfilter.and(likeCreditorNameFilter);
        }
        return qfilter;
    }

    public static QFilter initBondCriditorFilter(Map<String, Object> paramMap) {
        return TradeFinanceRptHelper.getBondCreditorFilter(paramMap);
    }

    public static QFilter initSlCriditorFilter(Map<String, Object> paramMap) {
        return TradeFinanceRptHelper.getSlCreditorFilter(paramMap);
    }

    public static QFilter initBizdateFitler(Map<String, Object> paramMap) {
        String bizDate = (String)paramMap.get("bizdateranges");
        Date cutoffdate = ReportCommonHelper.getCutOffDate(paramMap);
        cutoffdate = DateUtils.truncateDate((Date)(cutoffdate == null ? DateUtils.getCurrentDate() : cutoffdate));
        QFilter filter = new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)cutoffdate, (int)1));
        Date currentDate = DateUtils.getCurrentDate();
        if (!EmptyUtil.isEmpty((String)bizDate)) {
            switch (bizDate) {
                case "thismonth": {
                    filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getFirstDayOfMonth((Date)currentDate)).and(new QFilter("bizdate", "<", (Object)DateUtils.getFirstDateOfNextMonth((Date)currentDate))));
                    break;
                }
                case "thisweek": {
                    filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getFirstDayOfWeek((Date)currentDate)).and(new QFilter("bizdate", "<", (Object)DateUtils.getNextWeekMonday((Date)currentDate))));
                    break;
                }
                case "thisday": {
                    filter.and(new QFilter("bizdate", ">=", (Object)currentDate).and(new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)currentDate, (int)1))));
                    break;
                }
            }
        }
        if (RptDateRangeEnum.CUSTOM.getValue().equals(bizDate)) {
            Date bizDateStartDate = (Date)paramMap.get("bizdateranges_startdate");
            Date bizDateEndDate = (Date)paramMap.get("bizdateranges_enddate");
            if (!EmptyUtil.isEmpty((Object)bizDateStartDate) && !EmptyUtil.isEmpty((Object)bizDateEndDate)) {
                filter.and(new QFilter("bizdate", ">=", (Object)bizDateStartDate).and(new QFilter("bizdate", "<=", (Object)bizDateEndDate)));
            }
        }
        return filter;
    }

    public static QFilter initOrgFilter(Map<String, Object> paramMap) {
        HashSet<Long> comList = new HashSet<Long>();
        Object org = paramMap.get("filter_org");
        if (org instanceof DynamicObjectCollection) {
            DynamicObjectCollection companys = (DynamicObjectCollection)org;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)companys)) {
                for (DynamicObject company : companys) {
                    comList.add(company.getLong("id"));
                }
            }
        } else if (org instanceof List) {
            comList.addAll((List)org);
        }
        if (comList.size() > 0) {
            return new QFilter("org.id", "in", comList);
        }
        RequestContext context = RequestContext.get();
        String appid = (String)paramMap.get("appid");
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgIdList((Long)context.getCurrUserId(), (String)(appid == null ? "cfm" : appid), (String)"cfm_tradefinancerpt", (String)"47150e89000000ac");
        if (orgIds != null) {
            return new QFilter("org.id", "in", (Object)orgIds);
        }
        return null;
    }

    private static QFilter initFinProductFilter(Map<String, Object> paramMap) {
        ArrayList<Long> finList = new ArrayList<Long>();
        DynamicObjectCollection finproducts = (DynamicObjectCollection)paramMap.get("filter_finproduct");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)finproducts)) {
            for (DynamicObject finproduct : finproducts) {
                finList.add(finproduct.getLong("id"));
            }
        }
        QFilter qfilter = null;
        if (finList.size() > 0) {
            qfilter = new QFilter("finproduct.id", "in", finList);
        }
        return qfilter;
    }

    public static QFilter initCurrencyFilter(Map<String, Object> paramMap) {
        ArrayList<Long> cnyList = new ArrayList<Long>();
        DynamicObjectCollection currencys = (DynamicObjectCollection)paramMap.get("filter_currencies");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)currencys)) {
            for (DynamicObject currency : currencys) {
                cnyList.add(currency.getLong("id"));
            }
        }
        QFilter qfilter = null;
        if (cnyList.size() > 0) {
            qfilter = new QFilter("currency.id", "in", cnyList);
        }
        return qfilter;
    }

    public static List<Long> getloanBillIds(DataSet loanBillDS, String field) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : loanBillDS.copy()) {
            ids.add(row.getLong(field));
        }
        return ids;
    }
}

