/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.tree.TreeNode;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeFinanceRptHelper {
    private static final String[] DIM_FIELDS = new String[]{"orgname", "creditorname", "fincreditortype", "finproductname", "loancurrencyname"};
    public static final String[] OUTGROUP_CREDITOR_TYPES = new String[]{CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue()};

    public static DataSet createEmptyDS() {
        RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    public static DataSet repaymentSlDs(List<Long> loanBillIds, Date cutoffDate) {
        QFilter qFilter = TradeFinanceRptHelper.getRepayFilter(loanBillIds, cutoffDate).and("isbuyback", "=", (Object)false).and("loantype", "=", (Object)LoanTypeEnum.BANKSLOAN.getValue());
        DataSet repaymentDS = QueryServiceHelper.queryDataSet((String)(TradeFinanceRptHelper.class.getName() + "_slrepayment"), (String)"cfm_repaymentbill", (String)"slentryentity.s_loanbillno as loanbillid , slentryentity.s_repayamount as paidamount,slentryentity.s_bank bankid", (QFilter[])qFilter.toArray(), null);
        repaymentDS = repaymentDS.groupBy(new String[]{"loanbillid", "bankid"}).sum("paidamount", "paidamount").finish();
        return repaymentDS;
    }

    public static DataSet repaymentDS(List<Long> loanBillIds, Date cutoffDate) {
        QFilter qFilter = TradeFinanceRptHelper.getRepayFilter(loanBillIds, cutoffDate).and("isbuyback", "=", (Object)false).and("loantype", "!=", (Object)LoanTypeEnum.BANKSLOAN.getValue());
        DataSet repaymentDS = QueryServiceHelper.queryDataSet((String)(TradeFinanceRptHelper.class.getName() + "_repayment"), (String)"cfm_repaymentbill", (String)"loans.e_loanbill as loanbillid , loans.e_repayamount as paidamount", (QFilter[])qFilter.toArray(), null);
        repaymentDS = repaymentDS.groupBy(new String[]{"loanbillid"}).sum("paidamount", "paidamount").finish();
        return repaymentDS;
    }

    private static QFilter getRepayFilter(List<Long> loanBillIds, Date cutoffDate) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("bizdate", "<", (Object)DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)cutoffDate, (int)1), (boolean)true)).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        if (EmptyUtil.isNoEmpty(loanBillIds)) {
            return qFilter.and("loans.e_loanbill", "in", loanBillIds);
        }
        return qFilter;
    }

    public static QFilter loanBillQFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        Boolean includeClose = (Boolean)paramMap.get("filter_includecloseout");
        if (!includeClose.booleanValue()) {
            QFilter noCloseOffDate = new QFilter("closeoffdate", "=", null);
            Date cutOffDate = ReportCommonHelper.getCutOffDate(paramMap);
            QFilter lessThanCutOffDate = new QFilter("closeoffdate", "<=", (Object)cutOffDate).and(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue())).and(new QFilter("notrepayamount", ">", (Object)BigDecimal.ZERO));
            QFilter largeThanCutOffDate = new QFilter("closeoffdate", ">", (Object)cutOffDate);
            qFilter.and(lessThanCutOffDate.or(largeThanCutOffDate).or(noCloseOffDate));
        }
        qFilter.and(new QFilter("org.id", "in", orgIds));
        qFilter.and(TradeFinanceRptHelper.initBizdateFitler(paramMap));
        qFilter.and(TradeFinanceRptHelper.initFinProductFilter(paramMap));
        qFilter.and(TradeFinanceRptHelper.initCurrencyFilter(paramMap));
        return qFilter;
    }

    public static QFilter initBizdateFitler(Map<String, Object> paramMap) {
        String bizDate = (String)paramMap.get("bizdateranges");
        Date cutoffdate = ReportCommonHelper.getCutOffDate(paramMap);
        Date currentDate = DateUtils.getCurrentDate();
        cutoffdate = DateUtils.truncateDate((Date)(cutoffdate == null ? currentDate : cutoffdate));
        QFilter filter = new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)cutoffdate, (int)1));
        if (!EmptyUtil.isEmpty((String)bizDate)) {
            switch (bizDate) {
                case "thismonth": {
                    filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getFirstDayOfMonth((Date)currentDate)).and(new QFilter("bizdate", "<", (Object)DateUtils.getFirstDateOfNextMonth((Date)currentDate))));
                    break;
                }
                case "thisweek": {
                    filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getFirstDayOfWeek((Date)currentDate)).and(new QFilter("bizdate", "<", (Object)DateUtils.getNextWeekMonday((Date)currentDate))));
                    break;
                }
                case "thisday": {
                    filter.and(new QFilter("bizdate", ">=", (Object)currentDate).and(new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)currentDate, (int)1))));
                    break;
                }
            }
        }
        if (RptDateRangeEnum.CUSTOM.getValue().equals(bizDate)) {
            Object bizDateStartDate = paramMap.get("bizdateranges_startdate");
            Object bizDateEndDate = paramMap.get("bizdateranges_enddate");
            if (EmptyUtil.isNoEmpty((Object)bizDateStartDate) && EmptyUtil.isNoEmpty((Object)bizDateEndDate)) {
                filter.and(new QFilter("bizdate", ">=", bizDateStartDate).and(new QFilter("bizdate", "<=", bizDateEndDate)));
            }
        }
        return filter;
    }

    public static QFilter initFinProductFilter(Map<String, Object> paramMap) {
        ArrayList<Long> finList = new ArrayList<Long>();
        DynamicObjectCollection finproducts = (DynamicObjectCollection)paramMap.get("filter_finproduct");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)finproducts)) {
            for (DynamicObject finproduct : finproducts) {
                finList.add(finproduct.getLong("id"));
            }
        }
        QFilter qfilter = null;
        if (finList.size() > 0) {
            qfilter = new QFilter("finproduct.id", "in", finList);
        }
        return qfilter;
    }

    public static QFilter initCurrencyFilter(Map<String, Object> paramMap) {
        ArrayList<Long> cnyList = new ArrayList<Long>();
        DynamicObjectCollection currencys = (DynamicObjectCollection)paramMap.get("filter_currencies");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)currencys)) {
            for (DynamicObject currency : currencys) {
                cnyList.add(currency.getLong("id"));
            }
        }
        QFilter qfilter = null;
        if (cnyList.size() > 0) {
            qfilter = new QFilter("currency.id", "in", cnyList);
        }
        return qfilter;
    }

    public static Set<Long> getBondIds(DataSet dataSet) {
        HashSet<Long> ids = new HashSet<Long>(16);
        dataSet.copy().forEach(o -> ids.add(o.getLong("loanbillid")));
        return ids;
    }

    public static QFilter getCreditorFilter(Map<String, Object> paramMap, String loanType) {
        QFilter typeFilter = null;
        String creditorType = (String)paramMap.get("filter_creditortype");
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            typeFilter = LoanTypeEnum.BOND.getValue().equals(loanType) ? new QFilter("investor_entry.e_investortype", "=", (Object)creditorType) : new QFilter("creditortype", "=", (Object)creditorType);
        }
        QFilter credFilter = null;
        String creditor = (String)paramMap.get("filter_creditor");
        if ((typeFilter != null || typeFilter == null && EmptyUtil.isNoEmpty((String)creditor)) && EmptyUtil.isNoEmpty((String)creditor)) {
            if (CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                credFilter = TradeFinanceRptHelper.getLikeCreditorNameFilter(loanType, creditor);
            } else {
                String creditorId = (String)paramMap.get("filter_creditorid");
                credFilter = TradeFinanceRptHelper.getInCreditorIdFilter(loanType, creditorId);
            }
        }
        return typeFilter != null ? typeFilter.and(credFilter) : credFilter;
    }

    private static QFilter getLikeCreditorNameFilter(String loanType, String creditor) {
        String creditorName = "%" + creditor + "%";
        QFilter credFilter = LoanTypeEnum.BANKSLOAN.getValue().equals(loanType) ? new QFilter("banksyndicate_entry.e_bank.name", "like", (Object)creditorName) : (LoanTypeEnum.BOND.getValue().equals(loanType) ? new QFilter("investor_entry.e_investorname", "like", (Object)creditorName) : new QFilter("textcreditor", "like", (Object)creditorName));
        return credFilter;
    }

    private static QFilter getInCreditorIdFilter(String loanType, String creditorId) {
        String[] ids = StringUtils.split((String)creditorId, (String)";");
        List idList = Arrays.stream(ids).map(Long::valueOf).collect(Collectors.toList());
        QFilter credFilter = LoanTypeEnum.BANKSLOAN.getValue().equals(loanType) ? new QFilter("banksyndicate_entry.e_bank.id", "in", idList) : (LoanTypeEnum.BOND.getValue().equals(loanType) ? new QFilter("investor_entry.e_investorid", "in", idList) : new QFilter("creditor", "in", idList));
        return credFilter;
    }

    public static QFilter getLoanTypeFilter(String loanType) {
        QFilter qFilter = LoanTypeEnum.BANKSLOAN.getValue().equals(loanType) ? new QFilter("loantype", "=", (Object)loanType).and(new QFilter("banksyndicate_entry.id", "!=", (Object)0)) : (LoanTypeEnum.BOND.getValue().equals(loanType) ? new QFilter("loantype", "=", (Object)loanType).and(new QFilter("investor_entry.id", "!=", (Object)0)) : (LoanTypeEnum.FINLEASE.getValue().equals(loanType) || LoanTypeEnum.BANKLOAN.getValue().equals(loanType) ? new QFilter("loantype", "=", (Object)loanType) : new QFilter("loantype", "in", (Object)new String[]{"entrust", "ec"})));
        return qFilter;
    }

    public static List<String> getGroupFieldByDim(String statdim) {
        String[] groupFields = statdim.split(",");
        List<String> groupFieldList = Arrays.stream(groupFields).collect(Collectors.toList());
        groupFieldList.add("loancurrency");
        return groupFieldList;
    }

    public static DataSet transToBankCate(DataSet loanBillDS) {
        DataSet bankLoanDs = loanBillDS.copy().filter("creditortype = 'bank'");
        HashSet<Long> bankIds = new HashSet<Long>(16);
        bankLoanDs.forEach(bankLoan -> bankIds.add(bankLoan.getLong("creditorid")));
        final Map<Long, String> bankCateMap = TradeFinanceRptHelper.getBankCateMap(bankIds);
        final RowMeta rowMeta = loanBillDS.getRowMeta();
        return loanBillDS.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                boolean isBankLoan = CreditorTypeEnum.BANK.getValue().equals(row.getString("creditortype"));
                for (String fieldName : rowMeta.getFieldNames()) {
                    if (isBankLoan && "creditorname".equals(fieldName)) {
                        String bankCateName = (String)bankCateMap.get(row.getLong("creditorid"));
                        rowInfo.add(EmptyUtil.isNoEmpty((String)bankCateName) ? bankCateName : row.get(fieldName));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    public static Map<Long, String> getBankCateMap(Set<Long> bankIds) {
        DataSet bankDs = TradeFinanceRptHelper.getBankDs(bankIds);
        HashSet bakcgIds = new HashSet(16);
        bankDs.copy().forEach(bank -> bakcgIds.add(bank.getLong("bankcgid")));
        QFilter bankcgQF = new QFilter("id", "in", bakcgIds);
        DataSet bankcgDs = QueryServiceHelper.queryDataSet((String)(TradeFinanceRptHelper.class.getName() + "_bankcgsetting"), (String)"bd_bankcgsetting", (String)"id bankcgid,name bankcgname", (QFilter[])bankcgQF.toArray(), null);
        DataSet bankcgNameDs = bankDs.join(bankcgDs).on("bankcgid", "bankcgid").select(new String[]{"bankid", "bankcgname"}).finish();
        HashMap<Long, String> bankCgNameMap = new HashMap<Long, String>(16);
        bankcgNameDs.forEach(b -> bankCgNameMap.put(b.getLong("bankid"), b.getString("bankcgname")));
        return bankCgNameMap;
    }

    public static DataSet getBankDs(Set<Long> bankIds) {
        QFilter bankQF = new QFilter("id", "in", bankIds);
        DataSet bankDs = QueryServiceHelper.queryDataSet((String)(TradeFinanceRptHelper.class.getName() + "_bank"), (String)CreditorTypeEnum.BANK.getFormId(), (String)"id bankid, bank_cate bankcgid", (QFilter[])bankQF.toArray(), null);
        return bankDs;
    }

    public static DataSet groupAndSumDataSet(DataSet rowSet, String[] groupFields, String[] sumFields) {
        DataSet dsTemp = rowSet.copy();
        GroupbyDataSet gdsTemp = dsTemp.groupBy(groupFields);
        for (String sumField : sumFields) {
            gdsTemp.sum(sumField);
        }
        return gdsTemp.finish();
    }

    public static DataSet addPaidAmtField(DataSet loanBillDS, Date cutoffdate) {
        DataSet notSlorbackRepayDs;
        if (loanBillDS.isEmpty()) {
            return loanBillDS;
        }
        QFilter filter = TradeFinanceRptHelper.getRepayFilter(null, cutoffdate);
        DataSet repaymentDs = TradeFinanceRptHelper.getRepaymentDs(loanBillDS, filter);
        if (repaymentDs == null) {
            return loanBillDS;
        }
        loanBillDS = loanBillDS.updateField("notrepayamt", "drawamount");
        DataSet slorbackRepayDs = repaymentDs.copy().filter("loantype='sl' or isbuyback").groupBy(new String[]{"loanid", "entryid"}).sum("repayamt").finish();
        if (!slorbackRepayDs.isEmpty()) {
            loanBillDS = loanBillDS.leftJoin(slorbackRepayDs).on("loanbillid", "loanid").on("entryid", "entryid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"repayamt vrepayamt"}).finish().updateField("repayamt", "case when vrepayamt!=null then vrepayamt else 0 end").updateField("notrepayamt", "notrepayamt-repayamt").removeFields(new String[]{"vrepayamt"});
        }
        if (!(notSlorbackRepayDs = repaymentDs.copy().filter("loantype!='sl' and !isbuyback").groupBy(new String[]{"loanid"}).sum("repayamt").finish()).isEmpty()) {
            DataSet loanRepayAmountDs = loanBillDS.copy().groupBy(new String[]{"loanbillid"}).sum("drawamount").sum("repayamt").finish().updateField("repayamt", "case when repayamt=null then 0 else repayamt end");
            loanBillDS = loanBillDS.leftJoin(loanRepayAmountDs).on("loanbillid", "loanbillid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"drawamount1-repayamt totaldrawamount"}).finish();
            loanBillDS = loanBillDS.leftJoin(notSlorbackRepayDs).on("loanbillid", "loanid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"case when repayamt!=null then repayamt*notrepayamt/totaldrawamount else 0 end repayamtrate"}).finish().updateField("repayamt1", "repayamtrate");
        }
        return loanBillDS.updateFields(new String[]{"repayamt", "repayamt1"}, new String[]{"case when repayamt = null then 0 else repayamt end", "case when repayamt1 = null then 0 else repayamt1 end"}).addField("repayamt+repayamt1", "paidamt").addField("drawamount-paidamt", "unpaidamt").updateField("paidamt", "case when paidamt>drawamount then drawamount else paidamt end").updateField("unpaidamt", "case when unpaidamt>0 then unpaidamt else 0 end");
    }

    public static DataSet getRepaymentDs(DataSet loanBillDs, QFilter filter) {
        List<Long> slloanBillIds = TradeFinanceRptHelper.getLoanBillIds(loanBillDs.copy().filter("loantype='sl'"));
        List<Long> notSlLoanBillIds = TradeFinanceRptHelper.getLoanBillIds(loanBillDs.filter("loantype!='sl'"));
        DataSet repaymentDs = null;
        if (EmptyUtil.isNoEmpty(notSlLoanBillIds)) {
            QFilter notSlFilter = filter.copy().and("loans.e_loanbill", "in", notSlLoanBillIds);
            repaymentDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_notsl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,loans.e_loanbill loanid,loans.e_repayamount repayamt,loans.buyback_entry.e_investentryid entryid,loans.buyback_entry.e_buybackamt buybackamt", (QFilter[])new QFilter[]{notSlFilter}, null).updateField("repayamt", "case when entryid>0 then buybackamt else repayamt end").select("id,repaydate,loantype,isbuyback,loanid,repayamt,entryid");
        }
        if (EmptyUtil.isNoEmpty(slloanBillIds)) {
            QFilter slFilter = filter.and("slentryentity.s_loanbillno", "in", slloanBillIds);
            DataSet slLoandDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_sl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,slentryentity.s_loanbillno loanid,slentryentity.s_repayamount repayamt,slentryentity.s_bank entryid", (QFilter[])new QFilter[]{slFilter}, null);
            repaymentDs = repaymentDs != null ? repaymentDs.union(slLoandDs) : slLoandDs;
        }
        return repaymentDs;
    }

    public static List<Long> getLoanBillIds(DataSet loanBillDS) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        loanBillDS.copy().forEach(row -> ids.add(row.getLong("loanbillid")));
        return ids;
    }

    public static void initQueryColumn(IReportView view, String statdim, boolean showStep) {
        String[] dimFields;
        ReportList listTable = (ReportList)view.getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(columns.size());
        for (String dim : dimFields = statdim.split(",")) {
            for (AbstractReportColumn column : columns) {
                ReportColumn reportColumn;
                if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().equals(dim)) continue;
                rebuildColumns.add(reportColumn);
            }
        }
        Set allDimSet = Arrays.stream(DIM_FIELDS).collect(Collectors.toSet());
        List<String> amts = Arrays.asList("drawamount", "unpaidamt");
        if (showStep) {
            rebuildColumns.removeIf(c -> ((ReportColumn)c).getFieldKey().equals("loancurrencyname"));
        }
        String formId = view.getFormShowParameter().getFormId();
        for (AbstractReportColumn column : columns) {
            if (rebuildColumns.contains(column) || allDimSet.contains(((ReportColumn)column).getFieldKey()) || showStep && amts.contains(((ReportColumn)column).getFieldKey())) continue;
            rebuildColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public static String getOrgRootId(String orgViewNumber) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(orgViewNumber);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode != null ? rootNode.getId() : null;
    }

    @Deprecated
    public static Long getExchageTableId(Long orgId) {
        return TmcBusinessBaseHelper.getExchageTableId((Long)orgId);
    }

    public static DataSet genId(List ids, DataSet dataSet) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Field[] fs = dataSet.getRowMeta().getFields();
        for (Row row : dataSet) {
            Object[] arr = new Object[fs.length];
            for (int i = 0; i < fs.length; ++i) {
                String name = fs[i].getName();
                arr[i] = row.get(name);
                if (!ids.contains(name)) continue;
                arr[i] = DBServiceHelper.genGlobalLongId();
            }
            list.add(arr);
        }
        return Algo.create((String)"EmptyDataSet").createDataSet(list, dataSet.getRowMeta());
    }

    public static QFilter getSlCreditorFilter(Map<String, Object> paramMap) {
        DynamicObject bankType;
        String[] ids;
        QFilter creditorTypeFilter = new QFilter("loantype", "=", (Object)LoanTypeEnum.BANKSLOAN.getValue());
        String creditorType = (String)paramMap.get("filter_creditortype");
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            if (!CreditorTypeEnum.FINORG.getValue().equals(creditorType) && !CreditorTypeEnum.BANK.getValue().equals(creditorType)) {
                return QFilter.of((String)"1!=1", (Object[])new Object[0]);
            }
            if (CreditorTypeEnum.FINORG.getValue().equals(creditorType)) {
                creditorTypeFilter.and("banksyndicate_entry.e_bank.finorgtype.type", "!=", (Object)FinOrgTypeEnum.BANK.getValue());
            }
            if (CreditorTypeEnum.BANK.getValue().equals(creditorType)) {
                creditorTypeFilter.and("banksyndicate_entry.e_bank.finorgtype.type", "=", (Object)FinOrgTypeEnum.BANK.getValue());
            }
        }
        String creditorText = (String)paramMap.get("filter_creditor");
        String creditorId = (String)paramMap.get("filter_creditorid");
        List<Object> idList = new ArrayList();
        if (EmptyUtil.isNoEmpty((String)creditorId) && (idList = Arrays.stream(ids = StringUtils.split((String)creditorId, (String)";")).map(Long::valueOf).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList())).size() > 0) {
            creditorTypeFilter.and("banksyndicate_entry.e_bank", "in", idList);
        }
        if (EmptyUtil.isNoEmpty((String)creditorText) && idList.size() == 0) {
            QFilter likeCreditorNameFilter = TradeFinanceRptHelper.getLikeCreditorNameFilter(LoanTypeEnum.BANKSLOAN.getValue(), creditorText);
            creditorTypeFilter.and(likeCreditorNameFilter);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(bankType = (DynamicObject)paramMap.get("filter_banktype")))) {
            creditorTypeFilter.and("banksyndicate_entry.e_bank.bank_cate", "=", bankType.getPkValue());
        }
        return creditorTypeFilter;
    }

    public static QFilter getBondCreditorFilter(Map<String, Object> paramMap) {
        QFilter creditorTypeFilter = new QFilter("loantype", "=", (Object)LoanTypeEnum.BOND.getValue());
        String creditorType = (String)paramMap.get("filter_creditortype");
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            creditorTypeFilter.and("investor_entry.e_investortype", "=", (Object)creditorType);
        }
        String creditorText = (String)paramMap.get("filter_creditor");
        String creditorId = (String)paramMap.get("filter_creditorid");
        DynamicObject bankType = (DynamicObject)paramMap.get("filter_banktype");
        List<Object> idList = new ArrayList();
        if ((EmptyUtil.isNoEmpty((String)creditorId) || EmptyUtil.isNoEmpty((DynamicObject)bankType)) && !CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
            String[] ids = StringUtils.split((String)creditorId, (String)";");
            idList = Arrays.stream(ids).map(Long::valueOf).filter(o -> o != 1L && o != 2L && o != 0L).collect(Collectors.toList());
            if (idList.size() == 0 && EmptyUtil.isNoEmpty((DynamicObject)bankType)) {
                DynamicObjectCollection finorgs = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("bank_cate", "=", bankType.getPkValue())});
                idList.addAll(finorgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
            }
            if (idList.size() > 0) {
                creditorTypeFilter.and("investor_entry.e_investorid", "in", idList);
            }
        }
        if (EmptyUtil.isNoEmpty((String)creditorText) && idList.size() == 0) {
            QFilter likeCreditorNameFilter = new QFilter("investor_entry.e_investorname", "=", (Object)creditorText);
            if (EmptyUtil.isEmpty((String)creditorId)) {
                likeCreditorNameFilter = TradeFinanceRptHelper.getLikeCreditorNameFilter(LoanTypeEnum.BOND.getValue(), creditorText);
            }
            creditorTypeFilter.and(likeCreditorNameFilter);
        }
        return creditorTypeFilter;
    }

    public static boolean isAddOther(Map<String, Object> paramMap) {
        Object creditorType = paramMap.get("filter_creditortype");
        Object creditor = paramMap.get("filter_creditor");
        Object creditorId = paramMap.get("filter_creditorid");
        return EmptyUtil.isEmpty((Object)creditorType) && EmptyUtil.isEmpty((Object)creditor) || TradeFinanceRptHelper.isOnlyOther(creditorId) || TradeFinanceRptHelper.isOther(creditorId);
    }

    public static boolean isOnlyOther(Object creditorId) {
        return EmptyUtil.isNoEmpty((Object)creditorId) && "1".equals(String.valueOf(creditorId));
    }

    public static boolean isOther(Object creditorId) {
        return TradeFinanceRptHelper.isOnlyOther(creditorId) || EmptyUtil.isNoEmpty((Object)creditorId) && "2".equals(String.valueOf(creditorId));
    }
}

