/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.apply;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.tmc.cfm.mservice.compcost.CompCostServiceImpl;
import kd.tmc.fbp.common.bean.CompCostBean;
import kd.tmc.fbp.common.bean.CompCostRateBean;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplyCostEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"textcost"});
    }

    public void afterCreateNewData(EventObject e) {
        this.schemeControlEvt(true, false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.schemeControlEvt(false, false);
        this.calcFactCompCost();
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof TextEdit && StringUtils.equals((CharSequence)"textcost", (CharSequence)((TextEdit)evt.getSource()).getFieldKey())) {
            ((BasedataEdit)this.getControl("samplecost")).click();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "isneedscheme": {
                this.schemeControlEvt(true, false);
                break;
            }
            case "startdate": 
            case "enddate": 
            case "amount": 
            case "interestrate": {
                this.calcInstCostAmt();
                break;
            }
            case "samplecost": {
                this.sampleCostEvt();
                break;
            }
            case "costamt": {
                this.calcCompCostAmt();
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        this.schemeControlEvt(false, true);
        this.calcCompCostAmt();
    }

    private void schemeControlEvt(boolean isNewData, boolean isByImport) {
        boolean needScheme = (Boolean)this.getModel().getValue("isneedscheme");
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"costpanel"}, (!needScheme ? 1 : 0) != 0);
        int entryRowCount = this.getModel().getEntryRowCount("costentry");
        if (!needScheme && isNewData || !isNewData && entryRowCount < 1 || isByImport) {
            this.getModel().deleteEntryData("costentry");
            this.getModel().insertEntryRow("costentry", 1);
            String textCost = ResManager.loadKDString((String)"\u5229\u606f", (String)"LoanApplySchemeEditPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"textcost", (Object)textCost, (int)0);
            this.calcInstCostAmt();
        }
        if (entryRowCount > 0) {
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"textcost", "costrate", "costamt"});
        }
    }

    private void sampleCostEvt() {
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        DynamicObject sampleCost = (DynamicObject)this.getModel().getValue("samplecost");
        if (!isNeedScheme && null != sampleCost) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("costentry");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cost", (Object)sampleCost, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"textcost", (Object)sampleCost.getString("name"), (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"samplecost", null);
        }
    }

    private void calcInstCostAmt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal rate = (BigDecimal)this.getModel().getValue("interestrate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"costrate", (Object)rate, (int)0);
        BigDecimal costAmt = BigDecimal.ZERO;
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate, amount, rate})) {
            int termDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1;
            costAmt = rate.multiply(new BigDecimal(termDays)).multiply(amount).divide(new BigDecimal(36500), amount.scale(), 4);
        }
        this.getModel().setValue("costamt", (Object)costAmt, 0);
    }

    private void calcCompCostAmt() {
        DynamicObjectCollection costEntry = this.getModel().getEntryEntity("costentry");
        BigDecimal costAmt = costEntry.stream().map(v -> v.getBigDecimal("costamt")).filter(EmptyUtil::isNoEmpty).reduce(BigDecimal.ZERO, BigDecimal::add);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"compcost", (Object)costAmt);
        this.calcCompCostRate();
    }

    private void calcCompCostRate() {
        BigDecimal compCost = (BigDecimal)this.getModel().getValue("compcost");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        BigDecimal compCostRate = BigDecimal.ZERO;
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{compCost, amount, startDate, endDate}) && DateUtils.getDiffDays((Date)startDate, (Date)endDate) > 1) {
            int termDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1;
            compCostRate = compCost.multiply(new BigDecimal(36500)).divide(amount.multiply(new BigDecimal(termDays)), amount.scale(), 4);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"compcostrate", (Object)compCostRate);
    }

    private void calcFactCompCost() {
        String costRateProp;
        String costProp;
        Long applyId = (Long)this.getModel().getValue("id");
        CompCostServiceImpl compCostService = new CompCostServiceImpl();
        List costBeans = compCostService.calcCompCostForApply(Collections.singletonList(applyId));
        boolean isScheme = (Boolean)this.getModel().getValue("isneedscheme");
        String string = costProp = isScheme ? "factcompcost_scheme" : "factcompcost";
        if (EmptyUtil.isNoEmpty((Object)costBeans)) {
            this.getModel().setValue(costProp, (Object)((CompCostBean)costBeans.get(0)).getCostAmt());
        }
        List rateBeans = compCostService.calCompCostRateForApply(costBeans);
        String string2 = costRateProp = isScheme ? "factcompcostrate_scheme" : "factcompcostrate";
        if (EmptyUtil.isNoEmpty((Object)rateBeans)) {
            this.getModel().setValue(costRateProp, (Object)((CompCostRateBean)rateBeans.get(0)).getRateAmt());
        }
    }
}

