/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.apply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.GuaranteeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplyEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final Long INNER_LOAN_ID = 1312902938536014848L;
    private static final Log logger = LogFactory.getLog(LoanApplyEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit rateTypeF7 = (BasedataEdit)this.getControl("ratetype");
        rateTypeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finProductF7 = (BasedataEdit)this.getControl("finproduct");
        finProductF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountBankF7 = (BasedataEdit)this.getControl("accountbank");
        accountBankF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDeftCurrency();
        Date startDate = (Date)this.getModel().getValue("startdate");
        startDate = EmptyUtil.isNoEmpty((Object)startDate) ? startDate : DateUtils.getCurrentDate();
        this.getModel().setValue("startdate", (Object)startDate);
        Date endDate = DateUtils.getNextYear((Date)startDate, (int)1);
        this.getModel().setValue("enddate", (Object)endDate);
        this.getModel().setValue("term", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("bizdate", (Object)DateUtils.getCurrentTime());
        this.isNeedSchemeChgEvt();
        String interestType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.isAgree((String)interestType)) {
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        IDataEntityProperty iDataEntityProperty = e.getProperty();
        switch (propertyName = iDataEntityProperty.getName()) {
            case "creditortype": {
                this.creditorTypeChgEvt();
                this.setRepayWayComboList();
                break;
            }
            case "startdate": 
            case "enddate": {
                this.termDateChgEvt(propertyName, (Date)e.getChangeSet()[0].getOldValue());
                break;
            }
            case "term": {
                this.calcEndDate();
                break;
            }
            case "interesttype": {
                this.interestTypeChgEvt();
                break;
            }
            case "isneedscheme": {
                this.getModel().setValue("creditortype", null);
                this.isNeedSchemeChgEvt();
                this.isNotNeedScheme();
                break;
            }
            case "ratesign": 
            case "ratefloatpoint": 
            case "ratetype": {
                this.calcInterestRate();
                break;
            }
            case "ratecyclesign": {
                this.rateCycleSignChgEvt();
                break;
            }
            case "loantype": {
                this.getModel().setValue("creditlimit", null);
                this.initCreditorTypeComb();
                this.setCreditorCaption("loantype", "textcreditor");
                break;
            }
            case "finproduct": {
                this.getModel().setValue("creditlimit", null);
                this.autoWriteRateInfo();
                break;
            }
            case "interestrate": {
                this.setRepayWayComboList();
                break;
            }
            case "s_fintype": {
                this.setCreditorCaption("s_fintype", "s_textcreditor");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName = args.getProperty().getName();
        if ("ratetype".equals(propName)) {
            this.initRateTypefilter(args);
        } else if ("finproduct".equals(propName)) {
            this.initFinproductFilter(args);
        } else if ("accountbank".equals(propName)) {
            this.initBankAcctFilter(args);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.registerMustInput();
        this.initCreditorTypeComb();
        this.setRepayWayComboList();
        this.setCreditorCaption("loantype", "textcreditor");
    }

    public void afterImportData(ImportDataEventArgs e) {
        this.calcInterestRate();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("audit".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void isNeedSchemeChgEvt() {
        this.registerMustInput();
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        if (isNeedScheme) {
            this.getModel().setValue("accountbank", null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountbank"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountbank"});
        }
    }

    private void isNotNeedScheme() {
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        if (!isNeedScheme) {
            this.getModel().setValue("loantype", (Object)LoanTypeEnum.BANKLOAN.getValue());
            this.getModel().setValue("creditortype", (Object)CreditorTypeEnum.BANK.getValue());
            this.getModel().setValue("startdate", (Object)DateUtils.getCurrentDate());
            this.getModel().setValue("guarantee", (Object)GuaranteeEnum.NONE.getValue());
        }
    }

    private void interestTypeChgEvt() {
        IDataModel model = this.getModel();
        String interestType = (String)model.getValue("interesttype");
        if (StringUtils.equals((CharSequence)interestType, (CharSequence)InterestTypeEnum.FLOAT.getValue())) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"ratecyclesign", (Object)"M");
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"ratetype"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"ratecyclesign", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"ratecycle", null);
        }
        this.calcInterestRate();
    }

    private void creditorTypeChgEvt() {
        IDataModel model = this.getModel();
        model.setValue("finproduct", null);
        model.setValue("creditlimit", null);
        model.setValue("accountbank", null);
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)INNER_LOAN_ID)};
            DynamicObject product = BusinessDataServiceHelper.loadSingle((String)"cfm_financingvarieties", (String)"id", (QFilter[])qFilters);
            if (product != null) {
                this.getModel().setValue("finproduct", (Object)product);
                this.getView().setEnable(Boolean.TRUE, new String[]{"interestrate", "interesttype", "ratetype", "ratesign", "ratefloatpoint"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"interestrate", "interesttype", "ratetype", "ratesign", "ratefloatpoint"});
            }
        }
    }

    private void rateCycleSignChgEvt() {
        IDataModel model = this.getModel();
        if (EmptyUtil.isEmpty((Object)model.getValue("ratecyclesign"))) {
            model.setValue("ratecyclesign", (Object)"M");
        }
    }

    private void calcInterestRate() {
        IDataModel model = this.getModel();
        String interestType = (String)model.getValue("interesttype");
        if (EmptyUtil.isEmpty((String)interestType) || InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) {
            return;
        }
        String rateSign = (String)model.getValue("ratesign");
        if (EmptyUtil.isEmpty((String)rateSign)) {
            rateSign = RateSignEnum.ADD.getValue();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"ratesign", (Object)rateSign);
        }
        DynamicObject referRate = (DynamicObject)model.getValue("ratetype");
        Date startDate = (Date)model.getValue("startdate");
        if (null == referRate || null == startDate) {
            model.setValue("interestrate", (Object)0);
            return;
        }
        BigDecimal rate = MarketDataServiceHelper.referRate((String)referRate.getString("number"), (Date)startDate, (boolean)false);
        if (EmptyUtil.isEmpty((BigDecimal)rate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"interestrate", null);
            return;
        }
        BigDecimal rateFloatPoint = (BigDecimal)model.getValue("ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if (StringUtils.equals((CharSequence)RateSignEnum.SUBTRACT.getValue(), (CharSequence)rateSign)) {
            rateFloat = rateFloat.negate();
        }
        model.setValue("interestrate", (Object)rate.add(rateFloat));
    }

    private void registerMustInput() {
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isNeedScheme ? 1 : 0) != 0, (String[])new String[]{"finproduct", "loantype", "creditortype", "textcreditor", "startdate", "term", "enddate", "guarantee"});
    }

    private void setDeftCurrency() {
        DynamicObject fundsOrg = (DynamicObject)this.getModel().getValue("company");
        DynamicObject accountOrg = TmcOrgDataHelper.getAccountOrgByFundsOrg((DynamicObject)fundsOrg);
        if (EmptyUtil.isEmpty((DynamicObject)accountOrg)) {
            return;
        }
        DynamicObject currency = TmcBusinessBaseHelper.getBaseCurrency((long)accountOrg.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            this.getModel().setValue("currency", currency.getPkValue());
        }
    }

    private void initRateTypefilter(BeforeF7SelectEvent args) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (null != currency) {
            qFilters.add(new QFilter("currency", "in", currency.getPkValue()));
        } else {
            qFilters.add(new QFilter("currency", "=", (Object)0));
        }
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    private void initFinproductFilter(BeforeF7SelectEvent args) {
        ArrayList<QFilter> qfiters = new ArrayList<QFilter>(4);
        ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (EmptyUtil.isEmpty((String)creditorType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u7c7b\u578b\u3002", (String)"LoanApplySchemeEditPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            Object creditor = this.getModel().getValue("creditor");
            if (EmptyUtil.isEmpty((Object)creditor)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u3002", (String)"LoanApplyEditPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"FinancingSchemeEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("currency", "=", currency.getPkValue()), new QFilter("center.id", "=", creditor), new QFilter("servicecategory", "=", (Object)"B")};
            DynamicObject[] ldproducts = TmcDataServiceHelper.load((String)"ifm_ldproduct", (String)"id", (QFilter[])filters);
            List ids = Arrays.stream(ldproducts).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfiters.add(new QFilter("id", "in", ids));
            qfiters.add(new QFilter("biztype", "=", (Object)"ifm"));
            showParameter.getCustomParams().put("containDefault", "true");
            showParameter.setCaption(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u8d37\u6b3e\u4ea7\u54c1", (String)"LoanApplyEditPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        } else {
            qfiters.add(new QFilter("biztype", "=", (Object)"cfm"));
        }
        qfiters.add(new QFilter("finsource", "!=", (Object)"bond"));
        logger.info("Finproduct qfiter={},", (Object)((Object)qfiters).toString());
        showParameter.getListFilterParameter().getQFilters().addAll(qfiters);
    }

    private void initBankAcctFilter(BeforeF7SelectEvent args) {
        ArrayList<QFilter> qfiters = new ArrayList<QFilter>(2);
        qfiters.add(new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()));
        ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        if (!isNeedScheme) {
            String creditorType = (String)this.getModel().getValue("creditortype");
            if (EmptyUtil.isEmpty((String)creditorType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u7c7b\u578b\u3002", (String)"LoanApplySchemeEditPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                qfiters.add(new QFilter("bank", "=", this.getModel().getValue("creditor")));
                qfiters.add(new QFilter("acctclassify", "=", (Object)"I"));
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u501f\u6b3e\u5e01\u79cd\u3002", (String)"LoanApplySchemeEditPlugin_7", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                qfiters.add(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
            } else {
                qfiters.add(new QFilter("acctclassify", "!=", (Object)"I"));
            }
        }
        showParameter.getListFilterParameter().setQFilters(qfiters);
    }

    private void calcEndDate() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startdate = scheme.getDate("startdate");
        String termStr = scheme.getString("term");
        if (null == startdate || EmptyUtil.isEmpty((String)termStr)) {
            return;
        }
        Date endDate = TermHelper.getDateByTerm((String)termStr, (Date)startdate);
        this.getModel().setValue("enddate", (Object)endDate);
    }

    private void calcTerm() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startdate = scheme.getDate("startdate");
        Date endDate = scheme.getDate("enddate");
        if (null == startdate || null == endDate) {
            return;
        }
        String term = DateUtils.getDiff_ymd((Date)startdate, (Date)endDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)term);
    }

    private void initCreditorTypeComb() {
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        if (isNeedScheme) {
            return;
        }
        String loanType = (String)this.getModel().getValue("loantype");
        List<String> comboItemValues = StringUtils.equals((CharSequence)LoanTypeEnum.BANKLOAN.getValue(), (CharSequence)loanType) ? Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.SETTLECENTER.getValue()) : (StringUtils.equals((CharSequence)LoanTypeEnum.BANKSLOAN.getValue(), (CharSequence)loanType) ? Collections.singletonList(CreditorTypeEnum.BANK.getValue()) : (StringUtils.equals((CharSequence)LoanTypeEnum.FINLEASE.getValue(), (CharSequence)loanType) ? Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue()) : Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue())));
        TmcViewInputHelper.resetComboItems(comboItemValues, (String)"creditortype", (IFormView)this.getView());
    }

    private void autoWriteRateInfo() {
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"interestrate", "interesttype", "ratetype", "ratesign", "ratefloatpoint"});
            return;
        }
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (finProduct == null) {
            this.getModel().setValue("ratetype", null);
            this.getModel().setValue("ratesign", null);
            this.getModel().setValue("ratefloatpoint", null);
            this.getModel().setValue("interestrate", null);
            this.getModel().setValue("interesttype", null);
            return;
        }
        DynamicObject ldProduct = QueryServiceHelper.queryOne((String)"ifm_ldproduct", (String)"id,ratetype,basis,floatrate,productprice,referrate,ratesignbp,ratefloatpoints", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finProduct.getLong("id"))});
        if (ldProduct == null) {
            return;
        }
        Long id = ldProduct.getLong("id");
        if (INNER_LOAN_ID.equals(id)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"interestrate", "interesttype", "ratetype", "ratesign", "ratefloatpoint"});
            return;
        }
        String ratetype = ldProduct.getString("ratetype");
        boolean isFloatRate = InterestTypeEnum.FLOAT.getValue().equals(ratetype);
        this.getModel().setValue("interesttype", (Object)ratetype);
        BigDecimal productRate = ldProduct.getBigDecimal("productprice");
        if (isFloatRate) {
            this.getModel().setValue("ratetype", (Object)ldProduct.getLong("referrate"));
            this.getModel().setValue("ratesign", (Object)ldProduct.getString("ratesignbp"));
            this.getModel().setValue("ratefloatpoint", ldProduct.get("ratefloatpoints"));
        } else {
            this.getModel().setValue("interestrate", (Object)productRate);
            this.getView().setEnable(Boolean.TRUE, new String[]{"interestrate"});
        }
    }

    private void setRepayWayComboList() {
        String creditorType = (String)this.getModel().getValue("creditortype");
        BigDecimal interestRate = (BigDecimal)this.getModel().getValue("interestrate");
        List<String> comboItemValues = "settlecenter".equals(creditorType) || EmptyUtil.isEmpty((BigDecimal)interestRate) ? this.getRepaymentMode(true) : this.getRepaymentMode(false);
        TmcViewInputHelper.resetComboItems(comboItemValues, (String)"repaymentway", (IFormView)this.getView());
    }

    private void termDateChgEvt(String propName, Date oldValue) {
        if (!this.checkDate()) {
            if (StringUtils.equals((CharSequence)"startdate", (CharSequence)propName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u5fc5\u987b\u5c0f\u4e8e\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u3002", (String)"LoanApplyEditPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u9884\u8ba1\u5f00\u59cb\u65e5\u3002", (String)"LoanApplyEditPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)oldValue);
            return;
        }
        this.calcTerm();
        this.calcInterestRate();
    }

    private boolean checkDate() {
        Date enddate;
        Date startDate = (Date)this.getModel().getValue("startdate");
        return EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, enddate = (Date)this.getModel().getValue("enddate")}) || startDate.compareTo(enddate) < 0;
    }

    private List<String> getRepaymentMode(Boolean isSettleCenter) {
        ArrayList<String> comboItemValues = new ArrayList<String>(10);
        comboItemValues.add(RepaymentWayEnum.bqhblsbq.getValue());
        comboItemValues.add(RepaymentWayEnum.dqhblsbq.getValue());
        comboItemValues.add(RepaymentWayEnum.bqhbdqhx.getValue());
        comboItemValues.add(RepaymentWayEnum.dqhbdqhx.getValue());
        comboItemValues.add(RepaymentWayEnum.zdyhk.getValue());
        if (!isSettleCenter.booleanValue()) {
            comboItemValues.add(RepaymentWayEnum.debx.getValue());
            comboItemValues.add(RepaymentWayEnum.debj.getValue());
            comboItemValues.add(RepaymentWayEnum.dbdx.getValue());
        }
        return comboItemValues;
    }

    private void setCreditorCaption(String loanTypeField, String creditorField) {
        String loanType = (String)this.getModel().getValue(loanTypeField);
        FieldEdit creditor = (FieldEdit)this.getView().getControl(creditorField);
        if (this.getPageCache().get("creditor") == null) {
            this.getPageCache().put("creditor", creditor.getDisplayName().getLocaleValue());
        }
        String caption = this.getPageCache().get("creditor");
        if (LoanTypeEnum.isBanksLoan((String)loanType)) {
            caption = CfmFormResourceEnum.LoanApplyEditPlugin_5.loadKDString();
        }
        LocaleString loaclStr = new LocaleString(caption);
        creditor.setCaption(loaclStr);
    }
}

