/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.DecimalProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.mservice.compcost.CompCostServiceImpl;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class LoanApplyListPlugin
extends AbstractTmcBillBaseList {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String scene = (String)this.getView().getFormShowParameter().getCustomParams().get("SCENE");
        if (StringUtils.equals((CharSequence)scene, (CharSequence)"AUDITFLOW")) {
            e.getParameter().setFormId("cfm_loan_apply_layout");
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilter = e.getQFilters();
        String formName = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
        if (EmptyUtil.isNoEmpty((String)formName)) {
            String qcp = this.getView().getFormShowParameter().getCustomParam("billFormId").equals("fl_financelease_apply") ? "=" : "!=";
            qFilter.add(new QFilter("loantype", qcp, (Object)"finlease"));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"company.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List selectedIdList;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("selectscheme".equals(operateKey) && (selectedIdList = this.getSelectedIdList()).size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"LoanApplyListPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("pushbizdealbill".equals(operateKey)) {
            selectedIdList = this.getSelectedIdList();
            if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
                args.setCancel(true);
                return;
            }
            QFilter idQF = new QFilter("id", "in", (Object)selectedIdList);
            DynamicObject[] applyDOs = TmcDataServiceHelper.load((String)"cfm_loan_apply", (String)"id,billno, billstatus,creditortype, businessstatus", (QFilter[])idQF.toArray());
            List<DynamicObject> invalidStatusDOs = Arrays.stream(applyDOs).filter(o -> !BillStatusEnum.AUDIT.getValue().equals(o.getString("billstatus"))).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(invalidStatusDOs)) {
                args.setCancel(true);
                ArrayList billNos = new ArrayList(invalidStatusDOs.size());
                invalidStatusDOs.forEach(d -> billNos.add(d.getString("billno")));
                String billNoStr = String.join((CharSequence)",", billNos);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u975e\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"LoanApplyListPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), billNoStr));
                return;
            }
            List<DynamicObject> notSettleCenterDOs = Arrays.stream(applyDOs).filter(o -> !CreditorTypeEnum.SETTLECENTER.getValue().equals(o.getString("creditortype"))).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(notSettleCenterDOs)) {
                args.setCancel(true);
                ArrayList billNos = new ArrayList(notSettleCenterDOs.size());
                notSettleCenterDOs.forEach(d -> billNos.add(d.getString("billno")));
                String billNoStr = String.join((CharSequence)",", billNos);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u503a\u6743\u4eba\u7c7b\u578b\u975e\u7ed3\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"LoanApplyListPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), billNoStr));
                return;
            }
            List bizStatusDOs = Arrays.stream(applyDOs).filter(o -> !ApplyBusinessStatusEnum.HANDING.getValue().equals(o.getString("businessstatus")) && !ApplyBusinessStatusEnum.CHARGEBACK.getValue().equals(o.getString("businessstatus"))).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(bizStatusDOs)) {
                args.setCancel(true);
                ArrayList billNos = new ArrayList(bizStatusDOs.size());
                notSettleCenterDOs.forEach(d -> billNos.add(d.getString("billno")));
                String billNoStr = String.join((CharSequence)",", billNos);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u4e1a\u52a1\u72b6\u6001\u975e\u529e\u7406\u4e2d\u548c\u5df2\u9000\u56de\u72b6\u6001\u4e0d\u80fd\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"LoanApplyListPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), billNoStr));
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("selectscheme".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Long selectedId = this.getSelectedId();
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setFormId("cfm_loan_apply_layout");
            parameter.setPkId((Object)selectedId);
            parameter.setCustomParam("selectscheme", (Object)"true");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("generatecontract".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u5408\u540c\u6210\u529f\u3002", (String)"LoanApplyListPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (EmptyUtil.isEmpty((DynamicObjectCollection)rows)) {
                    return rows;
                }
                DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
                if (!properties.containsKey((Object)"id")) {
                    return rows;
                }
                CompCostServiceImpl compCostService = new CompCostServiceImpl();
                List applyIds = rows.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
                List costBeans = compCostService.calcCompCostForApply(applyIds);
                if (EmptyUtil.isEmpty((Collection)costBeans)) {
                    return rows;
                }
                Map<Long, BigDecimal> compMap = costBeans.stream().collect(Collectors.toMap(r -> r.getBillId(), r -> r.getCostAmt(), (r1, r2) -> r1));
                List rateBeans = compCostService.calCompCostRateForApply(costBeans);
                Map<Long, BigDecimal> rateMap = rateBeans.stream().collect(Collectors.toMap(r -> r.getBillId(), r -> r.getRateAmt(), (r1, r2) -> r1));
                this.addDynamicProp(rows);
                rows.forEach(row -> {
                    this.calcCompCost((DynamicObject)row, compMap);
                    this.calcCompCostRate((DynamicObject)row, rateMap);
                });
                return rows;
            }

            private void calcCompCost(DynamicObject row, Map<Long, BigDecimal> compMap) {
                DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
                if (!properties.containsKey((Object)"factcompcost")) {
                    return;
                }
                row.set("factcompcost", (Object)compMap.get(row.getLong("id")));
            }

            private void calcCompCostRate(DynamicObject row, Map<Long, BigDecimal> rateMap) {
                DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
                if (!properties.containsKey((Object)"factcompcostrate")) {
                    return;
                }
                row.set("factcompcostrate", (Object)rateMap.get(row.getLong("id")));
            }

            private void addDynamicProp(DynamicObjectCollection rows) {
                DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
                DecimalProp addProp = new DecimalProp();
                addProp.setName("factcompcost");
                addProp.setDisplayName(new LocaleString("factcompcost"));
                properties.add((Object)addProp);
                DecimalProp rateProp = new DecimalProp();
                rateProp.setName("factcompcostrate");
                rateProp.setDisplayName(new LocaleString("factcompcostrate"));
                properties.add((Object)rateProp);
            }
        });
    }
}

