/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bankloancontract;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;

public class BankContractCreditLimitPlugin
extends AbstractCreditLimitEditPlugin {
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("banksyndicate_entry".equals(entryName)) {
            this.getModel().setValue("e_creditlimit", null, e.getRowIndexs()[0]);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = args.getOperateKey()) {
            case "audit": {
                this.afterAuditOperation(args);
            }
        }
    }

    protected void setCreditUseFields() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.isBanksLoan((String)loanType)) {
            boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
            DynamicObject productFact = (DynamicObject)this.getModel().getValue("productfactory");
            boolean isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit((DynamicObject)productFact, (String)((String)this.getModel().getValue("loantype")));
            boolean isSave = BillStatusEnum.isSave((String)((String)this.getModel().getValue("billstatus")));
            if (!isSyncDraw || isSave || !isBanksLoanLimit) {
                super.setCreditUseFields();
                int entryRowCount = this.getModel().getEntryRowCount("banksyndicate_entry");
                for (int i = 0; i < entryRowCount; ++i) {
                    Object eLimit = this.getModel().getValue("e_creditlimit", i);
                    if (!EmptyUtil.isEmpty((Object)eLimit)) continue;
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)i, (String[])new String[]{"e_creditcurrency", "e_creditamt"});
                }
            }
            this.getView().setVisible(Boolean.valueOf(!isSyncDraw || isSave || !isBanksLoanLimit), new String[]{"e_creditcurrency", "e_creditamt"});
        }
    }

    private void afterAuditOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            this.getView().updateView("banksyndicate_entry");
        }
    }

    protected Map<String, String> getCreditlimiFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(8);
        fieldMap.put("e_creditlimit", "banksyndicate_entry");
        return fieldMap;
    }

    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", "org");
        propertys.put("finorg", "e_bank");
        propertys.put("amount", this.getAmountField());
        propertys.put("currency", "currency");
        propertys.put("startDate", "startdate");
        propertys.put("endDate", "enddate");
        return propertys;
    }

    protected Set<String> getEntryFields() {
        HashSet<String> entryFields = new HashSet<String>();
        entryFields.add("e_bank");
        entryFields.add("e_shareamount");
        entryFields.add("e_creditlimit");
        return entryFields;
    }

    protected BigDecimal getAmount() {
        return (BigDecimal)this.getModel().getValue(this.getAmountField(), this.getModel().getEntryCurrentRowIndex("banksyndicate_entry"));
    }

    public boolean checkCreditlimitParams() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{this.getBizPropertys().get("org"), this.getBizPropertys().get("finorg"), this.getBizPropertys().get("currency"), this.getBizPropertys().get("amount"), "finproduct"});
    }

    protected Long getCreditTypeId() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        return CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)finProduct.getPkValue()));
    }

    protected BigDecimal setCreditRatio() {
        return Constants.ONE_HUNDRED;
    }

    protected String getCreditVariety() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        return finProduct.getString("name");
    }

    public boolean isSubmitReCreate() {
        return Boolean.FALSE;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "lenderapplyno": 
            case "loantype": 
            case "productfactory": {
                this.removeCreditLimit(null);
                break;
            }
            case "e_bank": 
            case "e_shareamount": 
            case "ra_loanbilllistap": {
                this.removeCreditLimit(this.getModel().getEntryCurrentRowIndex("banksyndicate_entry"));
                break;
            }
            case "e_creditlimit": {
                int currIdx = this.getModel().getEntryCurrentRowIndex("banksyndicate_entry");
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)currIdx, (String[])new String[]{"e_creditcurrency", "e_creditamt"});
            }
        }
    }

    private void removeCreditLimit(Integer i) {
        if (i == null) {
            for (int index = 0; index < this.getModel().getEntryRowCount("banksyndicate_entry"); ++index) {
                this.getModel().setValue("e_creditlimit", null, index);
            }
            this.getModel().deleteEntryData("banksyndicate_entry");
        } else {
            this.getModel().setValue("e_creditlimit", null, i.intValue());
        }
    }

    protected String getCreditUseAmtField() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
            return "e_creditamt";
        }
        return null;
    }

    protected String getCreditUseCurrencyField() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
            return "e_creditcurrency";
        }
        return null;
    }

    private String getAmountField() {
        String loanType;
        DynamicObject productFact = (DynamicObject)this.getModel().getValue("productfactory");
        boolean isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit((DynamicObject)productFact, (String)(loanType = (String)this.getModel().getValue("loantype")));
        if (isBanksLoanLimit) {
            return "e_loanamount";
        }
        return "e_shareamount";
    }
}

