/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bill;

import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;

public class CfmBaseBillEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(CfmBaseBillEdit.class);

    public void beforeBindData(EventObject e) {
        Map customParams;
        String parentFormId;
        super.beforeBindData(e);
        boolean isDataChange = this.getModel().getDataChanged();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String status = dataEntity.getString("billstatus");
        String dataSource = dataEntity.getString("datasource");
        String confirmStatus = dataEntity.getString("confirmstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cancelconfirm"});
        IFormView parentView = null;
        try {
            parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
        catch (Exception e1) {
            logger.error(String.format("getViewNoPlugin() error:%s", e1.getMessage()));
        }
        if (parentView != null && "bos_list".equals(parentFormId = parentView.getEntityId()) && ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus) && BillStatusEnum.AUDIT.getValue().equals(status)) {
            String entityName = this.getModel().getDataEntityType().getName();
            if (DataSourceEnum.INVEST.getValue().equals(dataSource) && entityName.startsWith("cfm") || DataSourceEnum.CFM.getValue().equals(dataSource) && entityName.startsWith("cim")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_cancelconfirm"});
            }
        }
        if (BillStatusEnum.AUDIT.getValue().equals(status)) {
            if (DataSourceEnum.CFM.getValue().equals(dataSource)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            } else if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            }
        }
        if (BillStatusEnum.SUBMIT.getValue().equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unsubmit"});
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("confirm") && ConfirmStatusEnum.WAITCONFIRM.getValue().equals(confirmStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_confirm", "bar_returnback"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_confirm", "bar_returnback"});
        }
        CfmBillCommonHelper.setVisibleWhenBotpTrance((IFormView)this.getView(), (String)status);
        this.getModel().setDataChanged(isDataChange);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "cancelconfirm": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cancelconfirm", "bar_audit", "bar_createvoucher", "bar_unaudit", "bar_check", "bar_print", "bar_refresh"});
                    String formId = this.getView().getFormShowParameter().getFormId();
                    if (formId.isEmpty()) {
                        return;
                    }
                    this.getView().invokeOperation("refresh");
                    if (formId.contains("_contract")) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_draw", "bar_extend"});
                    }
                    if (!formId.contains("_loanbill")) break;
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_repaymentsc", "bar_repayment", "bar_payinterest"});
                    break;
                }
                case "audit": 
                case "submit": 
                case "unsubmit": 
                case "unaudit": {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                return;
            }
        }
    }
}

