/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bond;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondBillBuyBackEdit
extends AbstractBasePlugIn
implements RowClickEventListener {
    private static final String BOND_LOAN_BILL_INVEST_AMT_PROP = String.join((CharSequence)",", String.join((CharSequence)".", "investor_entry", "e_investorid"), String.join((CharSequence)".", "investor_entry", "e_avalinvestamt"));
    private static final String BOND_LOAN_BILL_INVEST_PROP = String.join((CharSequence)",", "id", "investor_entry", String.join((CharSequence)".", "investor_entry", "e_investorid"), String.join((CharSequence)".", "investor_entry", "e_investortype"), String.join((CharSequence)".", "investor_entry", "e_investorname"), String.join((CharSequence)".", "investor_entry", "e_investamount"), String.join((CharSequence)".", "investor_entry", "e_avalinvestamt"));

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int rowIdx = e.getChangeSet()[0].getRowIndex();
        Object newVal = e.getChangeSet()[0].getNewValue();
        int parentRowIdx = e.getChangeSet()[0].getParentRowIndex();
        switch (key) {
            case "isbuyback": {
                this.isBuyBackEvt();
                break;
            }
            case "e_buybackamt": {
                this.buyBackAmtEvt(newVal, rowIdx, parentRowIdx);
                break;
            }
        }
    }

    private void buyBackAmtEvt(Object newVal, int rowIdx, int parentRowIdx) {
        BigDecimal realTimeAvaInvestAmt = this.getRealTimeAvaInvestAmt(rowIdx, parentRowIdx);
        this.updateAvaInvestAmt(rowIdx, parentRowIdx, realTimeAvaInvestAmt);
        if (!this.checkBuyBackAmt(newVal, realTimeAvaInvestAmt, rowIdx, parentRowIdx)) {
            return;
        }
        this.setInvestAmount(newVal, realTimeAvaInvestAmt, rowIdx, parentRowIdx);
        this.setRepayAmount(parentRowIdx);
    }

    private void setRepayAmount(int parentRowIdx) {
        DynamicObjectCollection buyBackEntries = this.getModel().getEntryEntity("buyback_entry");
        BigDecimal sumBuyBackAmt = buyBackEntries.stream().map(e -> e.getBigDecimal("e_buybackamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("e_repayamount", (Object)sumBuyBackAmt, parentRowIdx);
    }

    private void updateAvaInvestAmt(int rowIdx, int parentRowIdx, BigDecimal realTimeAvaInvestAmt) {
        BigDecimal avaInvestAmt = (BigDecimal)this.getModel().getValue("e_avalinvestamt", rowIdx, parentRowIdx);
        if (realTimeAvaInvestAmt.compareTo(avaInvestAmt) != 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_avalinvestamt", (Object)realTimeAvaInvestAmt, (int)rowIdx, (int)parentRowIdx);
        }
    }

    private boolean checkBuyBackAmt(Object newVal, BigDecimal realTimeAvaInvestAmt, int rowIdx, int parentRowIdx) {
        if (null == newVal) {
            return false;
        }
        BigDecimal buybackAmt = (BigDecimal)newVal;
        if (buybackAmt.compareTo(realTimeAvaInvestAmt) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56de\u552e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6295\u8d44\u4eba\u7684\u5269\u4f59\u6295\u8d44\u91d1\u989d\u3002", (String)"BondBillBuyBackEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_buybackamt", (Object)BigDecimal.ZERO, (int)rowIdx, (int)parentRowIdx);
            return false;
        }
        return true;
    }

    private void setInvestAmount(Object newVal, BigDecimal realTimeAvaInvestAmt, int rowIdx, int parentRowIdx) {
        if (null == newVal) {
            return;
        }
        BigDecimal avaInvestAmt = realTimeAvaInvestAmt.subtract((BigDecimal)newVal);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_avalinvestamt", (Object)avaInvestAmt, (int)rowIdx, (int)parentRowIdx);
    }

    private BigDecimal getRealTimeAvaInvestAmt(int rowIdx, int parentRowIdx) {
        Object loanBill = this.getModel().getValue("e_loanbill", parentRowIdx);
        Object investEntryId = this.getModel().getValue("e_investentryid", rowIdx, parentRowIdx);
        if (EmptyUtil.isEmpty((Object)loanBill) || EmptyUtil.isEmpty((Object)investEntryId)) {
            return BigDecimal.ZERO;
        }
        DynamicObject bondLoanBill = QueryServiceHelper.queryOne((String)"cfm_loanbill_bond", (String)BOND_LOAN_BILL_INVEST_AMT_PROP, (QFilter[])new QFilter[]{new QFilter("id", "=", ((DynamicObject)loanBill).getPkValue()).and(new QFilter("investor_entry", "=", investEntryId))});
        return EmptyUtil.isNoEmpty((DynamicObject)bondLoanBill) ? bondLoanBill.getBigDecimal(String.join((CharSequence)".", "investor_entry", "e_avalinvestamt")) : BigDecimal.ZERO;
    }

    private void isBuyBackEvt() {
        if (this.checkBuyBack()) {
            this.setBuyBackEntryInfo();
            this.getView().updateView("buyback_entry");
        } else {
            this.clearBondLoanBuybackEntry();
        }
        this.setEntryVisible();
    }

    private boolean checkBuyBack() {
        if (!((Boolean)this.getModel().getValue("isbuyback")).booleanValue()) {
            return false;
        }
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loans)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u8fd8\u6b3e\u9009\u5355\u3002", (String)"BondBillBuyBackEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("isbuyback", (Object)false);
            return false;
        }
        List loanIds = loans.stream().map(d -> d.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection bondBills = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", loanIds).and("investor_entry", "is null", null)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bondBills)) {
            List billNos = bondBills.stream().map(d -> d.getString("billno")).collect(Collectors.toList());
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u6295\u8d44\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u56de\u552e\u3002", (String)"BondBillBuyBackEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", billNos)}));
            this.getModel().setValue("isbuyback", (Object)false);
            return false;
        }
        return true;
    }

    private void setEntryVisible() {
        boolean isBuyBack = (Boolean)this.getModel().getValue("isbuyback");
        if (isBuyBack) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap_buyback"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"e_buybackamt"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_buyback"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"e_buybackamt"});
            this.clearBondLoanBuybackEntry();
        }
    }

    private void clearBondLoanBuybackEntry() {
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        for (DynamicObject loan : loans) {
            DynamicObjectCollection buybackEntry = loan.getDynamicObjectCollection("buyback_entry");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)buybackEntry)) continue;
            loan.set("buyback_entry", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean isBuyBack = (Boolean)this.getModel().getValue("isbuyback");
        if (isBuyBack) {
            this.setRepaymentAmt(BigDecimal.ZERO);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setIsBuyBackInfo();
        this.setEntryInfo();
        if (!StringUtils.equals((CharSequence)"cfm_repaymentbill_bond", (CharSequence)this.getFormId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isbuyback"});
        }
        this.setRepaymentAmtValue();
    }

    private void setRepaymentAmtValue() {
        String operationKey;
        boolean isBuyBack = (Boolean)this.getModel().getValue("isbuyback");
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView viewNoPlugin = this.getView().getViewNoPlugin(parentPageId);
        String string = operationKey = viewNoPlugin != null ? viewNoPlugin.getPageCache().get("operationKey") : "";
        if (isBuyBack && "buyback".equals(operationKey) && BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.setRepaymentAmt(BigDecimal.ZERO);
            this.getView().getParentView().getPageCache().remove("operationKey");
        }
    }

    private void setBuyBackEntryInfo() {
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loans)) {
            return;
        }
        List loanBillId = loans.stream().map(d -> d.getDynamicObject("e_loanbill").getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection bondInvestEntries = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)BOND_LOAN_BILL_INVEST_PROP, (QFilter[])new QFilter[]{new QFilter("id", "in", loanBillId)});
        Map<Long, List<DynamicObject>> bondIdAndInvestEntries = bondInvestEntries.stream().collect(Collectors.groupingBy(d -> d.getLong("id")));
        for (DynamicObject loan : loans) {
            DynamicObjectCollection buybackEntries = loan.getDynamicObjectCollection("buyback_entry");
            List<DynamicObject> investEntry = bondIdAndInvestEntries.get(loan.getDynamicObject("e_loanbill").getLong("id"));
            for (DynamicObject entry : investEntry) {
                DynamicObject buybackEntry = buybackEntries.addNew();
                buybackEntry.set("e_investortype", entry.get(String.join((CharSequence)".", "investor_entry", "e_investortype")));
                buybackEntry.set("e_investorname", entry.get(String.join((CharSequence)".", "investor_entry", "e_investorname")));
                buybackEntry.set("e_investorid", entry.get(String.join((CharSequence)".", "investor_entry", "e_investorid")));
                buybackEntry.set("e_investamount", entry.get(String.join((CharSequence)".", "investor_entry", "e_investamount")));
                buybackEntry.set("e_avalinvestamt", entry.get(String.join((CharSequence)".", "investor_entry", "e_avalinvestamt")));
                buybackEntry.set("e_buybackamt", (Object)BigDecimal.ZERO);
                buybackEntry.set("e_investentryid", entry.get("investor_entry"));
            }
        }
    }

    private void setIsBuyBackInfo() {
        if (EmptyUtil.isEmpty((Object)this.getView().getParentView())) {
            return;
        }
        String operationKey = this.getView().getParentView().getPageCache().get("operationKey");
        boolean isBuyBack = this.getModel().getDataEntity().getBoolean("isbuyback");
        if (EmptyUtil.isNoEmpty((String)operationKey)) {
            if (Arrays.asList("pushrepayment", "pushtorepaymentbill").contains(operationKey) && !isBuyBack) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"isbuyback", (Object)false);
            } else if ("buyback".equals(operationKey)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"isbuyback", (Object)true);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isbuyback"});
        }
    }

    private void setEntryInfo() {
        this.setEntryVisible();
        this.setEntryEnable();
    }

    private void setEntryEnable() {
        this.setBuyBackEntryEnable();
        this.setLoanEntryEnable();
    }

    private void setBuyBackEntryEnable() {
        int buyBackSize = this.getModel().getEntryRowCount("buyback_entry");
        for (int i = 0; i < buyBackSize; ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_investorname", "e_investortype", "e_investamount", "e_avalinvestamt"});
        }
    }

    private void setLoanEntryEnable() {
        boolean isBuyBack = (Boolean)this.getModel().getValue("isbuyback");
        if (isBuyBack || this.isEnableRepayAmount()) {
            this.setRepaymentAmtEnable(false);
        }
    }

    private boolean isEnableRepayAmount() {
        Object repaymentMode = this.getModel().getValue("repaymentway");
        return RepaymentWayEnum.debx.getValue().equals(repaymentMode) || RepaymentWayEnum.debj.getValue().equals(repaymentMode) || RepaymentWayEnum.dbdx.getValue().equals(repaymentMode);
    }

    private void setRepaymentAmtEnable(boolean enable) {
        int loanRowCount = this.getModel().getEntryRowCount("loans");
        for (int i = 0; i < loanRowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"e_repayamount"});
        }
    }

    private void setRepaymentAmt(BigDecimal value) {
        int loanRowCount = this.getModel().getEntryRowCount("loans");
        for (int i = 0; i < loanRowCount; ++i) {
            this.getModel().setValue("e_repayamount", (Object)value, i);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid loanEntryGrid = (EntryGrid)this.getControl("loans");
        if (loanEntryGrid != null) {
            loanEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control ce = (Control)evt.getSource();
        if (ce.getKey().equals("loans")) {
            this.setEntryEnable();
        }
    }

    private String getFormId() {
        return this.getView().getFormShowParameter().getFormId();
    }
}

