/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bond;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondBillPayeeInfoEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String PAYEEACCTCALLBACK = "RepaymentBillProp.HEAD_PAYEEACCTTEXT_closeCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payeebanknum = (TextEdit)this.getView().getControl("payeeaccttext");
        payeebanknum.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "payeeaccttext": {
                this.dealAndShowBankInfo();
                break;
            }
        }
    }

    private void dealAndShowBankInfo() {
        String payeeType = (String)this.getModel().getValue("payeetype");
        if (EmptyUtil.isEmpty((String)payeeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondBillPayeeInfoEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (OppUnitTypeEnum.OTHER.getValue().equals(payeeType)) {
            return;
        }
        DynamicObject payee = (DynamicObject)this.getModel().getValue("payee");
        if (EmptyUtil.isNoEmpty((DynamicObject)payee)) {
            String payeeEntityType = payee.getDataEntityType().getName();
            Object payeeId = payee.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)payeeEntityType, (CharSequence)"bd_supplier")) {
                DynamicObject innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)payee);
                if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
                    QFilter qFilter = new QFilter("id", "=", payeeId);
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)payeeEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"BondBillPayeeInfoEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            lsp = EmptyUtil.isNoEmpty(innerOrgId) ? ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId) : ListConstructorHelper.getSupplierBankInfoShowParameter((Object)payeeId);
            if (EmptyUtil.isNoEmpty((Object)lsp)) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PAYEEACCTCALLBACK);
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "RepaymentBillProp.HEAD_PAYEEACCTTEXT_closeCallBack": {
                    this.oppAcctBankCloseCallBack(selectedRows.get(0));
                }
            }
        }
    }

    private void oppAcctBankCloseCallBack(ListSelectedRow row) {
        Object entryKey = row.getEntryPrimaryKeyValue();
        DynamicObject payee = this.getModel().getDataEntity().getDynamicObject("payee");
        String entityName = payee.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName)) {
            innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)payee);
        }
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") && innerOrg == null) {
            DynamicObject oppUnitDetail = TmcDataServiceHelper.loadSingle((String)payee.getDataEntityType().getName(), (String)"id,bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
            if (EmptyUtil.isEmpty((DynamicObject)oppUnitDetail)) {
                return;
            }
            DynamicObjectCollection entryBank = oppUnitDetail.getDynamicObjectCollection("entry_bank");
            for (DynamicObject entry : entryBank) {
                if (!entry.getPkValue().equals(entryKey)) continue;
                this.getModel().setValue("payeeaccttext", (Object)entry.getString("bankaccount"));
                this.getModel().setValue("payeebank", (Object)entry.getDynamicObject("bank"));
                break;
            }
        } else if (EmptyUtil.isNoEmpty((DynamicObject)innerOrg)) {
            DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,number", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
            if (EmptyUtil.isEmpty((DynamicObject)accountbanksDO)) {
                return;
            }
            this.getModel().setValue("payeeaccttext", (Object)accountbanksDO.getString("number"));
            DynamicObject bankDO = accountbanksDO.getDynamicObject("bank");
            if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) {
                this.getModel().setValue("payeebank", (Object)bankDO.getDynamicObject("bebank"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (EmptyUtil.isNoEmpty((Object)newValue) && newValue != oldValue) {
            switch (key) {
                case "payeetype": {
                    this.clearPayeeInfo("payee", "payeetext", "payeeaccttext", "payeebank");
                    break;
                }
                case "payee": {
                    this.clearPayeeInfo("payeetext", "payeeaccttext", "payeebank");
                    this.setDefaultAcctBankVal();
                    break;
                }
            }
        }
    }

    private void clearPayeeInfo(String ... fields) {
        for (String field : fields) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, null);
        }
    }

    private void setDefaultAcctBankVal() {
        DynamicObject payee = (DynamicObject)this.getModel().getValue("payee");
        if (EmptyUtil.isNoEmpty((DynamicObject)payee)) {
            String payeeEntityType = payee.getDataEntityType().getName();
            if (OppUnitTypeEnum.SUPPLIER.getValue().equals(payeeEntityType)) {
                QFilter qFilter = new QFilter("id", "=", payee.getPkValue());
                qFilter.and("entry_bank.isdefault_bank", "=", (Object)"1");
                DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)payeeEntityType, (String)"id,entry_bank,entry_bank.bankaccount,entry_bank.bank", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)entryBankDO)) {
                    DynamicObjectCollection entrys = entryBankDO.getDynamicObjectCollection("entry_bank");
                    DynamicObject entry = (DynamicObject)entrys.get(0);
                    this.getModel().setValue("payeeaccttext", (Object)entry.getString("bankaccount"));
                    this.getModel().setValue("payeebank", (Object)entry.getDynamicObject("bank"));
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }
}

