/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bond;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.tmc.cfm.formplugin.loanbill.BondLoanBillEdit;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondPlanBillEdit
extends BondLoanBillEdit {
    private static String[] FLOAT_RATE_TYPE_MUST_INPUT_FIELD = new String[]{"referencerate", "rateadjuststyle", "rateadjustdate", "rateadjustcycletype", "rateadjustcycle", "basis"};

    @Override
    public String getOccupybondlimitCtrlName() {
        return "syncoccupybondlimit";
    }

    @Override
    public String getDrawAmountCtrlName() {
        return "syncdrawamount";
    }

    @Override
    public String showDrawAmountEmptyTip() {
        return ResManager.loadKDString((String)"\u53d1\u884c\u603b\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondPlanBillEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public String getSelfSubscribeAmtCtrlName() {
        return "syncselfsubscribeamt";
    }

    @Override
    public String getLoanRateCtrlName() {
        return "syncstartloanrate";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newVal = e.getChangeSet()[0].getNewValue();
        String propName = e.getProperty().getName();
        if ("issyncdraw".equals(propName)) {
            this.fillorClearSyncDrawInfo((Boolean)this.getModel().getValue("issyncdraw"), false);
            this.firstFillSyncDrawField((Boolean)newVal);
            return;
        }
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (!isSyncDraw.booleanValue()) {
            return;
        }
        switch (propName) {
            case "syncdrawamount": {
                this.clearEntryData("condition_entry_s", "condition_entry_b");
                break;
            }
            case "syncterm": {
                this.termChgEvt();
                break;
            }
            case "expiredate": {
                this.endDateChgEvt();
                break;
            }
            case "issetcond_s": 
            case "issetcond_b": 
            case "issetcond_t": {
                this.delEntryDataAndSetEnableByCond((Boolean)newVal, propName, true);
                break;
            }
            case "isspark_s": 
            case "isspark_b": 
            case "isspark_t": {
                this.delEntryDataAndSetEnableByCond((Boolean)newVal, propName, false);
                break;
            }
            case "recamt_es": {
                this.calAndSetRemaitAmt("condition_entry_s", propName, "remaitamt_es");
                break;
            }
            case "recamt_eb": {
                this.calAndSetRemaitAmt("condition_entry_b", propName, "remaitamt_eb");
                break;
            }
            case "loanrate": {
                this.clearEntryData("condition_entry_t");
                break;
            }
            case "afteradjustinterdate_et": {
                this.validDeaLAdjustInterDate((Date)newVal, rowIndex);
                break;
            }
            case "exercisedate_es": 
            case "exercisedate_eb": {
                String entryName = e.getChangeSet()[0].getDataEntity().getDynamicObjectType().getName();
                this.validAndDealExerciseDate((Date)newVal, rowIndex, entryName, propName);
                break;
            }
            case "exercisedate_et": {
                this.validAndDealExerciseDateET((Date)newVal, rowIndex);
                break;
            }
            case "adjustdir_et": 
            case "adjustpoint_et": 
            case "afteradjustrate_et": {
                this.calAndSetAfterAdjustRate(rowIndex, propName);
                break;
            }
            case "org": 
            case "currency": 
            case "finproduct": {
                this.getModel().setValue(this.getOccupybondlimitCtrlName(), null);
                break;
            }
            case "issetpluspoint": {
                this.setResetConditionFlex();
                break;
            }
            case "e_investamount": 
            case "e_isselfsubscribe": {
                this.calSelfSubscribeAmount();
                break;
            }
            case "amount": 
            case "startdate": 
            case "enddate": {
                this.fillorClearSyncDrawInfo(isSyncDraw, false);
                break;
            }
            case "repaymentway": {
                this.fillorClearSyncDrawInfo(isSyncDraw, false);
                this.repayModeChgEvt((String)newVal);
                break;
            }
            case "settleintmode": {
                this.settleIntModeChgEvt((String)newVal);
                break;
            }
            case "interesttype": {
                this.interestTypeChgEvt((String)newVal);
                break;
            }
            case "bondtype": {
                this.setInterestType();
                break;
            }
            case "startintdate": {
                this.setContractInterestRate();
                this.endDateChgEvt();
                break;
            }
            case "ratefloatpoint": 
            case "referencerate": 
            case "ratesign": {
                this.setContractInterestRate();
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String entryName = (String)formOperate.getParameter().get("entryId");
        switch (operateKey) {
            case "newentrys": 
            case "newentryb": 
            case "newentryt": {
                this.validLastRowMustInput(entryName, args);
                break;
            }
            case "deleteentrys": 
            case "deleteentryb": 
            case "deleteentryt": {
                this.validOnlyDelLastRow(entryName, args);
                break;
            }
            case "quickbuilder": {
                this.validateForQuickBuild(args);
                break;
            }
            case "deleteentryer": {
                this.validatePlusEntryFirstRow(args);
            }
        }
    }

    public void fillorClearSyncDrawInfo(boolean isSyncDraw, boolean isBindData) {
        IDataModel model = this.getModel();
        if (isSyncDraw) {
            OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncdrawway", (Object)model.getValue("drawway"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncamount", (Object)model.getValue("amount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncnotdrawamount", (Object)model.getValue("amount"));
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW || operationStatus == OperationStatus.EDIT && !isBindData) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncdrawcurrency", (Object)model.getValue("currency"));
            }
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"syncpublishprice", "syncticketamt", "interesttype", "accountbank"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"repaymentway", "settleintmode", "basis"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"syncdrawamount", "syncbizdate", "startintdate", "syncterm", "expiredate"});
            this.setSyncDrawMustInput();
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String[])new String[]{"syncdrawway", "syncdrawcurrency", "syncamount", "syncbizdate", "startintdate", "syncterm", "expiredate", "fixedrepayamount"});
            model.deleteEntryData("investor_entry");
            model.deleteEntryData("condition_entry_s");
            model.deleteEntryData("condition_entry_b");
            model.deleteEntryData("condition_entry_t");
            model.deleteEntryData("entry_gcontract");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"syncpublishprice", "syncticketamt", "interesttype", "accountbank"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"interestsettledplan", "stageplan", "repaymentway", "settleintmode", "basis"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])FLOAT_RATE_TYPE_MUST_INPUT_FIELD);
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String[])FLOAT_RATE_TYPE_MUST_INPUT_FIELD);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"syncdrawamount", "syncbizdate", "startintdate", "syncterm", "expiredate"});
        }
    }

    private void firstFillSyncDrawField(boolean isSyncDraw) {
        IDataModel model = this.getModel();
        if (!isSyncDraw) {
            return;
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncdrawamount", (Object)model.getValue("amount"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncbizdate", (Object)model.getValue("startdate"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"startintdate", (Object)model.getValue("startdate"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncterm", (Object)model.getValue("term"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)model.getValue("enddate"));
        this.setInterestType();
    }

    private void setSyncDrawMustInput() {
        String repaymentWay = (String)this.getModel().getValue("repaymentway");
        RepaymentWayEnum repayWayEnum = RepaymentWayEnum.getByValue((String)repaymentWay);
        String settleIntMode = (String)this.getModel().getValue("settleintmode");
        boolean interestSettledPlanMustInput = repayWayEnum == RepaymentWayEnum.bqhbdqhx || repayWayEnum == RepaymentWayEnum.dqhbdqhx || repayWayEnum == RepaymentWayEnum.zdyhk && SettleIntModeEnum.gdpljx.getValue().equals(settleIntMode);
        boolean stagePlanMustInput = repayWayEnum == RepaymentWayEnum.dqhblsbq || repayWayEnum == RepaymentWayEnum.dqhbdqhx || repayWayEnum == RepaymentWayEnum.debx || repayWayEnum == RepaymentWayEnum.debj || repayWayEnum == RepaymentWayEnum.dbdx;
        boolean fixedRepayAmountShow = repayWayEnum == RepaymentWayEnum.dqhblsbq || repayWayEnum == RepaymentWayEnum.dqhbdqhx;
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)interestSettledPlanMustInput, (String[])new String[]{"interestsettledplan"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)stagePlanMustInput, (String[])new String[]{"stageplan"});
        this.getView().setVisible(Boolean.valueOf(fixedRepayAmountShow), new String[]{"fixedrepayamount"});
    }

    @Override
    public void afterBindData(EventObject e) {
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (isSyncDraw.booleanValue()) {
            this.fillorClearSyncDrawInfo(true, true);
            String interestType = (String)this.getModel().getValue("interesttype");
            this.interestTypeChgEvt(interestType);
            this.setNoLastRowAmtFiledEnable();
            this.endDateChgEvt();
            BigDecimal bindStartLoanRate = (BigDecimal)this.getModel().getValue("syncstartloanrate");
            if (EmptyUtil.isEmpty((BigDecimal)bindStartLoanRate)) {
                this.setContractInterestRate();
            }
        }
        this.setInterestType();
    }

    private void repayModeChgEvt(String repayModeValue) {
        if (RepaymentWayEnum.zdyhk.getValue().equals(repayModeValue)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"settleintmode"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"settleintmode"});
        }
    }

    private void settleIntModeChgEvt(String settleIntModeValue) {
        if (SettleIntModeEnum.gdpljx.getValue().equals(settleIntModeValue)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"interestsettledplan"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"interestsettledplan"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"interestsettledplan"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"interestsettledplan"});
        }
    }

    private void interestTypeChgEvt(String interestType) {
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])FLOAT_RATE_TYPE_MUST_INPUT_FIELD);
            String repaymentWay = (String)this.getModel().getValue("repaymentway");
            RepaymentWayEnum repaywayEnum = RepaymentWayEnum.getByValue((String)repaymentWay);
            String settleIntMode = (String)this.getModel().getValue("settleintmode");
            boolean interestsettledplanMustInput = repaywayEnum == RepaymentWayEnum.bqhbdqhx || repaywayEnum == RepaymentWayEnum.dqhbdqhx || repaywayEnum == RepaymentWayEnum.zdyhk && SettleIntModeEnum.gdpljx.getValue().equals(settleIntMode);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)interestsettledplanMustInput, (String[])new String[]{"interestsettledplan"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])FLOAT_RATE_TYPE_MUST_INPUT_FIELD);
        }
    }

    private void endDateChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startintdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        if (startDate != null && endDate != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncterm", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncterm", null);
        }
    }

    private void termChgEvt() {
        String term = (String)this.getModel().getValue("syncterm");
        if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", null);
        } else {
            Date startDate = (Date)this.getModel().getValue("startintdate");
            if (term != null && startDate != null) {
                DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
                Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
                String loanExpireRule = AdjustMethodEnum.no_adjust.getValue();
                if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
                    loanExpireRule = productFactory.getString("loanexpireadjustrule");
                }
                endDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)endDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)loanExpireRule));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)endDate);
            }
        }
    }

    private void setInterestType() {
        String bondtype = (String)this.getModel().getValue("bondtype");
        ComboEdit intType = (ComboEdit)this.getControl("interesttype");
        List<Object> comboItemValues = new ArrayList();
        if (StringUtils.equals((CharSequence)"floatratebond", (CharSequence)bondtype)) {
            comboItemValues = Collections.singletonList(InterestTypeEnum.FLOAT.getValue());
        } else {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            ComboItem comboItem0 = new ComboItem();
            comboItem0.setCaption(new LocaleString(InterestTypeEnum.getName((String)InterestTypeEnum.FIXED.getValue())));
            comboItem0.setValue(InterestTypeEnum.FIXED.getValue());
            comboItems.add(comboItem0);
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setCaption(new LocaleString(InterestTypeEnum.getName((String)InterestTypeEnum.AGREE.getValue())));
            comboItem1.setValue(InterestTypeEnum.AGREE.getValue());
            comboItem1.setItemVisible(false);
            comboItems.add(comboItem1);
            intType.setComboItems(comboItems);
        }
        if (comboItemValues.size() > 0) {
            TmcViewInputHelper.resetComboItems(comboItemValues, (String)"interesttype", (IFormView)this.getView());
        }
        if (this.getModel().getValue("interesttype") == null) {
            if (StringUtils.equals((CharSequence)"floatratebond", (CharSequence)bondtype)) {
                this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FLOAT.getValue());
            } else {
                this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
            }
        }
    }

    private void setContractInterestRate() {
        String interestType = (String)this.getModel().getValue("interesttype");
        if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            return;
        }
        DynamicObject referenceRate = (DynamicObject)this.getModel().getValue("referencerate");
        Date startDate = (Date)this.getModel().getValue("startintdate");
        BigDecimal rateFloatPoint = (BigDecimal)this.getModel().getValue("ratefloatpoint");
        String rateSign = (String)this.getModel().getValue("ratesign");
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false);
            if (EmptyUtil.isEmpty((BigDecimal)rate)) {
                this.getModel().setValue("syncstartloanrate", (Object)BigDecimal.ZERO);
                return;
            }
            BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncstartloanrate", (Object)rate.add(rateFloat));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncstartloanrate", (Object)BigDecimal.ZERO);
        }
    }

    @Override
    protected String getBizDatePropName() {
        return "syncbizdate";
    }
}

