/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.PushPayBillVerifyHelper;
import kd.tmc.cfm.common.resource.CfmCommonResourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmPush2PayFormOrListHelper {
    public static void formPush2PayForwardValid(BeforeDoOperationEventArgs args, IFormView view) {
        if (CfmPush2PayFormOrListHelper.isPush2PayOp(args)) {
            String errorInfo = null;
            DynamicObject bill = view.getModel().getDataEntity();
            switch (view.getEntityId()) {
                case "cfm_interestbill": {
                    errorInfo = PushPayBillVerifyHelper.verifyInterestBill((DynamicObject)bill, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE);
                    break;
                }
                case "cfm_repaymentbill": {
                    errorInfo = PushPayBillVerifyHelper.verifyRepaymentBill((DynamicObject)bill, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE);
                    break;
                }
                case "cim_invest_loanbill": {
                    errorInfo = PushPayBillVerifyHelper.verifyCimInvestLoanBill((DynamicObject)bill, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE);
                }
            }
            if (EmptyUtil.isNoEmpty(errorInfo)) {
                args.setCancel(true);
                view.showErrorNotification(errorInfo);
            }
        }
    }

    public static void listPush2PayForwardValid(BeforeDoOperationEventArgs args, IFormView view) {
        FormOperate formOperate;
        List<Object> selectEdPks;
        List<String> errorMessages;
        if (CfmPush2PayFormOrListHelper.isPush2PayOp(args) && EmptyUtil.isNoEmpty(errorMessages = CfmPush2PayFormOrListHelper.push2PayForwardValid(selectEdPks = args.getListSelectedData().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()), (formOperate = (FormOperate)args.getSource()).getEntityId()))) {
            view.showErrorNotification(String.join((CharSequence)"\n", errorMessages));
            args.setCancel(true);
        }
    }

    public static boolean isPush2PayOp(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String type = formOperate.getType();
        Map parameter = formOperate.getParameter();
        if ("push".equalsIgnoreCase(type) && EmptyUtil.isNoEmpty((Object)parameter) && !operateKey.endsWith("_nofrdcheck")) {
            String targetbill = (String)parameter.get("targetbill");
            return "cas_paybill".equalsIgnoreCase(targetbill);
        }
        return false;
    }

    public static List<String> push2PayForwardValid(List<Object> ids, String billType) {
        switch (billType) {
            case "cfm_interestbill": {
                DynamicObjectCollection instBills = QueryServiceHelper.query((String)billType, (String)"id,billno,billstatus,confirmstatus,isrelcash,isinit,combineinst,eassrcid,instbillctg,actualinstamt", (QFilter[])new QFilter("id", "in", ids).toArray());
                ArrayList<String> errorInfos = new ArrayList<String>(instBills.size());
                for (DynamicObject instBill : instBills) {
                    String billNo = instBill.getString("billno");
                    String errorInfo = PushPayBillVerifyHelper.verifyInterestBill((DynamicObject)instBill, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE);
                    if (!EmptyUtil.isNoEmpty((String)errorInfo)) continue;
                    errorInfos.add(String.format("%1$s:%2$s %3$s", CfmCommonResourceEnum.CfmPush2PayFormOrListHelper_01.loadKDString(), billNo, errorInfo));
                }
                return errorInfos;
            }
            case "cfm_repaymentbill": {
                DynamicObjectCollection repayBills = QueryServiceHelper.query((String)billType, (String)"id,billno,billstatus,confirmstatus,isrelcash,isinit,eassrcid,issuretyrepay,needpayamt", (QFilter[])new QFilter("id", "in", ids).toArray());
                ArrayList<String> errorInfos = new ArrayList<String>(repayBills.size());
                for (DynamicObject repayBill : repayBills) {
                    String billNo = repayBill.getString("billno");
                    String errorInfo = PushPayBillVerifyHelper.verifyRepaymentBill((DynamicObject)repayBill, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE);
                    if (!EmptyUtil.isNoEmpty((String)errorInfo)) continue;
                    errorInfos.add(String.format("%1$s:%2$s %3$s", CfmCommonResourceEnum.CfmPush2PayFormOrListHelper_02.loadKDString(), billNo, errorInfo));
                }
                return errorInfos;
            }
            case "cim_invest_loanbill": {
                DynamicObjectCollection loanBills = QueryServiceHelper.query((String)billType, (String)"id,billno,billstatus,confirmstatus,isrelcash,isinit,eassrcid,drawtype,settleintmode,drawamount,payedintamount", (QFilter[])new QFilter("id", "in", ids).toArray());
                ArrayList<String> errorInfos = new ArrayList<String>(loanBills.size());
                for (DynamicObject loanBill : loanBills) {
                    String billNo = loanBill.getString("billno");
                    String errorInfo = PushPayBillVerifyHelper.verifyCimInvestLoanBill((DynamicObject)loanBill, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE);
                    if (!EmptyUtil.isNoEmpty((String)errorInfo)) continue;
                    errorInfos.add(String.format("%1$s:%2$s %3$s", CfmCommonResourceEnum.CfmPush2PayFormOrListHelper_03.loadKDString(), billNo, errorInfo));
                }
                return errorInfos;
            }
        }
        return null;
    }
}

