/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillCreditLinkGmHelper {
    public static void dealInitGmContract(IFormView iFormView, IDataModel iDataModel, IPageCache iPageCache, Object newValue, Object oldValue, int rowIdx) {
        DynamicObjectCollection guaranteeUseBills;
        if (EmptyUtil.isEmpty((DynamicObjectCollection)iDataModel.getEntryEntity("loanentry"))) {
            return;
        }
        int parentIndex = iDataModel.getEntryCurrentRowIndex("loanentry");
        DynamicObject parentRow = iDataModel.getEntryRowEntity("loanentry", parentIndex);
        BigDecimal bizAmount = parentRow.getBigDecimal("drawamount");
        String entityName = iDataModel.getDataEntityType().getName();
        Map<String, Object> initBankSyncMap = InitBillCreditLinkGmHelper.getInitBankSyncMap(entityName, iDataModel, rowIdx);
        if (EmptyUtil.isNoEmpty((Object)oldValue) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(guaranteeUseBills = GuaranteeUseHelper.getGuaranteeUseBills((Long)((DynamicObject)oldValue).getLong("id"))))) {
            Set ids = guaranteeUseBills.stream().map(o -> o.getLong("gcontract")).collect(Collectors.toSet());
            ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
            for (int index = 0; index < iDataModel.getEntryRowCount("gmsubentry"); ++index) {
                DynamicObject gContract = (DynamicObject)iDataModel.getValue("gcontract", index);
                if (gContract == null || !ids.contains(gContract.getLong("id"))) continue;
                if (!initBankSyncMap.isEmpty()) {
                    String creditorType = (String)iDataModel.getValue("gcreditortype", index);
                    Long creditor = (Long)iDataModel.getValue("gcreditor", index);
                    if (!EmptyUtil.isNoEmpty((String)creditorType) || !creditorType.equals(initBankSyncMap.get("gcreditortype")) || creditor == null || !creditor.equals(initBankSyncMap.get("gcreditor"))) continue;
                    removeIndexes.add(index);
                    continue;
                }
                removeIndexes.add(index);
            }
            iFormView.getPageCache().put("isDeleteGuaranteeEntry", "yes");
            iDataModel.deleteEntryRows("gmsubentry", removeIndexes.stream().mapToInt(i -> i).toArray());
        }
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            DynamicObjectCollection guaranteeUseBills2;
            BigDecimal creditRatio = BigDecimal.ONE;
            String useBeanStr = iPageCache.get("cache_usebean" + rowIdx);
            if (EmptyUtil.isNoEmpty((String)useBeanStr)) {
                CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)useBeanStr, CreditLimitF7ResBean.class);
                creditRatio = res.getCreditRatio().divide(Constants.ONE_HUNDRED);
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(guaranteeUseBills2 = GuaranteeUseHelper.getGuaranteeUseBills((Long)((DynamicObject)newValue).getLong("id"))))) {
                InitBillCreditLinkGmHelper.createNewEntryRow(iDataModel, guaranteeUseBills2, creditRatio, bizAmount, initBankSyncMap, parentIndex);
            }
        }
        InitBillCreditLinkGmHelper.setEnable(iFormView, iDataModel);
    }

    private static void createNewEntryRow(IDataModel iDataModel, DynamicObjectCollection guaranteeUseBills, BigDecimal creditRatio, BigDecimal bizAmount, Map<String, Object> initBankSyncMap, int parentIndex) {
        DynamicObject bizCcy;
        if (!initBankSyncMap.isEmpty()) {
            bizAmount = (BigDecimal)initBankSyncMap.get("gsrcbizamount");
        }
        int scale = EmptyUtil.isNoEmpty((DynamicObject)(bizCcy = (DynamicObject)iDataModel.getValue(GuaranteeUseHelper.getBizPropName((String)iDataModel.getDataEntityType().getName(), (String)"bizcurrency")))) ? bizCcy.getInt("amtprecision") : 6;
        BigDecimal sumRatio = guaranteeUseBills.stream().map(g -> g.getBigDecimal("gratio").multiply(creditRatio)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (int i = 0; i < guaranteeUseBills.size(); ++i) {
            BigDecimal rate;
            boolean diffCurrency;
            BigDecimal gAmount;
            DynamicObject guaranteeUseBill = (DynamicObject)guaranteeUseBills.get(i);
            int index = iDataModel.createNewEntryRow("gmsubentry");
            iDataModel.setValue("gcontract", guaranteeUseBill.get("gcontract"), index, parentIndex);
            if (!initBankSyncMap.isEmpty()) {
                iDataModel.setValue("gcreditortype", initBankSyncMap.get("gcreditortype"), index, parentIndex);
                iDataModel.setValue("gcreditor", initBankSyncMap.get("gcreditor"), index, parentIndex);
                iDataModel.setValue("gcreditortext", initBankSyncMap.get("gcreditortext"), index, parentIndex);
            }
            BigDecimal gRatio = guaranteeUseBill.getBigDecimal("gratio").multiply(creditRatio);
            iDataModel.setValue("gratio", (Object)gRatio, index, parentIndex);
            if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == guaranteeUseBills.size() - 1) {
                gAmount = bizAmount.subtract(sumAmount);
            } else {
                gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP);
                sumAmount = sumAmount.add(gAmount);
            }
            iDataModel.setValue("gamount", (Object)gAmount, index, parentIndex);
            iDataModel.setValue("gcomment", guaranteeUseBill.get("gcomment"), index, parentIndex);
            Long gCcyId = guaranteeUseBill.getLong("gcontract.currency");
            boolean bl = diffCurrency = bizCcy != null && !gCcyId.equals(bizCcy.getPkValue());
            if (diffCurrency) {
                String gOrgPropName = GuaranteeUseHelper.getBizPropName((String)iDataModel.getDataEntityType().getName(), (String)"debtor");
                DynamicObject company = (DynamicObject)iDataModel.getValue(gOrgPropName);
                Long debtorId = EmptyUtil.isNoEmpty((DynamicObject)company) ? Long.valueOf(company.getLong("id")) : (Long)iDataModel.getValue("debtor");
                rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCcy.getLong("id"), (long)gCcyId, (long)debtorId, (Date)DateUtils.getCurrentDate());
            } else {
                rate = BigDecimal.ONE;
            }
            iDataModel.setValue("gexchrate", (Object)rate, index, parentIndex);
            iDataModel.setValue("gautoshow", (Object)Boolean.TRUE, index, parentIndex);
        }
    }

    public static Map<String, Object> getInitBankSyncMap(String entityName, IDataModel iDataModel, int rowIdx) {
        HashMap<String, Object> bankSyncMap = new HashMap<String, Object>(4);
        if ("cfm_initbill".equals(entityName) && LoanTypeEnum.isBanksLoan((String)((String)iDataModel.getValue("loantype")))) {
            bankSyncMap.put("gsrcbizamount", iDataModel.getValue("e_shareamount", rowIdx));
            bankSyncMap.put("gcreditortype", iDataModel.getValue("e_bankrole", rowIdx));
            DynamicObject bankDo = (DynamicObject)iDataModel.getValue("e_bank", rowIdx);
            if (EmptyUtil.isNoEmpty((DynamicObject)bankDo)) {
                bankSyncMap.put("gcreditor", bankDo.getLong("id"));
                bankSyncMap.put("gcreditortext", bankDo.getString("name"));
            }
        } else if ("cfm_initbill_bond".equals(entityName)) {
            bankSyncMap.put("gcreditortype", iDataModel.getValue("e_investortype", rowIdx));
            bankSyncMap.put("gcreditor", iDataModel.getValue("e_investorid", rowIdx));
            bankSyncMap.put("gcreditortext", iDataModel.getValue("e_investorname", rowIdx));
            bankSyncMap.put("gsrcbizamount", iDataModel.getValue("e_investamount", rowIdx));
        }
        return bankSyncMap;
    }

    public static Map<String, BigDecimal> getInitBankSyncMaps(String entityName, IDataModel iDataModel, int parentIndex) {
        HashMap<String, BigDecimal> bizAmountMap;
        block4: {
            block3: {
                bizAmountMap = new HashMap<String, BigDecimal>(16);
                if (!"cfm_initbill".equals(entityName)) break block3;
                String creditorType = (String)iDataModel.getValue("creditortype");
                Long creditor = (Long)iDataModel.getValue("creditor");
                bizAmountMap.put(creditorType + creditor, (BigDecimal)iDataModel.getValue("drawamount", parentIndex));
                if (!LoanTypeEnum.isBanksLoan((String)((String)iDataModel.getValue("loantype")))) break block4;
                for (DynamicObject bankSyncEntry : iDataModel.getEntryEntity("banksyndicate_entry")) {
                    String srcBankRole = bankSyncEntry.getString("e_bankrole");
                    DynamicObject bankDo = bankSyncEntry.getDynamicObject("e_bank");
                    DynamicObject creditLimitDo = bankSyncEntry.getDynamicObject("e_creditlimit");
                    if (EmptyUtil.isEmpty((String)srcBankRole) || EmptyUtil.isEmpty((DynamicObject)bankDo) || EmptyUtil.isEmpty((DynamicObject)creditLimitDo)) continue;
                    Long srcBankId = bankDo.getLong("id");
                    bizAmountMap.put(srcBankRole + srcBankId, bankSyncEntry.getBigDecimal("e_shareamount"));
                }
                break block4;
            }
            if ("cfm_initbill_bond".equals(entityName)) {
                for (DynamicObject investorEntry : iDataModel.getEntryEntity("investor_entry")) {
                    String srcBankRole = investorEntry.getString("e_investortype");
                    Long srcBankId = investorEntry.getLong("e_investorid");
                    DynamicObject creditLimitDo = investorEntry.getDynamicObject("e_vrcreditlimit");
                    if (EmptyUtil.isEmpty((String)srcBankRole) || srcBankId == null || EmptyUtil.isEmpty((DynamicObject)creditLimitDo)) continue;
                    bizAmountMap.put(srcBankRole + srcBankId, investorEntry.getBigDecimal("e_investamount"));
                }
            }
        }
        return bizAmountMap;
    }

    public static void setEnable(IFormView iFormView, IDataModel iDataModel) {
        for (int rowIndex = 0; rowIndex < iDataModel.getEntryRowCount("gmsubentry"); ++rowIndex) {
            if (!((Boolean)iDataModel.getValue("gcreditguarantee", rowIndex)).booleanValue()) continue;
            iFormView.setEnable(Boolean.FALSE, rowIndex, new String[]{"gcontract", "gexchrate", "gcomment"});
        }
    }
}

