/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractapply;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.common.helper.ContractApplyHelper;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;

public class ContractApplyHighLightPlugin
extends AbstractBasePlugIn {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    protected boolean isValidate() {
        return BillOperationStatus.SUBMIT.getValue() == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().getValue() || BillOperationStatus.AUDIT.getValue() == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().getValue() || "cim_busconfirm_list".equals(this.getView().getFormShowParameter().getParentFormId());
    }

    protected DynamicObject getContractBill() {
        Object loanContractId = this.getModel().getDataEntity().getDynamicObject("loancontractbill").get("id");
        DynamicObject loanContractBill = BusinessDataServiceHelper.loadSingle((Object)loanContractId, (String)"cfm_loancontractbill");
        ContractApplyHelper.assembleGuaranteeEntry((DynamicObject)loanContractBill);
        return loanContractBill;
    }

    protected DynamicObject getApplyBill() {
        DynamicObject apply = this.getModel().getDataEntity();
        Object loanContractId = this.getModel().getDataEntity().getDynamicObject("loancontractbill").get("id");
        apply.getDynamicObjectCollection("entry_gcontract").forEach(row -> row.set("gsrcbillid", loanContractId));
        return apply;
    }

    public void afterBindData(EventObject e) {
        if (this.isValidate()) {
            DynamicObject nextBill = this.getContractBill();
            DynamicObject lastBill = this.getApplyBill();
            ContractApplyHelper.showChangePropForFormView((DynamicObject)lastBill, (DynamicObject)nextBill, (IFormView)this.getView());
            Map<String, String> bizEntryMap = this.getEntryNameAndEntryKey();
            for (Map.Entry<String, String> entry : bizEntryMap.entrySet()) {
                boolean isModify = this.showChangePropForEntryGrid(lastBill, nextBill, entry.getKey(), entry.getValue(), this.getView());
                if (!isModify) continue;
                this.showTabMessage(entry.getKey());
            }
        }
    }

    protected Map<String, String> getEntryNameAndEntryKey() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        if (!"ifm_bizdealbill".equals(this.getView().getEntityId())) {
            map.put("project_entry", "e_project");
        }
        map.put("entry_gcontract", "gcontract_id");
        return map;
    }

    protected void showTabMessage(String entryName) {
        String tabPageName;
        Map<String, String> map = this.getEntryPropAndTabPage();
        if (map != null && (tabPageName = map.get(entryName)) != null) {
            TabPage tabPage = (TabPage)this.getControl(tabPageName);
            tabPage.setMessage(ResManager.loadKDString((String)"(\u6709\u4fee\u6539)", (String)"ContractApplyHighLightPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
    }

    protected Map<String, String> getEntryPropAndTabPage() {
        HashMap<String, String> entryMap = new HashMap<String, String>(8);
        entryMap.put("entry_gcontract", "tabpage_guarantee");
        entryMap.put("project_entry", "tabpage_bizinfo");
        return entryMap;
    }

    public boolean showChangePropForEntryGrid(DynamicObject lastBill, DynamicObject nextBill, String entryName, String entryKey, IFormView formView) {
        boolean isModify = false;
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entryName);
        DynamicObjectCollection lastEntities = lastBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection nextEntities = nextBill.getDynamicObjectCollection(entryName);
        HashMap nextRecord = new HashMap(nextEntities.size());
        if (lastEntities.size() > 0) {
            for (DynamicObject nextEntity : nextEntities) {
                Map nextMap = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)nextEntity, (boolean)true);
                nextRecord.put(nextMap.get(entryKey), nextMap);
            }
        }
        int size = lastEntities.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)lastEntities.get(i);
            Map lastObjMap = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)entry, (boolean)true);
            Map nextObjMap = (Map)nextRecord.get(lastObjMap.get(entryKey));
            if (null == nextObjMap) {
                ContractApplyHelper.setGridBackgroundColor((EntryGrid)entryGrid, (int)i);
                isModify = true;
                continue;
            }
            Map<String, List<Object>> entriesDiffering = this.entriesDiffering(entryName, lastObjMap, nextObjMap);
            if (CollectionUtils.isEmpty(entriesDiffering)) continue;
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(16);
            for (Map.Entry<String, List<Object>> diffEntry : entriesDiffering.entrySet()) {
                cellStyles.add(ContractApplyHelper.buildCellStyle((String)diffEntry.getKey(), (int)i));
                isModify = true;
            }
            entryGrid.setCellStyle(cellStyles);
        }
        return isModify;
    }

    protected Map<String, List<Object>> entriesDiffering(String entryName, Map<String, Object> lastObjMap, Map<String, Object> nextObjMap) {
        Map<String, List<Object>> entriesDiffering = null;
        switch (entryName) {
            case "entry_gcontract": {
                entriesDiffering = this.guaranteeEntriesDiffering(lastObjMap, nextObjMap);
                break;
            }
            case "project_entry": {
                entriesDiffering = this.projectEntriesDiffering(lastObjMap, nextObjMap);
                break;
            }
        }
        return entriesDiffering;
    }

    protected Map<String, List<Object>> guaranteeEntriesDiffering(Map<String, Object> lastObjMap, Map<String, Object> nextObjMap) {
        return ContractApplyHelper.guaranteeEntriesDiffering(lastObjMap, nextObjMap);
    }

    protected Map<String, List<Object>> projectEntriesDiffering(Map<String, Object> lastObjMap, Map<String, Object> nextObjMap) {
        return ContractApplyHelper.projectEntriesDiffering(lastObjMap, nextObjMap);
    }
}

