/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.constant.CfmEntityConst;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.formplugin.bill.AbstractMultCateTextF7Plugin;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractCreditorDebtorEdit
extends AbstractMultCateTextF7Plugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        BasedataEdit debtorAcct;
        super.registerListener(e);
        String entity = this.getModel().getDataEntityType().getName();
        if ("cfm_loancontract_bo".equals(entity)) {
            return;
        }
        BasedataEdit creditorAcct = (BasedataEdit)this.getControl("loaneracctbank");
        if (creditorAcct != null) {
            creditorAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ("cim_invest_contract".equals(entity) && (debtorAcct = (BasedataEdit)this.getControl("accountbank")) != null) {
            debtorAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "loaneracctbank": {
                this.creditorBankAcctF7Evt(evt);
                break;
            }
            case "accountbank": {
                this.debtorBankAcctF7Evt(evt);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "productfactory": {
                this.productFactoryChgEvt(e);
                break;
            }
            case "creditor": {
                this.creditorChgEvt(e);
                if (LoanTypeEnum.isBanksLoan((String)((String)this.getModel().getValue("loantype")))) break;
                this.setLenderNature();
                break;
            }
            case "creditortype": {
                this.creditorTypeChgEvt(e);
                this.setLenderNature();
                break;
            }
            case "debtortype": {
                this.setLenderNature();
                break;
            }
            case "debtor": {
                this.debtorChgEvt(e);
                this.setLenderNature();
                break;
            }
            case "loantype": 
            case "e_bank": {
                this.setLenderNature();
                break;
            }
        }
    }

    @Override
    protected String getTypePropName() {
        String entity = this.getModel().getDataEntityType().getName();
        if ("cfm_loancontractbill".equals(entity) || "ifm_loancontractbill".equals(entity) || CfmEntityConst.isLeaseContractBill((String)entity)) {
            return "creditortype";
        }
        if ("cim_invest_contract".equals(entity)) {
            return "debtortype";
        }
        return "creditortype";
    }

    @Override
    protected String getTextPropName() {
        String entity = this.getModel().getDataEntityType().getName();
        if ("cfm_loancontractbill".equals(entity) || "ifm_loancontractbill".equals(entity) || CfmEntityConst.isLeaseContractBill((String)entity)) {
            return "textcreditor";
        }
        if ("cim_invest_contract".equals(entity)) {
            return "textdebtor";
        }
        return "textcreditor";
    }

    @Override
    protected String getIdPropName() {
        String entity = this.getModel().getDataEntityType().getName();
        if ("cfm_loancontractbill".equals(entity) || "ifm_loancontractbill".equals(entity) || CfmEntityConst.isLeaseContractBill((String)entity)) {
            return "creditor";
        }
        if ("cim_invest_contract".equals(entity)) {
            return "debtor";
        }
        return "creditor";
    }

    @Override
    protected void addCustomFilter(String type, ListShowParameter lsp) {
        super.addCustomFilter(type, lsp);
        if (CreditorTypeEnum.INNERUNIT.getValue().equals(type)) {
            String orgProp = this.getModel().getDataEntityType().getMainOrg();
            DynamicObject org = (DynamicObject)this.getModel().getValue(orgProp);
            if (org != null) {
                QFilter orgQF = new QFilter("id", "!=", org.getPkValue());
                lsp.getListFilterParameter().getQFilters().add(orgQF);
            }
        }
    }

    private void productFactoryChgEvt(PropertyChangedArgs e) {
        String applyNO = (String)this.getModel().getValue("lenderapplyno");
        if (EmptyUtil.isNoEmpty((String)applyNO)) {
            return;
        }
        DynamicObject pf = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isEmpty((DynamicObject)pf)) {
            return;
        }
        String creditorType = pf.getString("creditortype");
        if (!"cim_invest_contract".equals(this.getModel().getDataEntityType().getName())) {
            this.getModel().setValue("creditortype", (Object)creditorType);
        } else {
            this.getModel().setValue("debtortype", (Object)creditorType);
        }
    }

    private void creditorChgEvt(PropertyChangedArgs e) {
        Long creditorid = (Long)this.getModel().getValue("creditor");
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (this.isInnerUnit(creditorType)) {
            this.getModel().setValue("creditorg", (Object)creditorid);
        } else {
            this.getModel().setValue("creditorg", null);
        }
        this.getModel().setValue("loaneracctbank", null);
    }

    private void creditorTypeChgEvt(PropertyChangedArgs e) {
        DynamicObject fv;
        String entity = this.getModel().getDataEntityType().getName();
        if (!"cfm_loancontractbill".equals(entity) && !CfmEntityConst.isLeaseContractBill((String)entity)) {
            return;
        }
        this.getModel().setValue("accountbank", null);
        DynamicObject finProd = (DynamicObject)this.getModel().getValue("finproduct");
        if (EmptyUtil.isEmpty((DynamicObject)finProd)) {
            return;
        }
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(oldValue) && (fv = TmcDataServiceHelper.loadSingleFromCache((Object)finProd.getPkValue(), (String)"cfm_financingvarieties")) != null && "ifm".equals(fv.getString("biztype"))) {
            this.getModel().setValue("finproduct", null);
        }
    }

    private QFilter getBankAcctFilter(DynamicObject fundOrg) {
        long orgId = fundOrg == null ? 0L : Long.parseLong(fundOrg.getPkValue().toString());
        return TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()).and(new QFilter("acctclassify", "!=", (Object)"I"));
    }

    private void debtorChgEvt(PropertyChangedArgs e) {
        String debtorType = (String)this.getModel().getValue("debtortype");
        Long debtorid = (Long)this.getModel().getValue("debtor");
        if (this.isInnerUnit(debtorType)) {
            this.getModel().setValue("org", (Object)debtorid);
        } else {
            this.getModel().setValue("org", null);
        }
        this.getModel().setValue("accountbank", null);
    }

    private boolean isInnerUnit(String type) {
        return CreditorTypeEnum.INNERUNIT.getValue().equals(type) || CreditorTypeEnum.SETTLECENTER.getValue().equals(type);
    }

    private boolean isCurrencyInputYet(BeforeF7SelectEvent evt) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            evt.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ContractCreditorDebtorEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"currency")));
            return false;
        }
        return true;
    }

    private void creditorBankAcctF7Evt(BeforeF7SelectEvent evt) {
        this.bankAcctF7Evt(evt, "creditorg");
    }

    private void debtorBankAcctF7Evt(BeforeF7SelectEvent evt) {
        this.bankAcctF7Evt(evt, "org");
    }

    private void bankAcctF7Evt(BeforeF7SelectEvent evt, String orgProp) {
        if (!this.isCurrencyInputYet(evt)) {
            return;
        }
        DynamicObject fundOrg = (DynamicObject)this.getModel().getValue(orgProp);
        if (EmptyUtil.isEmpty((DynamicObject)fundOrg)) {
            evt.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ContractCreditorDebtorEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)orgProp)));
            return;
        }
        QFilter qFilter = this.getBankAcctFilter(fundOrg);
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.setUseOrgId(((Long)fundOrg.getPkValue()).longValue());
        sp.setIsolationOrg(true);
        sp.getListFilterParameter().setFilter(qFilter);
    }
}

